/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.projectapi.MetaLookupMerger;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.LookupProvider;
import org.openide.ErrorManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LookupProviderSupport {
    private LookupProviderSupport() {
    }

    public static Lookup createCompositeLookup(Lookup lookup, String string) {
        return new DelegatingLookupImpl(lookup, string);
    }

    public static LookupMerger<Sources> createSourcesMerger() {
        return new SourcesMerger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatingLookupImpl
    extends ProxyLookup
    implements LookupListener,
    ChangeListener {
        private final Lookup baseLookup;
        private Lookup.Result<LookupProvider> providerResult;
        private LookupListener providerListener;
        private List<LookupProvider> old = Collections.emptyList();
        private List<Lookup> currentLookups;
        private final ChangeListener metaMergerListener;
        private Lookup.Result<LookupMerger> mergers;
        private final Lookup.Result<MetaLookupMerger> metaMergers;
        private Reference<LookupListener> listenerRef;
        private final List<Lookup.Result<?>> results = new ArrayList();

        public DelegatingLookupImpl(Lookup lookup, String string) {
            this(lookup, Lookups.forPath((String)string), string);
        }

        public DelegatingLookupImpl(Lookup lookup, Lookup lookup2, String string) {
            assert (lookup != null);
            this.baseLookup = lookup;
            this.providerResult = lookup2.lookup(new Lookup.Template(LookupProvider.class));
            this.metaMergers = lookup2.lookupResult(MetaLookupMerger.class);
            this.metaMergerListener = WeakListeners.change((ChangeListener)this, null);
            assert (this.isAllJustLookupProviders(lookup2)) : "Layer content at " + string + " contains other than LookupProvider instances! See messages.log file for more details.";
            this.doDelegate();
            this.providerListener = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    DelegatingLookupImpl.this.doDelegate();
                }
            };
            this.providerResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.providerListener, this.providerResult));
            this.metaMergers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.providerListener, this.metaMergers));
        }

        private boolean isAllJustLookupProviders(Lookup lookup) {
            for (Lookup.Item item : lookup.lookupResult(Object.class).allItems()) {
                Class clazz = item.getType();
                if (LookupProvider.class.isAssignableFrom(clazz) || MetaLookupMerger.class.isAssignableFrom(clazz)) continue;
                Logger.getLogger(LookupProviderSupport.class.getName()).warning(clazz.getName() + " from " + item.getId() + " is not a LookupProvider");
            }
            return true;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.doDelegate();
        }

        protected void beforeLookup(Lookup.Template<?> template) {
            for (MetaLookupMerger metaLookupMerger : this.metaMergers.allInstances()) {
                metaLookupMerger.probing(template.getType());
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.doDelegate();
        }

        private synchronized void doDelegate() {
            Class clazz;
            LookupListener lookupListener;
            Object object;
            for (Lookup.Result<?> object22 : this.results) {
                object22.removeLookupListener((LookupListener)this);
            }
            Collection collection = this.providerResult.allInstances();
            ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
            ProxyLookup proxyLookup = collection.iterator();
            while (proxyLookup.hasNext()) {
                object = (LookupProvider)proxyLookup.next();
                if (this.old.contains(object)) {
                    int lookup = this.old.indexOf(object);
                    arrayList.add(this.currentLookups.get(lookup));
                    continue;
                }
                Lookup arrayList2 = object.createAdditionalLookup(this.baseLookup);
                assert (arrayList2 != null);
                arrayList.add(arrayList2);
            }
            this.old = new ArrayList<LookupProvider>(collection);
            this.currentLookups = arrayList;
            arrayList.add(this.baseLookup);
            proxyLookup = new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
            object = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            LookupListener lookupListener2 = lookupListener = this.listenerRef != null ? this.listenerRef.get() : null;
            if (lookupListener != null) {
                this.mergers.removeLookupListener(lookupListener);
            }
            this.mergers = proxyLookup.lookupResult(LookupMerger.class);
            lookupListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.mergers);
            this.listenerRef = new WeakReference<LookupListener>(lookupListener);
            this.mergers.addLookupListener(lookupListener);
            ArrayList<LookupMerger> arrayList4 = new ArrayList<LookupMerger>(this.mergers.allInstances());
            for (MetaLookupMerger metaLookupMerger : this.metaMergers.allInstances()) {
                clazz = metaLookupMerger.merger();
                if (clazz != null) {
                    arrayList4.add((LookupMerger)((Object)clazz));
                }
                metaLookupMerger.removeChangeListener(this.metaMergerListener);
                metaLookupMerger.addChangeListener(this.metaMergerListener);
            }
            for (LookupMerger lookupMerger : arrayList4) {
                clazz = lookupMerger.getMergeableClass();
                if (object.contains(clazz)) {
                    ErrorManager.getDefault().log(16, "Two LookupMerger registered for class " + clazz + ". Only first one will be used");
                    continue;
                }
                object.add(clazz);
                arrayList3.add(lookupMerger.merge((Lookup)proxyLookup));
                Lookup.Result result = proxyLookup.lookupResult(clazz);
                result.addLookupListener((LookupListener)this);
                this.results.add(result);
            }
            proxyLookup = Lookups.exclude((Lookup)proxyLookup, (Class[])object.toArray(new Class[object.size()]));
            Lookup lookup = Lookups.fixed((Object[])arrayList3.toArray(new Object[arrayList3.size()]));
            this.setLookups(new Lookup[]{lookup, proxyLookup});
        }
    }

    private static class SourcesImpl
    implements Sources,
    ChangeListener,
    LookupListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Lookup.Result<Sources> delegates;
        private Collection<Sources> currentDelegates = new ArrayList<Sources>();

        private void setLookup(Lookup lookup) {
            if (this.currentDelegates.size() > 0) {
                for (Sources object : this.currentDelegates) {
                    object.removeChangeListener(this);
                }
                this.currentDelegates.clear();
            }
            if (this.delegates != null) {
                this.delegates.removeLookupListener((LookupListener)this);
            }
            Lookup.Result result = lookup.lookupResult(Sources.class);
            for (Sources sources : result.allInstances()) {
                sources.addChangeListener(this);
                this.currentDelegates.add(sources);
            }
            result.addLookupListener((LookupListener)this);
            this.delegates = result;
            this.changeSupport.fireChange();
        }

        public SourceGroup[] getSourceGroups(String string) {
            assert (this.delegates != null);
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            for (Sources sources : this.delegates.allInstances()) {
                SourceGroup[] sourceGroupArray = sources.getSourceGroups(string);
                if (sourceGroupArray == null) continue;
                for (SourceGroup sourceGroup : sourceGroupArray) {
                    if (sourceGroup == null) {
                        Exceptions.printStackTrace((Throwable)new NullPointerException(sources + " returns null source group!"));
                        continue;
                    }
                    arrayList.add(sourceGroup);
                }
            }
            return arrayList.toArray(new SourceGroup[arrayList.size()]);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.changeSupport.fireChange();
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (this.currentDelegates.size() > 0) {
                for (Sources sources : this.currentDelegates) {
                    sources.removeChangeListener(this);
                }
                this.currentDelegates.clear();
            }
            for (Sources sources : this.delegates.allInstances()) {
                sources.addChangeListener(this);
                this.currentDelegates.add(sources);
            }
            this.changeSupport.fireChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesMerger
    implements LookupMerger<Sources> {
        private SourcesImpl merger;

        private SourcesMerger() {
        }

        @Override
        public Class<Sources> getMergeableClass() {
            return Sources.class;
        }

        @Override
        public Sources merge(Lookup lookup) {
            if (this.merger == null) {
                this.merger = new SourcesImpl();
            }
            this.merger.setLookup(lookup);
            return this.merger;
        }
    }
}

