/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class BreakpointEnableAction
extends BooleanStateAction
implements ContextAwareAction {
    public boolean isEnabled() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(BreakpointEnableAction.class, (String)"CTL_enabled");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        Collection collection = lookup.lookupAll(BreakpointAnnotation.class);
        if (!collection.isEmpty()) {
            BreakpointAwareAction breakpointAwareAction = new BreakpointAwareAction(collection);
            return breakpointAwareAction;
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BreakpointAwareAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup {
        private Collection<? extends BreakpointAnnotation> ann;
        private HiddenBooleanStateAction hba;

        public BreakpointAwareAction(Collection<? extends BreakpointAnnotation> collection) {
            this.ann = collection;
            this.hba = (HiddenBooleanStateAction)SystemAction.get(HiddenBooleanStateAction.class);
        }

        @Override
        public Object getValue(String string) {
            return this.hba.getValue(string);
        }

        @Override
        public void putValue(String string, Object object) {
            this.hba.putValue(string, object);
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        private void setBreakpoints() {
            ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>(this.ann.size());
            for (BreakpointAnnotation breakpointAnnotation : this.ann) {
                arrayList.add(breakpointAnnotation.getBreakpoint());
            }
            this.hba.setFor(arrayList);
        }

        @Override
        public boolean isEnabled() {
            this.setBreakpoints();
            return true;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.hba.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.hba.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getMenuPresenter() {
            this.setBreakpoints();
            return this.hba.getMenuPresenter();
        }

        public JMenuItem getPopupPresenter() {
            this.setBreakpoints();
            return this.hba.getPopupPresenter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HiddenBooleanStateAction
    extends BooleanStateAction {
        private Collection<Reference<Breakpoint>> bRefs;

        public HiddenBooleanStateAction() {
            this.setEnabled(true);
        }

        public void setFor(Collection<Breakpoint> collection) {
            this.bRefs = new ArrayList<Reference<Breakpoint>>(collection.size());
            for (Breakpoint breakpoint : collection) {
                this.bRefs.add(new WeakReference<Breakpoint>(breakpoint));
            }
            this.setBooleanState(this.areBreakpointsEnabled());
        }

        private boolean areBreakpointsEnabled() {
            boolean bl = true;
            for (Reference<Breakpoint> reference : this.bRefs) {
                Breakpoint breakpoint = reference.get();
                if (breakpoint == null || breakpoint.isEnabled()) continue;
                bl = false;
            }
            return bl;
        }

        public String getName() {
            return NbBundle.getMessage(BreakpointEnableAction.class, (String)"CTL_enabled");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            boolean bl = !this.areBreakpointsEnabled();
            for (Reference<Breakpoint> reference : this.bRefs) {
                Breakpoint breakpoint = reference.get();
                if (breakpoint == null) continue;
                if (bl) {
                    breakpoint.enable();
                    continue;
                }
                breakpoint.disable();
            }
        }
    }
}

