/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.viewmodel.CheckNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements CheckNodeModel {
    public static final String BREAKPOINT_GROUP = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    private final Collection modelListeners = new ArrayList();

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(BreakpointsNodeModel.class).getString("CTL_BreakpointModel_Column_Name_Name");
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return "Root";
        }
        if (object instanceof String) {
            return NbBundle.getBundle(BreakpointsNodeModel.class).getString("CTL_BreakpointModel_Column_GroupName_Desc");
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return BREAKPOINT_GROUP;
        }
        if (object instanceof String) {
            return BREAKPOINT_GROUP;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelEvent(ModelEvent modelEvent) {
        ArrayList arrayList;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            arrayList = new ArrayList(this.modelListeners);
        }
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged(modelEvent);
        }
    }

    public boolean isCheckable(Object object) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(Object object) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(Object object) throws UnknownTypeException {
        if (object instanceof Breakpoint) {
            return ((Breakpoint)object).isEnabled();
        }
        if (object instanceof String) {
            String string = (String)object;
            Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
            Boolean bl = null;
            for (int i = 0; i < breakpointArray.length; ++i) {
                if (!breakpointArray[i].getGroupName().equals(string)) continue;
                if (bl == null) {
                    bl = breakpointArray[i].isEnabled();
                    continue;
                }
                if (bl.booleanValue() == breakpointArray[i].isEnabled()) continue;
                return null;
            }
            return bl;
        }
        throw new UnknownTypeException(object);
    }

    public void setSelected(Object object, Boolean bl) throws UnknownTypeException {
        if (bl != null) {
            if (object instanceof Breakpoint) {
                Breakpoint breakpoint = (Breakpoint)object;
                if (bl.booleanValue()) {
                    breakpoint.enable();
                } else {
                    breakpoint.disable();
                }
                this.fireModelEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)breakpoint));
                String string = breakpoint.getGroupName();
                if (string != null) {
                    this.fireModelEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)string));
                }
            } else if (object instanceof String) {
                String string = (String)object;
                Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
                ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
                for (int i = 0; i < breakpointArray.length; ++i) {
                    if (!breakpointArray[i].getGroupName().equals(string)) continue;
                    arrayList.add(breakpointArray[i]);
                }
                if (arrayList.size() > 0) {
                    for (Breakpoint breakpoint : arrayList) {
                        if (bl.booleanValue()) {
                            breakpoint.enable();
                        } else {
                            breakpoint.disable();
                        }
                        this.fireModelEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)breakpoint));
                    }
                    if (string != null) {
                        this.fireModelEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)string));
                    }
                }
            }
        }
    }
}

