/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.extbrowser.DelegatingWebBrowserImpl;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExtWebBrowser
implements HtmlBrowser.Factory,
Serializable,
PropertyChangeListener {
    private static final long serialVersionUID = -3021027901671504127L;
    public static final String PROP_NAME = "name";
    public static final String PROP_BROWSER_EXECUTABLE = "browserExecutable";
    public static final String PROP_DDESERVER = "dDEServer";
    public static final String PROP_DDE_ACTIVATE_TIMEOUT = "activateTimeout";
    public static final String PROP_DDE_OPENURL_TIMEOUT = "openurlTimeout";
    public static final String NETSCAPE = "NETSCAPE";
    public static final String IEXPLORE = "IEXPLORE";
    public static final String MOZILLA = "MOZILLA";
    public static final String FIREFOX = "FIREFOX";
    public static final String NETSCAPE6 = "NETSCAPE6";
    protected static final int DEFAULT_ACTIVATE_TIMEOUT = 2000;
    protected static final int DEFAULT_OPENURL_TIMEOUT = 3000;
    protected String ddeServer;
    protected int activateTimeout = 2000;
    protected int openurlTimeout = 3000;
    private static Logger err = Logger.getLogger("org.netbeans.modules.extbrowser");
    protected String name;
    protected NbProcessDescriptor browserExecutable;
    protected transient PropertyChangeSupport pcs;
    static /* synthetic */ Class class$org$netbeans$modules$extbrowser$ExtWebBrowser;

    public static Logger getEM() {
        return err;
    }

    public ExtWebBrowser() {
        this.init();
    }

    private void init() {
        if (err.isLoggable(Level.FINE)) {
            err.log(Level.FINE, this.getClass().getName() + " " + System.currentTimeMillis() + "> init");
        }
        this.pcs = new PropertyChangeSupport(this);
        if (Utilities.isWindows()) {
            this.pcs.addPropertyChangeListener(this);
        }
    }

    public String getDDEServer() {
        return this.ddeServer;
    }

    public void setDDEServer(String string) {
        if (string != null && !string.equals(this.ddeServer)) {
            String string2 = this.ddeServer;
            this.ddeServer = string;
            this.pcs.firePropertyChange(PROP_DDESERVER, string2, string);
            err.log(Level.INFO, "DDEServer changed to: " + string);
        }
    }

    public int getOpenurlTimeout() {
        return this.openurlTimeout;
    }

    public void setOpenurlTimeout(int n) {
        if (n != this.openurlTimeout) {
            int n2 = this.openurlTimeout;
            this.openurlTimeout = n;
            this.pcs.firePropertyChange(PROP_DDE_OPENURL_TIMEOUT, n2, n);
        }
    }

    public int getActivateTimeout() {
        return this.activateTimeout;
    }

    public void setActivateTimeout(int n) {
        if (n != this.activateTimeout) {
            int n2 = this.activateTimeout;
            this.activateTimeout = n;
            this.pcs.firePropertyChange(PROP_DDE_ACTIVATE_TIMEOUT, n2, n);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != null && !string.equals(this.name)) {
            String string2 = this.name;
            this.name = string;
            this.pcs.firePropertyChange(PROP_NAME, string2, string);
        }
    }

    public NbProcessDescriptor getBrowserExecutable() {
        if (this.browserExecutable == null || "".equals(this.browserExecutable.getProcessName())) {
            return this.defaultBrowserExecutable();
        }
        return this.browserExecutable;
    }

    public void setBrowserExecutable(NbProcessDescriptor nbProcessDescriptor) {
        NbProcessDescriptor nbProcessDescriptor2;
        if (nbProcessDescriptor != null && !nbProcessDescriptor.equals((Object)this.browserExecutable)) {
            nbProcessDescriptor2 = this.browserExecutable;
            this.browserExecutable = nbProcessDescriptor;
            this.pcs.firePropertyChange(PROP_BROWSER_EXECUTABLE, nbProcessDescriptor2, nbProcessDescriptor);
        }
        if (nbProcessDescriptor == null) {
            nbProcessDescriptor2 = this.browserExecutable;
            this.browserExecutable = this.defaultBrowserExecutable();
            this.pcs.firePropertyChange(PROP_BROWSER_EXECUTABLE, nbProcessDescriptor2, nbProcessDescriptor);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (propertyChangeEvent.getPropertyName().equals(PROP_BROWSER_EXECUTABLE) && (object = propertyChangeEvent.getNewValue()) != null && object instanceof NbProcessDescriptor) {
            String string = ((NbProcessDescriptor)object).getProcessName();
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "" + System.currentTimeMillis() + "> propertychange: " + string);
            }
            if (string != null && string.trim().length() > 0) {
                if (string.toUpperCase().indexOf("IEXPLORE.EXE") > -1) {
                    this.setDDEServer(IEXPLORE);
                } else if (string.toUpperCase().indexOf("MOZILLA.EXE") > -1) {
                    this.setDDEServer(MOZILLA);
                } else if (string.toUpperCase().indexOf("FIREFOX.EXE") > -1) {
                    this.setDDEServer(FIREFOX);
                } else if (string.toUpperCase().indexOf("NETSCP6.EXE") > -1) {
                    this.setDDEServer(NETSCAPE6);
                } else if (string.toUpperCase().indexOf("NETSCP.EXE") > -1) {
                    this.setDDEServer(NETSCAPE6);
                } else if (string.toUpperCase().indexOf("NETSCAPE.EXE") > -1) {
                    this.setDDEServer(NETSCAPE);
                } else {
                    this.setDDEServer(null);
                }
            }
        }
    }

    protected NbProcessDescriptor defaultBrowserExecutable() {
        String string = "netscape";
        if (err.isLoggable(Level.FINE)) {
            err.log(Level.FINE, "" + System.currentTimeMillis() + "> ExtBrowser: defaultBrowserExecutable: ");
        }
        if (Utilities.isWindows()) {
            string = "iexplore";
            String string2 = "";
            try {
                string = NbDdeBrowserImpl.getDefaultOpenCommand();
                String[] stringArray = Utilities.parseParameters((String)string);
                if (stringArray == null || stringArray.length == 0) {
                    throw new NbBrowserException();
                }
                string = stringArray[0];
                if (stringArray[0].toUpperCase().indexOf("IEXPLORE.EXE") > -1) {
                    this.setDDEServer(IEXPLORE);
                    string2 = "-nohome ";
                } else if (stringArray[0].toUpperCase().indexOf("MOZILLA.EXE") > -1) {
                    this.setDDEServer(MOZILLA);
                } else if (stringArray[0].toUpperCase().indexOf("FIREFOX.EXE") > -1) {
                    this.setDDEServer(FIREFOX);
                } else if (stringArray[0].toUpperCase().indexOf("NETSCP6.EXE") > -1) {
                    this.setDDEServer(NETSCAPE6);
                } else if (stringArray[0].toUpperCase().indexOf("NETSCP.EXE") > -1) {
                    this.setDDEServer(NETSCAPE6);
                } else if (stringArray[0].toUpperCase().indexOf("NETSCAPE.EXE") > -1) {
                    this.setDDEServer(NETSCAPE);
                }
                string2 = string2 + "{URL}";
                return new NbProcessDescriptor(string, string2);
            }
            catch (NbBrowserException nbBrowserException) {
                try {
                    string = NbDdeBrowserImpl.getBrowserPath(IEXPLORE);
                    if (string != null && string.trim().length() > 0) {
                        this.setDDEServer(IEXPLORE);
                        string2 = string2 + "{URL}";
                        return new NbProcessDescriptor(string, string2);
                    }
                    string = NbDdeBrowserImpl.getBrowserPath(MOZILLA);
                    if (string != null && string.trim().length() > 0) {
                        this.setDDEServer(MOZILLA);
                        string2 = string2 + "{URL}";
                        return new NbProcessDescriptor(string, string2);
                    }
                    string = NbDdeBrowserImpl.getBrowserPath(FIREFOX);
                    if (string != null && string.trim().length() > 0) {
                        this.setDDEServer(FIREFOX);
                        string2 = string2 + "{URL}";
                        return new NbProcessDescriptor(string, string2);
                    }
                    string = NbDdeBrowserImpl.getBrowserPath("Netscp");
                    if (string != null && string.trim().length() > 0) {
                        this.setDDEServer(NETSCAPE6);
                        string2 = string2 + "{URL}";
                        return new NbProcessDescriptor(string, string2);
                    }
                    string = NbDdeBrowserImpl.getBrowserPath("Netscp6");
                    if (string != null && string.trim().length() > 0) {
                        this.setDDEServer(NETSCAPE6);
                        string2 = string2 + "{URL}";
                        return new NbProcessDescriptor(string, string2);
                    }
                    string = NbDdeBrowserImpl.getBrowserPath("Netscape");
                    if (string != null && string.trim().length() > 0) {
                        this.setDDEServer(NETSCAPE);
                        string2 = string2 + "{URL}";
                        return new NbProcessDescriptor(string, string2);
                    }
                }
                catch (NbBrowserException nbBrowserException2) {
                    this.setDDEServer(IEXPLORE);
                    string = "C:\\Program Files\\Internet Explorer\\iexplore.exe";
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                string = "iexplore";
            }
            string2 = string2 + "{URL}";
            return new NbProcessDescriptor(string, string2);
        }
        if (Utilities.isUnix() && !Utilities.isMac()) {
            if (Utilities.getOperatingSystem() == 16) {
                string = "mozilla";
                File file = new File("/usr/local/mozilla/mozilla");
                if (file.exists()) {
                    string = file.getAbsolutePath();
                } else {
                    file = new File("/usr/bin/firefox");
                    if (file.exists()) {
                        string = file.getAbsolutePath();
                    }
                }
            } else if (Utilities.getOperatingSystem() == 8) {
                string = "netscape";
                File file = new File("/usr/dt/bin/sun_netscape");
                if (file.exists()) {
                    string = file.getAbsolutePath();
                }
            }
            return new NbProcessDescriptor(string, "-remote \"openURL({URL})\"", UnixBrowserFormat.getHint());
        }
        if (Utilities.getOperatingSystem() == 2048) {
            return new NbProcessDescriptor("Netscape.exe", " {URL}", UnixBrowserFormat.getHint());
        }
        if (Utilities.isMac()) {
            return new NbProcessDescriptor("/usr/bin/open", " {URL}", UnixBrowserFormat.getHint());
        }
        return new NbProcessDescriptor("", " {URL}", UnixBrowserFormat.getHint());
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        return new DelegatingWebBrowserImpl(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        int n;
        objectInputStream.defaultReadObject();
        if (this.browserExecutable != null && this.browserExecutable.getArguments() != null && (n = (string = this.browserExecutable.getArguments()).indexOf("{params}")) >= 0) {
            this.browserExecutable = new NbProcessDescriptor(this.browserExecutable.getProcessName(), string.substring(0, n) + "-remote \"openURL({URL})" + string.substring(n + 8), UnixBrowserFormat.getHint());
        }
        this.init();
    }

    public static class UnixBrowserFormat
    extends MapFormat {
        private static final long serialVersionUID = -699340388834127437L;
        public static final String TAG_URL = "URL";

        public UnixBrowserFormat(String string) {
            super(new HashMap());
            Map map = this.getMap();
            map.put(TAG_URL, string);
        }

        public static String getHint() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$ExtWebBrowser == null ? (class$org$netbeans$modules$extbrowser$ExtWebBrowser = ExtWebBrowser.class$("org.netbeans.modules.extbrowser.ExtWebBrowser")) : class$org$netbeans$modules$extbrowser$ExtWebBrowser), (String)"MSG_BrowserExecutorHint");
        }
    }
}

