/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.file;

import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.file.PlaylistNode;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaylistCursor {
    private long lastVideoTC = 0L;
    private long lastBroadcastTC = 0L;
    private long lastVideoFastTC = 0L;
    private long lastAudioTC = 0L;
    private long lastTC = 0L;
    private long startTC = 0L;
    private long endTC = 0L;
    private boolean sendAbsVideoTC = false;
    private boolean sendAbsBroadcastTC = false;
    private boolean sendAbsAudioTC = false;
    private long seekReqLocation = 0L;
    private long seekResLocation = 0L;
    private IMediaReaderStreamPosition seekVideoStreamPos = null;
    private long forceVideoTC = -1L;
    private boolean isSeeking = false;
    private int inReader = 0;
    private boolean interruptPlay = false;
    private boolean startPlaying = false;
    private boolean fillBuffer = false;
    private int seekType = 0;
    private List<Integer> seekTypes = new ArrayList<Integer>();
    private boolean isPlaylistReset = false;
    private boolean isFirstStream = true;
    private long realStartTime = 0L;
    private long realStartTC;
    private FastPlaySettings fastPlaySettings = null;
    private boolean videoCanPFrame = false;
    private boolean videoCanDFrame = false;
    private boolean isRealTimeSet = false;
    private PlaylistWriteControl writeControl = new PlaylistWriteControl();
    private PlaylistReaderWriteResults writeResults = new PlaylistReaderWriteResults();
    private boolean delayedFillBuffer = false;
    private long startTCOffset = 0L;
    private boolean waitForKeyFrame = false;
    private int lastSendBufferTime = 0;
    private int sendSeqCount = 0;
    private int chunkSize;
    private PlaylistNode node = null;
    private int seekTarget = 1;
    private int seekVideoTarget = 3;
    private IMediaReaderStreamPosition seekStartStreamPos = null;
    private long audioPacketCount = 0L;
    private long videoPacketCount = 0L;
    private long dataPacketCount = 0L;
    private boolean lastAudioWasZero = false;
    private long audioSampleDesc = -1L;
    private long videoSampleDesc = -1L;

    public void reset() {
        this.lastVideoTC = 0L;
        this.lastBroadcastTC = 0L;
        this.lastVideoFastTC = 0L;
        this.lastAudioTC = 0L;
        this.lastTC = 0L;
        this.startTC = 0L;
        this.startTCOffset = 0L;
        this.sendAbsVideoTC = false;
        this.sendAbsBroadcastTC = false;
        this.sendAbsAudioTC = false;
        this.seekReqLocation = 0L;
        this.seekResLocation = 0L;
        this.seekVideoStreamPos = null;
        this.fastPlaySettings = null;
        this.videoCanPFrame = false;
        this.videoCanDFrame = false;
        this.isRealTimeSet = false;
        this.delayedFillBuffer = false;
        this.forceVideoTC = -1L;
        this.waitForKeyFrame = false;
        this.lastSendBufferTime = 0;
        this.sendSeqCount = 0;
        this.audioSampleDesc = -1L;
        this.videoSampleDesc = -1L;
    }

    public boolean isStartPlaying() {
        return this.startPlaying;
    }

    public void setStartPlaying(boolean bl) {
        this.startPlaying = bl;
    }

    public long getSeekReqLocation() {
        return this.seekReqLocation;
    }

    public void setSeekReqLocation(long l) {
        this.seekReqLocation = l;
    }

    public long getSeekResLocation() {
        return this.seekResLocation;
    }

    public void setSeekResLocation(long l) {
        this.seekResLocation = l;
    }

    public long getLastAudioTC() {
        return this.lastAudioTC;
    }

    public void setLastAudioTC(long l) {
        this.lastAudioTC = l;
        this.lastTC = Math.max(l, this.lastTC);
    }

    public long getLastTC() {
        return this.lastTC;
    }

    public long getLastTCAdj() {
        if (this.fastPlaySettings == null) {
            return this.lastTC;
        }
        long l = this.fastPlaySettings.getStartTC();
        long l2 = this.fastPlaySettings.getDirection() > 0 ? l + Math.round((double)(this.lastTC - l) / this.fastPlaySettings.getMultiplier()) : l + Math.round((double)(l - this.lastTC) / this.fastPlaySettings.getMultiplier());
        return l2;
    }

    public long calcTCAdj(long l) {
        if (this.fastPlaySettings == null) {
            return l;
        }
        long l2 = this.fastPlaySettings.getStartTC();
        long l3 = this.fastPlaySettings.getDirection() > 0 ? l2 + Math.round((double)(l - l2) / this.fastPlaySettings.getMultiplier()) : l2 + Math.round((double)(l2 - l) / this.fastPlaySettings.getMultiplier());
        return l3;
    }

    public void setLastTC(long l) {
        this.lastTC = l;
    }

    public long getLastVideoTC() {
        return this.lastVideoTC;
    }

    public void setLastVideoTC(long l) {
        this.lastVideoTC = l;
        this.lastTC = Math.max(l, this.lastTC);
    }

    public long getLastBroadcastTC() {
        return this.lastBroadcastTC;
    }

    public void setLastBroadcastTC(long l) {
        this.lastBroadcastTC = l;
        this.lastTC = Math.max(l, this.lastTC);
    }

    public long getLastVideoFastTC() {
        return this.lastVideoFastTC;
    }

    public void setLastVideoFastTC(long l) {
        this.lastVideoFastTC = l;
    }

    public void incLastVideoFastTC(long l) {
        this.lastVideoFastTC += l;
    }

    public boolean isSendAbsAudioTC() {
        return this.sendAbsAudioTC;
    }

    public void setSendAbsAudioTC(boolean bl) {
        this.sendAbsAudioTC = bl;
    }

    public boolean isSendAbsVideoTC() {
        return this.sendAbsVideoTC;
    }

    public void setSendAbsVideoTC(boolean bl) {
        this.sendAbsVideoTC = bl;
    }

    public boolean isSendAbsBroadcastTC() {
        return this.sendAbsBroadcastTC;
    }

    public void setSendAbsBroadcastTC(boolean bl) {
        this.sendAbsBroadcastTC = bl;
    }

    public boolean isSeeking() {
        return this.isSeeking;
    }

    public void setSeeking(boolean bl) {
        this.isSeeking = bl;
    }

    public void enterReader() {
        ++this.inReader;
    }

    public void leaveReader() {
        --this.inReader;
        if (this.inReader == 0) {
            this.interruptPlay = false;
        }
    }

    public boolean isInterruptPlay() {
        return this.interruptPlay;
    }

    public boolean isBreakLoop() {
        return this.isSeeking || this.interruptPlay;
    }

    public void setInterruptPlay() {
        if (this.inReader > 0) {
            this.interruptPlay = true;
        }
    }

    public int getSeekType() {
        return this.seekType;
    }

    public void setSeekType(int n) {
        this.seekType = n;
    }

    public void addSeekType(int n) {
        Integer n2 = new Integer(n);
        if (this.seekTypes.contains(n2)) {
            this.seekTypes.remove(n2);
        }
        this.seekTypes.add(n);
    }

    public List<Integer> getSeekTypes() {
        return new ArrayList<Integer>(this.seekTypes);
    }

    public void clearSeekTypes() {
        this.seekTypes.clear();
    }

    public boolean isPlaylistReset() {
        return this.isPlaylistReset;
    }

    public void setPlaylistReset(boolean bl) {
        this.isPlaylistReset = bl;
    }

    public boolean isFirstStream() {
        return this.isFirstStream;
    }

    public void setFirstStream(boolean bl) {
        this.isFirstStream = bl;
    }

    public long getStartTC() {
        return this.startTC;
    }

    public void setStartTC(long l) {
        this.startTC = l;
    }

    public void incStartTC(long l) {
        this.startTC += l;
    }

    public long getEndTC() {
        return this.endTC;
    }

    public void setEndTC(long l) {
        this.endTC = l;
    }

    public long getRealStartTC() {
        return this.realStartTC;
    }

    public void setRealStartTC(long l) {
        this.realStartTC = l;
    }

    public long getRealStartTime() {
        return this.realStartTime;
    }

    public void setRealStartTime(long l) {
        this.realStartTime = l;
    }

    public boolean isFillBuffer() {
        return this.fillBuffer;
    }

    public void setFillBuffer(boolean bl) {
        this.fillBuffer = bl;
    }

    public FastPlaySettings getFastPlaySettings() {
        return this.fastPlaySettings;
    }

    public void setFastPlaySettings(FastPlaySettings fastPlaySettings) {
        this.fastPlaySettings = fastPlaySettings;
    }

    public boolean isVideoCanPFrame() {
        return this.videoCanPFrame;
    }

    public void setVideoCanPFrame(boolean bl) {
        this.videoCanPFrame = bl;
    }

    public boolean isVideoCanDFrame() {
        return this.videoCanDFrame;
    }

    public void setVideoCanDFrame(boolean bl) {
        this.videoCanDFrame = bl;
    }

    public boolean isRealTimeSet() {
        return this.isRealTimeSet;
    }

    public void setRealTimeSet(boolean bl) {
        this.isRealTimeSet = bl;
    }

    public PlaylistWriteControl getWriteControl() {
        return this.writeControl;
    }

    public PlaylistReaderWriteResults getWriteResults() {
        this.writeResults.reset();
        return this.writeResults;
    }

    public boolean isDelayedFillBuffer() {
        return this.delayedFillBuffer;
    }

    public void setDelayedFillBuffer(boolean bl) {
        this.delayedFillBuffer = bl;
    }

    public long getStartTCOffset() {
        return this.startTCOffset;
    }

    public void setStartTCOffset(long l) {
        this.startTCOffset = l;
    }

    public IMediaReaderStreamPosition getSeekVideoStreamPos() {
        return this.seekVideoStreamPos;
    }

    public void setSeekVideoStreamPos(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        this.seekVideoStreamPos = iMediaReaderStreamPosition;
    }

    public long getForceVideoTC() {
        return this.forceVideoTC;
    }

    public void setForceVideoTC(long l) {
        this.forceVideoTC = l;
    }

    public boolean isWaitForKeyFrame() {
        return this.waitForKeyFrame;
    }

    public void setWaitForKeyFrame(boolean bl) {
        this.waitForKeyFrame = bl;
    }

    public int getLastSendBufferTime() {
        return this.lastSendBufferTime;
    }

    public void setLastSendBufferTime(int n) {
        this.lastSendBufferTime = n;
    }

    public int incSendSeqCount() {
        return ++this.sendSeqCount;
    }

    public int decSendSeqCount() {
        return --this.sendSeqCount;
    }

    public int getSendSeqCount() {
        return this.sendSeqCount;
    }

    public void setSendSeqCount(int n) {
        this.sendSeqCount = n;
    }

    public PlaylistNode getNode() {
        return this.node;
    }

    public void setNode(PlaylistNode playlistNode) {
        this.node = playlistNode;
    }

    public int getSeekTarget() {
        return this.seekTarget;
    }

    public void setSeekTarget(int n) {
        this.seekTarget = n;
    }

    public int getSeekVideoTarget() {
        return this.seekVideoTarget;
    }

    public void setSeekVideoTarget(int n) {
        this.seekVideoTarget = n;
    }

    public IMediaReaderStreamPosition getSeekStartStreamPos() {
        return this.seekStartStreamPos;
    }

    public void setSeekStartStreamPos(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        this.seekStartStreamPos = iMediaReaderStreamPosition;
    }

    public long getAudioPacketCount() {
        return this.audioPacketCount;
    }

    public void setAudioPacketCount(long l) {
        this.audioPacketCount = l;
    }

    public void incAudioPacketCount() {
        ++this.audioPacketCount;
    }

    public long getVideoPacketCount() {
        return this.videoPacketCount;
    }

    public void setVideoPacketCount(long l) {
        this.videoPacketCount = l;
    }

    public void incVideoPacketCount() {
        ++this.videoPacketCount;
    }

    public long getDataPacketCount() {
        return this.dataPacketCount;
    }

    public void setDataPacketCount(long l) {
        this.dataPacketCount = l;
    }

    public void incDataPacketCount() {
        ++this.dataPacketCount;
    }

    public void resetPacketCounts() {
        this.audioPacketCount = 0L;
        this.dataPacketCount = 0L;
        this.videoPacketCount = 0L;
    }

    public boolean isLastAudioWasZero() {
        return this.lastAudioWasZero;
    }

    public void setLastAudioWasZero(boolean bl) {
        this.lastAudioWasZero = bl;
    }

    public long getAudioSampleDesc() {
        return this.audioSampleDesc;
    }

    public void setAudioSampleDesc(long l) {
        this.audioSampleDesc = l;
    }

    public long getVideoSampleDesc() {
        return this.videoSampleDesc;
    }

    public void setVideoSampleDesc(long l) {
        this.videoSampleDesc = l;
    }
}

