/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.AnchorShapeFactory;
import org.netbeans.api.visual.widget.ComponentWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.AddTableDlg;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.CondNode;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.JoinNode;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QBGraphScene;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QBNodeComponent;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInputTable;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInputTableModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInternalFrame;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderTableModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.And;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ExpressionList;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Or;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SQLQueryFactory;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Value;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Where;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class QueryBuilderGraphFrame
extends JPanel
implements ActionListener,
TableModelListener,
ItemListener,
KeyListener,
DropTargetListener,
PopupMenuProvider {
    private static final boolean DEBUG = false;
    private boolean _disableQBGF = false;
    private QueryBuilder _queryBuilder;
    private DropTarget _dropTarget;
    private JDesktopPane _desktopPane = null;
    private QBGFJPanel _canvas = null;
    private QueryBuilderInputTable _queryBuilderInputTable;
    private DefaultTableModel _inputTableModel;
    private JEditorPane _sqlTextArea;
    private DefaultTableModel _resultTableModel;
    private QBGraphScene _scene;
    private JScrollPane _desktopScrollPane;
    private JViewport viewport;
    private FrameSelectionListener _fsl = null;
    private ComponentListener _cl = null;
    private JPopupMenu _backgroundPopup;
    private JPopupMenu _tableTitlePopup;
    private AddTableDlg _addTableDlg = null;
    boolean _firstTableInserted = false;
    private QBNodeComponent _selectedNode;
    private static final int initX = 40;
    private static final int initY = 40;
    private static final int offsetX = 20;
    private int offsetY = 20;
    private static final int MAX_TABLES_IN_A_ROW = 5;
    private Random randomVal = new Random();
    private JMenuItem runQueryMenuItem;
    private JMenuItem groupByMenuItem;
    private boolean _checkTableColumnValidity = false;
    private boolean _inputTableAddCriteria = false;
    URL url_primary_key = this.getClass().getResource("/org/netbeans/modules/db/sql/visualeditor/resources/primaryKey.gif");
    URL url_foreign_key = this.getClass().getResource("/org/netbeans/modules/db/sql/visualeditor/resources/foreignKey.gif");
    Point _gLocation;

    public QueryBuilderGraphFrame(QueryBuilder queryBuilder, QueryBuilderInputTable queryBuilderInputTable, JEditorPane jEditorPane, DefaultTableModel defaultTableModel) {
        super(new BorderLayout());
        Log.getLogger().entering("QueryBuilderGraphFrame", "constructor");
        this._queryBuilder = queryBuilder;
        this._queryBuilderInputTable = queryBuilderInputTable;
        this._inputTableModel = (DefaultTableModel)this._queryBuilderInputTable.getModel();
        this._sqlTextArea = jEditorPane;
        this._resultTableModel = defaultTableModel;
        this._inputTableModel.addTableModelListener(this);
        this._fsl = new FrameSelectionListener();
        this._cl = new CompListener();
        this._backgroundPopup = this.createBackgroundPopup();
        this._tableTitlePopup = this.createTableTitlePopup();
        this.setVisible(true);
    }

    void initScene(QBGraphScene qBGraphScene, JComponent jComponent) {
        this._scene = qBGraphScene;
        this._dropTarget = new DropTarget(jComponent, 3, this);
    }

    void setDropTarget(Component component) {
        this._dropTarget = new DropTarget(component, 3, this);
    }

    void setScene(QBGraphScene qBGraphScene) {
        this._scene = qBGraphScene;
    }

    void getCanvasFocus() {
        this._canvas.requestFocus(true);
    }

    void setQBGFEnabled(boolean bl) {
        boolean bl2 = this._disableQBGF = !bl;
        if (this._disableQBGF) {
            int n = (int)this.getSize().getWidth();
            int n2 = (int)this.getSize().getHeight();
        }
    }

    void resizeDesktop() {
    }

    void setActivatedNode(QueryBuilderInternalFrame queryBuilderInternalFrame) {
        if (queryBuilderInternalFrame != null) {
            TableNode tableNode = queryBuilderInternalFrame.getNode();
            this._queryBuilder.setActivatedNodes(new Node[]{tableNode});
        } else {
            this._queryBuilder.setActivatedNodes(new Node[0]);
        }
        this._queryBuilder.activateActions();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this._checkTableColumnValidity = true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this._checkTableColumnValidity = true;
        if (keyEvent.isShiftDown()) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 121: {
                    this._backgroundPopup.show(keyEvent.getComponent(), keyEvent.getComponent().getX(), keyEvent.getComponent().getY());
                }
            }
        }
        this._queryBuilder.handleKeyPress(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this._checkTableColumnValidity = true;
    }

    public void setTableColumnValidity(boolean bl) {
        this._checkTableColumnValidity = bl;
    }

    public boolean checkTableColumnValidity() {
        return this._checkTableColumnValidity && this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().queryChanged();
    }

    JPopupMenu createBackgroundPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.runQueryMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"RUN_QUERY"));
        this.runQueryMenuItem.addActionListener(this);
        jPopupMenu.add(this.runQueryMenuItem);
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"Add_Table"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        this.groupByMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"GROUP_BY"));
        this.groupByMenuItem.addItemListener(this);
        jPopupMenu.add(this.groupByMenuItem);
        return jPopupMenu;
    }

    JPopupMenu createTableTitlePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"REMOVE_FROM_QUERY"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        QBNodeComponent qBNodeComponent;
        if (widget instanceof QBGraphScene) {
            return this._backgroundPopup;
        }
        this._selectedNode = qBNodeComponent = (QBNodeComponent)this._scene.findObject(widget);
        return this._tableTitlePopup;
    }

    protected String getClassName(Object object) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this._disableQBGF) {
            return;
        }
        if (!this._queryBuilder._updateModel) {
            return;
        }
        Log.getLogger().finest("Entering QBGF.tableChanged, source: " + tableModelEvent.getSource());
        if (tableModelEvent.getSource() instanceof QueryBuilderTableModel) {
            this.tableModelChanged(tableModelEvent);
        } else if (tableModelEvent.getSource() instanceof QueryBuilderInputTableModel) {
            this.inputTableModelChanged(tableModelEvent);
        }
    }

    private void tableModelChanged(TableModelEvent tableModelEvent) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "tableModelChanged");
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        QueryBuilderTableModel queryBuilderTableModel = (QueryBuilderTableModel)tableModelEvent.getSource();
        String string = queryBuilderTableModel.getTableSpec();
        String string2 = (String)queryBuilderTableModel.getValueAt(n, n2 + 2);
        Object object = queryBuilderTableModel.getValueAt(n, n2);
        if (object == Boolean.TRUE) {
            if (this._queryBuilder._updateModel) {
                this._queryBuilder.getQueryModel().addColumn(string, string2);
                this._queryBuilderInputTable.selectColumn(string, string2, Boolean.TRUE);
            }
        } else if (object == Boolean.FALSE) {
            if (this._queryBuilder._updateModel) {
                this._queryBuilder.getQueryModel().removeColumn(string, string2);
            }
            this._queryBuilderInputTable.selectColumn(string, string2, Boolean.FALSE);
        }
        if (this._queryBuilder._updateText) {
            this._queryBuilder.generateText();
        }
    }

    private void inputTableModelChanged(TableModelEvent tableModelEvent) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "inputTableModelChanged");
        if (this._inputTableAddCriteria) {
            return;
        }
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        QueryBuilderInputTableModel queryBuilderInputTableModel = (QueryBuilderInputTableModel)tableModelEvent.getSource();
        if (n != -1) {
            Object object;
            String string = (String)queryBuilderInputTableModel.getValueAt(n2, 0);
            String string2 = (String)queryBuilderInputTableModel.getValueAt(n2, 2);
            if (n == 1) {
                object = ((String)queryBuilderInputTableModel.getValueAt(n2, 1)).trim();
                if (object == null || ((String)object).length() == 0) {
                    this._queryBuilder.getQueryModel().removeDerivedColName(string2, string);
                } else {
                    this._queryBuilder.getQueryModel().setDerivedColName(string2, string, (String)object);
                }
            }
            if (n == 3) {
                object = (Boolean)queryBuilderInputTableModel.getValueAt(n2, n);
                QBNodeComponent qBNodeComponent = this.findGraphNode(string2);
                QueryBuilderTableModel queryBuilderTableModel = qBNodeComponent.getQueryBuilderTableModel();
                queryBuilderTableModel.selectColumn(string, (Boolean)object);
                return;
            }
            if (n == 6) {
                object = ((String)queryBuilderInputTableModel.getValueAt(n2, 6)).trim();
                if (object != null && ((String)object).length() == 0) {
                    this._inputTableAddCriteria = true;
                    queryBuilderInputTableModel.setValueAt("", n2, 7);
                    this._inputTableAddCriteria = false;
                    this._queryBuilder.getQueryModel().removeCriteria(string2, string, 1);
                } else {
                    if (((String)object).trim().equals("*****")) {
                        return;
                    }
                    Predicate predicate = this.checkCriteria(string2, string, (String)object);
                    if (predicate == null) {
                        this._queryBuilderInputTable.getModel().setValueAt("", n2, n);
                        return;
                    }
                    int n3 = this._queryBuilder.getQueryModel().getCriteriaCount();
                    String string3 = (String)queryBuilderInputTableModel.getValueAt(n2, 7);
                    if (string3 != null && string3.trim().length() != 0 && string3.trim().equals("*")) {
                        return;
                    }
                    int n4 = string3 == null || string3.trim().length() == 0 ? n3 + 1 : Integer.parseInt(string3);
                    this._inputTableAddCriteria = true;
                    queryBuilderInputTableModel.setValueAt(new Integer(n4).toString(), n2, 7);
                    this._inputTableAddCriteria = false;
                    if (n4 < n3 + 1) {
                        this._queryBuilder.getQueryModel().replaceCriteria(string2, string, predicate, n4);
                    } else {
                        this._queryBuilder.getQueryModel().addCriteria(string2, string, predicate);
                    }
                }
                this._queryBuilderInputTable.clearSelection();
                this._inputTableAddCriteria = true;
                this._queryBuilderInputTable.generateTableWhere(this._queryBuilder.getQueryModel());
                this._inputTableAddCriteria = false;
            } else if (n == 7) {
                object = ((String)queryBuilderInputTableModel.getValueAt(n2, 6)).trim();
                String string4 = (String)queryBuilderInputTableModel.getValueAt(n2, n);
                if (string4 != null && string4.trim().length() != 0 && string4.trim().equals("*")) {
                    return;
                }
                this._queryBuilder.getQueryModel().removeCriteria(string2, string, 1);
                if (string4 == null || string4.trim().length() == 0) {
                    this._inputTableAddCriteria = true;
                    queryBuilderInputTableModel.setValueAt("", n2, 6);
                    this._inputTableAddCriteria = false;
                } else {
                    int n5 = Integer.parseInt(string4);
                    Predicate predicate = this.checkCriteria(string2, string, (String)object);
                    if (predicate == null) {
                        this._queryBuilderInputTable.getModel().setValueAt("", n2, n);
                        return;
                    }
                    if (((String)object).trim().length() != 0) {
                        this._queryBuilder.getQueryModel().addCriteria(string2, string, predicate, n5);
                    }
                }
                this._queryBuilderInputTable.clearSelection();
                this._inputTableAddCriteria = true;
                this._queryBuilderInputTable.generateTableWhere(this._queryBuilder.getQueryModel());
                this._inputTableAddCriteria = false;
            }
            if (this._queryBuilder._updateText) {
                this._queryBuilder.generateText();
            }
        }
    }

    private Predicate checkCriteria(String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        if (string3.startsWith(">=")) {
            string4 = ">=";
            string5 = string3.substring(2).trim();
        } else if (string3.startsWith("<=")) {
            string4 = "<=";
            string5 = string3.substring(2).trim();
        } else if (string3.startsWith("<>")) {
            string4 = "<>";
            string5 = string3.substring(2).trim();
        } else if (string3.startsWith(">")) {
            string4 = ">";
            string5 = string3.substring(1).trim();
        } else if (string3.startsWith("<")) {
            string4 = "<";
            string5 = string3.substring(1).trim();
        } else if (string3.startsWith("=")) {
            string4 = "=";
            string5 = string3.substring(1).trim();
        } else if (string3.toUpperCase().startsWith("LIKE")) {
            string4 = " LIKE ";
            string5 = string3.substring(5).trim();
        } else if (string3.toUpperCase().startsWith("IN")) {
            string4 = " IN ";
            string5 = string3.substring(3).trim();
        }
        if (string4 == null || string4.trim().length() == 0 || string5 == null || string5.trim().length() == 0) {
            String string6 = NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"CRITERIA_ERROR");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)(string6 + "\n\n"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            this._queryBuilderInputTable.clearSelection();
            return null;
        }
        Column column = SQLQueryFactory.createColumn(string, string2);
        Predicate predicate = SQLQueryFactory.createPredicate((Value)column, string5, string4);
        return predicate;
    }

    public void setCurrentSelectedFrameTitle(String string) {
        if ((QueryBuilderInternalFrame)this._desktopPane.getSelectedFrame() != null) {
            ((QueryBuilderInternalFrame)this._desktopPane.getSelectedFrame()).setTitle(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTableInteractively(String string) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertTableInteractively", string);
        if (this._queryBuilder.getQueryModel() == null || this._queryBuilder.getQueryModel().genText() == null) {
            String string2 = "select * from " + string;
            this._queryBuilder.populate(string2, false);
            this._queryBuilder.setSqlCommand(string2);
            return;
        }
        QueryBuilder.showBusyCursor(true);
        this._queryBuilder._updateText = false;
        try {
            String string3;
            String string4 = null;
            String[] stringArray = string.split("\\.");
            if (stringArray.length > 1) {
                string4 = stringArray[0];
                string3 = stringArray[1];
            } else {
                string3 = string;
            }
            String string5 = new String(string3);
            String string6 = this._queryBuilder.getQueryModel().genUniqueName(string);
            Table table = string6 == null ? SQLQueryFactory.createTable(string5, null, string4) : SQLQueryFactory.createTable(string5, string6, string4);
            JoinTable joinTable = SQLQueryFactory.createJoinTable(table);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("*");
            this._queryBuilder.getQueryModel().insertTable(joinTable);
            QBNodeComponent qBNodeComponent = this.insertTable(joinTable, arrayList);
            List list = this.insertFKEdges(qBNodeComponent, string);
            this._queryBuilder.getQueryModel().addRelationships(joinTable, list);
            this._firstTableInserted = true;
        }
        finally {
            this._queryBuilder._updateText = true;
            QueryBuilder.showBusyCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertTableFromModel(JoinTable joinTable, List list) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertTableFromModel", joinTable.getTableSpec());
        boolean bl = this._queryBuilder._updateText;
        this._queryBuilder._updateText = false;
        try {
            QBNodeComponent qBNodeComponent = this.insertTable(joinTable, list);
            if (qBNodeComponent == null) {
                return;
            }
            this.insertJoinEdges(joinTable);
            this._firstTableInserted = true;
        }
        finally {
            this._queryBuilder._updateText = bl;
        }
    }

    QBNodeComponent insertTable(JoinTable joinTable, List list) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertTable", new Object[]{joinTable, list});
        String string = joinTable.getFullTableName();
        QBNodeComponent qBNodeComponent = this.createNode(joinTable, list);
        this.refresh();
        return qBNodeComponent;
    }

    QBNodeComponent createNode(JoinTable joinTable, List list) {
        Object object;
        int n;
        ArrayList arrayList;
        String[] stringArray;
        String string = joinTable.getFullTableName();
        String[] stringArray2 = string.split("\\.");
        String string2 = stringArray2.length > 1 ? stringArray2[1] : stringArray2[0];
        String string3 = joinTable.getCorrName();
        String string4 = string3 != null ? string3 : string;
        Log.getLogger().finest("Entering QBGF.createNode, fullTableName: " + string + " corrName: " + string3);
        try {
            stringArray = this._queryBuilder.checkFullTableName(string);
            if (stringArray != null & !string.equals(stringArray)) {
                string = stringArray;
                Log.getLogger().finest("  fullTableName corrected to " + string);
            }
        }
        catch (SQLException sQLException) {
            Log.getLogger().finest("  fullTableName " + sQLException.getMessage());
        }
        stringArray = new String[]{"", "", ""};
        try {
            arrayList = this._queryBuilder.getColumnNames(string);
        }
        catch (SQLException sQLException) {
            arrayList = new ArrayList();
        }
        Object[][] objectArray = new Object[arrayList.size()][3];
        Iterator iterator = arrayList.iterator();
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        try {
            arrayList2 = this._queryBuilder.getPrimaryKeys(string);
            arrayList3 = this._queryBuilder.getImportedKeyColumns(string);
        }
        catch (SQLException sQLException) {
            Log.getLogger().warning("QueryBuilderGraphFrame:  cannot get info " + sQLException.getLocalizedMessage());
            arrayList2 = new ArrayList();
            arrayList3 = new ArrayList();
        }
        for (n = 0; iterator.hasNext() && n < arrayList.size(); ++n) {
            object = new String(iterator.next().toString());
            objectArray[n][0] = list.contains("*") || list.contains(object) ? Boolean.TRUE : Boolean.FALSE;
            objectArray[n][1] = arrayList2.contains(((String)object).trim()) ? new ImageIcon(this.url_primary_key) : (arrayList3.contains(((String)object).trim()) ? new ImageIcon(this.url_foreign_key) : null);
            objectArray[n][2] = object;
            this._queryBuilderInputTable.addRow(string4, (String)object);
            this._queryBuilderInputTable.selectColumn(string4, (String)object, (Boolean)objectArray[n][0]);
        }
        object = new QueryBuilderTableModel(string, string3, stringArray, objectArray);
        ((AbstractTableModel)object).addTableModelListener(this);
        for (n = 0; n < ((DefaultTableModel)object).getRowCount(); ++n) {
            ((DefaultTableModel)object).setValueAt(objectArray[n][0], n, 0);
        }
        String string5 = string3 == null ? string2 : string3 + ": " + string2;
        Widget widget = this._scene.addNode(string5, (QueryBuilderTableModel)object);
        widget.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        QBNodeComponent qBNodeComponent = this.findComponent(widget);
        widget.setPreferredLocation(this.getNextGraphLocation(qBNodeComponent.getPreferredSize()));
        this._scene.validate();
        return qBNodeComponent;
    }

    Point getNextGraphLocation(Dimension dimension) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "getNextGraphLocation", new Object[]{dimension.getWidth(), dimension.getHeight()});
        if (!this._firstTableInserted) {
            this._gLocation = new Point(40, 40);
        } else {
            this._gLocation = new Point((int)(this._gLocation.getX() + dimension.getWidth() + 20.0 + (double)this.randomVal.nextInt((int)dimension.getWidth() / 2)), (int)(this._gLocation.getY() + (double)this.offsetY + (double)this.randomVal.nextInt((int)dimension.getHeight() / 2)));
            this.offsetY *= -1;
            if (this._gLocation.getX() > (double)((int)dimension.getWidth() * 5)) {
                this._gLocation = new Point(40, (int)this._gLocation.getY() + (int)dimension.getHeight() + 2 * this.offsetY);
            }
        }
        return this._gLocation;
    }

    QBNodeComponent findComponent(Widget widget) {
        List list = widget.getChildren();
        for (Widget widget2 : list) {
            if (!(widget2 instanceof ComponentWidget)) continue;
            return (QBNodeComponent)((ComponentWidget)widget2).getComponent();
        }
        return null;
    }

    private List insertFKEdges(QBNodeComponent qBNodeComponent, String string) {
        ArrayList arrayList;
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertFKEdges", new Object[]{qBNodeComponent, string});
        try {
            arrayList = this._queryBuilder.getForeignKeys(string);
        }
        catch (SQLException sQLException) {
            arrayList = new ArrayList();
        }
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        Collection collection = this._scene.getNodes();
        for (Object e : collection) {
            String string2;
            String[] stringArray;
            if (!(e instanceof QBNodeComponent) || (stringArray = this._queryBuilder.findForeignKey(string2 = ((QBNodeComponent)e).getFullTableName(), string, arrayList)) == null) continue;
            String string3 = ((QBNodeComponent)e).getTableSpec();
            String string4 = qBNodeComponent.getTableSpec();
            if (stringArray[0].equals(stringArray[2])) {
                stringArray[0] = string3;
                stringArray[2] = string4;
            }
            this.insertGraphEdge((QBNodeComponent)e, qBNodeComponent, string2, string, string3, string4, null, null, stringArray, "INNER");
            arrayList2.add(stringArray);
        }
        return arrayList2;
    }

    void insertJoinEdges(JoinTable joinTable) {
        Expression expression;
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertJoinEdges", joinTable);
        String string = joinTable.getJoinType();
        if (string != null && !string.equals("CROSS") && (expression = joinTable.getExpression()) instanceof Predicate) {
            Predicate predicate = (Predicate)expression;
            this.insertJoinEdge(predicate, string);
        }
    }

    void insertJoinEdge(Predicate predicate, String string) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertJoinEdge", new Object[]{predicate, string});
        Value value = predicate.getVal1();
        Value value2 = predicate.getVal2();
        if (value instanceof Column && value2 instanceof Column) {
            Column column = (Column)value;
            String string2 = column.getTableSpec();
            String string3 = this._queryBuilder.getQueryModel().getFullTableName(string2);
            String string4 = column.getColumnName();
            QBNodeComponent qBNodeComponent = this.findGraphNode(string2);
            Column column2 = (Column)value2;
            String string5 = column2.getTableSpec();
            String string6 = this._queryBuilder.getQueryModel().getFullTableName(string5);
            String string7 = column2.getColumnName();
            QBNodeComponent qBNodeComponent2 = this.findGraphNode(string5);
            String[] stringArray = null;
            try {
                stringArray = this._queryBuilder.findForeignKey(string3, string4, string6, string7);
            }
            catch (SQLException sQLException) {
                Log.getLogger().warning("QBGF:  findforeignKey " + sQLException.getLocalizedMessage());
            }
            this.insertGraphEdge(qBNodeComponent, qBNodeComponent2, string3, string6, string2, string5, string4, string7, stringArray, string);
        }
    }

    void insertGraphEdge(QBNodeComponent qBNodeComponent, QBNodeComponent qBNodeComponent2, String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String string7) {
        System.out.println("Entering insertGraphEdge, tableSpec1: " + string3 + "  tableSpec2: " + string4);
        AbstractNode abstractNode = string5 == null ? (string.equalsIgnoreCase(stringArray[0]) ? this.createPropertyNode(string3, stringArray[1], string4, stringArray[3], string7, this._queryBuilder) : this.createPropertyNode(string4, stringArray[1], string3, stringArray[3], string7, this._queryBuilder)) : this.createPropertyNode(string3, string5, string4, string6, string7, this._queryBuilder);
        Widget widget = this._scene.addEdge(abstractNode);
        this._scene.setEdgeSource(abstractNode, qBNodeComponent);
        this._scene.setEdgeTarget(abstractNode, qBNodeComponent2);
        ConnectionWidget connectionWidget = (ConnectionWidget)widget;
        connectionWidget.getActions().addAction(this._scene.createSelectAction());
        AnchorShape anchorShape = AnchorShapeFactory.createTriangleAnchorShape((int)18, (boolean)true, (boolean)false, (int)17);
        connectionWidget.setStroke((Stroke)new BasicStroke(1.5f, 2, 1));
        if (stringArray != null) {
            if (stringArray[0].equalsIgnoreCase(string)) {
                connectionWidget.setTargetAnchorShape(anchorShape);
            } else {
                connectionWidget.setSourceAnchorShape(anchorShape);
            }
        }
        this._queryBuilder.setActivatedNodes(new Node[]{abstractNode});
        this._scene.validate();
    }

    AbstractNode createPropertyNode(String string, String string2, String string3, String string4, String string5, QueryBuilder queryBuilder) {
        if (string5 == null || string5.equals("")) {
            return new CondNode(string, string2, string3, string4, queryBuilder);
        }
        return new JoinNode(string, string2, string3, string4, string5, queryBuilder);
    }

    void removeTable(QBNodeComponent qBNodeComponent) {
        String string = qBNodeComponent.getTableSpec();
        Log.getLogger().entering("QueryBuilderGraphFrame", "removeTable", string);
        Collection collection = this._scene.findNodeEdges(qBNodeComponent, true, true);
        for (Object e : collection) {
            this._scene.removeEdge(e);
        }
        this._scene.removeNode(qBNodeComponent);
        this._queryBuilderInputTable.removeRows(string);
        this._queryBuilder.getQueryModel().removeTable(string);
        this._queryBuilder.generate();
        this.setGroupBy(this._queryBuilder.getQueryModel().hasGroupBy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateGraph(QueryModel queryModel) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "generateGraph");
        if (this._disableQBGF) {
            return;
        }
        this._queryBuilder._updateModel = false;
        try {
            this.generateGraphFrom(queryModel);
            this.generateGraphWhere(queryModel);
            this.generateGraphOrderBy(queryModel);
            this.refresh();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this._queryBuilder._updateModel = true;
        }
    }

    private void generateGraphFrom(QueryModel queryModel) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "generateGraphFrom");
        List list = queryModel.getFrom().getTableList();
        for (int i = 0; i < list.size(); ++i) {
            JoinTable joinTable = (JoinTable)list.get(i);
            String string = joinTable.getTableSpec();
            String string2 = joinTable.getFullTableName();
            ArrayList arrayList = new ArrayList();
            queryModel.getColumnNames(string, arrayList);
            this.insertTableFromModel(joinTable, arrayList);
        }
    }

    private boolean whereHasDuplicateColumns(List list, Predicate predicate) {
        ArrayList arrayList = new ArrayList();
        predicate.getReferencedColumns(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Column column = (Column)arrayList.get(i);
            int n = 0;
            for (int j = 0; j < list.size(); ++j) {
                if (((Column)list.get(j)).equals(column)) {
                    ++n;
                }
                if (n <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private void generateGraphWhere(QueryModel queryModel) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "generateGraphWhere");
        this._inputTableAddCriteria = true;
        Where where = queryModel.getWhere();
        if (where != null) {
            Expression expression = where.getExpression();
            ArrayList arrayList = new ArrayList();
            where.getReferencedColumns(arrayList);
            if (expression == null) {
                this._inputTableAddCriteria = false;
                return;
            }
            if (expression instanceof Predicate) {
                if (this.whereHasDuplicateColumns(arrayList, (Predicate)expression)) {
                    this.insertPredicate((Predicate)expression, -1);
                } else {
                    this.insertPredicate((Predicate)expression, 0);
                }
            } else if (expression instanceof And) {
                this.insertAndOr(expression, arrayList, 0);
            } else if (expression instanceof Or) {
                this.insertAndOr(expression, arrayList, 0);
            }
        }
        this._inputTableAddCriteria = false;
    }

    private void insertAndOr(Expression expression, List list, int n) {
        ExpressionList expressionList = (ExpressionList)expression;
        for (int i = 0; i < expressionList.size(); ++i) {
            expression = expressionList.getExpression(i);
            if (expression instanceof Predicate) {
                if (this.whereHasDuplicateColumns(list, (Predicate)expression)) {
                    this.insertPredicate((Predicate)expression, -1);
                    continue;
                }
                this.insertPredicate((Predicate)expression, n++);
                continue;
            }
            if (expression instanceof And) {
                this.insertAndOr(expression, list, n++);
                continue;
            }
            if (!(expression instanceof Or)) continue;
            this.insertAndOr(expression, list, n++);
        }
    }

    private void insertPredicate(Predicate predicate, int n) {
        Value value = predicate.getVal1();
        Value value2 = predicate.getVal2();
        if (value instanceof Column && value2 instanceof Column) {
            this.insertJoinEdge(predicate, "");
        } else {
            String string = predicate.getVal2().toString();
            Column column = (Column)value;
            String string2 = column.getTableSpec();
            String string3 = column.getColumnName();
            String string4 = predicate.getOp() + " " + string;
            if (n == -1) {
                this._queryBuilderInputTable.addCriterion(string2, string3, "*****", "*");
            } else {
                String string5 = n == -1 ? "" : new Integer(n + 1).toString();
                this._queryBuilderInputTable.addCriterion(string2, string3, string4, string5);
            }
        }
    }

    private void generateGraphOrderBy(QueryModel queryModel) {
        this._queryBuilderInputTable.generateTableOrderBy(queryModel);
    }

    QBNodeComponent findGraphNode(String string) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "findGraphNode", string);
        Collection collection = this._scene.getNodes();
        for (Object e : collection) {
            if (!(e instanceof QBNodeComponent) || !((QBNodeComponent)e).getTableSpec().equals(string)) continue;
            return (QBNodeComponent)e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTable() {
        Log.getLogger().entering("QueryBuilderGraphFrame", "addTable");
        QueryBuilder.showBusyCursor(true);
        try {
            List<String> list = this._queryBuilder.getAllTables();
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            this._addTableDlg = new AddTableDlg(stringArray, true);
            if (this._addTableDlg.getReturnStatus() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Object[] objectArray = QueryBuilderGraphFrame.this._addTableDlg.getSelectedValues();
                        for (int i = 0; i < objectArray.length; ++i) {
                            String string = (String)objectArray[i];
                            QueryBuilderGraphFrame.this.insertTableInteractively(string);
                        }
                        QueryBuilderGraphFrame.this._queryBuilder.generateText();
                        QueryBuilderGraphFrame.this.runQueryMenuItem.setEnabled(true);
                        QueryBuilderGraphFrame.this.groupByMenuItem.setEnabled(true);
                        QueryBuilderGraphFrame.this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(true);
                        QueryBuilderGraphFrame.this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(true);
                    }
                });
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            QueryBuilder.showBusyCursor(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "actionPerformed");
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem.getText().equals(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"Add_Table"))) {
            this.addTable();
        } else if (jMenuItem.getText().equals(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"RUN_QUERY"))) {
            this._queryBuilder.executeQuery(this._sqlTextArea.getText());
        } else if (jMenuItem.getText().equals(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"REMOVE_FROM_QUERY"))) {
            this.removeTable();
        }
    }

    public void removeNode(TableNode tableNode) {
    }

    public void removeNode(CondNode condNode) {
    }

    public void removeNode(JoinNode joinNode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTable() {
        Log.getLogger().entering("QueryBuilderGraphFrame", "removeTable");
        QueryBuilder.showBusyCursor(true);
        this._queryBuilder._updateText = false;
        try {
            this.removeTable(this._selectedNode);
        }
        finally {
            this._queryBuilder._updateText = true;
        }
        if (this._sqlTextArea.getText() == null) {
            this.runQueryMenuItem.setEnabled(false);
            this.groupByMenuItem.setEnabled(false);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(false);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(false);
        } else if (this._sqlTextArea.getText().trim().length() == 0) {
            this.runQueryMenuItem.setEnabled(false);
            this.groupByMenuItem.setEnabled(false);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(false);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(false);
        } else {
            this.runQueryMenuItem.setEnabled(true);
            this.groupByMenuItem.setEnabled(true);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(true);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(true);
        }
        QueryBuilder.showBusyCursor(false);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JMenuItem jMenuItem = (JMenuItem)itemEvent.getSource();
        if (jMenuItem.getText().equals(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"GROUP_BY"))) {
            if (itemEvent.getStateChange() == 1) {
                this._queryBuilder.getQueryModel().addGroupBy();
            } else {
                this._queryBuilder.getQueryModel().removeGroupBy();
            }
            this._queryBuilder.generateText();
        }
    }

    public void setGroupBy(boolean bl) {
        this.groupByMenuItem.setSelected(bl);
    }

    void redrawFrameWithMove(QueryBuilderInternalFrame queryBuilderInternalFrame) {
    }

    private void redrawFrame(QueryBuilderInternalFrame queryBuilderInternalFrame) {
    }

    void refresh() {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this._disableQBGF) {
            return;
        }
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                NotifyDescriptor.Message message;
                Object object = transferable.getTransferData(dataFlavorArray[i]);
                if (!(object instanceof Node)) continue;
                dropTargetDropEvent.acceptDrop(3);
                List<String> list = this._queryBuilder.getAllTables();
                String string = ((Node)object).getName();
                for (int j = 0; j < list.size(); ++j) {
                    String string2 = list.get(j);
                    message = string2.split("\\.");
                    String string3 = ((String[])message).length > 1 ? message[1] : message[0];
                    if (!string3.equals(string)) continue;
                    string = string2;
                    break;
                }
                if (list.contains(string)) {
                    this.insertTableInteractively(string);
                    this._queryBuilder.generateText();
                    this.runQueryMenuItem.setEnabled(true);
                    this.groupByMenuItem.setEnabled(true);
                    this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(true);
                    this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(true);
                    this.refresh();
                    this.resizeDesktop();
                } else {
                    String string4 = NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"DRAG_AND_DROP_FROM_CURRENT_DATASOURCE");
                    message = new NotifyDescriptor.Message((Object)(string4 + ", " + this._queryBuilder.getConnectionInfo() + "\n\n"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    private class CompListener
    extends ComponentAdapter {
        private CompListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (QueryBuilderGraphFrame.this._disableQBGF) {
                return;
            }
            QueryBuilderGraphFrame.this.refresh();
        }
    }

    private class FrameSelectionListener
    extends InternalFrameAdapter {
        private FrameSelectionListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            Object object = internalFrameEvent.getSource();
            QueryBuilderInternalFrame queryBuilderInternalFrame = (QueryBuilderInternalFrame)QueryBuilderGraphFrame.this._desktopPane.getSelectedFrame();
            QueryBuilderGraphFrame.this.setActivatedNode(queryBuilderInternalFrame);
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }
    }

    private class ObjectSelectProvider
    implements SelectProvider {
        private ObjectSelectProvider() {
        }

        public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
            return true;
        }

        public void select(Widget widget, Point point, boolean bl) {
            Object object = QueryBuilderGraphFrame.this._scene.findObject(widget);
            if (object != null && object instanceof AbstractNode) {
                AbstractNode abstractNode = (AbstractNode)object;
                QueryBuilderGraphFrame.this._queryBuilder.setActivatedNodes(new Node[]{abstractNode});
                QueryBuilderGraphFrame.this._scene.userSelectionSuggested(Collections.singleton(object), bl);
            }
        }
    }

    public class PerfTimer {
        long _time;

        public PerfTimer() {
            this.resetTimer();
        }

        public void resetTimer() {
            this._time = System.currentTimeMillis();
        }

        public long elapsedTime() {
            return System.currentTimeMillis() - this._time;
        }

        public void print(String string) {
            System.out.println(string + ": " + this.elapsedTime() + " ms");
        }
    }

    class QBGFJPanel
    extends JPanel {
        QBGFJPanel() {
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (QueryBuilderGraphFrame.this._queryBuilder.getParseErrorMessage() != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                this.paintCenteredText(graphics2D);
            }
        }

        private void paintCenteredText(Graphics2D graphics2D) {
            int n;
            int n2;
            int n3;
            int n4;
            String string = QueryBuilderGraphFrame.this._queryBuilder.getParseErrorMessage();
            int n5 = 1;
            int n6 = string.length();
            for (n4 = 0; n4 < n6; ++n4) {
                if (string.charAt(n4) != '\n') continue;
                ++n5;
            }
            n4 = QueryBuilderGraphFrame.this._desktopScrollPane.getViewport().getWidth();
            n6 = QueryBuilderGraphFrame.this._desktopScrollPane.getViewport().getHeight();
            this.setSize(new Dimension(n4, n6));
            int n7 = n6 / 2;
            Font font = UIManager.getFont("Label.font");
            graphics2D.setFont(font);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n8 = fontMetrics.getHeight() + 3;
            int n9 = n7 - n8 * n5 / 2;
            int n10 = n4;
            int n11 = 0;
            int n12 = 0;
            for (int i = 0; i < n5; ++i) {
                String string2;
                n3 = string.indexOf(10, n12);
                if (n3 != -1) {
                    string2 = string.substring(n12, n3);
                    n12 = n3 + 1;
                } else {
                    string2 = string.substring(n12);
                }
                Rectangle2D rectangle2D = font.getStringBounds(string2, fontRenderContext);
                n2 = (n4 - (int)rectangle2D.getWidth()) / 2;
                if (n2 < n10) {
                    n10 = n2;
                }
                if ((n = n2 + (int)rectangle2D.getWidth()) <= n11) continue;
                n11 = n;
            }
            Color color = null;
            color = this.getBackground();
            graphics2D.setColor(color);
            n3 = n9;
            int n13 = n9 + n5 * n8;
            graphics2D.fillRect(n10 - 5, n3, n11 - n10 + 10, n13 - n3 + 10);
            graphics2D.setColor(Color.gray);
            n12 = 0;
            int n14 = n9 + 10;
            n14 += fontMetrics.getHeight() - fontMetrics.getDescent();
            for (n2 = 0; n2 < n5; ++n2) {
                String string3;
                n = string.indexOf(10, n12);
                if (n != -1) {
                    string3 = string.substring(n12, n);
                    n12 = n + 1;
                } else {
                    string3 = string.substring(n12);
                }
                Rectangle2D rectangle2D = font.getStringBounds(string3, fontRenderContext);
                int n15 = (n4 - (int)rectangle2D.getWidth()) / 2;
                graphics2D.drawString(string3, n15, n14);
                n14 += n8;
            }
        }
    }

    class TableTitlePopupListener
    extends MouseAdapter {
        TableTitlePopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getComponent().isEnabled()) {
                QueryBuilderGraphFrame.this._tableTitlePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

