/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.mediacaster;

import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;

public class MediaStreamMediaCasterPlay
extends MediaStreamLivePlay {
    protected String mediaCasterType = "shoutcast";
    protected MediaCasterItem mediaCasterDef = null;
    protected MediaCasterStreamMap mediaCasterStreams = null;

    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        super.init(iMediaStream, mediaStreamMap);
        WMSProperties wMSProperties = this.getParent().getProperties();
        if (wMSProperties != null) {
            this.mediaCasterType = wMSProperties.getPropertyStr("mediaCasterType", this.mediaCasterType);
        }
        IApplicationInstance iApplicationInstance = mediaStreamMap.getAppInstance();
        this.mediaCasterStreams = iApplicationInstance.getMediaCasterStreams();
        IVHost iVHost = iApplicationInstance.getVHost();
        MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
        this.mediaCasterDef = mediaCasterList.getMediaCasterDef(this.mediaCasterType);
        if (this.mediaCasterDef == null) {
            WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).error("Can't find MediaCaster definition: " + this.mediaCasterType);
        }
    }

    public void startPlay() {
        WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).info("MediaStreamMediaCasterPlay: startPlay");
        this.mediaCasterStreams.registerPlayer((IMediaStreamPlay)this, this.mediaCasterDef);
        super.startPlay();
    }

    public void close() {
        WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).info("MediaStreamMediaCasterPlay: close");
        super.close();
        this.mediaCasterStreams.unregisterPlayer((IMediaStreamPlay)this, this.mediaCasterDef);
    }

    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        String string = this.mediaCasterDef.getIdString(this.getParent().getName());
        IMediaStream iMediaStream = this.getParent().getStreams().getStream(string);
        return iMediaStream == null ? 0 : super.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    public boolean play() {
        String string = this.mediaCasterDef.getIdString(this.getParent().getName());
        IMediaStream iMediaStream = this.getParent().getStreams().getStream(string);
        return iMediaStream == null ? false : super.play(iMediaStream);
    }
}

