/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.record;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.record.RecordReceiver;

public class MediaStreamRecord
extends MediaStream {
    private RecordReceiver recordReceiver = new RecordReceiver((IMediaStream)this);

    public void init(MediaStreamMap mediaStreamMap, int n, WMSProperties wMSProperties) {
        super.init(mediaStreamMap, n, wMSProperties);
        boolean bl = this.getProperties().getPropertyBoolean("versionFile", false);
        boolean bl2 = this.getProperties().getPropertyBoolean("recordWaitForVideoKeyFrame", false);
        this.recordReceiver.setVersionFile(bl);
        this.recordReceiver.setWaitForVideoKeyFrame(bl2);
        this.recordReceiver.init();
    }

    public void resetRecord() {
        this.recordReceiver.resetRecord();
    }

    public void addVideoData(byte[] byArray, int n, int n2) {
        this.recordReceiver.addVideoData(byArray, n, n2, this.videoSize, this.videoTC);
    }

    public void addDataData(byte[] byArray, int n, int n2) {
        this.recordReceiver.addDataData(byArray, n, n2, this.dataSize, this.dataTC);
    }

    public void addAudioData(byte[] byArray, int n, int n2) {
        this.recordReceiver.addAudioData(byArray, n, n2, this.audioSize, this.audioTC);
    }

    public int getAudioMissing() {
        return this.recordReceiver.getAudioMissing(this.audioSize);
    }

    public int getVideoMissing() {
        return this.recordReceiver.getVideoMissing(this.videoSize);
    }

    public int getDataMissing() {
        return this.recordReceiver.getDataMissing(this.dataSize);
    }

    public void publish() {
        this.recordReceiver.publish();
        super.reset();
    }

    public void trim() {
    }

    public boolean play() {
        return false;
    }

    public void resetNoLookup() {
    }

    public void reset() {
    }

    public void updateLoggingValues() {
        super.updateLoggingValues();
        if (!this.isPlay()) {
            this.recordReceiver.updateLoggingValues();
        }
    }

    public double length() {
        double d = 0.0;
        d = this.isPlay() ? super.length() : this.recordReceiver.length();
        return d;
    }

    public long size() {
        long l = 0L;
        l = this.isPlay() ? super.size() : this.recordReceiver.size();
        return l;
    }

    public void startPublishing() {
        this.recordReceiver.startPublishing();
    }

    public void stopPublishing() {
        this.recordReceiver.stopPublishing();
    }

    public void setVersionFile(boolean bl) {
        this.recordReceiver.setVersionFile(bl);
    }

    public void startAudioPacket() {
        this.recordReceiver.startAudioPacket();
    }

    public void startVideoPacket() {
        this.recordReceiver.startVideoPacket();
    }

    public void startDataPacket() {
        this.recordReceiver.startDataPacket();
    }
}

