/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LanguagesNavigatorModel
implements TreeModel {
    private NbEditorDocument document;
    private ASTNode astNode;
    private NavigatorNode root;
    private EventListenerList listenerList = new EventListenerList();
    private static NavigatorComparator navigatorComparator;
    private ParserListener parserListener;
    private ParserManagerImpl parserManager;

    LanguagesNavigatorModel() {
        this.root = new NavigatorNode("", "", null, true);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object object, int n) {
        return ((NavigatorNode)object).getNodes(null).get(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((NavigatorNode)object).getNodes(null).size();
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((NavigatorNode)object).getNodes(null).isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((NavigatorNode)object).getNodes(null).indexOf(object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    void setContext(NbEditorDocument nbEditorDocument) {
        this.document = nbEditorDocument;
        if (nbEditorDocument == null) {
            this.root = new NavigatorNode("", "", null, true);
            this.astNode = null;
            this.setParserManager(null);
            this.fire();
            return;
        }
        ParserManagerImpl parserManagerImpl = ParserManagerImpl.getImpl((Document)nbEditorDocument);
        this.setParserManager(parserManagerImpl);
        this.refreshASTNode();
    }

    private void setParserManager(ParserManagerImpl parserManagerImpl) {
        if (parserManagerImpl == this.parserManager) {
            return;
        }
        if (this.parserListener == null) {
            this.parserListener = new ParserListener();
        }
        if (this.parserManager != null) {
            this.parserManager.removeListener(this.parserListener);
        }
        if (parserManagerImpl != null) {
            parserManagerImpl.addListener(this.parserListener);
        }
        this.parserManager = parserManagerImpl;
    }

    private void refreshASTNode() {
        this.astNode = this.parserManager.getAST();
        if (this.astNode == null) {
            this.root = new NavigatorNode("", "", null, true);
            this.fire();
        } else {
            ArrayList<ASTItem> arrayList = new ArrayList<ASTItem>();
            arrayList.add(this.astNode);
            List<ASTNavigatorNode> list = this.root.getNodes(this);
            if (this.root instanceof ASTNavigatorNode && ((ASTNavigatorNode)this.root).document == this.document && list != null && list.size() > 0) {
                if (this.parserManager.getState() == ParserManager.State.PARSING) {
                    return;
                }
                ASTNavigatorNode aSTNavigatorNode = new ASTNavigatorNode((StyledDocument)this.document, this.astNode, arrayList, "Root", "", null, false);
                ((ASTNavigatorNode)this.root).refreshNode(this, aSTNavigatorNode, new LinkedList());
            } else {
                ASTNavigatorNode aSTNavigatorNode = new ASTNavigatorNode((StyledDocument)this.document, this.astNode, arrayList, "Root", "", null, false);
                aSTNavigatorNode.getNodes(this);
                if (this.parserManager.getState() == ParserManager.State.PARSING) {
                    return;
                }
                this.root = aSTNavigatorNode;
                this.fire();
            }
        }
    }

    private void fire() {
        TreeModelListener[] treeModelListenerArray = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        if (treeModelListenerArray.length == 0) {
            return;
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
        for (int i = 0; i < treeModelListenerArray.length; ++i) {
            treeModelListenerArray[i].treeStructureChanged(treeModelEvent);
        }
    }

    private void fireRemove(ASTNavigatorNode aSTNavigatorNode, int[] nArray, ASTNavigatorNode[] aSTNavigatorNodeArray, LinkedList<ASTNavigatorNode> linkedList) {
        TreeModelListener[] treeModelListenerArray = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        if (treeModelListenerArray.length == 0) {
            return;
        }
        TreePath treePath = new TreePath(linkedList.toArray());
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, (Object[])aSTNavigatorNodeArray);
        for (int i = 0; i < treeModelListenerArray.length; ++i) {
            treeModelListenerArray[i].treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireInsert(ASTNavigatorNode aSTNavigatorNode, int[] nArray, ASTNavigatorNode[] aSTNavigatorNodeArray, LinkedList<ASTNavigatorNode> linkedList) {
        TreeModelListener[] treeModelListenerArray = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        if (treeModelListenerArray.length == 0) {
            return;
        }
        TreePath treePath = new TreePath(linkedList.toArray());
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, (Object[])aSTNavigatorNodeArray);
        for (int i = 0; i < treeModelListenerArray.length; ++i) {
            treeModelListenerArray[i].treeNodesInserted(treeModelEvent);
        }
    }

    private boolean cancel() {
        return this.parserManager.getState() == ParserManager.State.PARSING;
    }

    TreePath getTreePath(int n) {
        if (this.astNode == null) {
            return null;
        }
        if (!(this.root instanceof ASTNavigatorNode)) {
            return null;
        }
        ASTPath aSTPath = this.astNode.findPath(n);
        if (aSTPath == null) {
            return null;
        }
        ArrayList<ASTNavigatorNode> arrayList = new ArrayList<ASTNavigatorNode>();
        ASTNavigatorNode aSTNavigatorNode = (ASTNavigatorNode)this.root;
        ListIterator<ASTItem> listIterator = aSTPath.listIterator();
        if (listIterator.next() != aSTNavigatorNode.item) {
            return null;
        }
        arrayList.add(aSTNavigatorNode);
        block0: while (listIterator.hasNext()) {
            ASTItem aSTItem = (ASTItem)listIterator.next();
            for (ASTNavigatorNode aSTNavigatorNode2 : aSTNavigatorNode.getNodes(null)) {
                if (aSTNavigatorNode2.item != aSTItem) continue;
                aSTNavigatorNode = aSTNavigatorNode2;
                arrayList.add(aSTNavigatorNode2);
                continue block0;
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new TreePath(arrayList.toArray());
    }

    String getTooltip(Object object) {
        return ((NavigatorNode)object).tooltip;
    }

    void show(Object object) {
        ((NavigatorNode)object).show();
    }

    String getIcon(Object object) {
        return ((NavigatorNode)object).icon;
    }

    String getDisplayName(Object object) {
        return ((NavigatorNode)object).displayName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ASTNavigatorNode
    extends NavigatorNode {
        ASTItem item;
        List<ASTItem> path;
        private StyledDocument document;
        private List<ASTNavigatorNode> nodes;

        ASTNavigatorNode(StyledDocument styledDocument, ASTItem aSTItem, List<ASTItem> list, String string, String string2, String string3, boolean bl) {
            super(string, string2, string3, bl);
            this.document = styledDocument;
            this.item = aSTItem;
            this.path = list;
        }

        @Override
        void show() {
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)this.document);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            Line.Set set = lineCookie.getLineSet();
            Line line = set.getCurrent(NbDocument.findLineNumber((StyledDocument)this.document, (int)this.item.getOffset()));
            int n = NbDocument.findLineColumn((StyledDocument)this.document, (int)this.item.getOffset());
            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, n);
        }

        @Override
        List<ASTNavigatorNode> getNodes(LanguagesNavigatorModel languagesNavigatorModel) {
            Feature feature;
            if (this.nodes != null) {
                return this.nodes;
            }
            if (this.isLeaf) {
                this.nodes = Collections.emptyList();
                return this.nodes;
            }
            this.nodes = new ArrayList<ASTNavigatorNode>();
            this.getNavigatorNodes(this.item, new ArrayList<ASTItem>(this.path), this.nodes, languagesNavigatorModel);
            Language language = (Language)this.item.getLanguage();
            if (language != null && (feature = language.getFeatureList().getFeature("PROPERTIES")) != null && feature.getBoolean("navigator-sort", false)) {
                if (navigatorComparator == null) {
                    LanguagesNavigatorModel.navigatorComparator = new NavigatorComparator();
                }
                Collections.sort(this.nodes, navigatorComparator);
            }
            return this.nodes;
        }

        private void refreshNode(LanguagesNavigatorModel languagesNavigatorModel, ASTNavigatorNode aSTNavigatorNode, LinkedList<ASTNavigatorNode> linkedList) {
            this.item = aSTNavigatorNode.item;
            this.path = aSTNavigatorNode.path;
            if (this.nodes == null) {
                return;
            }
            linkedList.add(this);
            List<ASTNavigatorNode> list = aSTNavigatorNode.getNodes(languagesNavigatorModel);
            ArrayList<ASTNavigatorNode> arrayList = new ArrayList<ASTNavigatorNode>(list.size());
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            for (ASTNavigatorNode aSTNavigatorNodeArray2 : list) {
                int aSTNavigatorNodeArray3;
                ASTNavigatorNode i = null;
                for (aSTNavigatorNodeArray3 = n; aSTNavigatorNodeArray3 < this.nodes.size(); ++aSTNavigatorNodeArray3) {
                    if (!this.compareNodes(aSTNavigatorNodeArray2, this.nodes.get(aSTNavigatorNodeArray3))) continue;
                    i = this.nodes.get(aSTNavigatorNodeArray3);
                    n = aSTNavigatorNodeArray3 + 1;
                    break;
                }
                if (i != null) {
                    arrayList.add(i);
                    for (aSTNavigatorNodeArray3 = n2; aSTNavigatorNodeArray3 < n - 1; ++aSTNavigatorNodeArray3) {
                        arrayList2.add(aSTNavigatorNodeArray3);
                    }
                    n2 = n;
                    i.refreshNode(languagesNavigatorModel, aSTNavigatorNodeArray2, linkedList);
                } else {
                    arrayList.add(aSTNavigatorNodeArray2);
                    arrayList3.add(n3);
                }
                ++n3;
            }
            for (int i = n; i < this.nodes.size(); ++i) {
                arrayList2.add(i);
            }
            int[] nArray = new int[arrayList2.size()];
            ASTNavigatorNode[] aSTNavigatorNodeArray = new ASTNavigatorNode[arrayList2.size()];
            for (int nArray2 = 0; nArray2 < nArray.length; ++nArray2) {
                nArray[nArray2] = (Integer)arrayList2.get(nArray2);
                aSTNavigatorNodeArray[nArray2] = this.nodes.get(nArray[nArray2]);
            }
            int[] nArray2 = new int[arrayList3.size()];
            ASTNavigatorNode[] aSTNavigatorNodeArray2 = new ASTNavigatorNode[arrayList3.size()];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = (Integer)arrayList3.get(i);
                aSTNavigatorNodeArray2[i] = list.get(nArray2[i]);
            }
            this.nodes = arrayList;
            if (nArray.length > 0) {
                languagesNavigatorModel.fireRemove(this, nArray, aSTNavigatorNodeArray, linkedList);
            }
            if (nArray2.length > 0) {
                languagesNavigatorModel.fireInsert(this, nArray2, aSTNavigatorNodeArray2, linkedList);
            }
            linkedList.removeLast();
        }

        private void getNavigatorNodes(ASTItem aSTItem, List<ASTItem> list, List<ASTNavigatorNode> list2, LanguagesNavigatorModel languagesNavigatorModel) {
            Iterator<ASTItem> iterator = aSTItem.getChildren().iterator();
            while (iterator.hasNext()) {
                if (languagesNavigatorModel != null && languagesNavigatorModel.cancel()) {
                    return;
                }
                ASTItem aSTItem2 = iterator.next();
                list.add(aSTItem2);
                ASTNavigatorNode aSTNavigatorNode = this.createNavigatorNode(aSTItem2, list);
                if (aSTNavigatorNode != null) {
                    list2.add(aSTNavigatorNode);
                } else {
                    this.getNavigatorNodes(aSTItem2, list, list2, languagesNavigatorModel);
                }
                list.remove(list.size() - 1);
            }
        }

        private ASTNavigatorNode createNavigatorNode(ASTItem aSTItem, List<ASTItem> list) {
            ASTPath aSTPath = ASTPath.create(list);
            Feature feature = null;
            Language language = (Language)aSTItem.getLanguage();
            if (language == null) {
                return null;
            }
            feature = language.getFeatureList().getFeature("NAVIGATOR", aSTPath);
            if (feature == null) {
                return null;
            }
            SyntaxContext syntaxContext = SyntaxContext.create((Document)this.document, aSTPath);
            String string = (String)feature.getValue("display_name", syntaxContext);
            if (string == null || string.trim().length() == 0) {
                return null;
            }
            String string2 = (String)feature.getValue("tooltip", syntaxContext);
            String string3 = (String)feature.getValue("icon", syntaxContext);
            if (string3 == null) {
                string3 = "org/netbeans/modules/languages/resources/node.gif";
            }
            boolean bl = feature.getBoolean("isLeaf", syntaxContext, false);
            return new ASTNavigatorNode(this.document, aSTItem, new ArrayList<ASTItem>(list), string, string2, string3, bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NavigatorComparator
    implements Comparator<NavigatorNode> {
        NavigatorComparator() {
        }

        @Override
        public int compare(NavigatorNode navigatorNode, NavigatorNode navigatorNode2) {
            return navigatorNode.displayName.compareToIgnoreCase(navigatorNode2.displayName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NavigatorNode {
        String displayName;
        String tooltip;
        String icon;
        boolean isLeaf;

        NavigatorNode(String string, String string2, String string3, boolean bl) {
            this.displayName = string;
            this.tooltip = string2;
            this.icon = string3;
            this.isLeaf = bl;
        }

        void show() {
        }

        List<ASTNavigatorNode> getNodes(LanguagesNavigatorModel languagesNavigatorModel) {
            return Collections.emptyList();
        }

        boolean compareNodes(NavigatorNode navigatorNode, NavigatorNode navigatorNode2) {
            if (navigatorNode.displayName == null ? navigatorNode2.displayName != null : !navigatorNode.displayName.equals(navigatorNode2.displayName)) {
                return false;
            }
            if (navigatorNode.icon == null ? navigatorNode2.icon != null : !navigatorNode.icon.equals(navigatorNode2.icon)) {
                return false;
            }
            return navigatorNode.isLeaf == navigatorNode2.isLeaf;
        }
    }

    class ParserListener
    implements ParserManagerListener {
        ParserListener() {
        }

        public void parsed(ParserManager.State state, ASTNode aSTNode) {
            if (state == ParserManager.State.PARSING) {
                return;
            }
            LanguagesNavigatorModel.this.refreshASTNode();
        }
    }
}

