/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.mercurial;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ini4j.Ini;
import org.ini4j.InvalidIniFormatException;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.mercurial.MercurialHyperlink;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.openide.util.NbBundle;
import org.openide.windows.OutputListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonMercurialSCM
implements HudsonSCM {
    static final Logger LOG = Logger.getLogger(HudsonMercurialSCM.class.getName());

    public HudsonSCM.Configuration forFolder(File file) {
        final URI uRI = HudsonMercurialSCM.getDefaultPull(file.toURI());
        if (uRI == null) {
            return null;
        }
        return new HudsonSCM.Configuration(){

            public void configure(Document document) {
                Element element = document.getDocumentElement();
                Element element2 = (Element)element.appendChild(document.createElement("scm"));
                element2.setAttribute("class", "hudson.plugins.mercurial.MercurialSCM");
                element2.appendChild(document.createElement("source")).appendChild(document.createTextNode(uRI.toString()));
                element2.appendChild(document.createElement("modules")).appendChild(document.createTextNode(""));
                element2.appendChild(document.createElement("clean")).appendChild(document.createTextNode("true"));
                HudsonSCM.Helper.addTrigger((Document)document);
            }

            public ProjectHudsonJobCreatorFactory.ConfigurationStatus problems() {
                if (!uRI.isAbsolute() || "file".equals(uRI.getScheme())) {
                    return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withWarning((String)NbBundle.getMessage(HudsonMercurialSCM.class, (String)"warning.local_repo", (Object)uRI));
                }
                return null;
            }
        };
    }

    public String translateWorkspacePath(HudsonJob hudsonJob, String string, File file) {
        return null;
    }

    public List<? extends HudsonJobChangeItem> parseChangeSet(HudsonJob hudsonJob, Element element) {
        if (!"hg".equals(HudsonSCM.Helper.xpath((String)"kind", (Element)element))) {
            return null;
        }
        URI uRI = HudsonMercurialSCM.getDefaultPull(URI.create(hudsonJob.getUrl() + "ws/"), hudsonJob);
        if (uRI == null) {
            LOG.log(Level.FINE, "No known repo location for {0}", hudsonJob);
        }
        if (uRI != null && !"http".equals(uRI.getScheme()) && !"https".equals(uRI.getScheme())) {
            LOG.log(Level.FINE, "Need hgweb to show changes from {0}", uRI);
            uRI = null;
        }
        final URI uRI2 = uRI;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class HgItem
        implements HudsonJobChangeItem {
            final Element itemXML;

            HgItem(Element element) {
                this.itemXML = element;
            }

            public String getUser() {
                return HudsonSCM.Helper.xpath((String)"author/fullName", (Element)this.itemXML);
            }

            public String getMessage() {
                return HudsonSCM.Helper.xpath((String)"msg", (Element)this.itemXML);
            }

            public Collection<? extends HudsonJobChangeItem.HudsonJobChangeFile> getFiles() {
                int n;
                if ("true".equals(HudsonSCM.Helper.xpath((String)"merge", (Element)this.itemXML))) {
                    return Collections.emptySet();
                }
                final String string = HudsonSCM.Helper.xpath((String)"node", (Element)this.itemXML);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class HgFile
                implements HudsonJobChangeItem.HudsonJobChangeFile {
                    final String path;
                    final HudsonJobChangeItem.HudsonJobChangeFile.EditType editType;

                    HgFile(String string3, HudsonJobChangeItem.HudsonJobChangeFile.EditType editType) {
                        this.path = string3;
                        this.editType = editType;
                    }

                    public String getName() {
                        return this.path;
                    }

                    public HudsonJobChangeItem.HudsonJobChangeFile.EditType getEditType() {
                        return this.editType;
                    }

                    public OutputListener hyperlink() {
                        return uRI2 != null ? new MercurialHyperlink(uRI2, string, this) : null;
                    }
                }
                ArrayList<HgFile> arrayList = new ArrayList<HgFile>();
                NodeList nodeList = this.itemXML.getElementsByTagName("addedPath");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    arrayList.add(new HgFile(HudsonSCM.Helper.xpath((String)"text()", (Element)((Element)nodeList.item(n))), HudsonJobChangeItem.HudsonJobChangeFile.EditType.add));
                }
                nodeList = this.itemXML.getElementsByTagName("modifiedPath");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    arrayList.add(new HgFile(HudsonSCM.Helper.xpath((String)"text()", (Element)((Element)nodeList.item(n))), HudsonJobChangeItem.HudsonJobChangeFile.EditType.edit));
                }
                nodeList = this.itemXML.getElementsByTagName("deletedPath");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    arrayList.add(new HgFile(HudsonSCM.Helper.xpath((String)"text()", (Element)((Element)nodeList.item(n))), HudsonJobChangeItem.HudsonJobChangeFile.EditType.delete));
                }
                return arrayList;
            }
        }
        ArrayList<HgItem> arrayList = new ArrayList<HgItem>();
        NodeList nodeList = element.getElementsByTagName("item");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(new HgItem((Element)nodeList.item(i)));
        }
        return arrayList;
    }

    static URI getDefaultPull(URI uRI) {
        return HudsonMercurialSCM.getDefaultPull(uRI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI getDefaultPull(URI uRI, HudsonJob hudsonJob) {
        Object object;
        assert (uRI.toString().endsWith("/"));
        URI uRI2 = uRI.resolve(".hg/hgrc");
        String string = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HudsonMercurialSCM.class.getClassLoader());
        try {
            object = new ConnectionBuilder();
            if (hudsonJob != null) {
                object = object.job(hudsonJob);
            }
            InputStream inputStream = object.url(uRI2.toURL()).connection().getInputStream();
            try {
                Ini ini = new Ini(inputStream);
                Ini.Section section = (Ini.Section)ini.get((Object)"paths");
                if (section != null && (string = (String)section.get((Object)"default-pull")) == null) {
                    string = (String)section.get((Object)"default");
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (InvalidIniFormatException invalidIniFormatException) {
            LOG.log(Level.FINE, "{0} was malformed, perhaps no workspace: {1}", new Object[]{uRI2, invalidIniFormatException});
            URI uRI3 = null;
            return uRI3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.log(Level.FINE, "{0} is not an Hg repo", uRI);
            URI uRI4 = null;
            return uRI4;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Could not parse " + uRI2, exception);
            URI uRI5 = null;
            return uRI5;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        if (string == null) {
            LOG.log(Level.FINE, "{0} does not specify paths.default or default-pull", uRI2);
            return null;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            LOG.log(Level.FINE, "{0} looks like a local file location", string);
            return new File(string).toURI();
        }
        object = string.replaceFirst("//[^/]+(:[^/]+)?@", "//");
        try {
            return uRI.resolve(new URI((String)object));
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.log(Level.FINE, "{0} is not a valid URI", object);
            return null;
        }
    }
}

