/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningAnnotationProvider
extends AnnotationProvider {
    static VersioningAnnotationProvider instance;
    private Map<FileSystem, Set<FileObject>> filesToRefresh = new HashMap<FileSystem, Set<FileObject>>();
    private Map<FileSystem, Set<FileObject>> parentsToRefresh = new HashMap<FileSystem, Set<FileObject>>();
    private RequestProcessor rp = new RequestProcessor("Versioning fire FileStatusChanged", 1, true);
    private RequestProcessor.Task refreshAllAnnotationsTask = this.rp.create(new Runnable(){

        public void run() {
            VersioningAnnotationProvider.this.clearMap(VersioningAnnotationProvider.this.filesToRefresh);
            VersioningAnnotationProvider.this.clearMap(VersioningAnnotationProvider.this.parentsToRefresh);
            FileSystem fileSystem = Utils.getRootFilesystem();
            VersioningAnnotationProvider.this.fireFileStatusChanged(new FileStatusEvent(fileSystem, true, true));
        }
    });
    private RequestProcessor.Task fireFileStatusChangedTask = this.rp.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet hashSet;
            Set set;
            FileSystem fileSystem;
            Object object;
            Object object2;
            Object object3;
            ArrayList<FileStatusEvent> arrayList = new ArrayList<FileStatusEvent>();
            ArrayList<FileStatusEvent> arrayList2 = new ArrayList<FileStatusEvent>();
            Object object4 = VersioningAnnotationProvider.this.filesToRefresh;
            synchronized (object4) {
                object3 = VersioningAnnotationProvider.this.filesToRefresh.keySet();
                if (object3 == null || object3.size() == 0) {
                    return;
                }
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (FileSystem)object2.next();
                    fileSystem = new HashSet();
                    set = new HashSet<FileObject>();
                    hashSet = (HashSet)VersioningAnnotationProvider.this.filesToRefresh.get(object);
                    for (FileObject fileObject : hashSet) {
                        if (fileObject.isFolder()) {
                            set.add(fileObject);
                            continue;
                        }
                        fileSystem.add(fileObject);
                    }
                    hashSet.clear();
                    if (fileSystem.size() > 0) {
                        arrayList.add(new FileStatusEvent((FileSystem)object, (Set)fileSystem, true, true));
                    }
                    if (set.size() <= 0) continue;
                    arrayList2.add(new FileStatusEvent((FileSystem)object, set, true, true));
                }
            }
            this.fireFileStatusEvents(arrayList);
            this.fireFileStatusEvents(arrayList2);
            object4 = new ArrayList();
            object3 = VersioningAnnotationProvider.this.parentsToRefresh;
            synchronized (object3) {
                object2 = VersioningAnnotationProvider.this.parentsToRefresh.keySet();
                object = object2.iterator();
                while (object.hasNext()) {
                    fileSystem = (FileSystem)object.next();
                    set = (Set)VersioningAnnotationProvider.this.parentsToRefresh.get(fileSystem);
                    hashSet = new HashSet(set);
                    object4.add(new FileStatusEvent(fileSystem, hashSet, true, false));
                    set.clear();
                }
            }
            this.fireFileStatusEvents((Collection<FileStatusEvent>)object4);
        }

        private void fireFileStatusEvents(Collection<FileStatusEvent> collection) {
            for (FileStatusEvent fileStatusEvent : collection) {
                VersioningAnnotationProvider.this.fireFileStatusChanged(fileStatusEvent);
            }
        }
    });

    public VersioningAnnotationProvider() {
        instance = this;
    }

    private VersioningSystem getOwner(File file) {
        return file == null ? null : VersioningManager.getInstance().getOwner(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image annotateIcon(Image image, int n, Set<? extends FileObject> set) {
        long l = System.currentTimeMillis();
        VersioningManager.LOG.log(Level.FINE, "annotateIcon");
        Object object = null;
        long l2 = 0L;
        try {
            if (set.isEmpty()) {
                Image image2 = image;
                return image2;
            }
            FileObject fileObject = set.iterator().next();
            VersioningSystem versioningSystem = this.getOwner(FileUtil.toFile((FileObject)fileObject));
            if (versioningSystem == null) {
                Image image3 = null;
                return image3;
            }
            object = versioningSystem.getVCSAnnotator();
            if (object == null) {
                Image image4 = null;
                return image4;
            }
            VCSContext vCSContext = Utils.contextForFileObjects(set);
            l2 = System.currentTimeMillis();
            Image image5 = ((VCSAnnotator)object).annotateIcon(image, vCSContext);
            return image5;
        }
        finally {
            if (VersioningManager.LOG.isLoggable(Level.FINE)) {
                long l3 = System.currentTimeMillis();
                if (object != null) {
                    VersioningManager.LOG.log(Level.FINE, " " + object.getClass().getName() + " returns in " + (l3 - l2) + " millis");
                }
                VersioningManager.LOG.fine("annotateIcon returns in " + (l3 - l) + " millis");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String annotateNameHtml(String string, Set<? extends FileObject> set) {
        long l = System.currentTimeMillis();
        VersioningManager.LOG.log(Level.FINE, "annotateNameHtml");
        Object object = null;
        long l2 = 0L;
        try {
            if (set.isEmpty()) {
                String string2 = string;
                return string2;
            }
            FileObject fileObject = set.iterator().next();
            VersioningSystem versioningSystem = this.getOwner(FileUtil.toFile((FileObject)fileObject));
            if (versioningSystem == null) {
                String string3 = null;
                return string3;
            }
            object = versioningSystem.getVCSAnnotator();
            if (object == null) {
                String string4 = null;
                return string4;
            }
            l2 = System.currentTimeMillis();
            VCSContext vCSContext = Utils.contextForFileObjects(set);
            String string5 = ((VCSAnnotator)object).annotateName(string, vCSContext);
            return string5;
        }
        finally {
            if (VersioningManager.LOG.isLoggable(Level.FINE)) {
                long l3 = System.currentTimeMillis();
                if (object != null) {
                    VersioningManager.LOG.log(Level.FINE, " " + object.getClass().getName() + " returns in " + (l3 - l2) + " millis");
                }
                VersioningManager.LOG.fine("annotateNameHtml returns in " + (l3 - l) + " millis");
            }
        }
    }

    public Action[] actions(Set set) {
        Object object;
        Object object22;
        if (set.isEmpty()) {
            return new Action[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LocalHistoryActions localHistoryActions = null;
        HashMap<VersioningSystem, ArrayList<Object>> hashMap = new HashMap<VersioningSystem, ArrayList<Object>>(3);
        for (Object object22 : set) {
            VersioningSystem versioningSystem;
            object = FileUtil.toFile((FileObject)object22);
            if (object == null) continue;
            VersioningSystem versioningSystem2 = VersioningManager.getInstance().getLocalHistory((File)object);
            if (localHistoryActions == null && versioningSystem2 != null && versioningSystem2.getVCSAnnotator() != null) {
                localHistoryActions = (LocalHistoryActions)SystemAction.get(LocalHistoryActions.class);
                localHistoryActions.setVersioningSystem(versioningSystem2);
                arrayList.add((Object)localHistoryActions);
            }
            if ((versioningSystem = this.getOwner((File)object)) == null) continue;
            ArrayList<Object> arrayList2 = (ArrayList<Object>)hashMap.get(versioningSystem);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Object>();
            }
            arrayList2.add(object);
            hashMap.put(versioningSystem, arrayList2);
        }
        Object object3 = null;
        if (hashMap.keySet().size() != 1) {
            return arrayList.toArray(new Action[arrayList.size()]);
        }
        object3 = (VersioningSystem)hashMap.keySet().iterator().next();
        object22 = null;
        if (object3 != null) {
            object22 = ((VersioningSystem)object3).getVCSAnnotator();
        }
        if (object22 != null) {
            object = (VersioningSystemActions)SystemAction.get(VersioningSystemActions.class);
            ((AbstractVersioningSystemActions)((Object)object)).setVersioningSystem((VersioningSystem)object3);
            arrayList.add(object);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public InterceptionListener getInterceptionListener() {
        return VersioningManager.getInstance().getInterceptionListener();
    }

    public String annotateName(String string, Set set) {
        return string;
    }

    static void refreshAllAnnotations() {
        if (instance != null) {
            instance.refreshAnnotations(null);
        }
    }

    void refreshAnnotations(Set<File> set) {
        if (set == null) {
            this.refreshAllAnnotationsTask.schedule(2000);
            return;
        }
        for (File file : set) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (fileObject == null) {
                fileObject = this.getExistingParent(file);
            } else {
                this.addToMap(this.filesToRefresh, fileObject);
                fileObject = fileObject.getParent();
            }
            for (FileObject fileObject2 = fileObject; fileObject2 != null; fileObject2 = fileObject2.getParent()) {
                this.addToMap(this.parentsToRefresh, fileObject2);
            }
        }
        this.fireFileStatusChangedTask.schedule(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMap(Map<FileSystem, Set<FileObject>> map) {
        Map<FileSystem, Set<FileObject>> map2 = map;
        synchronized (map2) {
            if (map.size() > 0) {
                map.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMap(Map<FileSystem, Set<FileObject>> map, FileObject fileObject) {
        FileSystem fileSystem;
        if (fileObject == null) {
            return;
        }
        try {
            fileSystem = fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return;
        }
        Map<FileSystem, Set<FileObject>> map2 = map;
        synchronized (map2) {
            Set<FileObject> set = map.get(fileSystem);
            if (set == null) {
                set = new HashSet<FileObject>();
                map.put(fileSystem, set);
            }
            set.add(fileObject);
        }
    }

    private FileObject getExistingParent(File file) {
        FileObject fileObject = null;
        for (File file2 = file; file2 != null && fileObject == null; file2 = file2.getParentFile()) {
            file2 = FileUtil.normalizeFile((File)file2);
            fileObject = FileUtil.toFileObject((File)file2);
        }
        return fileObject;
    }

    public static abstract class AbstractVersioningSystemActions
    extends SystemAction
    implements ContextAwareAction {
        private VersioningSystem system;

        public String getName() {
            return Utils.getDisplayName(this.system);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.system.getClass());
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new RealVersioningSystemActions(this.system, Utils.contextForLookup(lookup));
        }

        public void setVersioningSystem(VersioningSystem versioningSystem) {
            this.system = versioningSystem;
        }
    }

    public static class LocalHistoryActions
    extends AbstractVersioningSystemActions {
    }

    private static class RealVersioningSystemActions
    extends AbstractAction
    implements Presenter.Popup {
        private final VersioningSystem system;
        private final VCSContext context;

        public RealVersioningSystemActions(VersioningSystem versioningSystem, VCSContext vCSContext) {
            super(Utils.getDisplayName(versioningSystem));
            this.system = versioningSystem;
            this.context = vCSContext;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            return new VersioningSystemMenuItem();
        }

        private class VersioningSystemMenuItem
        extends JMenu {
            private boolean popupContructed;

            public VersioningSystemMenuItem() {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)Utils.getDisplayName(RealVersioningSystemActions.this.system));
            }

            public void setSelected(boolean bl) {
                if (bl && !this.popupContructed) {
                    Action[] actionArray = RealVersioningSystemActions.this.system.getVCSAnnotator().getActions(RealVersioningSystemActions.this.context, VCSAnnotator.ActionDestination.PopupMenu);
                    for (int i = 0; i < actionArray.length; ++i) {
                        Action action = actionArray[i];
                        if (action == null) {
                            this.addSeparator();
                            continue;
                        }
                        JMenuItem jMenuItem = Utils.toMenuItem(action);
                        this.add(jMenuItem);
                    }
                    this.popupContructed = true;
                }
                super.setSelected(bl);
            }
        }
    }

    public static class VersioningSystemActions
    extends AbstractVersioningSystemActions {
    }
}

