/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.MainProjectScanningScope;
import org.netbeans.modules.tasklist.projectint.OpenedProjectsIterator;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenedProjectsScanningScope
extends TaskScanningScope
implements PropertyChangeListener {
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;
    private Project[] currentProjects;

    private OpenedProjectsScanningScope(String string, String string2, Image image) {
        super(string, string2, image, true);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("StatusBarLabel", NbBundle.getMessage(OpenedProjectsScanningScope.class, (String)"LBL_OpenedProjectsStatusBar"));
        this.lookupContent.add(hashMap);
    }

    public static OpenedProjectsScanningScope create() {
        return new OpenedProjectsScanningScope(NbBundle.getBundle(MainProjectScanningScope.class).getString("LBL_OpenedProjectsScope"), NbBundle.getBundle(MainProjectScanningScope.class).getString("HINT_OpenedProjectsScope"), ImageUtilities.loadImage((String)"org/netbeans/modules/tasklist/projectint/opened_projects_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        return new OpenedProjectsIterator();
    }

    public boolean isInScope(FileObject fileObject) {
        if (null == fileObject || null == this.currentProjects) {
            return false;
        }
        for (Project project : this.currentProjects) {
            SourceGroup[] sourceGroupArray;
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("generic")) {
                FileObject fileObject2 = sourceGroup.getRootFolder();
                if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) && !fileObject2.equals(fileObject)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        OpenedProjectsScanningScope openedProjectsScanningScope = this;
        synchronized (openedProjectsScanningScope) {
            if (null == this.lookup) {
                this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
            }
        }
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(TaskScanningScope.Callback callback) {
        OpenedProjectsScanningScope openedProjectsScanningScope = this;
        synchronized (openedProjectsScanningScope) {
            if (null != callback && null == this.callback) {
                OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
                this.setLookupContent(OpenProjects.getDefault().getOpenProjects());
            } else if (null == callback && null != this.callback) {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
                this.setLookupContent(null);
            }
            this.callback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
            OpenedProjectsScanningScope openedProjectsScanningScope = this;
            synchronized (openedProjectsScanningScope) {
                if (null != this.callback) {
                    this.setLookupContent(OpenProjects.getDefault().getOpenProjects());
                    this.callback.refresh();
                }
            }
        }
    }

    private void setLookupContent(Project[] projectArray) {
        if (null != this.currentProjects) {
            for (Project project : this.currentProjects) {
                this.lookupContent.remove((Object)project);
            }
        }
        if (null != projectArray) {
            for (Project project : projectArray) {
                this.lookupContent.add((Object)project);
            }
        }
        this.currentProjects = projectArray;
    }
}

