/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jdesktop.layout.GroupLayout;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiNotification;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.CompoundUndoManager;
import org.netbeans.modules.kenai.collab.chat.InsertLinkAction;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.LinkOtherFileAction;
import org.netbeans.modules.kenai.collab.chat.LinkOtherIssue;
import org.netbeans.modules.kenai.collab.chat.MessageHistoryManager;
import org.netbeans.modules.kenai.collab.chat.MessagingHandleImpl;
import org.netbeans.modules.kenai.collab.chat.NotificationExtension;
import org.netbeans.modules.kenai.ui.spi.KenaiIssueAccessor;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.DropDownButtonFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ChatPanel
extends JPanel {
    private MultiUserChat muc;
    private Chat suc;
    private boolean disableAutoScroll = false;
    private HTMLEditorKit editorKit = null;
    private static final String[][] smileysMap = new String[][]{{"B)", "cool"}, {"B-)", "cool"}, {"8-)", "cool"}, {":]", "grin"}, {":-]", "grin"}, {":D", "laughing"}, {":-D", "laughing"}, {":(", "sad"}, {":-(", "sad"}, {":)", "smiley"}, {":-)", "smiley"}, {";)", "wink"}, {";-)", "wink"}};
    private CompoundUndoManager undo;
    private MessageHistoryManager history = new MessageHistoryManager();
    private static final String ISSUE_REPORT_STRING = "(issue |bug |ISSUE:|ISSUE: )#?([A-Z_]+-)*([0-9]+)";
    private static final Pattern ISSUE_REPORT = Pattern.compile("(issue |bug |ISSUE:|ISSUE: )#?([A-Z_]+-)*([0-9]+)", 2);
    private static final String STACK_TRACE_STRING = "(|catch.)at.((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)";
    private static final Pattern STACK_TRACE = Pattern.compile("(|catch.)at.((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)");
    private static final String EXCEPTION_MESSAGE_STRING = "(?:Exception in thread \"(?:main|Main Thread)\" )?(?:(?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)+)([a-zA-Z_$][a-zA-Z0-9_$]*(?:: .+)?)";
    private static final Pattern EXCEPTION_MESSAGE = Pattern.compile("(?:Exception in thread \"(?:main|Main Thread)\" )?(?:(?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)+)([a-zA-Z_$][a-zA-Z0-9_$]*(?:: .+)?)");
    private static final String CLASSPATH_RESOURCE_STRING = "FILE:(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))";
    private static final Pattern CLASSPATH_RESOURCE = Pattern.compile("FILE:(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))");
    private static final String ABSOLUTE_RESOURCE_STRING = "FILE:/(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))";
    private static final Pattern ABSOLUTE_RESOURCE = Pattern.compile("FILE:/(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))");
    private static final String PROJECT_RESOURCE_STRING = "FILE:\\{\\$([a-zA-Z_$][\\.a-zA-Z0-9_$]*)\\}/(([a-zA-Z_$][a-zA-Z0-9_$]*/)*)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))";
    private static final Pattern PROJECT_RESOURCE = Pattern.compile("FILE:\\{\\$([a-zA-Z_$][\\.a-zA-Z0-9_$]*)\\}/(([a-zA-Z_$][a-zA-Z0-9_$]*/)*)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))");
    private static final Pattern RESOURCES = Pattern.compile("((|catch.)at.((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\))|(FILE:(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+)))|(FILE:\\{\\$([a-zA-Z_$][\\.a-zA-Z0-9_$]*)\\}/(([a-zA-Z_$][a-zA-Z0-9_$]*/)*)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+)))|(FILE:/(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+)))");
    List undoCharsList = Arrays.asList(Character.valueOf(' '), Character.valueOf('.'), Character.valueOf(','), Character.valueOf('!'), Character.valueOf('\t'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf(';'));
    private JPanel buttons;
    private JPopupMenu dropDownMenu;
    private JTextPane inbox;
    private JPanel inboxPanel;
    private JScrollPane inboxScrollPane;
    private JLabel online;
    private JTextPane outbox;
    private JPanel outboxPanel;
    private JScrollPane outboxScrollPane;
    private JButton sendButton;
    private JButton sendLinkButton;
    private JSplitPane splitter;
    private JLabel statusLine;
    private JMenuItem temp;
    private JPanel topPanel;
    private Date lastDatePrinted;
    private Date lastMessageDate;
    private String lastNickPrinted = null;
    private String rgb = null;

    private void addNotificationsMenuItem(JPopupMenu jPopupMenu) throws MissingResourceException {
        NotificationsEnabledAction notificationsEnabledAction = new NotificationsEnabledAction();
        String string = null;
        try {
            string = this.isPrivate() ? this.getPrivateName() : Kenai.getDefault().getProject(this.getName()).getDisplayName();
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(ChatPanel.class, (String)"CTL_NotificationsFor", (Object[])new Object[]{string}), ChatNotifications.getDefault().isEnabled(this.getName()));
        jCheckBoxMenuItem.addActionListener(notificationsEnabledAction);
        jPopupMenu.add(jCheckBoxMenuItem);
    }

    private void insertLinkToEditor() {
        if (EditorRegistry.lastFocusedComponent() != null) {
            new InsertLinkAction(EditorRegistry.lastFocusedComponent(), this.outbox, true, false).actionPerformed(null);
        }
    }

    private TopComponent selectedEditorComponent() {
        Mode mode = WindowManager.getDefault().findMode("editor");
        TopComponent topComponent = mode.getSelectedTopComponent();
        TopComponent topComponent2 = this.getTopComponent(EditorRegistry.lastFocusedComponent());
        if (topComponent2 == topComponent) {
            return topComponent;
        }
        return null;
    }

    private void insertLinkToIssue() {
        KenaiIssueAccessor.IssueHandle[] issueHandleArray;
        if (this.muc == null) {
            issueHandleArray = KenaiIssueAccessor.getDefault().getRecentIssues();
        } else {
            try {
                issueHandleArray = KenaiIssueAccessor.getDefault().getRecentIssues(Kenai.getDefault().getProject(StringUtils.parseName((String)this.muc.getRoom())));
            }
            catch (KenaiException kenaiException) {
                issueHandleArray = new KenaiIssueAccessor.IssueHandle[]{};
                Exceptions.printStackTrace((Throwable)kenaiException);
            }
        }
        if (issueHandleArray.length > 0) {
            new InsertLinkAction(issueHandleArray[0], this.outbox, false).actionPerformed(null);
        }
    }

    private void selectIssueReport(Matcher matcher) {
        Object object;
        KenaiProject kenaiProject;
        KenaiProject kenaiProject2;
        String string;
        block17: {
            string = matcher.group(3);
            kenaiProject2 = null;
            try {
                if (this.isPrivate()) {
                    try {
                        kenaiProject = Kenai.getDefault().getMyProjects().iterator();
                        kenaiProject2 = (KenaiProject)kenaiProject.next();
                        if (matcher.group(2) == null || matcher.group(2).equals("")) {
                            while (kenaiProject.hasNext()) {
                                object = kenaiProject2.getFeatures(KenaiService.Type.ISSUES);
                                if (((KenaiFeature[])object).length == 0) continue;
                                KenaiFeature kenaiFeature = object[0];
                                if (!kenaiFeature.getService().equals("bugzilla")) {
                                    kenaiProject2 = (KenaiProject)kenaiProject.next();
                                    continue;
                                }
                                break block17;
                            }
                            break block17;
                        }
                        while (kenaiProject.hasNext()) {
                            System.out.println(kenaiProject2.getName());
                            object = matcher.group(2).replaceAll("-", "_").toLowerCase();
                            object = ((String)object).substring(0, ((String)object).length() - 1);
                            if (!kenaiProject2.getName().replaceAll("-", "_").toLowerCase().equals(object)) {
                                kenaiProject2 = (KenaiProject)kenaiProject.next();
                                continue;
                            }
                            break block17;
                        }
                        break block17;
                    }
                    catch (KenaiException kenaiException) {
                        Exceptions.printStackTrace((Throwable)kenaiException);
                        break block17;
                    }
                }
                kenaiProject2 = Kenai.getDefault().getProject(StringUtils.parseName((String)this.muc.getRoom()));
            }
            catch (KenaiException kenaiException) {
                kenaiException.printStackTrace();
            }
        }
        kenaiProject = kenaiProject2;
        if (kenaiProject == null) {
            return;
        }
        object = null;
        try {
            object = kenaiProject.getFeatures(KenaiService.Type.ISSUES);
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (((KenaiFeature[])object).length == 0) {
            return;
        }
        if (object[0].getService().equals("jira")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KenaiIssueAccessor.getDefault().open(kenaiProject, kenaiProject.getName().toUpperCase().replaceAll("-", "_") + "-" + string);
                }
            });
        } else if (object[0].getService().equals("bugzilla")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KenaiIssueAccessor.getDefault().open(kenaiProject, string);
                }
            });
        }
    }

    private void selectStackTrace(Matcher matcher) {
        String string = matcher.group(2);
        String string2 = matcher.group(3);
        String string3 = string.replace('.', '/') + string2;
        int n = Integer.parseInt(matcher.group(4));
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
        FileObject fileObject = classPath.findResource(string3);
        if (fileObject != null) {
            ChatPanel.doOpen(fileObject, n);
        }
    }

    private void selectClasspathResource(Matcher matcher) {
        String string = matcher.group(1) + matcher.group(4);
        int n = Integer.parseInt(matcher.group(5));
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
        FileObject fileObject = classPath.findResource(string);
        if (fileObject != null) {
            ChatPanel.doOpen(fileObject, n);
        }
    }

    private void selectProjectResource(Matcher matcher) {
        String string = matcher.group(2) + matcher.group(5);
        int n = Integer.parseInt(matcher.group(6));
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            if (!ProjectUtils.getInformation((Project)project).getName().equals(matcher.group(1))) continue;
            FileObject fileObject = project.getProjectDirectory().getFileObject(string);
            ChatPanel.doOpen(fileObject, n);
            return;
        }
    }

    private void selectAbsoluteResource(Matcher matcher) {
        String string = "/" + matcher.group(1) + matcher.group(4);
        int n = Integer.parseInt(matcher.group(5));
        File file = new File(string);
        if (file.exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            ChatPanel.doOpen(fileObject, n);
        }
    }

    private static boolean doOpen(FileObject fileObject, int n) {
        try {
            Object object;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null && n != -1) {
                Line line = null;
                try {
                    line = lineCookie.getLineSet().getCurrent(n - 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    line = lineCookie.getLineSet().getCurrent(0);
                }
                if (line != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    return true;
                }
            }
            if ((object = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    public ChatPanel(MultiUserChat multiUserChat) {
        this.muc = multiUserChat;
        this.setName(StringUtils.parseName((String)multiUserChat.getRoom()));
        this.init();
        if (!Kenai.getDefault().getXMPPConnection().isConnected()) {
            try {
                KenaiConnection.getDefault().reconnect(multiUserChat);
            }
            catch (XMPPException xMPPException) {
                Exceptions.printStackTrace((Throwable)xMPPException);
            }
        }
        this.muc.addParticipantListener(new PacketListener(){

            public void processPacket(Packet packet) {
                ChatPanel.this.insertPresence((Presence)packet);
            }
        });
        KenaiConnection.getDefault().join(multiUserChat, new ChatListener());
    }

    public ChatPanel(String string) {
        this.setName(ChatTopComponent.createPrivateName(StringUtils.parseName((String)string)));
        this.init();
        this.suc = KenaiConnection.getDefault().joinPrivate(string, new ChatListener());
    }

    public boolean isPrivate() {
        return this.getName().startsWith("private.");
    }

    public String getPrivateName() {
        assert (this.isPrivate());
        return this.getName().substring(this.getName().indexOf(46) + 1);
    }

    private void init() {
        this.initComponents();
        this.online.setHorizontalTextPosition(2);
        if (this.isPrivate()) {
            this.topPanel.remove(this.online);
            this.online = new KenaiUserUI(this.getPrivateName()).createUserWidget();
            this.online.setText(null);
            this.online.setBorder(BorderFactory.createEmptyBorder(3, 1, 3, 1));
            this.topPanel.add((Component)this.online, "East");
            this.topPanel.validate();
        }
        this.editorKit = (HTMLEditorKit)this.inbox.getEditorKit();
        Font font = UIManager.getFont("Label.font");
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        StyleSheet styleSheet = ((HTMLDocument)this.inbox.getDocument()).getStyleSheet();
        styleSheet.addRule(string);
        styleSheet.addRule(".buddy {color: black; font-weight: bold; padding: 4px;}");
        styleSheet.addRule(".time {color: lightgrey; padding: 4px;");
        styleSheet.addRule(".message {color: lightgrey; padding: 2px 4px;");
        styleSheet.addRule(".date {color: #cc9922; padding: 7px 0;");
        if (!this.isPrivate()) {
            MessagingHandleImpl messagingHandleImpl = ChatNotifications.getDefault().getMessagingHandle(this.getName());
            messagingHandleImpl.addPropertyChangeListener(new PresenceListener());
        }
        this.inbox.setBackground(Color.WHITE);
        this.inbox.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL uRL = hyperlinkEvent.getURL();
                    if (uRL != null && !uRL.getProtocol().equals("file") && !uRL.getProtocol().equals("issue")) {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                    } else {
                        String string = hyperlinkEvent.getDescription();
                        Matcher matcher = STACK_TRACE.matcher(string);
                        if (matcher.matches()) {
                            ChatPanel.this.selectStackTrace(matcher);
                        } else {
                            matcher = CLASSPATH_RESOURCE.matcher(string);
                            if (matcher.matches()) {
                                ChatPanel.this.selectClasspathResource(matcher);
                            } else {
                                matcher = PROJECT_RESOURCE.matcher(string);
                                if (matcher.matches()) {
                                    ChatPanel.this.selectProjectResource(matcher);
                                } else {
                                    matcher = ABSOLUTE_RESOURCE.matcher(string);
                                    if (matcher.matches()) {
                                        ChatPanel.this.selectAbsoluteResource(matcher);
                                    } else {
                                        matcher = ISSUE_REPORT.matcher(string);
                                        if (matcher.matches()) {
                                            ChatPanel.this.selectIssueReport(matcher);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        });
        this.outbox.setBackground(Color.WHITE);
        this.splitter.setResizeWeight(0.9);
        this.refreshOnlineStatus();
        this.undo = new CompoundUndoManager(this.outbox);
        this.inboxScrollPane.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                JScrollBar jScrollBar = ChatPanel.this.inboxScrollPane.getVerticalScrollBar();
                if (jScrollBar == null) {
                    return;
                }
                ChatPanel.this.disableAutoScroll = jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum();
            }
        });
        this.inboxScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getSource();
                if (!adjustmentEvent.getValueIsAdjusting()) {
                    return;
                }
                ChatPanel.this.disableAutoScroll = jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum();
            }
        });
        this.inbox.setComponentPopupMenu(this.dropDownMenu);
        this.outbox.setComponentPopupMenu(this.dropDownMenu);
        UIUtils.logKenaiUsage("CHAT", this.isPrivate() ? "PRIVATE_CHAT" : "CHATROOM");
    }

    void insertToInputArea(String string) {
        if (string == null) {
            return;
        }
        try {
            this.outbox.getDocument().insertString(this.outbox.getCaretPosition(), string, null);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        this.outbox.requestFocus();
    }

    private String removeTags(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\r\n", "\n");
        string2 = string2.replaceAll("\r", "\n");
        return string2.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>");
    }

    private String replaceLinks(String string) {
        String string2 = string.replaceAll("(http|https|ftp)://([a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,4}(/[^ ]*)*", "<a href=\"$0\">$0</a>");
        string2 = RESOURCES.matcher(string2).replaceAll("<a href=\"$0\">$0</a>");
        string2 = ISSUE_REPORT.matcher(string2).replaceAll("<a href=\"$0\">$0</a>");
        return string2.replaceAll("  ", " &nbsp;");
    }

    private String replaceSmileys(String string) {
        if (string.matches(".*[B8:;]-?[]D()].*")) {
            for (int i = 0; i < smileysMap.length; ++i) {
                string = string.replace(smileysMap[i][0], "<img align=\"center\" src=\"" + this.getClass().getResource("/org/netbeans/modules/kenai/collab/resources/emo_" + smileysMap[i][1] + "16.png") + "\"></img>");
            }
        }
        return string;
    }

    private void refreshOnlineStatus() throws MissingResourceException {
        if (this.muc != null) {
            this.online.setText(this.muc.getOccupantsCount() + "");
            Iterator iterator = this.muc.getOccupants();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body>");
            while (iterator.hasNext()) {
                stringBuffer.append(StringUtils.parseResource((String)((String)iterator.next())) + "<br>");
            }
            stringBuffer.append("</body></html>");
            this.online.setToolTipText(stringBuffer.toString());
        }
    }

    private void initComponents() {
        this.dropDownMenu = new JPopupMenu();
        this.temp = new JMenuItem();
        this.splitter = new JSplitPane();
        this.outboxPanel = new JPanel();
        this.buttons = new JPanel();
        this.sendLinkButton = DropDownButtonFactory.createDropDownButton((Icon)ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/kenai/ui/resources/insertlink.png", (boolean)true), (JPopupMenu)this.dropDownMenu);
        this.sendButton = new JButton();
        this.outboxScrollPane = new JScrollPane();
        this.outbox = new JTextPane();
        this.inboxPanel = new JPanel();
        this.inboxScrollPane = new JScrollPane();
        this.inbox = new JTextPane(){

            public void scrollRectToVisible(Rectangle rectangle) {
                if (!ChatPanel.this.disableAutoScroll) {
                    super.scrollRectToVisible(rectangle);
                }
            }
        };
        this.topPanel = new JPanel();
        this.online = new JLabel();
        this.statusLine = new JLabel();
        this.dropDownMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ChatPanel.this.dropDownMenuPopupMenuWillBecomeInvisible(popupMenuEvent);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ChatPanel.this.dropDownMenuPopupMenuWillBecomeVisible(popupMenuEvent);
            }
        });
        this.dropDownMenu.add(this.temp);
        this.splitter.setOrientation(0);
        this.outboxPanel.setLayout(new BorderLayout());
        this.buttons.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.sendLinkButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/insertlink.png")));
        this.sendLinkButton.setToolTipText(NbBundle.getBundle(ChatPanel.class).getString("ChatPanel.sendLinkButton.toolTipText"));
        this.sendLinkButton.setFocusable(false);
        this.sendLinkButton.setHorizontalTextPosition(0);
        this.sendLinkButton.setVerticalTextPosition(3);
        this.sendLinkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.sendLinkButtonActionPerformed(actionEvent);
            }
        });
        this.sendButton.setText(NbBundle.getMessage(ChatPanel.class, (String)"ChatPanel.sendButton.text", (Object[])new Object[0]));
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.sendButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.buttons);
        this.buttons.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sendLinkButton).addPreferredGap(0, 197, Short.MAX_VALUE).add((Component)this.sendButton)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.sendButton).add((Component)this.sendLinkButton));
        this.outboxPanel.add((Component)this.buttons, "South");
        this.outbox.setMaximumSize(new Dimension(0, 16));
        this.outbox.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ChatPanel.this.outboxKeyPressed(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                ChatPanel.this.keyTyped(keyEvent);
            }
        });
        this.outboxScrollPane.setViewportView(this.outbox);
        this.outboxPanel.add((Component)this.outboxScrollPane, "Center");
        this.splitter.setRightComponent(this.outboxPanel);
        this.inboxPanel.setBackground(Color.white);
        this.inboxPanel.setLayout(new BorderLayout());
        this.inboxScrollPane.setBorder(null);
        this.inboxScrollPane.setViewportBorder(null);
        this.inbox.setBorder(null);
        this.inbox.setContentType("text/html");
        this.inbox.setEditable(false);
        this.inbox.setText(NbBundle.getMessage(ChatPanel.class, (String)"ChatPanel.inbox.text", (Object[])new Object[0]));
        this.inbox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ChatPanel.this.inboxFocusGained(focusEvent);
            }
        });
        this.inboxScrollPane.setViewportView(this.inbox);
        this.inboxPanel.add((Component)this.inboxScrollPane, "Center");
        this.topPanel.setBackground(Color.white);
        this.topPanel.setLayout(new BorderLayout());
        this.online.setBackground(Color.white);
        this.online.setForeground(Color.blue);
        this.online.setHorizontalAlignment(4);
        this.online.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/collab/resources/user_online.png")));
        this.online.setBorder(BorderFactory.createEmptyBorder(3, 1, 3, 1));
        this.topPanel.add((Component)this.online, "East");
        this.topPanel.add((Component)this.statusLine, "Center");
        this.inboxPanel.add((Component)this.topPanel, "North");
        this.splitter.setTopComponent(this.inboxPanel);
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.splitter, -1, 268, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.splitter, -1, 403, Short.MAX_VALUE));
    }

    private void keyTyped(KeyEvent keyEvent) {
        if (this.undoCharsList.contains(Character.valueOf(keyEvent.getKeyChar()))) {
            this.undo.startNewCompoundEdit();
            return;
        }
        if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            block16: {
                if (keyEvent.isAltDown() || keyEvent.isShiftDown() || keyEvent.isControlDown()) {
                    try {
                        this.outbox.getStyledDocument().insertString(this.outbox.getCaretPosition(), "\r\n", null);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                    return;
                }
                try {
                    if (!(this.muc == null || KenaiConnection.getDefault().isConnected() && this.muc.isJoined())) {
                        try {
                            KenaiConnection.getDefault().reconnect(this.muc);
                        }
                        catch (XMPPException xMPPException) {
                            JOptionPane.showMessageDialog(this, xMPPException.getMessage());
                            return;
                        }
                    }
                    if (this.outbox.getText().trim().equals("")) break block16;
                    int n = this.outbox.getCaretPosition();
                    if (n > 1 && (this.outbox.getText().charAt(n - 1) == '\n' || this.outbox.getText().charAt(n - 1) == '\r')) {
                        try {
                            boolean bl = this.outbox.getText().charAt(n - 1) == '\n';
                            this.outbox.getDocument().remove(n - 1, 1);
                            n = this.outbox.getCaretPosition();
                            if (bl && n > 1 && this.outbox.getText().charAt(n - 1) == '\r') {
                                this.outbox.getDocument().remove(n - 1, 1);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    if (this.muc != null) {
                        this.muc.sendMessage(this.outbox.getText().trim());
                    } else {
                        Message message = new Message(this.suc.getParticipant());
                        message.setBody(this.outbox.getText().trim());
                        this.suc.sendMessage(message);
                        this.insertMessage(message);
                    }
                    UIUtils.logKenaiUsage("CHAT", "MESSAGE_SENT");
                }
                catch (XMPPException xMPPException) {
                    Exceptions.printStackTrace((Throwable)xMPPException);
                }
            }
            this.outbox.setText("");
            this.undo.discardAllEdits();
            this.history.resetHistory();
        }
    }

    private void outboxKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 90) {
            try {
                this.undo.undo();
                this.history.resetHistory();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            return;
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 89) {
            try {
                this.undo.redo();
                this.history.resetHistory();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            return;
        }
        if (keyEvent.isControlDown() || keyEvent.isAltDown()) {
            if (keyEvent.getKeyCode() == 38) {
                String string;
                if (this.history.isOnStart()) {
                    this.history.setEditedMessage(this.outbox.getText());
                }
                if ((string = this.history.getPreviousMessage()) != null) {
                    this.outbox.setText(string);
                }
                return;
            }
            if (keyEvent.getKeyCode() == 40) {
                String string = this.history.getNextMessage();
                if (string != null) {
                    this.outbox.setText(string);
                }
                return;
            }
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 76) {
            Mode mode = WindowManager.getDefault().findMode("editor");
            TopComponent topComponent = mode.getSelectedTopComponent();
            if (this.getTopComponent(EditorRegistry.lastFocusedComponent()) == topComponent) {
                this.insertLinkToEditor();
            } else if (topComponent != null && this.isIssueRelated(topComponent)) {
                this.insertLinkToIssue();
            } else {
                Point point = this.outbox.getCaret().getMagicCaretPosition();
                if (point == null) {
                    point = new Point(0, 0);
                }
                this.outbox.getComponentPopupMenu().show(this.outbox, point.x, point.y);
            }
        }
    }

    private boolean isIssueRelated(TopComponent topComponent) {
        if (this.muc == null) {
            KenaiIssueAccessor.IssueHandle[] issueHandleArray = KenaiIssueAccessor.getDefault().getRecentIssues();
            if (issueHandleArray.length < 1) {
                return false;
            }
            return issueHandleArray[0].isShowing();
        }
        try {
            KenaiIssueAccessor.IssueHandle[] issueHandleArray = KenaiIssueAccessor.getDefault().getRecentIssues(Kenai.getDefault().getProject(StringUtils.parseName((String)this.muc.getRoom())));
            KenaiIssueAccessor.IssueHandle[] issueHandleArray2 = KenaiIssueAccessor.getDefault().getRecentIssues();
            if (issueHandleArray.length < 1) {
                return false;
            }
            if (issueHandleArray[0].getID().equals(issueHandleArray2[0].getID())) {
                return issueHandleArray[0].isShowing();
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
            return false;
        }
        return false;
    }

    private TopComponent getTopComponent(Component component) {
        while (component != null && !(component instanceof TopComponent)) {
            component = component.getParent();
        }
        return (TopComponent)component;
    }

    private void sendButtonActionPerformed(ActionEvent actionEvent) {
        KeyEvent keyEvent = new KeyEvent((Component)actionEvent.getSource(), actionEvent.getID(), actionEvent.getWhen(), actionEvent.getModifiers(), 10, '\n');
        this.keyTyped(keyEvent);
        this.outbox.requestFocus();
    }

    private void inboxFocusGained(FocusEvent focusEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatPanel.this.inbox.getCaret().setVisible(false);
            }
        });
    }

    private void dropDownMenuPopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        KenaiIssueAccessor.IssueHandle[] issueHandleArray;
        this.dropDownMenu.removeAll();
        JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
        if (jPopupMenu.getInvoker() == this.inbox) {
            this.addNotificationsMenuItem(this.dropDownMenu);
            return;
        }
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent != null) {
            this.dropDownMenu.add(new InsertLinkAction(jTextComponent, this.outbox, true, this.selectedEditorComponent() != null));
            this.dropDownMenu.add(new JSeparator());
        }
        for (JTextComponent jTextComponent2 : EditorRegistry.componentList()) {
            this.dropDownMenu.add(new InsertLinkAction(jTextComponent2, this.outbox, false, false));
        }
        if (jTextComponent != null) {
            this.dropDownMenu.add(new JSeparator());
        }
        if (this.muc == null) {
            issueHandleArray = KenaiIssueAccessor.getDefault().getRecentIssues();
        } else {
            try {
                issueHandleArray = KenaiIssueAccessor.getDefault().getRecentIssues(Kenai.getDefault().getProject(StringUtils.parseName((String)this.muc.getRoom())));
            }
            catch (KenaiException kenaiException) {
                issueHandleArray = new KenaiIssueAccessor.IssueHandle[]{};
                Exceptions.printStackTrace((Throwable)kenaiException);
            }
        }
        for (int i = 0; issueHandleArray != null && i < 3 && i < issueHandleArray.length; ++i) {
            Mode mode = WindowManager.getDefault().findMode("editor");
            TopComponent topComponent = mode.getSelectedTopComponent();
            this.dropDownMenu.add(new InsertLinkAction(issueHandleArray[i], this.outbox, this.isIssueRelated(topComponent)));
        }
        if (issueHandleArray.length > 0) {
            this.dropDownMenu.add(new JSeparator());
        }
        this.dropDownMenu.add(new LinkOtherFileAction(this.outbox));
        this.dropDownMenu.add(new LinkOtherIssue(this.outbox));
        if (jPopupMenu.getInvoker() == this.outbox) {
            this.dropDownMenu.add(new JSeparator());
            this.addNotificationsMenuItem(this.dropDownMenu);
        }
    }

    private void dropDownMenuPopupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.dropDownMenu.removeAll();
        this.dropDownMenu.add(this.temp);
    }

    private void sendLinkButtonActionPerformed(ActionEvent actionEvent) {
        this.insertLinkToEditor();
        this.outbox.requestFocus();
    }

    private String getMessageBody(Message message) {
        NotificationExtension notificationExtension = (NotificationExtension)message.getExtension("notification", "http://kenai.com/schema/XMPPNotification");
        String string = message.getBody();
        if (string == null) {
            string = "";
        }
        if (notificationExtension == null) {
            return string;
        }
        KenaiNotification kenaiNotification = notificationExtension.getNotification();
        if (kenaiNotification.getType() != KenaiService.Type.SOURCE) {
            return string;
        }
        int n = string.indexOf(93);
        String string2 = n >= 0 ? string.substring(n + 2) : string;
        String string3 = ((KenaiNotification.Modification)kenaiNotification.getModifications().get(0)).getId();
        String string4 = StringUtils.parseName((String)message.getFrom());
        if (string4.contains("@")) {
            string4 = StringUtils.parseName((String)string4);
        }
        String string5 = Kenai.getDefault().getUrl().toString() + "/projects/" + string4 + "/sources/" + kenaiNotification.getServiceName() + "/revision/" + string3;
        return string2 + "\n" + string5;
    }

    protected void insertMessage(Message message) {
        try {
            String string;
            boolean bl;
            HTMLDocument hTMLDocument = (HTMLDocument)this.inbox.getStyledDocument();
            Date date = ChatPanel.getTimestamp((Packet)message);
            String string2 = this.suc == null ? StringUtils.parseResource((String)message.getFrom()) : StringUtils.parseName((String)message.getFrom());
            String string3 = this.getMessageBody(message);
            this.history.addMessage(string3);
            Random random = new Random(string2.hashCode());
            float f = random.nextFloat();
            Color color = Color.getHSBColor(f, 0.1f, 0.95f);
            Color color2 = Color.getHSBColor(f, 0.1f, 1.0f);
            boolean bl2 = this.lastNickPrinted != null ? !this.lastNickPrinted.equals(string2) : (bl = true);
            bl |= this.lastMessageDate != null && date != null ? date.getTime() > this.lastMessageDate.getTime() + 120000L : true;
            this.lastNickPrinted = string2;
            this.lastMessageDate = date;
            if (!this.isSameDate(this.lastDatePrinted, date)) {
                this.lastDatePrinted = date;
                bl = true;
                this.rgb = null;
                string = "<table border=\"0\" borderwith=\"0\" width=\"100%\"><tbody><tr><td class=\"date\" align=\"left\">" + (this.isToday(date) ? NbBundle.getMessage(ChatPanel.class, (String)"LBL_Today") : DateFormat.getDateInstance().format(date)) + "</td><td class=\"date\" align=\"right\">" + DateFormat.getTimeInstance(3).format(date) + "</td></tr></tbody></table>";
                this.editorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), string, 0, 0, null);
            }
            string = "";
            if (bl) {
                if (this.rgb != null) {
                    string = string + "<div style=\"height: 3px; background-color: rgb(" + this.rgb + ")\"></div>";
                }
                string = string + "<table border=\"0\" borderwith=\"0\" width=\"100%\"><tbody><tr style=\"background-color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\">" + "<td class=\"buddy\" align=\"left\">" + string2 + "</td><td class=\"time\" align=\"right\">" + DateFormat.getTimeInstance(3).format(ChatPanel.getTimestamp((Packet)message)) + "</td></tr></tbody></table>";
            }
            this.rgb = color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue();
            string = string + "<div class=\"message\" style=\"background-color: rgb(" + this.rgb + ")\">" + this.replaceSmileys(this.replaceLinks(this.removeTags(string3))) + "</div>";
            this.editorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), string, 0, 0, null);
            this.inbox.revalidate();
            this.inbox.repaint();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static Date getTimestamp(Packet packet) {
        DelayInformation delayInformation = (DelayInformation)packet.getExtension("x", "jabber:x:delay");
        if (delayInformation != null) {
            return delayInformation.getStamp();
        }
        return new Date();
    }

    boolean isToday(Date date) {
        return this.isSameDate(date, new Date());
    }

    boolean isSameDate(Date date, Date date2) {
        if (date == null) {
            return false;
        }
        return date.getDate() == date2.getDate() && date.getMonth() == date2.getMonth() && date.getYear() == date2.getYear();
    }

    protected void insertPresence(final Presence presence) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatPanel.this.statusLine.setForeground(Color.black);
                ChatPanel.this.statusLine.setText("<html><b>" + StringUtils.parseResource((String)presence.getFrom()) + "</b> is now " + presence.getType() + "</html>");
                new Fader(ChatPanel.this.statusLine).start();
            }
        });
    }

    protected void setEndSelection() {
        this.inbox.setSelectionStart(this.inbox.getDocument().getLength());
        this.inbox.setSelectionEnd(this.inbox.getDocument().getLength());
    }

    private class ChatListener
    implements PacketListener,
    MessageListener {
        private ChatListener() {
        }

        public void processPacket(Packet packet) {
            this.processMessage(ChatPanel.this.suc, (Message)packet);
        }

        public void processMessage(Chat chat, final Message message) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ChatPanel.this.setEndSelection();
                    ChatPanel.this.insertMessage(message);
                    if (!ChatPanel.this.isVisible()) {
                        ChatTopComponent.findInstance().setModified(ChatPanel.this);
                    }
                }
            });
        }
    }

    private static class Fader {
        private JComponent target;
        private Timer timer = new Timer(50, new ActionListener(){
            int c = 0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.c += 10;
                if (this.c > 255) {
                    this.c = 0;
                    Fader.this.timer.stop();
                    return;
                }
                Color color = new Color(this.c, this.c, this.c);
                Fader.this.target.setForeground(color);
            }
        });

        public Fader(JComponent jComponent) {
            this.target = jComponent;
            this.timer.setInitialDelay(2000);
        }

        public void start() {
            this.timer.start();
        }
    }

    private class NotificationsEnabledAction
    implements ActionListener {
        private NotificationsEnabledAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            ChatNotifications.getDefault().setEnabled(ChatPanel.this.getName(), jCheckBoxMenuItem.getState());
        }
    }

    private class PresenceListener
    implements PropertyChangeListener {
        private PresenceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ChatPanel.this.refreshOnlineStatus();
                }
            });
        }
    }
}

