/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.WhoIsOnlineAction;
import org.netbeans.modules.kenai.ui.Utilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class PresenceIndicator {
    private static ImageIcon ONLINE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/online.png"));
    private static ImageIcon OFFLINE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/offline.png"));
    private static PresenceIndicator instance;
    private JLabel label = new JLabel();
    private MouseL helper;
    private boolean inited = false;

    public void setStatus(Kenai.Status status) {
        this.label.setIcon(status == Kenai.Status.ONLINE ? ONLINE : OFFLINE);
        if (status != Kenai.Status.ONLINE) {
            this.label.setText("");
        }
        switch (status) {
            case OFFLINE: {
                this.label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_Offline_Tooltip"));
                break;
            }
            case LOGGED_IN: {
                this.label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_LoggedInButNotOnChat_Tooltip"));
                break;
            }
            case ONLINE: {
                this.label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_LoggedIn_Tooltip", (Object)(KenaiUser.getOnlineUserCount() > 0 ? Integer.valueOf(KenaiUser.getOnlineUserCount() - 1) : "")));
            }
        }
        this.label.setVisible(status != Kenai.Status.OFFLINE);
    }

    Component getComponent() {
        return this.label;
    }

    public static synchronized PresenceIndicator getDefault() {
        if (instance == null) {
            instance = new PresenceIndicator();
        }
        return instance;
    }

    private PresenceIndicator() {
        this.label.setVisible(false);
        this.label.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.helper = new MouseL();
        this.label.addMouseListener(this.helper);
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        Kenai.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PresenceIndicator.this.setStatus(Kenai.getDefault().getStatus());
            }
        });
        this.inited = true;
    }

    private class MouseL
    extends MouseAdapter {
        private Cursor oldCursor;

        private MouseL() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.oldCursor = PresenceIndicator.this.label.getCursor();
            PresenceIndicator.this.label.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PresenceIndicator.this.label.setCursor(this.oldCursor);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Kenai.Status status = Kenai.getDefault().getStatus();
            if (mouseEvent.getClickCount() == 2) {
                if (status == Kenai.Status.ONLINE) {
                    ChatTopComponent.openAction((TopComponent)ChatTopComponent.findInstance(), (String)"", (String)"", (boolean)false).actionPerformed(new ActionEvent(mouseEvent, mouseEvent.getID(), ""));
                }
            } else if (status != Kenai.Status.OFFLINE) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(PresenceIndicator.class, (String)"CTL_WhoIsOnlineAction"));
                jPopupMenu.add(jMenuItem);
                jMenuItem.setEnabled(status == Kenai.Status.ONLINE);
                final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(PresenceIndicator.class, (String)"CTL_OnlineCheckboxMenuItem"), status == Kenai.Status.ONLINE);
                jPopupMenu.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem.setEnabled(Utilities.isChatSupported());
                JMenuItem jMenuItem2 = new JMenuItem(NbBundle.getMessage(PresenceIndicator.class, (String)"CTL_LogoutMenuItem"));
                jPopupMenu.add(jMenuItem2);
                final Kenai kenai = Kenai.getDefault();
                jCheckBoxMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                try {
                                    PasswordAuthentication passwordAuthentication = kenai.getPasswordAuthentication();
                                    kenai.login(passwordAuthentication.getUserName(), passwordAuthentication.getPassword(), jCheckBoxMenuItem.isSelected());
                                }
                                catch (KenaiException kenaiException) {
                                    Exceptions.printStackTrace((Throwable)kenaiException);
                                }
                            }
                        });
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        kenai.logout();
                    }
                });
                jMenuItem.addActionListener(new WhoIsOnlineAction());
                jPopupMenu.show(PresenceIndicator.this.label, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        }
    }

    public static class PresenceListener
    implements PacketListener {
        public void processPacket(Packet packet) {
            PresenceIndicator.getDefault().label.setText(KenaiUser.getOnlineUserCount() > 0 ? KenaiUser.getOnlineUserCount() - 1 + "" : "");
            PresenceIndicator.getDefault().label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_LoggedIn_Tooltip", (Object)(KenaiUser.getOnlineUserCount() > 0 ? Integer.valueOf(KenaiUser.getOnlineUserCount() - 1) : "")));
            for (MultiUserChat multiUserChat : KenaiConnection.getDefault().getChats()) {
                String string = StringUtils.parseName((String)multiUserChat.getRoom());
                assert (string != null) : "muc.getRoom() = " + multiUserChat.getRoom();
                ChatNotifications.getDefault().getMessagingHandle(string).setOnlineCount(multiUserChat.getOccupantsCount());
            }
        }
    }
}

