/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.ui.KenaiSearchPanel;
import org.netbeans.modules.kenai.ui.URLDisplayerAction;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class KenaiProjectsListRenderer
extends JPanel {
    private URL url;
    private JButton detailsButton;
    private JLabel iconLabel;
    private JPanel jPanel1;
    private JTextArea projectDescLabel;
    private JLabel projectNameLabel;
    private JPanel repoPanel;
    private JLabel repoPathLabel;
    private JLabel repoTypeLabel;
    private JLabel tagsLabel;

    public KenaiProjectsListRenderer(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.initComponents();
        KenaiSearchPanel.KenaiProjectSearchInfo kenaiProjectSearchInfo = (KenaiSearchPanel.KenaiProjectSearchInfo)object;
        this.projectNameLabel.setText("<html><b>" + kenaiProjectSearchInfo.kenaiProject.getDisplayName() + " (" + kenaiProjectSearchInfo.kenaiProject.getName() + ")</b></html>");
        if (kenaiProjectSearchInfo.kenaiFeature != null) {
            this.repoPathLabel.setText(kenaiProjectSearchInfo.kenaiFeature.getLocation());
            this.repoTypeLabel.setText("(" + kenaiProjectSearchInfo.kenaiFeature.getService() + ")");
        } else {
            this.remove(this.repoPanel);
        }
        try {
            int n2;
            String string = kenaiProjectSearchInfo.kenaiProject.getDescription();
            string = string.replaceAll("\n+", " ");
            string = string.replaceAll("\t+", " ");
            Icon icon = null;
            try {
                icon = kenaiProjectSearchInfo.kenaiProject.getProjectIcon();
            }
            catch (KenaiException kenaiException) {
                Logger.getLogger(KenaiProjectsListRenderer.class.getName()).log(Level.INFO, "There are problems with getting a project icon - maybe see http://www.netbeans.org/issues/show_bug.cgi?id=172649", kenaiException);
            }
            Image image = null;
            image = icon != null ? ImageUtilities.icon2Image((Icon)icon) : ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/ui/resources/default.jpg");
            image = image.getScaledInstance(100, 100, 4);
            this.iconLabel.setIcon(ImageUtilities.image2Icon((Image)image));
            this.projectDescLabel.setText(string);
            this.projectDescLabel.setRows(kenaiProjectSearchInfo.kenaiProject.getDescription().length() / 100 + 1);
            String string2 = kenaiProjectSearchInfo.kenaiProject.getTags();
            if (string2.length() > 60 && (n2 = string2.indexOf(32, 60)) != -1) {
                string2 = string2.substring(0, n2) + " ...";
            }
            if (string2.length() > 0) {
                String string3 = NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.tagsLabel.text");
                this.tagsLabel.setText("<html><i>" + string3 + " " + string2.replaceAll(" ", ", ") + "</i></html>");
            } else {
                this.tagsLabel.setText("");
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.projectDescLabel.setBackground(jList.getSelectionBackground());
            this.detailsButton.setForeground(jList.getSelectionForeground());
            this.repoPathLabel.setForeground(jList.getSelectionForeground());
            this.repoPanel.setBackground(jList.getSelectionBackground());
            this.projectDescLabel.setForeground(jList.getSelectionForeground());
            this.tagsLabel.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(new Color(255, 255, 255));
            this.projectDescLabel.setBackground(new Color(255, 255, 255));
            this.repoPanel.setBackground(new Color(255, 255, 255));
            this.detailsButton.setForeground(ColorManager.getDefault().getLinkColor());
            this.repoPathLabel.setForeground(ColorManager.getDefault().getLinkColor());
            this.projectDescLabel.setForeground(new Color(128, 128, 128));
            this.tagsLabel.setForeground(new Color(128, 128, 128));
        }
        this.url = kenaiProjectSearchInfo.kenaiProject.getWebLocation();
    }

    private void initComponents() {
        this.iconLabel = new JLabel();
        this.projectNameLabel = new JLabel();
        this.tagsLabel = new JLabel();
        this.projectDescLabel = new JTextArea();
        this.detailsButton = new LinkButton(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.detailsLabel.text"), (Action)new URLDisplayer());
        this.repoPanel = new JPanel();
        this.repoPathLabel = new JLabel();
        this.repoTypeLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.iconLabel.setBackground(new Color(255, 255, 255));
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setHorizontalTextPosition(0);
        this.iconLabel.setMaximumSize(new Dimension(100, 100));
        this.iconLabel.setMinimumSize(new Dimension(100, 100));
        this.iconLabel.setOpaque(true);
        this.iconLabel.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.iconLabel, gridBagConstraints);
        this.projectNameLabel.setForeground(new Color(0, 22, 103));
        this.projectNameLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.projectNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.tagsLabel.setFont(new Font("Lucida Grande", 0, 10));
        this.tagsLabel.setForeground(new Color(128, 128, 128));
        this.tagsLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.tagsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 6, 0);
        this.add((Component)this.tagsLabel, gridBagConstraints);
        this.projectDescLabel.setFont(new Font("Lucida Grande", 0, 12));
        this.projectDescLabel.setForeground(new Color(128, 128, 128));
        this.projectDescLabel.setLineWrap(true);
        this.projectDescLabel.setWrapStyleWord(true);
        this.projectDescLabel.setFocusable(false);
        this.projectDescLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 14);
        this.add((Component)this.projectDescLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.detailsButton, gridBagConstraints);
        this.repoPanel.setLayout(new GridBagLayout());
        this.repoPathLabel.setForeground(ColorManager.getDefault().getLinkColor());
        this.repoPathLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.repoPathLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.repoPanel.add((Component)this.repoPathLabel, gridBagConstraints);
        this.repoTypeLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.repoTypeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.repoPanel.add((Component)this.repoTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.add((Component)this.repoPanel, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(10, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private class URLDisplayer
    extends AbstractAction {
        private URLDisplayer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new URLDisplayerAction("", KenaiProjectsListRenderer.this.url).actionPerformed(actionEvent);
        }
    }
}

