/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.LoginPanel;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class LoginAction
extends AbstractAction {
    private static LoginAction instance;
    private boolean logout;

    private LoginAction() {
        this.setLogout(Kenai.getDefault().getPasswordAuthentication() != null);
    }

    public static synchronized LoginAction getDefault() {
        if (instance == null) {
            instance = new LoginAction();
            Kenai.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("login".equals(propertyChangeEvent.getPropertyName())) {
                        if (propertyChangeEvent.getNewValue() == null) {
                            instance.setLogout(false);
                        } else {
                            instance.setLogout(true);
                        }
                        if (!"url".equals(propertyChangeEvent.getPropagationId())) {
                            Preferences preferences = NbPreferences.forModule(LoginPanel.class);
                            preferences.put(UIUtils.getPrefName(".login"), Boolean.toString(propertyChangeEvent.getNewValue() != null));
                        }
                    } else if ("xmpp_login".equals(propertyChangeEvent.getPropertyName()) && !"url".equals(propertyChangeEvent.getPropagationId())) {
                        Preferences preferences = NbPreferences.forModule(LoginPanel.class);
                        preferences.put(UIUtils.getPrefName(".online"), Boolean.toString(propertyChangeEvent.getNewValue() != null));
                    }
                }
            });
        }
        return instance;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.logout) {
            Kenai.getDefault().logout();
        } else {
            if (!UIUtils.showLogin()) {
                return;
            }
            KenaiTopComponent.findInstance().open();
            KenaiTopComponent.findInstance().requestActive();
        }
    }

    private void setLogout(boolean bl) {
        this.logout = bl;
        if (bl) {
            this.putValue("Name", NbBundle.getMessage(LoginAction.class, (String)"CTL_LogoutAction"));
        } else {
            this.putValue("Name", NbBundle.getMessage(LoginAction.class, (String)"CTL_LoginAction"));
        }
    }
}

