/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;

public class LinkButton
extends JButton {
    public LinkButton(Image image, Action action) {
        this(new ImageIcon(image), action);
    }

    public LinkButton(Icon icon, Action action) {
        this.setIcon(icon);
        this.setPressedIcon(icon);
        this.init(action);
    }

    public LinkButton(String string, Icon icon, Action action) {
        super(string);
        this.setIcon(icon);
        this.setPressedIcon(icon);
        Object object = action.getValue("ShortDescription");
        if (null != object) {
            this.setToolTipText(object.toString());
        }
        this.init(action);
    }

    public LinkButton(String string, Action action) {
        super(string);
        if (null != action) {
            Object object;
            Icon icon = (Icon)action.getValue("SmallIcon");
            if (null != icon) {
                this.setIcon(icon);
                this.setPressedIcon(icon);
            }
            if (null != (object = action.getValue("ShortDescription"))) {
                this.setToolTipText(object.toString());
            }
        }
        this.init(action);
    }

    public void setForeground(Color color, boolean bl) {
        if (bl) {
            if (color instanceof UIResource) {
                color = new Color(color.getRGB());
            }
            this.setForeground(color);
        } else if (this.isEnabled()) {
            this.setForeground(ColorManager.getDefault().getLinkColor());
        } else {
            this.setForeground(ColorManager.getDefault().getDisabledColor());
        }
    }

    private void init(Action action) {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setFocusable(false);
        this.setContentAreaFilled(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setModel(new Model());
        if (null != action) {
            this.addActionListener(action);
            this.setForeground(ColorManager.getDefault().getLinkColor());
        } else {
            this.setEnabled(false);
            this.setForeground(ColorManager.getDefault().getDisabledColor());
        }
        this.setFont(UIManager.getFont("Tree.font"));
    }

    private static class Model
    extends DefaultButtonModel {
        private Model() {
        }

        public boolean isPressed() {
            return false;
        }
    }
}

