/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.MessagingAccessor;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.netbeans.modules.kenai.ui.treelist.LeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MyProjectNode
extends LeafNode {
    private final ProjectHandle project;
    private final ProjectAccessor accessor;
    private final QueryAccessor qaccessor;
    private final MessagingAccessor maccessor;
    private MessagingHandle mh;
    private Action openAction;
    private JPanel component = null;
    private JLabel lbl = null;
    private LinkButton btnOpen = null;
    private LinkButton btnMessages = null;
    private LinkButton btnBugs = null;
    private boolean isMemberProject = false;
    private final Object LOCK = new Object();
    private final PropertyChangeListener projectListener;
    private TreeLabel rightPar;
    private TreeLabel leftPar;
    private static RequestProcessor rp;

    public MyProjectNode(final ProjectHandle projectHandle) {
        super(null);
        if (projectHandle == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        this.projectListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("content".equals(propertyChangeEvent.getPropertyName())) {
                    MyProjectNode.this.refreshChildren();
                    if (null != MyProjectNode.this.lbl) {
                        MyProjectNode.this.lbl.setText(projectHandle.getDisplayName());
                    }
                } else if ("messageCount".equals(propertyChangeEvent.getPropertyName())) {
                    if (MyProjectNode.this.btnMessages != null) {
                        MyProjectNode.this.setOnline(MyProjectNode.this.mh.getMessageCount() > 0);
                        MyProjectNode.this.btnMessages.setText(MyProjectNode.this.mh.getMessageCount() + "");
                    }
                } else if ("xmpp_login".equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getOldValue() == null) {
                        MyProjectNode.this.setOnline(MyProjectNode.this.mh.getMessageCount() > 0);
                    } else if (propertyChangeEvent.getNewValue() == null) {
                        MyProjectNode.this.setOnline(false);
                        MyProjectNode.this.mh.removePropertyChangeListener(MyProjectNode.this.projectListener);
                        MyProjectNode.this.mh = MyProjectNode.this.maccessor.getMessaging(projectHandle);
                        MyProjectNode.this.mh.addPropertyChangeListener(MyProjectNode.this.projectListener);
                    }
                } else if ("queryResult".equals(propertyChangeEvent.getPropertyName())) {
                    List list = (List)propertyChangeEvent.getNewValue();
                    for (QueryResultHandle queryResultHandle : list) {
                        if (queryResultHandle.getResultType() != QueryResultHandle.ResultType.ALL_CHANGES_RESULT) continue;
                        DashboardImpl.getInstance().myProjectsProgressStarted();
                        MyProjectNode.this.setBugsLater(queryResultHandle);
                        return;
                    }
                }
            }
        };
        this.project = projectHandle;
        this.project.addPropertyChangeListener(this.projectListener);
        this.accessor = ProjectAccessor.getDefault();
        this.maccessor = MessagingAccessor.getDefault();
        this.qaccessor = QueryAccessor.getDefault();
        this.mh = this.maccessor.getMessaging(projectHandle);
        this.mh.addPropertyChangeListener(this.projectListener);
        Kenai.getDefault().addPropertyChangeListener(this.projectListener);
    }

    ProjectHandle getProject() {
        return this.project;
    }

    ProjectAccessor getAccessor() {
        return this.accessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JComponent getComponent(Color color, Color color2, boolean bl, boolean bl2) {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.component) {
                this.component = new JPanel(new GridBagLayout());
                this.component.setOpaque(false);
                this.lbl = new TreeLabel(this.project.getDisplayName());
                this.component.add((Component)this.lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 3), 0, 0));
                MessagingHandle messagingHandle = this.maccessor.getMessaging(this.project);
                int n = messagingHandle.getMessageCount();
                this.leftPar = new TreeLabel("(");
                this.rightPar = new TreeLabel(")");
                this.component.add((Component)this.leftPar, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.btnMessages = new LinkButton(n + "", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/collab/resources/newmessage.png", (boolean)true), this.maccessor.getOpenMessagesAction(this.project));
                this.btnMessages.setHorizontalTextPosition(2);
                this.component.add((Component)this.btnMessages, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.component.add((Component)this.rightPar, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.setOnline(messagingHandle.getOnlineCount() >= 0 && n > 0);
                MyProjectNode.post(new Runnable(){

                    public void run() {
                        DashboardImpl.getInstance().myProjectsProgressStarted();
                        QueryHandle queryHandle = MyProjectNode.this.qaccessor.getAllIssuesQuery(MyProjectNode.this.project);
                        if (queryHandle != null) {
                            queryHandle.addPropertyChangeListener(MyProjectNode.this.projectListener);
                            List<QueryResultHandle> list = MyProjectNode.this.qaccessor.getQueryResults(queryHandle);
                            for (QueryResultHandle queryResultHandle : list) {
                                if (queryResultHandle.getResultType() != QueryResultHandle.ResultType.ALL_CHANGES_RESULT) continue;
                                MyProjectNode.this.setBugsLater(queryResultHandle);
                                return;
                            }
                        }
                        DashboardImpl.getInstance().myProjectsProgressFinished();
                    }
                });
                this.component.add((Component)new JLabel(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.btnOpen = new LinkButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/open.png", (boolean)true), this.getOpenAction());
                this.btnOpen.setText(null);
                this.btnOpen.setToolTipText(NbBundle.getMessage(MyProjectNode.class, (String)"LBL_Open"));
                this.btnOpen.setRolloverEnabled(true);
                this.btnOpen.setRolloverIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/open_over.png", (boolean)true));
                this.component.add((Component)this.btnOpen, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
            }
            this.lbl.setForeground(color);
            return this.component;
        }
    }

    public Action getDefaultAction() {
        return this.accessor.getDefaultAction(this.project, false);
    }

    private void setOnline(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (MyProjectNode.this.btnBugs == null || "0".equals(MyProjectNode.this.btnBugs.getText())) {
                    if (MyProjectNode.this.leftPar != null) {
                        MyProjectNode.this.leftPar.setVisible(bl);
                    }
                    if (MyProjectNode.this.rightPar != null) {
                        MyProjectNode.this.rightPar.setVisible(bl);
                    }
                }
                if (MyProjectNode.this.btnMessages != null) {
                    MyProjectNode.this.btnMessages.setVisible(bl);
                }
                DashboardImpl.getInstance().dashboardComponent.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private Action getOpenAction() {
        if (this.openAction == null) {
            this.openAction = this.getDefaultAction();
        }
        return this.openAction;
    }

    public Action[] getPopupActions() {
        return this.accessor.getPopupActions(this.project, false);
    }

    void setMemberProject(boolean bl) {
        if (bl == this.isMemberProject) {
            return;
        }
        this.isMemberProject = bl;
        this.fireContentChanged();
        this.refreshChildren();
    }

    private static synchronized void post(Runnable runnable) {
        if (rp == null) {
            rp = new RequestProcessor();
        }
        rp.post(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        super.dispose();
        if (null != this.project) {
            this.project.removePropertyChangeListener(this.projectListener);
        }
        if (null != this.mh) {
            this.mh.removePropertyChangeListener(this.projectListener);
        }
        Kenai.getDefault().removePropertyChangeListener(this.projectListener);
        Class<MyProjectNode> clazz = MyProjectNode.class;
        synchronized (MyProjectNode.class) {
            rp = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void setBugsLater(final QueryResultHandle queryResultHandle) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MyProjectNode.this.btnBugs != null) {
                    MyProjectNode.this.component.remove(MyProjectNode.this.btnBugs);
                }
                boolean bl = MyProjectNode.this.btnMessages != null && MyProjectNode.this.btnMessages.isVisible();
                MyProjectNode.this.btnBugs = new LinkButton(queryResultHandle.getText(), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/bug.png", (boolean)true), MyProjectNode.this.qaccessor.getOpenQueryResultAction(queryResultHandle));
                MyProjectNode.this.btnBugs.setHorizontalTextPosition(2);
                MyProjectNode.this.btnBugs.setToolTipText(queryResultHandle.getToolTipText());
                MyProjectNode.this.component.add((Component)MyProjectNode.this.btnBugs, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
                boolean bl2 = bl || !"0".equals(queryResultHandle.getText());
                MyProjectNode.this.leftPar.setVisible(bl2);
                MyProjectNode.this.rightPar.setVisible(bl2);
                MyProjectNode.this.btnBugs.setVisible(!"0".equals(queryResultHandle.getText()));
                MyProjectNode.this.component.validate();
                DashboardImpl dashboardImpl = DashboardImpl.getInstance();
                dashboardImpl.myProjectsProgressFinished();
                dashboardImpl.dashboardComponent.repaint();
            }
        });
    }
}

