/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.nodes;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.Customizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.kenai.ui.nodes.KenaiInstance;
import org.netbeans.modules.kenai.ui.nodes.KenaiInstancesManager;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KenaiInstanceCustomizer
extends JPanel
implements Customizer,
DocumentListener {
    private Object bean;
    private NotificationLineSupport ns;
    private DialogDescriptor dd;
    private JLabel lblName;
    private JLabel lblUrl;
    private JTextField txtDisplayName;
    private JTextField txtUrl;
    private static Pattern urlPatten = Pattern.compile("https://([a-zA-Z0-9\\-\\.])+\\.(([a-zA-Z]{2,3})|(info)|(name)|(aero)|(coop)|(museum)|(jobs)|(mobi)|(travel))/?$");

    public KenaiInstanceCustomizer() {
        this.initComponents();
        this.txtDisplayName.getDocument().addDocumentListener(this);
        this.txtUrl.getDocument().addDocumentListener(this);
    }

    public void setObject(Object object) {
        this.bean = object;
    }

    public String getDisplayName() {
        return this.txtDisplayName.getText();
    }

    public String getUrl() {
        return this.txtUrl.getText();
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.lblUrl = new JLabel();
        this.txtDisplayName = new JTextField();
        this.txtUrl = new JTextField();
        this.lblName.setLabelFor(this.txtDisplayName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.lblName.text"));
        this.lblUrl.setLabelFor(this.txtUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblUrl, (String)NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.lblUrl.text"));
        this.txtUrl.setText(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.txtUrl.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblName).add((Component)this.lblUrl)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtUrl, -1, 326, Short.MAX_VALUE).add((Component)this.txtDisplayName, -1, 326, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.txtDisplayName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txtUrl, -2, -1, -2).add((Component)this.lblUrl)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void validateInput() {
        this.clearError();
        String string = this.getDisplayName();
        if (string.trim().length() == 0) {
            this.showError(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_NoName"));
            return;
        }
        if (string.contains(",")) {
            this.showError(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_IllegalCharacter", (Object)"','"));
            return;
        }
        if (string.contains(";")) {
            this.showError(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_IllegalCharacter", (Object)"';'"));
            return;
        }
        String string2 = KenaiInstanceCustomizer.urlValid(this.getUrl());
        if (string2 != null) {
            this.showError(string2);
            return;
        }
    }

    private void showError(String string) {
        this.ns.setInformationMessage(string);
        this.dd.setValid(false);
    }

    private void clearError() {
        this.ns.clearMessages();
        this.dd.setValid(true);
    }

    private static String urlValid(String string) {
        if (!string.startsWith("https://")) {
            return NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_NotHttps");
        }
        if (!urlPatten.matcher(string).matches()) {
            return NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_UrlNotValid");
        }
        for (KenaiInstance kenaiInstance : KenaiInstancesManager.getDefault().getInstances()) {
            if (!kenaiInstance.getUrl().toString().equals(string.endsWith("/") ? string.substring(0, string.length() - 1) : string)) continue;
            return NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_UrlUsed", (Object)string);
        }
        try {
            new URL(string);
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return malformedURLException.getMessage();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateInput();
    }

    void setNotificationsSupport(NotificationLineSupport notificationLineSupport) {
        this.ns = notificationLineSupport;
    }

    void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
    }
}

