/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.nodes;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.nodes.KenaiInstance;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KenaiInstancesManager {
    private static KenaiInstancesManager instance;
    private List<KenaiInstance> instances = new ArrayList<KenaiInstance>();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROP_INSTANCES = "prop_instances";
    private Preferences prefs = NbPreferences.forModule(Kenai.class);
    private static final String INSTANCES_PREF = "kenai.instances";

    public static synchronized KenaiInstancesManager getDefault() {
        if (instance == null) {
            instance = new KenaiInstancesManager();
        }
        return instance;
    }

    private KenaiInstancesManager() {
        String string;
        String string2;
        Object object;
        String[] stringArray;
        String string3 = this.prefs.get(INSTANCES_PREF, "");
        if (string3.length() > 1) {
            stringArray = string3.split(";");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object = stringArray[i];
                if (((String)object).length() <= 0) continue;
                this.instances.add(new KenaiInstance(((String)object).split(",")[0], ((String)object).split(",")[1]));
            }
        }
        if (!this.instances.contains(object = new KenaiInstance(string2 = (stringArray = Kenai.getDefault()).getUrl().toString(), string = stringArray.getName()))) {
            this.instances.add((KenaiInstance)object);
            this.store();
        }
    }

    public void addInstance(KenaiInstance kenaiInstance) {
        this.instances.add(kenaiInstance);
        this.store();
        this.propertyChangeSupport.firePropertyChange(PROP_INSTANCES, null, kenaiInstance);
    }

    private void store() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<KenaiInstance> iterator = this.instances.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(";");
        }
        this.prefs.put(INSTANCES_PREF, stringBuffer.toString());
    }

    public boolean removeInstance(KenaiInstance kenaiInstance) {
        boolean bl = this.instances.remove(kenaiInstance);
        this.store();
        this.propertyChangeSupport.firePropertyChange(PROP_INSTANCES, kenaiInstance, null);
        return bl;
    }

    public Collection<KenaiInstance> getInstances() {
        return Collections.unmodifiableList(this.instances);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setDefaultInstance(final URL uRL) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Kenai.getDefault().setUrl(uRL);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UIUtils.tryLogin(false);
                        DashboardImpl.getInstance().refreshNonMemberProjects();
                    }
                });
            }
        });
    }
}

