/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.spi;

import java.awt.Component;
import java.awt.Graphics;
import java.net.PasswordAuthentication;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class KenaiUserUI {
    KenaiUser user;
    private static ImageIcon ONLINE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/user_online.png"));
    private static ImageIcon OFFLINE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/user_offline.png"));
    private Icon icon;
    private String chatMessage;

    public KenaiUserUI(String string) {
        this.user = KenaiUser.forName((String)string);
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new Icon(){

                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                    if (KenaiUserUI.this.user.isOnline()) {
                        ONLINE.paintIcon(component, graphics, n, n2);
                    } else {
                        OFFLINE.paintIcon(component, graphics, n, n2);
                    }
                }

                public int getIconWidth() {
                    if (KenaiUserUI.this.user.isOnline()) {
                        return ONLINE.getIconWidth();
                    }
                    return ONLINE.getIconWidth();
                }

                public int getIconHeight() {
                    if (KenaiUserUI.this.user.isOnline()) {
                        return ONLINE.getIconHeight();
                    }
                    return ONLINE.getIconHeight();
                }
            };
        }
        return this.icon;
    }

    public JLabel createUserWidget() {
        return UIUtils.createUserWidget(this);
    }

    public String getUserName() {
        return this.user.getUserName();
    }

    public void setMessage(String string) {
        this.chatMessage = string;
    }

    public void startChat() {
        this.startChat(this.chatMessage);
    }

    public void startChat(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                final Kenai kenai = Kenai.getDefault();
                if (kenai.getStatus() != Kenai.Status.ONLINE) {
                    if (JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(Utilities.class, (String)"MSG_GO_ONLINE"), NbBundle.getMessage(Utilities.class, (String)"MSG_GO_ONLINE_TITLE"), 0) == 0) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                PasswordAuthentication passwordAuthentication = kenai.getPasswordAuthentication();
                                if (passwordAuthentication != null) {
                                    try {
                                        kenai.login(passwordAuthentication.getUserName(), passwordAuthentication.getPassword(), true);
                                        KenaiUserUI.this.startChat();
                                    }
                                    catch (KenaiException kenaiException) {
                                        Exceptions.printStackTrace((Throwable)kenaiException);
                                    }
                                } else if (UIUtils.tryLogin(true)) {
                                    KenaiUserUI.this.startChat();
                                } else {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            if (UIUtils.showLogin()) {
                                                KenaiUserUI.this.startChat();
                                            }
                                        }
                                    });
                                }
                            }
                        });
                        return;
                    }
                    return;
                }
                ChatTopComponent chatTopComponent = ChatTopComponent.findInstance();
                chatTopComponent.open();
                chatTopComponent.requestActive();
                chatTopComponent.setActivePrivate(KenaiUserUI.this.user.getUserName());
                chatTopComponent.insertToActiveChat(string);
                chatTopComponent.requestFocus();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public KenaiUser getKenaiUser() {
        return this.user;
    }
}

