/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.URL;
import org.netbeans.modules.parsing.impl.indexing.FileObjectProvider;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class FileObjectIndexable
implements IndexableImpl,
FileObjectProvider {
    private final FileObject root;
    private final String relativePath;
    private Object url;
    private String mimeType;
    private FileObject file;

    public FileObjectIndexable(FileObject fileObject, FileObject fileObject2) {
        this(fileObject, FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2));
        this.file = fileObject2;
    }

    public FileObjectIndexable(FileObject fileObject, String string) {
        Parameters.notNull((CharSequence)"root", (Object)fileObject);
        Parameters.notNull((CharSequence)"relativePath", (Object)string);
        this.root = fileObject;
        this.relativePath = string;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public URL getURL() {
        if (this.url == null) {
            try {
                FileObject fileObject = this.getFileObject();
                if (fileObject != null) {
                    this.url = fileObject.getURL();
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.url = fileStateInvalidException;
            }
        }
        return this.url instanceof URL ? (URL)this.url : null;
    }

    public String getMimeType() {
        return this.mimeType == null ? "content/unknown" : this.mimeType;
    }

    public boolean isTypeOf(String string) {
        String string2;
        FileObject fileObject;
        Parameters.notNull((CharSequence)"mimeType", (Object)string);
        if (this.mimeType == null && (fileObject = this.getFileObject()) != null && (string2 = FileUtil.getMIMEType((FileObject)fileObject, (String[])new String[]{string})) != null && !string2.equals("content/unknown")) {
            this.mimeType = string2;
        }
        return this.mimeType == null ? false : this.mimeType.equals(string);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FileObjectIndexable fileObjectIndexable = (FileObjectIndexable)object;
        if (!(this.root == fileObjectIndexable.root || this.root != null && this.root.equals(fileObjectIndexable.root))) {
            return false;
        }
        return this.relativePath == fileObjectIndexable.relativePath || this.relativePath != null && this.relativePath.equals(fileObjectIndexable.relativePath);
    }

    public int hashCode() {
        int n = 7;
        n = 83 * n + (this.root != null ? this.root.hashCode() : 0);
        n = 83 * n + (this.relativePath != null ? this.relativePath.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "FileObjectIndexable@" + Integer.toHexString(System.identityHashCode(this)) + " [" + FileObjectIndexable.toURL(this.root) + "/" + this.getRelativePath() + "]";
    }

    public FileObject getFileObject() {
        if (this.file == null) {
            this.file = this.root.getFileObject(this.relativePath);
        }
        return this.file == null ? null : (this.file.isValid() ? this.file : null);
    }

    private static String toURL(FileObject fileObject) {
        try {
            return fileObject.getURL().toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return fileObject.getPath();
        }
    }
}

