/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeStamps {
    private static final Logger LOG = Logger.getLogger(TimeStamps.class.getName());
    private static final String TIME_STAMPS_FILE = "timestamps.properties";
    private final URL root;
    private final Properties props = new Properties();
    private final Set<String> unseen;
    private FileObject rootFoCache;
    private boolean changed;

    private TimeStamps(URL uRL, boolean bl) throws IOException {
        assert (uRL != null);
        this.root = uRL;
        this.unseen = bl ? new HashSet() : null;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        FileObject fileObject = CacheFolder.getDataFolder(this.root);
        FileObject fileObject2 = fileObject.getFileObject(TIME_STAMPS_FILE);
        if (fileObject2 != null) {
            try {
                InputStream inputStream = fileObject2.getInputStream();
                try {
                    this.props.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
                if (this.unseen != null) {
                    for (Object object : this.props.keySet()) {
                        this.unseen.add((String)object);
                    }
                }
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        FileObject fileObject = CacheFolder.getDataFolder(this.root);
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)TIME_STAMPS_FILE);
        assert (fileObject2 != null);
        try {
            OutputStream outputStream = fileObject2.getOutputStream();
            try {
                if (this.unseen != null) {
                    this.props.keySet().removeAll(this.unseen);
                }
                this.props.store(outputStream, "");
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, null, iOException);
        }
        this.changed = false;
    }

    public Set<String> getUnseenFiles() {
        return this.unseen;
    }

    public boolean checkAndStoreTimestamp(FileObject fileObject, String string) {
        boolean bl;
        long l;
        String string2;
        String string3;
        if (this.rootFoCache == null) {
            this.rootFoCache = URLMapper.findFileObject((URL)this.root);
        }
        if ((string3 = (String)this.props.setProperty(string2 = string != null ? string : URLMapper.findURL((FileObject)fileObject, (int)1).toExternalForm(), Long.toString(l = fileObject.lastModified().getTime()))) == null) {
            this.changed |= true;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0}: lastTimeStamp=null, fileTimeStamp={1} is out of date", new Object[]{fileObject.getPath(), l});
            }
            return false;
        }
        if (this.unseen != null) {
            this.unseen.remove(string2);
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string3);
            bl = l2 == l;
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warning("Invalid timestamp: " + string3 + " for file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
            bl = false;
        }
        if (!bl && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: lastTimeStamp={1}, fileTimeStamp={2} is out of date", new Object[]{fileObject.getPath(), l2, l});
        }
        this.changed |= !bl;
        return bl;
    }

    public static TimeStamps forRoot(URL uRL, boolean bl) throws IOException {
        return new TimeStamps(uRL, bl);
    }

    public static boolean existForRoot(URL uRL) throws IOException {
        FileObject fileObject;
        assert (uRL != null);
        FileObject fileObject2 = CacheFolder.getDataFolder(uRL, true);
        return fileObject2 != null && (fileObject = fileObject2.getFileObject(TIME_STAMPS_FILE)) != null;
    }
}

