/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.nb.javascript.BaseFunction;
import org.mozilla.nb.javascript.BeanProperty;
import org.mozilla.nb.javascript.ClassCache;
import org.mozilla.nb.javascript.ClassShutter;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.ContextFactory;
import org.mozilla.nb.javascript.FieldAndMethods;
import org.mozilla.nb.javascript.Kit;
import org.mozilla.nb.javascript.MemberBox;
import org.mozilla.nb.javascript.NativeJavaConstructor;
import org.mozilla.nb.javascript.NativeJavaMethod;
import org.mozilla.nb.javascript.ObjArray;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaMembers {
    private Class<?> cl;
    private Map<String, Object> members;
    private Map<String, FieldAndMethods> fieldAndMethods;
    private Map<String, Object> staticMembers;
    private Map<String, FieldAndMethods> staticFieldAndMethods;
    MemberBox[] ctors;
    private boolean includePrivate;

    JavaMembers(Scriptable scriptable, Class<?> clazz) {
        this(scriptable, clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaMembers(Scriptable scriptable, Class<?> clazz, boolean bl) {
        try {
            Context context = ContextFactory.getGlobal().enterContext();
            ClassShutter classShutter = context.getClassShutter();
            if (classShutter != null && !classShutter.visibleToScripts(clazz.getName())) {
                throw Context.reportRuntimeError1("msg.access.prohibited", clazz.getName());
            }
            this.includePrivate = context.hasFeature(13);
            this.members = new HashMap<String, Object>();
            this.staticMembers = new HashMap<String, Object>();
            this.cl = clazz;
            this.reflect(scriptable, bl);
        }
        finally {
            Context.exit();
        }
    }

    boolean has(String string, boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object = map.get(string);
        if (object != null) {
            return true;
        }
        return this.findExplicitFunction(string, bl) != null;
    }

    Object get(Scriptable scriptable, String string, Object object, boolean bl) {
        Class<?> clazz;
        Object object2;
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object3 = map.get(string);
        if (!bl && object3 == null) {
            object3 = this.staticMembers.get(string);
        }
        if (object3 == null && (object3 = this.getExplicitFunction(scriptable, string, object, bl)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (object3 instanceof Scriptable) {
            return object3;
        }
        Context context = Context.getContext();
        try {
            if (object3 instanceof BeanProperty) {
                BeanProperty beanProperty = (BeanProperty)object3;
                if (beanProperty.getter == null) {
                    return Scriptable.NOT_FOUND;
                }
                object2 = beanProperty.getter.invoke(object, Context.emptyArgs);
                clazz = beanProperty.getter.method().getReturnType();
            } else {
                Field field = (Field)object3;
                object2 = field.get(bl ? null : object);
                clazz = field.getType();
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return context.getWrapFactory().wrap(context, scriptable, object2, clazz);
    }

    void put(Scriptable scriptable, String string, Object object, Object object2, boolean bl) {
        Object object3;
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object4 = map.get(string);
        if (!bl && object4 == null) {
            object4 = this.staticMembers.get(string);
        }
        if (object4 == null) {
            throw this.reportMemberNotFound(string);
        }
        if (object4 instanceof FieldAndMethods) {
            object3 = (FieldAndMethods)map.get(string);
            object4 = ((FieldAndMethods)object3).field;
        }
        if (object4 instanceof BeanProperty) {
            object3 = (BeanProperty)object4;
            if (((BeanProperty)object3).setter == null) {
                throw this.reportMemberNotFound(string);
            }
            if (((BeanProperty)object3).setters == null || object2 == null) {
                Class<?> clazz = ((BeanProperty)object3).setter.argTypes[0];
                Object[] objectArray = new Object[]{Context.jsToJava(object2, clazz)};
                try {
                    ((BeanProperty)object3).setter.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    throw Context.throwAsScriptRuntimeEx(exception);
                }
            } else {
                Object[] objectArray = new Object[]{object2};
                ((BeanProperty)object3).setters.call(Context.getContext(), ScriptableObject.getTopLevelScope(scriptable), scriptable, objectArray);
            }
        } else {
            if (!(object4 instanceof Field)) {
                object3 = object4 == null ? "msg.java.internal.private" : "msg.java.method.assign";
                throw Context.reportRuntimeError1((String)object3, string);
            }
            object3 = (Field)object4;
            Object object5 = Context.jsToJava(object2, ((Field)object3).getType());
            try {
                ((Field)object3).set(object, object5);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ((((Field)object3).getModifiers() & 0x10) != 0) {
                    return;
                }
                throw Context.throwAsScriptRuntimeEx(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Context.reportRuntimeError3("msg.java.internal.field.type", object2.getClass().getName(), object3, object.getClass().getName());
            }
        }
    }

    Object[] getIds(boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        return map.keySet().toArray(new Object[map.size()]);
    }

    static String javaSignature(Class<?> clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        String string = clazz.getName();
        String string2 = "[]";
        if (n == 1) {
            return string.concat(string2);
        }
        int n2 = string.length() + n * string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        while (n != 0) {
            --n;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static String liveConnectSignature(Class<?>[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i != n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(JavaMembers.javaSignature(classArray[i]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private MemberBox findExplicitFunction(String string, boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        int n = string.indexOf(40);
        if (n < 0) {
            return null;
        }
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        MemberBox[] memberBoxArray = null;
        boolean bl3 = bl2 = bl && n == 0;
        if (bl2) {
            memberBoxArray = this.ctors;
        } else {
            String string2 = string.substring(0, n);
            object2 = map.get(string2);
            if (!bl && object2 == null) {
                object2 = this.staticMembers.get(string2);
            }
            if (object2 instanceof NativeJavaMethod) {
                object = (NativeJavaMethod)object2;
                memberBoxArray = ((NativeJavaMethod)object).methods;
            }
        }
        if (memberBoxArray != null) {
            for (int i = 0; i < memberBoxArray.length; ++i) {
                object2 = memberBoxArray[i].argTypes;
                object = JavaMembers.liveConnectSignature(object2);
                if (n + ((String)object).length() != string.length() || !string.regionMatches(n, (String)object, 0, ((String)object).length())) continue;
                return memberBoxArray[i];
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scriptable, String string, Object object, boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object2 = null;
        MemberBox memberBox = this.findExplicitFunction(string, bl);
        if (memberBox != null) {
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptable);
            if (memberBox.isCtor()) {
                NativeJavaConstructor nativeJavaConstructor = new NativeJavaConstructor(memberBox);
                nativeJavaConstructor.setPrototype(scriptable2);
                object2 = nativeJavaConstructor;
                map.put(string, nativeJavaConstructor);
            } else {
                String string2 = memberBox.getName();
                object2 = map.get(string2);
                if (object2 instanceof NativeJavaMethod && ((NativeJavaMethod)object2).methods.length > 1) {
                    NativeJavaMethod nativeJavaMethod = new NativeJavaMethod(memberBox, string);
                    nativeJavaMethod.setPrototype(scriptable2);
                    map.put(string, nativeJavaMethod);
                    object2 = nativeJavaMethod;
                }
            }
        }
        return object2;
    }

    private static Method[] discoverAccessibleMethods(Class<?> clazz, boolean bl, boolean bl2) {
        HashMap<MethodSignature, Method> hashMap = new HashMap<MethodSignature, Method>();
        JavaMembers.discoverAccessibleMethods(clazz, hashMap, bl, bl2);
        return hashMap.values().toArray(new Method[hashMap.size()]);
    }

    private static void discoverAccessibleMethods(Class<?> clazz, Map<MethodSignature, Method> map, boolean bl, boolean bl2) {
        if (Modifier.isPublic(clazz.getModifiers()) || bl2) {
            try {
                if (bl || bl2) {
                    while (clazz != null) {
                        try {
                            Method[] methodArray = clazz.getDeclaredMethods();
                            for (int i = 0; i < methodArray.length; ++i) {
                                Method method = methodArray[i];
                                int n = method.getModifiers();
                                if (!Modifier.isPublic(n) && !Modifier.isProtected(n) && !bl2) continue;
                                if (bl2) {
                                    method.setAccessible(true);
                                }
                                map.put(new MethodSignature(method), method);
                            }
                            clazz = clazz.getSuperclass();
                        }
                        catch (SecurityException securityException) {
                            Method[] methodArray = clazz.getMethods();
                            for (int i = 0; i < methodArray.length; ++i) {
                                Method method = methodArray[i];
                                MethodSignature methodSignature = new MethodSignature(method);
                                if (map.get(methodSignature) != null) continue;
                                map.put(methodSignature, method);
                            }
                            break;
                        }
                    }
                } else {
                    Method[] methodArray = clazz.getMethods();
                    for (int i = 0; i < methodArray.length; ++i) {
                        Method method = methodArray[i];
                        MethodSignature methodSignature = new MethodSignature(method);
                        map.put(methodSignature, method);
                    }
                }
                return;
            }
            catch (SecurityException securityException) {
                Context.reportWarning("Could not discover accessible methods of class " + clazz.getName() + " due to lack of privileges, " + "attemping superclasses/interfaces.", "discoverAccessibleMethods", new Object[]{clazz});
            }
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            JavaMembers.discoverAccessibleMethods(classArray[i], map, bl, bl2);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            JavaMembers.discoverAccessibleMethods(clazz2, map, bl, bl2);
        }
    }

    private void reflect(Scriptable scriptable, boolean bl) {
        int n;
        HashMap<String, FieldAndMethods> hashMap;
        Object object;
        MemberBox[] securityException;
        int n2;
        Method[] methodArray = JavaMembers.discoverAccessibleMethods(this.cl, bl, this.includePrivate);
        for (n2 = 0; n2 < methodArray.length; ++n2) {
            Method method = methodArray[n2];
            int n3 = method.getModifiers();
            boolean bl2 = Modifier.isStatic(n3);
            Map<String, Object> object3 = bl2 ? this.staticMembers : this.members;
            Object object2 = object3.get(securityException = method.getName());
            if (object2 == null) {
                object3.put((String)securityException, method);
                continue;
            }
            if (object2 instanceof ObjArray) {
                object = (ObjArray)object2;
            } else {
                if (!(object2 instanceof Method)) {
                    Kit.codeBug();
                }
                object = new ObjArray();
                ((ObjArray)object).add(object2);
                object3.put((String)securityException, object);
            }
            ((ObjArray)object).add(method);
        }
        for (n2 = 0; n2 != 2; ++n2) {
            boolean bl3 = n2 == 0;
            Map<String, Object> map = bl3 ? this.staticMembers : this.members;
            for (String hashMap2 : map.keySet()) {
                Object object3 = map.get(hashMap2);
                if (object3 instanceof Method) {
                    securityException = new MemberBox[]{new MemberBox((Method)object3)};
                } else {
                    object = (ObjArray)object3;
                    int n3 = ((ObjArray)object).size();
                    if (n3 < 2) {
                        Kit.codeBug();
                    }
                    securityException = new MemberBox[n3];
                    for (int i = 0; i != n3; ++i) {
                        hashMap = (Method)((ObjArray)object).get(i);
                        securityException[i] = new MemberBox((Method)((Object)hashMap));
                    }
                }
                object = new NativeJavaMethod(securityException);
                if (scriptable != null) {
                    ScriptRuntime.setFunctionProtoAndParent((BaseFunction)object, scriptable);
                }
                map.put(hashMap2, object);
            }
        }
        Field[] fieldArray = this.getAccessibleFields();
        for (n = 0; n < fieldArray.length; ++n) {
            Field field = fieldArray[n];
            String string = field.getName();
            int n4 = field.getModifiers();
            if (!this.includePrivate && !Modifier.isPublic(n4)) continue;
            try {
                Object object4;
                boolean bl2 = Modifier.isStatic(n4);
                Map<String, Object> map = bl2 ? this.staticMembers : this.members;
                object = map.get(string);
                if (object == null) {
                    map.put(string, field);
                    continue;
                }
                if (object instanceof NativeJavaMethod) {
                    object4 = (NativeJavaMethod)object;
                    FieldAndMethods fieldAndMethods = new FieldAndMethods(scriptable, ((NativeJavaMethod)object4).methods, field);
                    Map<String, FieldAndMethods> map2 = hashMap = bl2 ? this.staticFieldAndMethods : this.fieldAndMethods;
                    if (hashMap == null) {
                        hashMap = new HashMap<String, FieldAndMethods>();
                        if (bl2) {
                            this.staticFieldAndMethods = hashMap;
                        } else {
                            this.fieldAndMethods = hashMap;
                        }
                    }
                    hashMap.put(string, fieldAndMethods);
                    map.put(string, fieldAndMethods);
                    continue;
                }
                if (object instanceof Field) {
                    object4 = (Field)object;
                    if (!((Field)object4).getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) continue;
                    map.put(string, field);
                    continue;
                }
                Kit.codeBug();
                continue;
            }
            catch (SecurityException securityException2) {
                Context.reportWarning("Could not access field " + string + " of class " + this.cl.getName() + " due to lack of privileges.");
            }
        }
        for (n = 0; n != 2; ++n) {
            boolean bl5 = n == 0;
            Map<String, Object> map = bl5 ? this.staticMembers : this.members;
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            for (String string : map.keySet()) {
                Object object5;
                Object object6;
                boolean bl3 = string.startsWith("get");
                boolean bl4 = string.startsWith("set");
                boolean bl6 = string.startsWith("is");
                if (!bl3 && !bl6 && !bl4 || ((String)((Object)(hashMap = string.substring(bl6 ? 2 : 3)))).length() == 0) continue;
                Object object7 = hashMap;
                char c = ((String)((Object)hashMap)).charAt(0);
                if (Character.isUpperCase(c)) {
                    if (((String)((Object)hashMap)).length() == 1) {
                        object7 = ((String)((Object)hashMap)).toLowerCase();
                    } else {
                        char c2 = ((String)((Object)hashMap)).charAt(1);
                        if (!Character.isUpperCase(c2)) {
                            object7 = Character.toLowerCase(c) + ((String)((Object)hashMap)).substring(1);
                        }
                    }
                }
                if (hashMap2.containsKey(object7) || (object6 = map.get(object7)) != null && (!this.includePrivate || !Modifier.isPrivate(((Member)object6).getModifiers()))) continue;
                MemberBox memberBox = null;
                memberBox = this.findGetter(bl5, map, "get", (String)((Object)hashMap));
                if (memberBox == null) {
                    memberBox = this.findGetter(bl5, map, "is", (String)((Object)hashMap));
                }
                MemberBox memberBox2 = null;
                NativeJavaMethod nativeJavaMethod = null;
                String string2 = "set".concat((String)((Object)hashMap));
                if (map.containsKey(string2) && (object5 = map.get(string2)) instanceof NativeJavaMethod) {
                    NativeJavaMethod nativeJavaMethod2 = (NativeJavaMethod)object5;
                    if (memberBox != null) {
                        Class<?> clazz = memberBox.method().getReturnType();
                        memberBox2 = JavaMembers.extractSetMethod(clazz, nativeJavaMethod2.methods, bl5);
                    } else {
                        memberBox2 = JavaMembers.extractSetMethod(nativeJavaMethod2.methods, bl5);
                    }
                    if (nativeJavaMethod2.methods.length > 1) {
                        nativeJavaMethod = nativeJavaMethod2;
                    }
                }
                object5 = new BeanProperty(memberBox, memberBox2, nativeJavaMethod);
                hashMap2.put(object7, object5);
            }
            for (String string : hashMap2.keySet()) {
                Object v = hashMap2.get(string);
                map.put(string, v);
            }
        }
        Constructor<?>[] constructorArray = this.getAccessibleConstructors();
        this.ctors = new MemberBox[constructorArray.length];
        for (int i = 0; i != constructorArray.length; ++i) {
            this.ctors[i] = new MemberBox(constructorArray[i]);
        }
    }

    private Constructor<?>[] getAccessibleConstructors() {
        if (this.includePrivate && this.cl != ScriptRuntime.ClassClass) {
            try {
                AccessibleObject[] accessibleObjectArray = this.cl.getDeclaredConstructors();
                Constructor.setAccessible(accessibleObjectArray, true);
                return accessibleObjectArray;
            }
            catch (SecurityException securityException) {
                Context.reportWarning("Could not access constructor  of class " + this.cl.getName() + " due to lack of privileges.");
            }
        }
        return this.cl.getConstructors();
    }

    private Field[] getAccessibleFields() {
        if (this.includePrivate) {
            try {
                ArrayList<Field> arrayList = new ArrayList<Field>();
                for (Class<?> clazz = this.cl; clazz != null; clazz = clazz.getSuperclass()) {
                    Field[] fieldArray = clazz.getDeclaredFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        fieldArray[i].setAccessible(true);
                        arrayList.add(fieldArray[i]);
                    }
                }
                return arrayList.toArray(new Field[arrayList.size()]);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.cl.getFields();
    }

    private MemberBox findGetter(boolean bl, Map<String, Object> map, String string, String string2) {
        Object object;
        String string3 = string.concat(string2);
        if (map.containsKey(string3) && (object = map.get(string3)) instanceof NativeJavaMethod) {
            NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)object;
            return JavaMembers.extractGetMethod(nativeJavaMethod.methods, bl);
        }
        return null;
    }

    private static MemberBox extractGetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 0; i < memberBoxArray.length; ++i) {
            MemberBox memberBox = memberBoxArray[i];
            if (memberBox.argTypes.length != 0 || bl && !memberBox.isStatic()) continue;
            Class<?> clazz = memberBox.method().getReturnType();
            if (clazz == Void.TYPE) break;
            return memberBox;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class<?> clazz, MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 1; i <= 2; ++i) {
            for (int j = 0; j < memberBoxArray.length; ++j) {
                Class<?>[] classArray;
                MemberBox memberBox = memberBoxArray[j];
                if (bl && !memberBox.isStatic() || (classArray = memberBox.argTypes).length != 1) continue;
                if (i == 1) {
                    if (classArray[0] != clazz) continue;
                    return memberBox;
                }
                if (i != 2) {
                    Kit.codeBug();
                }
                if (!classArray[0].isAssignableFrom(clazz)) continue;
                return memberBox;
            }
        }
        return null;
    }

    private static MemberBox extractSetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 0; i < memberBoxArray.length; ++i) {
            MemberBox memberBox = memberBoxArray[i];
            if (bl && !memberBox.isStatic() || memberBox.method().getReturnType() != Void.TYPE || memberBox.argTypes.length != 1) continue;
            return memberBox;
        }
        return null;
    }

    Map<String, FieldAndMethods> getFieldAndMethodsObjects(Scriptable scriptable, Object object, boolean bl) {
        Map<String, FieldAndMethods> map;
        Map<String, FieldAndMethods> map2 = map = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (map == null) {
            return null;
        }
        int n = map.size();
        HashMap<String, FieldAndMethods> hashMap = new HashMap<String, FieldAndMethods>(n);
        for (FieldAndMethods fieldAndMethods : map.values()) {
            FieldAndMethods fieldAndMethods2 = new FieldAndMethods(scriptable, fieldAndMethods.methods, fieldAndMethods.field);
            fieldAndMethods2.javaObject = object;
            hashMap.put(fieldAndMethods.field.getName(), fieldAndMethods2);
        }
        return hashMap;
    }

    static JavaMembers lookupClass(Scriptable scriptable, Class<?> clazz, Class<?> clazz2, boolean bl) {
        JavaMembers javaMembers;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        ClassCache classCache = ClassCache.get(scriptable);
        Map<Class<?>, JavaMembers> map = classCache.getClassCacheMap();
        Class<?> clazz3 = clazz;
        while (true) {
            if ((javaMembers = map.get(clazz3)) != null) {
                return javaMembers;
            }
            try {
                javaMembers = new JavaMembers(scriptable, clazz3, bl);
            }
            catch (SecurityException securityException) {
                if (clazz2 != null && clazz2.isInterface()) {
                    clazz3 = clazz2;
                    clazz2 = null;
                    continue;
                }
                Class<?> clazz4 = clazz3.getSuperclass();
                if (clazz4 == null) {
                    if (clazz3.isInterface()) {
                        clazz4 = ScriptRuntime.ObjectClass;
                    } else {
                        throw securityException;
                    }
                }
                clazz3 = clazz4;
                continue;
            }
            break;
        }
        if (classCache.isCachingEnabled()) {
            map.put(clazz3, javaMembers);
        }
        return javaMembers;
    }

    RuntimeException reportMemberNotFound(String string) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodSignature {
        private final String name;
        private final Class<?>[] args;

        private MethodSignature(String string, Class<?>[] classArray) {
            this.name = string;
            this.args = classArray;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object object) {
            if (object instanceof MethodSignature) {
                MethodSignature methodSignature = (MethodSignature)object;
                return methodSignature.name.equals(this.name) && Arrays.equals(this.args, methodSignature.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

