/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.TextAction;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class RefactoringSubMenuAction
extends TextAction
implements Presenter.Menu,
Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(RefactoringSubMenuAction.class.getName());
    private final boolean showIcons;

    public static RefactoringSubMenuAction create(FileObject fileObject) {
        return new RefactoringSubMenuAction(true);
    }

    public static JMenu createMenu() {
        RefactoringSubMenuAction refactoringSubMenuAction = new RefactoringSubMenuAction(true);
        return (JMenu)refactoringSubMenuAction.getMenuPresenter();
    }

    RefactoringSubMenuAction(boolean bl) {
        super(NbBundle.getMessage(RefactoringSubMenuAction.class, (String)"LBL_Action"));
        this.showIcons = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JMenuItem getMenuPresenter() {
        return new SubMenu();
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuPresenter();
    }

    public boolean equals(Object object) {
        return object instanceof RefactoringSubMenuAction;
    }

    public int hashCode() {
        return 1;
    }

    private final class SubMenu
    extends JMenu {
        private boolean createMenuLazily;
        private boolean wasSeparator;
        private boolean shouldAddSeparator;

        public SubMenu() {
            super((String)RefactoringSubMenuAction.this.getValue("Name"));
            this.createMenuLazily = true;
            if (RefactoringSubMenuAction.this.showIcons) {
                this.setMnemonic(NbBundle.getMessage(RefactoringSubMenuAction.class, (String)"LBL_ActionMnemonic").charAt(0));
            }
        }

        public JPopupMenu getPopupMenu() {
            if (this.createMenuLazily) {
                this.createMenuItems();
                this.createMenuLazily = false;
            }
            return super.getPopupMenu();
        }

        private void createMenuItems() {
            this.removeAll();
            FileObject fileObject = FileUtil.getConfigFile((String)"Menu/Refactoring");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            if (dataFolder != null) {
                this.wasSeparator = true;
                this.shouldAddSeparator = false;
                DataObject[] dataObjectArray = dataFolder.getChildren();
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    JMenuItem jMenuItem;
                    Object object;
                    InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class);
                    if (instanceCookie == null) continue;
                    try {
                        object = instanceCookie.instanceCreate();
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.WARNING, dataObjectArray[i].toString(), iOException);
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOG.log(Level.WARNING, dataObjectArray[i].toString(), classNotFoundException);
                        continue;
                    }
                    if (object instanceof Presenter.Popup) {
                        jMenuItem = ((Presenter.Popup)object).getPopupPresenter();
                        if (jMenuItem instanceof DynamicMenuContent) {
                            for (JComponent jComponent : ((DynamicMenuContent)jMenuItem).getMenuPresenters()) {
                                this.addPresenter(jComponent);
                            }
                            continue;
                        }
                        this.addPresenter(jMenuItem);
                        continue;
                    }
                    if (object instanceof Action) {
                        jMenuItem = new JMenuItem();
                        Actions.connect((JMenuItem)jMenuItem, (Action)((Action)object), (boolean)true);
                        this.addPresenter(jMenuItem);
                        continue;
                    }
                    if (!(object instanceof JSeparator)) continue;
                    this.addPresenter((JSeparator)object);
                }
            }
        }

        private void addPresenter(JComponent jComponent) {
            boolean bl;
            if (!RefactoringSubMenuAction.this.showIcons && jComponent instanceof AbstractButton) {
                ((AbstractButton)jComponent).setIcon(null);
            }
            boolean bl2 = bl = jComponent == null || jComponent instanceof JSeparator;
            if (bl) {
                if (!this.wasSeparator) {
                    this.shouldAddSeparator = true;
                    this.wasSeparator = true;
                }
            } else {
                if (this.shouldAddSeparator) {
                    this.addSeparator();
                    this.shouldAddSeparator = false;
                }
                this.add(jComponent);
                this.wasSeparator = false;
            }
        }
    }
}

