/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.viewmodel.DefaultTreeExpansionManager;
import org.netbeans.modules.viewmodel.ExceptionNode;
import org.netbeans.modules.viewmodel.HyperColumnModel;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.awt.Actions;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModelNode
extends AbstractNode {
    private static final int MAX_HTML_LENGTH = 511;
    private Models.CompoundModel model;
    private ColumnModel[] columns;
    protected TreeModelRoot treeModelRoot;
    protected Object object;
    private String htmlDisplayName;
    private String shortDescription;
    private final Object shortDescriptionLock = new Object();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private static final String EVALUATING_STR = NbBundle.getMessage(TreeModelNode.class, (String)"EvaluatingProp");
    private final Map<Models.CompoundModel, RequestProcessor.Task> tasksByModels = new HashMap<Models.CompoundModel, RequestProcessor.Task>();
    private static RequestProcessor requestProcessor;
    private Integer depth;

    public TreeModelNode(Models.CompoundModel compoundModel, TreeModelRoot treeModelRoot, Object object) {
        this(compoundModel, compoundModel.getColumns(), TreeModelNode.createChildren(compoundModel, compoundModel.getColumns(), treeModelRoot, object), treeModelRoot, object);
    }

    public TreeModelNode(Models.CompoundModel compoundModel, ColumnModel[] columnModelArray, TreeModelRoot treeModelRoot, Object object) {
        this(compoundModel, columnModelArray, TreeModelNode.createChildren(compoundModel, columnModelArray, treeModelRoot, object), treeModelRoot, object);
    }

    protected TreeModelNode(Models.CompoundModel compoundModel, ColumnModel[] columnModelArray, Children children, TreeModelRoot treeModelRoot, Object object) {
        super(children, Lookups.fixed((Object[])new Object[]{object, new CheckNodeCookieImpl(compoundModel, object)}));
        this.model = compoundModel;
        this.treeModelRoot = treeModelRoot;
        this.object = object;
        if (compoundModel.getHelpId() != null) {
            this.setValue("propertiesHelpID", compoundModel.getHelpId());
        }
        treeModelRoot.registerNode(object, this);
        this.refreshNode();
        this.initProperties(columnModelArray);
    }

    private static Executor asynchronous(Models.CompoundModel compoundModel, AsynchronousModelFilter.CALL cALL, Object object) {
        Executor executor;
        try {
            executor = compoundModel.asynchronous(cALL, object);
            if (executor == null) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)new NullPointerException("Provided executor is null."), (String)("model = " + compoundModel + ", object = " + object)));
                executor = AsynchronousModelFilter.CURRENT_THREAD;
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)exception, (String)("model = " + compoundModel + ", object = " + object)));
            executor = AsynchronousModelFilter.CURRENT_THREAD;
        }
        return executor;
    }

    private void initProperties(ColumnModel[] columnModelArray) {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        this.columns = columnModelArray;
        int n = columnModelArray.length;
        for (int i = 0; i < n; ++i) {
            set.put((Node.Property)new MyProperty(columnModelArray[i], this.treeModelRoot));
        }
        sheet.put(set);
        this.setSheet(sheet);
    }

    private static Children createChildren(Models.CompoundModel compoundModel, ColumnModel[] columnModelArray, TreeModelRoot treeModelRoot, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            return compoundModel.isLeaf(object) ? Children.LEAF : new TreeModelChildren(compoundModel, columnModelArray, treeModelRoot, object);
        }
        catch (UnknownTypeException unknownTypeException) {
            if (!(object instanceof String)) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + compoundModel, unknownTypeException);
            }
            return Children.LEAF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription() {
        Object object = this.shortDescriptionLock;
        synchronized (object) {
            if (this.shortDescription != null) {
                return this.shortDescription;
            }
        }
        object = TreeModelNode.asynchronous(this.model, AsynchronousModelFilter.CALL.SHORT_DESCRIPTION, this.object);
        if (object == AsynchronousModelFilter.CURRENT_THREAD) {
            return this.updateShortDescription();
        }
        object.execute(new Runnable(){

            public void run() {
                TreeModelNode.this.updateShortDescription();
                TreeModelNode.this.fireShortDescriptionChange(null, null);
            }
        });
        return EVALUATING_STR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateShortDescription() {
        try {
            String string = this.model.getShortDescription(this.object);
            if (string != null) {
                string = TreeModelNode.adjustHTML(string);
            }
            Object object = this.shortDescriptionLock;
            synchronized (object) {
                this.shortDescription = string;
            }
            return string;
        }
        catch (UnknownTypeException unknownTypeException) {
            if (!(this.object instanceof String)) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFireShortDescriptionChange() {
        Object object = this.shortDescriptionLock;
        synchronized (object) {
            this.shortDescription = null;
        }
        this.fireShortDescriptionChange(null, null);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return this.treeModelRoot.getRootNode().getActions(false);
        }
        try {
            return this.model.getActions(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            return new Action[0];
        }
    }

    public Action getPreferredAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TreeModelNode.this.model.performDefaultAction(TreeModelNode.this.object);
                }
                catch (UnknownTypeException unknownTypeException) {
                    // empty catch block
                }
            }
        };
    }

    public boolean canDestroy() {
        try {
            Action[] actionArray = this.model.getActions(this.object);
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                if (actionArray[i] == null || (object = actionArray[i].getValue("AcceleratorKey")) == null || !object.equals(KeyStroke.getKeyStroke("DELETE"))) continue;
                return actionArray[i].isEnabled();
            }
            return false;
        }
        catch (UnknownTypeException unknownTypeException) {
            return false;
        }
    }

    public boolean canCopy() {
        try {
            return this.model.canCopy(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
            return false;
        }
    }

    public boolean canCut() {
        try {
            return this.model.canCut(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
            return false;
        }
    }

    public void destroy() {
        try {
            Action[] actionArray = this.model.getActions(this.object);
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                if (actionArray[i] == null || (object = actionArray[i].getValue("AcceleratorKey")) == null || !object.equals(KeyStroke.getKeyStroke("DELETE"))) continue;
                actionArray[i].actionPerformed(null);
                return;
            }
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
        }
        if (this.model.getRoot() == this.object) {
            this.treeModelRoot.destroy();
        }
    }

    void setObject(Object object) {
        this.setObject(this.model, object);
    }

    void setObject(Models.CompoundModel compoundModel, Object object) {
        this.setObjectNoRefresh(object);
        this.refresh(compoundModel);
    }

    private void setObjectNoRefresh(Object object) {
        this.object = object;
        Children children = this.getChildren();
        if (children instanceof TreeModelChildren) {
            ((TreeModelChildren)children).object = object;
        }
    }

    public Object getObject() {
        return this.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(final Models.CompoundModel compoundModel) {
        Map<Object, Object> map = this.properties;
        synchronized (map) {
            this.properties.clear();
        }
        map = this.tasksByModels;
        synchronized (map) {
            RequestProcessor.Task task = this.tasksByModels.get(compoundModel);
            if (task == null) {
                task = this.getRequestProcessor().create(new Runnable(){

                    public void run() {
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(this);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Exceptions.printStackTrace((Throwable)invocationTargetException);
                            }
                            return;
                        }
                        TreeModelNode.this.refreshNode();
                        TreeModelNode.this.doFireShortDescriptionChange();
                        TreeModelNode.this.refreshTheChildren(compoundModel, new TreeModelChildren.RefreshingInfo(true));
                    }
                });
                this.tasksByModels.put(compoundModel, task);
            }
            task.schedule(0);
        }
    }

    void refresh(final Models.CompoundModel compoundModel, int n) {
        if (n == -1) {
            this.refresh(compoundModel);
            return;
        }
        boolean bl = false;
        if ((1 & n) != 0) {
            try {
                this.setModelDisplayName();
            }
            catch (UnknownTypeException unknownTypeException) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + compoundModel, unknownTypeException);
            }
            bl = true;
        }
        if ((2 & n) != 0) {
            try {
                String string = compoundModel.getIconBaseWithExtension(this.object);
                if (string != null) {
                    this.setIconBaseWithExtension(string);
                } else {
                    this.setIconBaseWithExtension("org/openide/resources/actions/empty.gif");
                }
            }
            catch (UnknownTypeException unknownTypeException) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + compoundModel, unknownTypeException);
            }
            bl = true;
        }
        if ((4 & n) != 0) {
            this.doFireShortDescriptionChange();
            bl = true;
        }
        if ((8 & n) != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeModelNode.this.refreshTheChildren(compoundModel, new TreeModelChildren.RefreshingInfo(false));
                }
            });
            bl = true;
        }
        if ((0x10 & n) != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeModelNode.this.expandIfSetToExpanded();
                }
            });
        }
        if (!bl) {
            this.refresh(compoundModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RequestProcessor getRequestProcessor() {
        Class<TreeModelNode> clazz = TreeModelNode.class;
        synchronized (TreeModelNode.class) {
            if (requestProcessor == null) {
                requestProcessor = new RequestProcessor("TreeModel", 1);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return requestProcessor;
        }
    }

    private void setName(String string, boolean bl) {
        String string2;
        String string3 = this.htmlDisplayName;
        String string4 = this.getDisplayName();
        if (string.startsWith("<html>")) {
            this.htmlDisplayName = string;
            string2 = TreeModelNode.removeHTML(string);
        } else if (string.startsWith("<_html>")) {
            this.htmlDisplayName = '<' + string.substring(2);
            string2 = "";
        } else {
            this.htmlDisplayName = null;
            string2 = string;
        }
        if (string4 == null || !string4.equals(string2)) {
            this.setDisplayName(string2);
        } else if (string3 != null && !string3.equals(this.htmlDisplayName) || this.htmlDisplayName != null && !this.htmlDisplayName.equals(string3)) {
            this.fireDisplayNameChange(string4 + "_HACK", this.getDisplayName());
        }
    }

    private void setModelDisplayName() throws UnknownTypeException {
        Executor executor = TreeModelNode.asynchronous(this.model, AsynchronousModelFilter.CALL.DISPLAY_NAME, this.object);
        if (executor == AsynchronousModelFilter.CURRENT_THREAD) {
            String string = this.model.getDisplayName(this.object);
            if (string == null) {
                NullPointerException nullPointerException = new NullPointerException("Model: " + this.model + ".getDisplayName (" + this.object + ") = null!");
                Exceptions.printStackTrace((Throwable)nullPointerException);
            } else {
                this.setName(string, false);
            }
        } else {
            final String string = this.getDisplayName();
            this.setName(EVALUATING_STR, false);
            executor.execute(new Runnable(){

                public void run() {
                    String string2;
                    try {
                        string2 = TreeModelNode.this.model.getDisplayName(TreeModelNode.this.object);
                    }
                    catch (UnknownTypeException unknownTypeException) {
                        Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + TreeModelNode.this.model, unknownTypeException);
                        TreeModelNode.this.setName(string, false);
                        return;
                    }
                    if (string2 == null) {
                        NullPointerException nullPointerException = new NullPointerException("Model: " + TreeModelNode.this.model + ".getDisplayName (" + TreeModelNode.this.object + ") = null!");
                        Exceptions.printStackTrace((Throwable)nullPointerException);
                        TreeModelNode.this.setName(string, false);
                    } else {
                        TreeModelNode.this.setName(string2, false);
                    }
                }
            });
        }
    }

    private void refreshNode() {
        try {
            this.setModelDisplayName();
            String string = null;
            if (this.model.getRoot() != this.object) {
                string = this.model.getIconBaseWithExtension(this.object);
            }
            if (string != null) {
                this.setIconBaseWithExtension(string);
            } else {
                this.setIconBaseWithExtension("org/openide/resources/actions/empty.gif");
            }
            this.firePropertyChange(null, null, null);
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumn(String string) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.remove(string);
            this.properties.remove(string + "#html");
        }
        this.firePropertyChange(string, null, null);
    }

    protected void refreshTheChildren(Models.CompoundModel compoundModel, TreeModelChildren.RefreshingInfo refreshingInfo) {
        Children children = this.getChildren();
        try {
            if (children instanceof TreeModelChildren) {
                if (compoundModel.isLeaf(this.object)) {
                    this.setChildren(Children.LEAF);
                } else {
                    ((TreeModelChildren)children).refreshChildren(refreshingInfo);
                }
            } else if (!compoundModel.isLeaf(this.object)) {
                this.setChildren((Children)new TreeModelChildren(compoundModel, this.columns, this.treeModelRoot, this.object));
            }
        }
        catch (UnknownTypeException unknownTypeException) {
            if (!(this.object instanceof String)) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + compoundModel, unknownTypeException);
            }
            this.setChildren(Children.LEAF);
        }
    }

    private static String htmlValue(String string) {
        if (string.length() <= 6 || !string.substring(0, 6).equalsIgnoreCase("<html>")) {
            return null;
        }
        if (string.length() > 511) {
            int n = TreeModelNode.findEndTagsPos(string);
            String string2 = string.substring(n + 1);
            string = string.substring(0, 508 - string2.length());
            int n2 = string.length();
            for (int i = n2 - 1; i > n2 - 6 && string.charAt(i) != ';'; --i) {
                if (string.charAt(i) != '&') continue;
                string = string.substring(0, i);
                break;
            }
            string = string + "..." + string2;
        }
        return TreeModelNode.adjustHTML(string);
    }

    private static int findEndTagsPos(String string) {
        int n;
        int n2 = 0;
        for (n = string.length() - 1; n >= 0; --n) {
            if (string.charAt(n) == '>') {
                ++n2;
                continue;
            }
            if (string.charAt(n) == '<') {
                --n2;
                continue;
            }
            if (n2 == 0) break;
        }
        return n;
    }

    private static String removeHTML(String string) {
        if (string.length() <= 6 || !string.substring(0, 6).equalsIgnoreCase("<html>")) {
            return string;
        }
        string = string.replaceAll("<i>", "");
        string = string.replaceAll("</i>", "");
        string = string.replaceAll("<b>", "");
        string = string.replaceAll("</b>", "");
        string = string.replaceAll("<html>", "");
        string = string.replaceAll("</html>", "");
        string = string.replaceAll("</font>", "");
        int n = string.indexOf("<font");
        while (n >= 0) {
            int n2 = string.indexOf(">", n);
            string = string.substring(0, n) + string.substring(n2 + 1);
            n = string.indexOf("<font");
        }
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&gt;", ">");
        string = string.replaceAll("&amp;", "&");
        return string;
    }

    private static String adjustHTML(String string) {
        string = string.replaceAll(Matcher.quoteReplacement("\\"), "\\\\\\\\");
        StringBuffer stringBuffer = null;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = null;
            if (c == '\n') {
                string2 = "\\n";
            } else if (c == '\r') {
                string2 = "\\r";
            } else if (c == '\f') {
                string2 = "\\f";
            } else if (c == '\b') {
                string2 = "\\b";
            }
            if (string2 == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string.substring(0, i));
            } else {
                stringBuffer.append(string.substring(n, i));
            }
            stringBuffer.append(string2);
            n = i + 1;
        }
        if (stringBuffer == null) {
            return string;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public boolean canRename() {
        try {
            return this.model.canRename(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
            return false;
        }
    }

    public void setName(String string) {
        try {
            this.model.setName(this.object, string);
            super.setName(string);
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
        }
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable transferable;
        try {
            transferable = this.model.clipboardCopy(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
            transferable = null;
        }
        if (transferable == null) {
            return super.clipboardCopy();
        }
        return transferable;
    }

    public Transferable clipboardCut() throws IOException {
        Transferable transferable;
        try {
            transferable = this.model.clipboardCut(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
            transferable = null;
        }
        if (transferable == null) {
            return super.clipboardCut();
        }
        return transferable;
    }

    public void createPasteTypes(Transferable transferable, List<PasteType> list) {
        PasteType[] pasteTypeArray;
        try {
            pasteTypeArray = this.model.getPasteTypes(this.object, transferable);
        }
        catch (UnknownTypeException unknownTypeException) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
            pasteTypeArray = null;
        }
        if (pasteTypeArray == null) {
            super.createPasteTypes(transferable, list);
        } else {
            list.addAll(Arrays.asList(pasteTypeArray));
        }
    }

    private final void expandIfSetToExpanded() {
        try {
            Models.TreeFeatures treeFeatures;
            DefaultTreeExpansionManager.get(this.model).setChildrenToActOn(this.getTreeDepth());
            if (this.model.isExpanded(this.object) && (treeFeatures = this.treeModelRoot.getTreeFeatures()) != null) {
                treeFeatures.expandNode(this.object);
            }
        }
        catch (UnknownTypeException unknownTypeException) {
            // empty catch block
        }
    }

    private Integer getTreeDepth() {
        Node node = this.getParentNode();
        if (node == null) {
            return 0;
        }
        if (this.depth != null) {
            return this.depth;
        }
        int n = 1;
        while ((node = node.getParentNode()) != null) {
            ++n;
        }
        this.depth = new Integer(n);
        return this.depth;
    }

    private static final class CheckNodeCookieImpl
    implements CheckableNode {
        private final Models.CompoundModel model;
        private final Object object;

        public CheckNodeCookieImpl(Models.CompoundModel compoundModel, Object object) {
            this.model = compoundModel;
            this.object = object;
        }

        public boolean isCheckable() {
            try {
                return this.model.isCheckable(this.object);
            }
            catch (UnknownTypeException unknownTypeException) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)unknownTypeException, (String)("Model = " + this.model)));
                return false;
            }
        }

        public boolean isCheckEnabled() {
            try {
                return this.model.isCheckEnabled(this.object);
            }
            catch (UnknownTypeException unknownTypeException) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)unknownTypeException, (String)("Model = " + this.model)));
                return false;
            }
        }

        public Boolean isSelected() {
            try {
                return this.model.isSelected(this.object);
            }
            catch (UnknownTypeException unknownTypeException) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)unknownTypeException, (String)("Model = " + this.model)));
                return false;
            }
        }

        public void setSelected(Boolean bl) {
            try {
                this.model.setSelected(this.object, bl);
            }
            catch (UnknownTypeException unknownTypeException) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)unknownTypeException, (String)("Model = " + this.model)));
            }
        }
    }

    private class MyProperty
    extends PropertySupport
    implements Runnable {
        private String id;
        private String propertyId;
        private ColumnModel columnModel;
        private boolean nodeColumn;
        private TreeModelRoot treeModelRoot;
        private final int[] evaluated;
        private RequestProcessor.Task task;
        private RequestProcessor lastRp;

        MyProperty(ColumnModel columnModel, TreeModelRoot treeModelRoot) {
            super(columnModel.getID(), columnModel.getType() == null ? String.class : columnModel.getType(), Actions.cutAmpersand((String)columnModel.getDisplayName()), columnModel.getShortDescription(), true, true);
            this.evaluated = new int[]{0};
            this.nodeColumn = columnModel.getType() == null;
            this.treeModelRoot = treeModelRoot;
            if (columnModel instanceof HyperColumnModel) {
                this.propertyId = columnModel.getID();
                this.columnModel = ((HyperColumnModel)columnModel).getSpecific();
                this.id = this.columnModel.getID();
            } else {
                this.id = this.propertyId = columnModel.getID();
                this.columnModel = columnModel;
            }
        }

        public boolean canWrite() {
            if (this.nodeColumn) {
                return false;
            }
            try {
                return !TreeModelNode.this.model.isReadOnly(TreeModelNode.this.object, this.columnModel.getID());
            }
            catch (UnknownTypeException unknownTypeException) {
                if (!(TreeModelNode.this.object instanceof String)) {
                    Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model, unknownTypeException);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Object object = "";
            String string = null;
            String string2 = null;
            try {
                block24: {
                    try {
                        object = TreeModelNode.this.model.getValueAt(TreeModelNode.this.object, this.id);
                        if (!(object instanceof String)) break block24;
                        string = TreeModelNode.htmlValue((String)object);
                        string2 = TreeModelNode.removeHTML((String)object);
                    }
                    catch (UnknownTypeException unknownTypeException) {
                        if (!(TreeModelNode.this.object instanceof String)) {
                            unknownTypeException.printStackTrace();
                            System.out.println("  Column id:" + this.columnModel.getID());
                            System.out.println(TreeModelNode.this.model);
                            System.out.println();
                        }
                        Object var6_5 = null;
                        Map map = TreeModelNode.this.properties;
                        // MONITORENTER : map
                        if (object instanceof String) {
                            TreeModelNode.this.properties.put(this.id, string2);
                            TreeModelNode.this.properties.put(this.id + "#html", string);
                        } else {
                            TreeModelNode.this.properties.put(this.id, object);
                        }
                        int[] nArray = this.evaluated;
                        // MONITORENTER : this.evaluated
                        boolean bl = this.evaluated[0] == -1;
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                        // MONITOREXIT : nArray
                        // MONITOREXIT : map
                        if (!bl) return;
                        TreeModelNode.this.firePropertyChange(this.propertyId, null, object);
                        return;
                    }
                    catch (Throwable throwable) {
                        Exceptions.printStackTrace((Throwable)throwable);
                        Object var6_6 = null;
                        Map map = TreeModelNode.this.properties;
                        // MONITORENTER : map
                        if (object instanceof String) {
                            TreeModelNode.this.properties.put(this.id, string2);
                            TreeModelNode.this.properties.put(this.id + "#html", string);
                        } else {
                            TreeModelNode.this.properties.put(this.id, object);
                        }
                        int[] nArray = this.evaluated;
                        // MONITORENTER : this.evaluated
                        boolean bl = this.evaluated[0] == -1;
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                        // MONITOREXIT : nArray
                        // MONITOREXIT : map
                        if (!bl) return;
                        TreeModelNode.this.firePropertyChange(this.propertyId, null, object);
                        return;
                    }
                }
                Object var6_4 = null;
                Map map = TreeModelNode.this.properties;
                // MONITORENTER : map
                if (object instanceof String) {
                    TreeModelNode.this.properties.put(this.id, string2);
                    TreeModelNode.this.properties.put(this.id + "#html", string);
                } else {
                    TreeModelNode.this.properties.put(this.id, object);
                }
                int[] nArray = this.evaluated;
                // MONITORENTER : this.evaluated
                boolean bl = this.evaluated[0] == -1;
                this.evaluated[0] = 1;
                this.evaluated.notifyAll();
                // MONITOREXIT : nArray
                // MONITOREXIT : map
                if (!bl) return;
                TreeModelNode.this.firePropertyChange(this.propertyId, null, object);
                return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Map map = TreeModelNode.this.properties;
                // MONITORENTER : map
                if (object instanceof String) {
                    TreeModelNode.this.properties.put(this.id, string2);
                    TreeModelNode.this.properties.put(this.id + "#html", string);
                } else {
                    TreeModelNode.this.properties.put(this.id, object);
                }
                int[] nArray = this.evaluated;
                // MONITORENTER : this.evaluated
                boolean bl = this.evaluated[0] == -1;
                this.evaluated[0] = 1;
                this.evaluated.notifyAll();
                // MONITOREXIT : nArray
                // MONITOREXIT : map
                if (!bl) throw throwable;
                TreeModelNode.this.firePropertyChange(this.propertyId, null, object);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public synchronized Object getValue() {
            if (this.nodeColumn) {
                return TreeModelNode.this.getDisplayName();
            }
            Object object = TreeModelNode.this.properties;
            // MONITORENTER : object
            if (TreeModelNode.this.properties.containsKey(this.id)) {
                // MONITOREXIT : object
                return TreeModelNode.this.properties.get(this.id);
            }
            // MONITOREXIT : object
            object = TreeModelNode.asynchronous(TreeModelNode.this.model, AsynchronousModelFilter.CALL.VALUE, TreeModelNode.this.object);
            if (object == AsynchronousModelFilter.CURRENT_THREAD) {
                return this.getTheValue();
            }
            Object object2 = this.evaluated;
            // MONITORENTER : this.evaluated
            this.evaluated[0] = 0;
            // MONITOREXIT : object2
            object.execute(this);
            object2 = null;
            Object object3 = this.evaluated;
            // MONITORENTER : this.evaluated
            if (this.evaluated[0] != 1) {
                try {
                    this.evaluated.wait(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.evaluated[0] != 1) {
                    this.evaluated[0] = -1;
                    object2 = EVALUATING_STR;
                }
            }
            // MONITOREXIT : object3
            if (object2 == null) {
                Map map = TreeModelNode.this.properties;
                object3 = map;
                // MONITORENTER : map
                object2 = TreeModelNode.this.properties.get(this.id);
                // MONITOREXIT : object3
            }
            if (object2 != EVALUATING_STR) return object2;
            if (this.getValueType() == null) return object2;
            if (this.getValueType() == String.class) return object2;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object getTheValue() {
            Object object = "";
            String string = null;
            String string2 = null;
            try {
                block15: {
                    try {
                        object = TreeModelNode.this.model.getValueAt(TreeModelNode.this.object, this.id);
                        if (!(object instanceof String)) break block15;
                        string = TreeModelNode.htmlValue((String)object);
                        string2 = TreeModelNode.removeHTML((String)object);
                    }
                    catch (UnknownTypeException unknownTypeException) {
                        if (!(TreeModelNode.this.object instanceof String)) {
                            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + TreeModelNode.this.model + "\n,Column id:" + this.columnModel.getID(), unknownTypeException);
                        }
                        Object var6_5 = null;
                        Map map2 = TreeModelNode.this.properties;
                        synchronized (map2) {
                            if (object instanceof String) {
                                TreeModelNode.this.properties.put(this.id, string2);
                                TreeModelNode.this.properties.put(this.id + "#html", string);
                            } else {
                                TreeModelNode.this.properties.put(this.id, object);
                            }
                            return object;
                        }
                    }
                }
                Object var6_4 = null;
                Map map = TreeModelNode.this.properties;
                synchronized (map) {
                    if (object instanceof String) {
                        TreeModelNode.this.properties.put(this.id, string2);
                        TreeModelNode.this.properties.put(this.id + "#html", string);
                    } else {
                        TreeModelNode.this.properties.put(this.id, object);
                    }
                    return object;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Map map = TreeModelNode.this.properties;
                synchronized (map) {
                    if (object instanceof String) {
                        TreeModelNode.this.properties.put(this.id, string2);
                        TreeModelNode.this.properties.put(this.id + "#html", string);
                    } else {
                        TreeModelNode.this.properties.put(this.id, object);
                    }
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(String string) {
            if (string.equals("htmlDisplayValue")) {
                if (this.nodeColumn) {
                    return TreeModelNode.this.getHtmlDisplayName();
                }
                Object object = this.evaluated;
                synchronized (this.evaluated) {
                    if (this.evaluated[0] != 1) {
                        // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                        return "<html><font color=\"0000CC\">" + EVALUATING_STR + "</font></html>";
                    }
                    // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                    Map map = TreeModelNode.this.properties;
                    object = map;
                    synchronized (map) {
                        // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                        return TreeModelNode.this.properties.get(this.id + "#html");
                    }
                }
            }
            return super.getValue(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getShortDescription() {
            if (this.nodeColumn) {
                return TreeModelNode.this.getShortDescription();
            }
            Object object = TreeModelNode.this.properties;
            synchronized (object) {
                if (!TreeModelNode.this.properties.containsKey(this.id)) {
                    return null;
                }
                String string = (String)TreeModelNode.this.properties.get(this.id + "#shortDescription");
                if (string != null) {
                    return string;
                }
            }
            object = TreeModelNode.asynchronous(TreeModelNode.this.model, AsynchronousModelFilter.CALL.SHORT_DESCRIPTION, TreeModelNode.this.object);
            if (object == AsynchronousModelFilter.CURRENT_THREAD) {
                return this.updateShortDescription();
            }
            object.execute(new Runnable(){

                public void run() {
                    MyProperty.this.updateShortDescription();
                    TreeModelNode.this.firePropertyChange(MyProperty.this.propertyId, null, null);
                }
            });
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String updateShortDescription() {
            try {
                String string;
                JToolTip jToolTip = new JToolTip();
                String string2 = null;
                try {
                    jToolTip.putClientProperty("getShortDescription", TreeModelNode.this.object);
                    Object object = TreeModelNode.this.model.getValueAt(jToolTip, this.id);
                    if (object != null) {
                        string2 = TreeModelNode.adjustHTML(object.toString());
                    }
                    string = string2;
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    jToolTip.putClientProperty("getShortDescription", null);
                    Map map = TreeModelNode.this.properties;
                    synchronized (map) {
                        TreeModelNode.this.properties.put(this.id + "#shortDescription", string2);
                        throw throwable;
                    }
                }
                jToolTip.putClientProperty("getShortDescription", null);
                Map map = TreeModelNode.this.properties;
                synchronized (map) {
                    TreeModelNode.this.properties.put(this.id + "#shortDescription", string2);
                    return string;
                }
            }
            catch (UnknownTypeException unknownTypeException) {
                return null;
            }
        }

        public void setValue(final Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Executor executor = TreeModelNode.asynchronous(TreeModelNode.this.model, AsynchronousModelFilter.CALL.VALUE, TreeModelNode.this.object);
            if (executor == AsynchronousModelFilter.CURRENT_THREAD) {
                this.setTheValue(object);
            } else {
                executor.execute(new Runnable(){

                    public void run() {
                        MyProperty.this.setTheValue(object);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTheValue(Object object) {
            try {
                Object object2 = object;
                TreeModelNode.this.model.setValueAt(TreeModelNode.this.object, this.id, object2);
                object2 = TreeModelNode.this.model.getValueAt(TreeModelNode.this.object, this.id);
                Map map = TreeModelNode.this.properties;
                synchronized (map) {
                    if (object2 instanceof String) {
                        TreeModelNode.this.properties.put(this.id, TreeModelNode.removeHTML((String)object2));
                        TreeModelNode.this.properties.put(this.id + "#html", TreeModelNode.htmlValue((String)object2));
                    } else {
                        TreeModelNode.this.properties.put(this.id, object2);
                    }
                }
                TreeModelNode.this.firePropertyChange(this.propertyId, null, null);
            }
            catch (UnknownTypeException unknownTypeException) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model, unknownTypeException);
            }
        }

        public PropertyEditor getPropertyEditor() {
            PropertyEditor propertyEditor = this.columnModel.getPropertyEditor();
            if (propertyEditor == null) {
                return super.getPropertyEditor();
            }
            return propertyEditor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TreeModelChildren
    extends Children.Keys<Object>
    implements Runnable {
        private boolean initialezed = false;
        private final Models.CompoundModel model;
        private final ColumnModel[] columns;
        protected final TreeModelRoot treeModelRoot;
        protected Object object;
        protected WeakHashMap<Object, WeakReference<TreeModelNode>> objectToNode = new WeakHashMap();
        private final int[] evaluated = new int[]{0};
        private RefreshingInfo evaluatingRefreshingInfo;
        private Object[] children_evaluated;
        private RefreshingInfo refreshInfo = null;
        private boolean refreshingStarted = true;
        private RequestProcessor.Task task;
        private RequestProcessor lastRp;
        protected static final Object WAIT_KEY = new Object();
        private Integer depth;

        TreeModelChildren(Models.CompoundModel compoundModel, ColumnModel[] columnModelArray, TreeModelRoot treeModelRoot, Object object) {
            this.model = compoundModel;
            this.columns = columnModelArray;
            this.treeModelRoot = treeModelRoot;
            this.object = object;
        }

        protected void addNotify() {
            this.initialezed = true;
            this.refreshChildren(new RefreshingInfo(true));
        }

        protected void removeNotify() {
            this.initialezed = false;
            this.setKeys(Collections.emptySet());
        }

        void refreshChildren(RefreshingInfo refreshingInfo) {
            if (!this.initialezed) {
                return;
            }
            this.refreshLazyChildren(refreshingInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object[] objectArray = this.evaluated;
            synchronized (this.evaluated) {
                this.refreshingStarted = false;
                RefreshingInfo refreshingInfo = this.refreshInfo;
                if (this.evaluatingRefreshingInfo == null) {
                    this.evaluatingRefreshingInfo = this.refreshInfo;
                } else if (this.refreshInfo != null) {
                    this.evaluatingRefreshingInfo = this.evaluatingRefreshingInfo.mergeWith(this.refreshInfo);
                }
                this.refreshInfo = null;
                // ** MonitorExit[var2_1 /* !! */ ] (shouldn't be in output)
                try {
                    objectArray = this.getModelChildren(refreshingInfo);
                }
                catch (UnknownTypeException unknownTypeException) {
                    objectArray = new Object[0];
                    if (!(this.object instanceof String)) {
                        Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                    objectArray = new Object[0];
                }
                int[] nArray = this.evaluated;
                synchronized (this.evaluated) {
                    boolean bl;
                    int n = this.evaluated[0];
                    if (this.refreshingStarted) {
                        bl = false;
                    } else {
                        boolean bl2 = bl = this.evaluated[0] == -1;
                        if (!bl) {
                            this.children_evaluated = objectArray;
                        } else {
                            this.evaluatingRefreshingInfo = null;
                        }
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                    }
                    // ** MonitorExit[var4_9] (shouldn't be in output)
                    if (bl) {
                        this.applyChildren(objectArray, refreshingInfo);
                    }
                    return;
                }
            }
        }

        protected Object[] getModelChildren(RefreshingInfo refreshingInfo) throws UnknownTypeException {
            int n = this.model.getChildrenCount(this.object);
            return this.model.getChildren(this.object, 0, n);
        }

        protected Executor getModelAsynchronous() {
            return TreeModelNode.asynchronous(this.model, AsynchronousModelFilter.CALL.CHILDREN, this.object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshLazyChildren(RefreshingInfo refreshingInfo) {
            Executor executor = this.getModelAsynchronous();
            if (executor == AsynchronousModelFilter.CURRENT_THREAD) {
                Object[] objectArray;
                block19: {
                    try {
                        objectArray = this.getModelChildren(refreshingInfo);
                    }
                    catch (UnknownTypeException unknownTypeException) {
                        objectArray = new Object[]{};
                        if (this.object instanceof String) break block19;
                        Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, unknownTypeException);
                    }
                }
                this.applyChildren(objectArray, refreshingInfo);
                return;
            }
            Object[] objectArray = this.evaluated;
            synchronized (this.evaluated) {
                this.evaluated[0] = 0;
                this.refreshingStarted = true;
                this.refreshInfo = this.refreshInfo == null ? refreshingInfo : this.refreshInfo.mergeWith(refreshingInfo);
                // ** MonitorExit[var3_4 /* !! */ ] (shouldn't be in output)
                executor.execute(this);
                int[] nArray = this.evaluated;
                synchronized (this.evaluated) {
                    if (this.evaluated[0] != 1) {
                        try {
                            this.evaluated.wait(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.evaluated[0] != 1) {
                            this.evaluated[0] = -1;
                            objectArray = null;
                        } else {
                            objectArray = this.children_evaluated;
                        }
                    } else {
                        objectArray = this.children_evaluated;
                    }
                    if (this.children_evaluated == null && this.evaluated[0] == 1) {
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        return;
                    }
                    this.children_evaluated = null;
                    if (objectArray != null) {
                        refreshingInfo = this.evaluatingRefreshingInfo;
                        this.evaluatingRefreshingInfo = null;
                    }
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    if (objectArray == null) {
                        this.applyWaitChildren();
                    } else {
                        this.applyChildren(objectArray, refreshingInfo);
                    }
                    return;
                }
            }
        }

        private void applyChildren(final Object[] objectArray, RefreshingInfo refreshingInfo) {
            int n = objectArray.length;
            WeakHashMap<Object, WeakReference<TreeModelNode>> weakHashMap = new WeakHashMap<Object, WeakReference<TreeModelNode>>();
            for (int i = 0; i < n; ++i) {
                TreeModelNode treeModelNode;
                if (objectArray[i] == null) {
                    throw new NullPointerException("Null child at index " + i + ", parent: " + this.object + ", model: " + this.model);
                }
                WeakReference<TreeModelNode> weakReference = this.objectToNode.get(objectArray[i]);
                if (weakReference == null || (treeModelNode = (TreeModelNode)((Object)weakReference.get())) == null) continue;
                if (refreshingInfo == null || refreshingInfo.isRefreshSubNodes(objectArray[i])) {
                    treeModelNode.setObject(objectArray[i]);
                } else {
                    treeModelNode.setObjectNoRefresh(objectArray[i]);
                }
                weakHashMap.put(objectArray[i], weakReference);
            }
            this.objectToNode = weakHashMap;
            this.setKeys(objectArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        TreeModelChildren.this.expandIfSetToExpanded(objectArray[i]);
                    }
                }
            });
        }

        protected void expandIfSetToExpanded(Object object) {
            try {
                Models.TreeFeatures treeFeatures;
                DefaultTreeExpansionManager.get(this.model).setChildrenToActOn(this.getTreeDepth());
                if (this.model.isExpanded(object) && (treeFeatures = this.treeModelRoot.getTreeFeatures()) != null && treeFeatures.isExpanded(this.object)) {
                    treeFeatures.expandNode(object);
                }
            }
            catch (UnknownTypeException unknownTypeException) {
                // empty catch block
            }
        }

        Integer getTreeDepth() {
            Node node = this.getNode();
            if (node == null) {
                return 0;
            }
            if (this.depth != null) {
                return this.depth;
            }
            int n = 1;
            while ((node = node.getParentNode()) != null) {
                ++n;
            }
            this.depth = new Integer(n);
            return this.depth;
        }

        private void applyWaitChildren() {
            this.setKeys(new Object[]{WAIT_KEY});
        }

        public Node[] createNodes(Object object) {
            if (object == WAIT_KEY) {
                AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                abstractNode.setName(NbBundle.getMessage(TreeModelNode.class, (String)"WaitNode"));
                abstractNode.setIconBaseWithExtension("org/netbeans/modules/viewmodel/wait.gif");
                return new Node[]{abstractNode};
            }
            if (object instanceof Exception) {
                return new Node[]{new ExceptionNode((Exception)object)};
            }
            TreeModelNode treeModelNode = new TreeModelNode(this.model, this.columns, this.treeModelRoot, object);
            this.objectToNode.put(object, new WeakReference<TreeModelNode>(treeModelNode));
            return new Node[]{treeModelNode};
        }

        public static class RefreshingInfo {
            protected boolean refreshSubNodes;

            public RefreshingInfo(boolean bl) {
                this.refreshSubNodes = bl;
            }

            public RefreshingInfo mergeWith(RefreshingInfo refreshingInfo) {
                this.refreshSubNodes = this.refreshSubNodes || refreshingInfo.refreshSubNodes;
                return this;
            }

            public boolean isRefreshSubNodes(Object object) {
                return this.refreshSubNodes;
            }
        }
    }
}

