/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.NetworkAccess;
import org.netbeans.updater.UpdaterFrame;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallSupportImpl {
    private InstallSupport support;
    private boolean progressRunning = false;
    private static Logger err = Logger.getLogger(InstallSupportImpl.class.getName());
    private static final String AUTOUPDATE_SERVICES_MODULE = "org.netbeans.modules.autoupdate.services";
    private Map<UpdateElementImpl, File> element2Clusters = null;
    private final Set<File> downloadedFiles = new HashSet<File>();
    private boolean isGlobal;
    private int wasDownloaded = 0;
    private Future<Boolean> runningTask;
    private STEP currentStep = STEP.NOTSTARTED;
    private Collection<UpdateElementImpl> trusted = new ArrayList<UpdateElementImpl>();
    private Collection<UpdateElementImpl> signed = new ArrayList<UpdateElementImpl>();
    private Map<UpdateElement, Collection<Certificate>> certs = new HashMap<UpdateElement, Collection<Certificate>>();
    private List<? extends OperationContainer.OperationInfo> infos = null;
    private ExecutorService es = null;
    private Set<ModuleUpdateElementImpl> affectedModuleImpls = null;
    private Set<FeatureUpdateElementImpl> affectedFeatureImpls = null;

    public InstallSupportImpl(InstallSupport installSupport) {
        this.support = installSupport;
    }

    public boolean doDownload(final ProgressHandle progressHandle, boolean bl) throws OperationException {
        this.isGlobal = bl;
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Object object;
                int n;
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                Object object2 = this;
                synchronized (object2) {
                    InstallSupportImpl.this.currentStep = STEP.DOWNLOAD;
                }
                InstallSupportImpl.this.infos = InstallSupportImpl.this.support.getContainer().listAll();
                object2 = new ArrayList();
                for (Object object3 : InstallSupportImpl.this.infos) {
                    if (((OperationContainer.OperationInfo)object3).getUpdateUnit().getInstalled() != null && ((OperationContainer.OperationInfo)object3).getUpdateUnit().getInstalled().equals(((OperationContainer.OperationInfo)object3).getUpdateElement())) {
                        for (UpdateElement object4 : ((OperationContainer.OperationInfo)object3).getRequiredElements()) {
                            OperationContainer.OperationInfo operationInfo;
                            n = 1;
                            object = object2.iterator();
                            while (object.hasNext()) {
                                operationInfo = (OperationContainer.OperationInfo)object.next();
                                if (!operationInfo.getUpdateElement().equals(object4)) continue;
                                n = 0;
                                break;
                            }
                            if (n == 0) continue;
                            object = OperationContainer.createForUpdate();
                            operationInfo = ((OperationContainer)object).add(object4);
                            object2.add(operationInfo);
                        }
                        continue;
                    }
                    object2.add(object3);
                }
                InstallSupportImpl.this.infos = (List)object2;
                int n2 = 0;
                for (Iterator iterator : InstallSupportImpl.this.infos) {
                    n2 += ((OperationContainer.OperationInfo)((Object)iterator)).getUpdateElement().getDownloadSize();
                }
                if (progressHandle != null) {
                    progressHandle.start();
                    progressHandle.progress(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Estabilish"));
                    InstallSupportImpl.this.progressRunning = false;
                }
                int n3 = 0;
                try {
                    for (OperationContainer.OperationInfo operationInfo : InstallSupportImpl.this.infos) {
                        if (InstallSupportImpl.this.cancelled()) {
                            Boolean bl = false;
                            return bl;
                        }
                        n = InstallSupportImpl.this.doDownload(operationInfo, progressHandle, n3, n2);
                        if (n == -1) {
                            object = false;
                            return object;
                        }
                        n3 += n;
                    }
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.progress("");
                        progressHandle.finish();
                    }
                }
                assert (n2 == n3) : "Was downloaded " + n3 + ", planned was " + n2;
                InstallSupportImpl.this.wasDownloaded = n3;
                return true;
            }
        };
        boolean bl2 = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl2 = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            err.log(Level.FINE, "InstallSupport.doDownload was cancelled", cancellationException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            if (!(executionException.getCause() instanceof OperationException)) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
            throw (OperationException)executionException.getCause();
        }
        return bl2;
    }

    public boolean doValidate(InstallSupport.Validator validator, final ProgressHandle progressHandle) throws OperationException {
        assert (validator != null);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                2 var1_1 = this;
                synchronized (var1_1) {
                    assert (InstallSupportImpl.this.currentStep != STEP.FINISHED);
                    if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                        return false;
                    }
                    InstallSupportImpl.this.currentStep = STEP.VALIDATION;
                }
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                if (progressHandle != null) {
                    progressHandle.start(InstallSupportImpl.this.wasDownloaded);
                }
                int n = 0;
                try {
                    for (OperationContainer.OperationInfo operationInfo : InstallSupportImpl.this.infos) {
                        boolean bl;
                        Object object;
                        if (InstallSupportImpl.this.cancelled()) {
                            object = false;
                            return object;
                        }
                        object = Trampoline.API.impl(operationInfo.getUpdateElement());
                        boolean bl2 = bl = ((UpdateElementImpl)object).getInstallInfo().getCustomInstaller() != null;
                        if (bl) {
                            assert (false) : "InstallSupportImpl cannot support CustomInstaller!";
                            continue;
                        }
                        n += InstallSupportImpl.this.doValidate(operationInfo, progressHandle, n);
                    }
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.progress("");
                        progressHandle.finish();
                    }
                }
                return true;
            }
        };
        boolean bl = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            err.log(Level.FINE, "InstallSupport.doValidate was cancelled", cancellationException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            if (interruptedException.getCause() instanceof OperationException) {
                throw (OperationException)interruptedException.getCause();
            }
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof OperationException) {
                throw (OperationException)executionException.getCause();
            }
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean doInstall(InstallSupport.Installer installer, final ProgressHandle progressHandle) throws OperationException {
        assert (installer != null);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                boolean bl2;
                block49: {
                    Object object;
                    File file;
                    int n;
                    Object object2;
                    Object object32;
                    3 var1_1 = this;
                    // MONITORENTER : var1_1
                    assert (InstallSupportImpl.this.currentStep != STEP.FINISHED) : (Object)((Object)InstallSupportImpl.access$100(InstallSupportImpl.this)) + " != STEP.FINISHED";
                    if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                        // MONITOREXIT : var1_1
                        return false;
                    }
                    InstallSupportImpl.this.currentStep = STEP.INSTALLATION;
                    // MONITOREXIT : var1_1
                    assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                    InstallSupportImpl.this.addTrustedCertificates();
                    InstallSupportImpl.this.affectedModuleImpls = new HashSet();
                    InstallSupportImpl.this.affectedFeatureImpls = new HashSet();
                    if (progressHandle != null) {
                        progressHandle.start();
                    }
                    block26: for (Object object32 : InstallSupportImpl.this.infos) {
                        object2 = Trampoline.API.impl(((OperationContainer.OperationInfo)object32).getUpdateElement());
                        switch (((UpdateElementImpl)object2).getType()) {
                            case KIT_MODULE: 
                            case MODULE: {
                                InstallSupportImpl.this.affectedModuleImpls.add((ModuleUpdateElementImpl)object2);
                                continue block26;
                            }
                            case STANDALONE_MODULE: 
                            case FEATURE: {
                                InstallSupportImpl.this.affectedFeatureImpls.add((FeatureUpdateElementImpl)object2);
                                InstallSupportImpl.this.affectedModuleImpls.addAll(((FeatureUpdateElementImpl)object2).getContainedModuleElements());
                                continue block26;
                            }
                        }
                        assert (false) : "Unsupported type " + object2;
                    }
                    bl2 = false;
                    object32 = null;
                    object2 = null;
                    File file2 = null;
                    File file3 = null;
                    for (Object object4 : InstallSupportImpl.this.affectedModuleImpls) {
                        Iterator iterator = this;
                        // MONITORENTER : iterator
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            // MONITOREXIT : iterator
                            return false;
                        }
                        // MONITOREXIT : iterator
                        if (Utilities.isElementInstalled(((UpdateElementImpl)object4).getUpdateElement())) continue;
                        iterator = ((UpdateElementImpl)object4).getUpdateUnit().getInstalled();
                        file3 = InstallSupportImpl.this.getTargetCluster((UpdateElement)((Object)iterator), (UpdateElementImpl)object4, InstallSupportImpl.this.isGlobal);
                        Object object5 = ((ModuleUpdateElementImpl)object4).getInstallInfo().getDistribution();
                        err.log(Level.FINE, "Source URL for " + ((ModuleUpdateElementImpl)object4).getCodeName() + " is " + object5);
                        n = ((URL)object5).getFile().toLowerCase(Locale.US).endsWith(".nbm".toLowerCase(Locale.US));
                        file = InstallSupportImpl.getDestination(file3, ((ModuleUpdateElementImpl)object4).getCodeName(), n != 0);
                        assert (file != null) : "Destination file exists for " + object4 + " in " + file3;
                        if (InstallSupportImpl.AUTOUPDATE_SERVICES_MODULE.equals(((ModuleUpdateElementImpl)object4).getCodeName())) {
                            err.log(Level.FINEST, "org.netbeans.modules.autoupdate.services is being installed, check if contains netbeans/modules/ext/updater.jar");
                            object = new JarFile(file);
                            try {
                                for (JarEntry jarEntry : Collections.list(((JarFile)object).entries())) {
                                    if (!"netbeans/modules/ext/updater.jar".equals(jarEntry.toString())) continue;
                                    err.log(Level.FINE, "netbeans/modules/ext/updater.jar is being installed from " + ((ModuleUpdateElementImpl)object4).getCodeName());
                                    object32 = jarEntry;
                                    object2 = object;
                                    file2 = file3;
                                    bl2 = true;
                                    break;
                                }
                            }
                            finally {
                                if (object != null && !object.equals(object2)) {
                                    ((ZipFile)object).close();
                                }
                            }
                        }
                        bl2 |= InstallSupportImpl.this.needsRestart(iterator != null, (UpdateElementImpl)object4, file);
                    }
                    try {
                        Object object4;
                        Utilities.writeAdditionalInformation(InstallSupportImpl.this.getElement2Clusters());
                        if (object2 != null) {
                            Utilities.writeUpdateOfUpdaterJar((JarEntry)object32, (JarFile)object2, file2);
                        }
                        if (bl2) break block49;
                        HashSet<File> hashSet = this;
                        // MONITORENTER : hashSet
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            object4 = false;
                            // MONITOREXIT : hashSet
                            return object4;
                        }
                        // MONITOREXIT : hashSet
                        if (progressHandle != null) {
                            progressHandle.switchToDeterminate(InstallSupportImpl.this.affectedModuleImpls.size());
                        }
                        hashSet = null;
                        object4 = InstallSupportImpl.this.downloadedFiles;
                        // MONITORENTER : object4
                        hashSet = new HashSet<File>(InstallSupportImpl.this.downloadedFiles);
                        // MONITOREXIT : object4
                        if (!hashSet.isEmpty()) {
                            object4 = UpdaterFrame.runFromIDE(hashSet, new RefreshModulesListener(progressHandle), NbBundle.getBranding(), false);
                            try {
                                ((Thread)object4).join();
                                for (Object object5 : InstallSupportImpl.this.affectedModuleImpls) {
                                    file = Utilities.toModule(((ModuleUpdateElementImpl)object5).getCodeName(), ((ModuleUpdateElementImpl)object5).getSpecificationVersion());
                                    for (n = 0; n < 100 && file == null; ++n) {
                                        Thread.sleep(100L);
                                        file = Utilities.toModule(((ModuleUpdateElementImpl)object5).getCodeName(), ((ModuleUpdateElementImpl)object5).getSpecificationVersion());
                                    }
                                    if (n != 100) continue;
                                    err.log(Level.INFO, "Timeout waiting for loading module " + ((ModuleUpdateElementImpl)object5).getCodeName() + '/' + ((ModuleUpdateElementImpl)object5).getSpecificationVersion());
                                    ((Thread)object4).interrupt();
                                    InstallSupportImpl.this.afterInstall();
                                    object = InstallSupportImpl.this.downloadedFiles;
                                    // MONITORENTER : object
                                    InstallSupportImpl.this.downloadedFiles.clear();
                                    // MONITOREXIT : object
                                    throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_TurnOnTimeout", (Object)((UpdateElementImpl)object5).getUpdateElement()));
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                err.log(Level.INFO, interruptedException.getMessage(), interruptedException);
                                ((Thread)object4).interrupt();
                            }
                        }
                        InstallSupportImpl.this.afterInstall();
                        object4 = InstallSupportImpl.this.downloadedFiles;
                        // MONITORENTER : object4
                        InstallSupportImpl.this.downloadedFiles.clear();
                        // MONITOREXIT : object4
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.progress("");
                            progressHandle.finish();
                        }
                    }
                }
                if (bl2) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
        };
        boolean bl = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            err.log(Level.FINE, "InstallSupport.doInstall was cancelled", cancellationException);
            Boolean bl2 = false;
            return bl2;
        }
        catch (InterruptedException interruptedException) {
            err.log(Level.INFO, interruptedException.getLocalizedMessage(), interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof OperationException) {
                throw (OperationException)executionException.getCause();
            }
            err.log(Level.INFO, executionException.getLocalizedMessage(), executionException);
        }
        finally {
            if (!bl) {
                this.getElement2Clusters().clear();
            }
        }
        return bl;
    }

    private void afterInstall() {
        UpdateElement updateElement;
        UpdateUnit updateUnit;
        if (this.affectedModuleImpls != null) {
            for (ModuleUpdateElementImpl updateElementImpl : this.affectedModuleImpls) {
                updateUnit = updateElementImpl.getUpdateUnit();
                updateElement = updateElementImpl.getUpdateElement();
                Trampoline.API.impl(updateUnit).updateInstalled(updateElement);
            }
            this.affectedModuleImpls = null;
        }
        if (this.affectedFeatureImpls != null) {
            for (FeatureUpdateElementImpl featureUpdateElementImpl : this.affectedFeatureImpls) {
                updateUnit = featureUpdateElementImpl.getUpdateUnit();
                updateElement = featureUpdateElementImpl.getUpdateElement();
                Trampoline.API.impl(updateUnit).updateInstalled(updateElement);
            }
            this.affectedFeatureImpls = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            assert (this.currentStep != STEP.FINISHED);
            this.currentStep = STEP.RESTART;
        }
        Utilities.deleteAllDoLater();
        this.getElement2Clusters().clear();
        LifecycleManager.getDefault().exit();
        this.doRestartLater(restarter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRestartLater(OperationSupport.Restarter restarter) {
        if (this.affectedModuleImpls != null) {
            for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.affectedModuleImpls) {
                UpdateUnitFactory.getDefault().scheduleForRestart(moduleUpdateElementImpl.getUpdateElement());
            }
        }
        Utilities.writeInstallLater(new HashMap<UpdateElementImpl, File>(this.getElement2Clusters()));
        this.getElement2Clusters().clear();
        Set<File> set = this.downloadedFiles;
        synchronized (set) {
            this.downloadedFiles.clear();
        }
    }

    public String getCertificate(InstallSupport.Installer installer, UpdateElement updateElement) {
        Collection<Certificate> collection = this.certs.get(updateElement);
        if (collection != null) {
            String string = "";
            for (Certificate certificate : collection) {
                string = string + certificate;
            }
            return string;
        }
        return null;
    }

    public boolean isTrusted(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        boolean bl = false;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                bl = this.trusted.contains(updateElementImpl);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                bl = !set.isEmpty();
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    bl &= this.trusted.contains(moduleUpdateElementImpl);
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return bl;
    }

    public boolean isSigned(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        boolean bl = false;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                bl = this.signed.contains(updateElementImpl);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                bl = !set.isEmpty();
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    bl &= this.signed.contains(moduleUpdateElementImpl);
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return bl;
    }

    private void addTrustedCertificates() {
        HashSet<UpdateElementImpl> hashSet = new HashSet<UpdateElementImpl>(this.signed);
        hashSet.removeAll(this.trusted);
        if (hashSet.isEmpty()) {
            return;
        }
        HashSet<Certificate> hashSet2 = new HashSet<Certificate>();
        for (UpdateElementImpl updateElementImpl : hashSet) {
            hashSet2.addAll(this.certs.get(updateElementImpl.getUpdateElement()));
        }
        if (!hashSet2.isEmpty()) {
            Utilities.addCertificates(hashSet2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() throws OperationException {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            this.currentStep = STEP.CANCEL;
        }
        if (this.runningTask != null && !this.runningTask.isDone() && !this.runningTask.isCancelled()) {
            boolean bl = this.runningTask.cancel(true);
            assert (bl) : this.runningTask + " was cancelled.";
        }
        Set<File> set = this.downloadedFiles;
        synchronized (set) {
            for (File file : this.downloadedFiles) {
                if (file == null || !file.exists()) continue;
                file.delete();
            }
            this.downloadedFiles.clear();
        }
        Utilities.cleanUpdateOfUpdaterJar();
        if (this.affectedFeatureImpls != null) {
            this.affectedFeatureImpls = null;
        }
        if (this.affectedModuleImpls != null) {
            this.affectedModuleImpls = null;
        }
        this.getElement2Clusters().clear();
    }

    private int doDownload(OperationContainer.OperationInfo operationInfo, ProgressHandle progressHandle, int n, int n2) throws OperationException {
        UpdateElement updateElement = operationInfo.getUpdateElement();
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        int n3 = 0;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                n3 += this.doDownload(updateElementImpl, progressHandle, n, n2);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                int n4 = n;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    int n5 = this.doDownload(moduleUpdateElementImpl, progressHandle, n4, n2);
                    if (n5 == -1) {
                        return -1;
                    }
                    n4 += n5;
                    n3 += n5;
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDownload(UpdateElementImpl updateElementImpl, ProgressHandle progressHandle, int n, int n2) throws OperationException {
        if (this.cancelled()) {
            return -1;
        }
        UpdateElement updateElement = updateElementImpl.getUpdateUnit().getInstalled();
        File file = this.getTargetCluster(updateElement, updateElementImpl, this.isGlobal);
        assert (file != null) : "Target cluster for " + updateElementImpl + " must exist.";
        if (file == null) {
            file = InstallManager.getUserDir();
        }
        URL uRL = updateElementImpl.getInstallInfo().getDistribution();
        err.log(Level.FINE, "Source URL for " + updateElementImpl.getCodeName() + " is " + uRL);
        if (uRL == null) {
            String string = NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_NullSource", (Object)updateElementImpl.getCodeName());
            err.log(Level.INFO, string);
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, string);
        }
        boolean bl = uRL.getFile().toLowerCase(Locale.US).endsWith(".nbm".toLowerCase(Locale.US));
        File file2 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), bl);
        if (file2.exists()) {
            err.log(Level.FINE, "Target NBM file " + file2 + " of " + updateElementImpl.getUpdateElement() + " already downloaded.");
            return updateElementImpl.getDownloadSize();
        }
        int n3 = 0;
        try {
            String string = updateElementImpl.getDisplayName();
            File file3 = FileUtil.normalizeFile((File)file2);
            Set<File> set = this.downloadedFiles;
            synchronized (set) {
                this.downloadedFiles.add(file3);
            }
            n3 = this.copy(uRL, file2, progressHandle, updateElementImpl.getDownloadSize(), n, n2, string);
        }
        catch (UnknownHostException unknownHostException) {
            err.log(Level.INFO, unknownHostException.getMessage(), unknownHostException);
            throw new OperationException(OperationException.ERROR_TYPE.PROXY, uRL.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            err.log(Level.INFO, fileNotFoundException.getMessage(), fileNotFoundException);
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            err.log(Level.INFO, iOException.getMessage(), iOException);
            throw new OperationException(OperationException.ERROR_TYPE.PROXY, uRL.toString());
        }
        return n3;
    }

    private int doValidate(OperationContainer.OperationInfo operationInfo, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElement updateElement = operationInfo.getUpdateElement();
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        int n2 = 0;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                n2 = this.doValidate(updateElementImpl, progressHandle, n);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                int n3 = n;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    int n4 = this.doValidate(moduleUpdateElementImpl, progressHandle, n3);
                    n3 += n4;
                    n2 += n4;
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return n2;
    }

    private int doValidate(UpdateElementImpl updateElementImpl, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElement updateElement = updateElementImpl.getUpdateUnit().getInstalled();
        File file = this.getTargetCluster(updateElement, updateElementImpl, this.isGlobal);
        URL uRL = updateElementImpl.getInstallInfo().getDistribution();
        boolean bl = uRL.getFile().toLowerCase(Locale.US).endsWith(".nbm".toLowerCase(Locale.US));
        File file2 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), bl);
        assert (file2.exists()) : file2.getAbsolutePath();
        int n2 = 0;
        n2 = this.verifyNbm(updateElementImpl.getUpdateElement(), file2, progressHandle, n);
        return n2;
    }

    static File getDestination(File file, String string, boolean bl) {
        err.log(Level.FINE, "Target cluster for " + string + " is " + file);
        File file2 = new File(file, Utilities.DOWNLOAD_DIR);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string2 = string.replace('.', '-');
        File file3 = new File(file2, string2 + (bl ? ".nbm" : ""));
        err.log(Level.FINE, "Destination file for " + string + " is " + file3);
        return file3;
    }

    private static File getDestination(File file, String string) {
        return InstallSupportImpl.getDestination(file, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelled() {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            return STEP.CANCEL == this.currentStep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copy(URL uRL, File file, ProgressHandle progressHandle, int n, int n2, int n3, String string) throws MalformedURLException, IOException {
        Object object;
        OpenConnectionListener openConnectionListener = new OpenConnectionListener(uRL);
        final NetworkAccess.Task task = NetworkAccess.createNetworkAcessTask(uRL, AutoupdateSettings.getOpenConnectionTimeout(), openConnectionListener);
        new Thread(new Runnable(){

            public void run() {
                while (!task.isFinished()) {
                    if (InstallSupportImpl.this.cancelled()) {
                        task.cancel();
                        break;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }).start();
        task.waitFinished();
        try {
            if (openConnectionListener.getException() != null) {
                throw openConnectionListener.getException();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            err.log(Level.INFO, fileNotFoundException.getMessage(), fileNotFoundException);
            throw new IOException(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Unavailable", (Object)uRL));
        }
        catch (IOException iOException) {
            err.log(Level.INFO, iOException.getMessage(), iOException);
            throw new IOException(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Unavailable", (Object)uRL));
        }
        catch (Exception exception) {
            err.log(Level.INFO, exception.getMessage(), exception);
            throw new IOException(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Unavailable", (Object)uRL));
        }
        if (this.cancelled()) {
            err.log(Level.FINE, "Download of " + uRL + " was cancelled");
            throw new IOException("Download of " + uRL + " was cancelled");
        }
        InputStream inputStream = openConnectionListener.getInputStream();
        int n4 = openConnectionListener.getContentLength();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = null;
        err.log(Level.FINEST, "Copy " + uRL + " to " + file + "[" + n + "]");
        boolean bl = false;
        int n5 = 0;
        try {
            int n6;
            object = new byte[1024];
            int n7 = 0;
            while (!(bl = this.cancelled()) && (n6 = bufferedInputStream.read((byte[])object)) != -1) {
                if (bufferedOutputStream == null) {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                }
                bufferedOutputStream.write((byte[])object, 0, n6);
                n5 += n6;
                n7 += n6;
                if (!this.progressRunning && progressHandle != null) {
                    progressHandle.switchToDeterminate(n3);
                    this.progressRunning = true;
                }
                if (n7 <= 1024) continue;
                if (progressHandle != null) {
                    assert (this.progressRunning);
                    progressHandle.switchToDeterminate(n3);
                    int n8 = n2 + (n5 < n ? n5 : n);
                    progressHandle.progress(string, n8 < n3 ? n8 : n3);
                }
                n7 = 0;
            }
            if (n != n5) {
                err.log(Level.FINEST, "Increment (" + n5 + ") of is not equal to estimatedSize (" + n + ").");
            }
        }
        catch (IOException iOException) {
            err.log(Level.INFO, "Writing content of URL " + uRL + " failed.", iOException);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.flush();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {
                err.log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        if (n4 != -1 && n5 != n4) {
            if (bl) {
                err.log(Level.FINE, "Download of " + uRL + " was cancelled");
            } else {
                err.log(Level.INFO, "Content length was reported as " + n4 + " byte(s) but read " + n5 + " byte(s)");
            }
            if (bufferedOutputStream != null && file.exists()) {
                err.log(Level.INFO, "Deleting not fully downloaded file " + file);
                file.delete();
                object = FileUtil.normalizeFile((File)file);
                Set<File> set = this.downloadedFiles;
                synchronized (set) {
                    this.downloadedFiles.remove(object);
                }
            }
            if (bl) {
                throw new IOException("Download of " + uRL + " was cancelled");
            }
            throw new IOException("Server closed connection unexpectedly");
        }
        err.log(Level.FINE, "Destination " + file + " is successfully wrote. Size " + file.length());
        return n;
    }

    private int verifyNbm(UpdateElement updateElement, File file, ProgressHandle progressHandle, int n) throws OperationException {
        String string = null;
        try {
            n += updateElement.getDownloadSize();
            if (progressHandle != null) {
                progressHandle.progress(updateElement.getDisplayName(), n < this.wasDownloaded ? n : this.wasDownloaded);
            }
            Collection<Certificate> collection = InstallSupportImpl.getNbmCertificates(file);
            assert (collection != null);
            if (collection.size() > 0) {
                this.certs.put(updateElement, collection);
            }
            if (collection.isEmpty()) {
                string = "UNSIGNED";
            } else {
                ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                for (KeyStore keyStore : Utilities.getKeyStore()) {
                    arrayList.addAll(InstallSupportImpl.getCertificates(keyStore));
                }
                KeyStore keyStore = Utilities.loadKeyStore();
                if (keyStore != null) {
                    arrayList.addAll(InstallSupportImpl.getCertificates(keyStore));
                }
                if (arrayList.containsAll(collection)) {
                    string = "TRUSTED";
                    this.trusted.add(updateElementImpl);
                    this.signed.add(updateElementImpl);
                } else {
                    string = "UNTRUSTED";
                    this.signed.add(updateElementImpl);
                }
            }
        }
        catch (IOException iOException) {
            err.log(Level.INFO, iOException.getMessage(), iOException);
            string = "BAD_DOWNLOAD";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_CorruptedNBM", (Object)file));
        }
        catch (KeyStoreException keyStoreException) {
            err.log(Level.INFO, keyStoreException.getMessage(), keyStoreException);
            string = "CORRUPTED";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_CorruptedNBM", (Object)file));
        }
        err.log(Level.FINE, "NBM " + file + " was verified as " + string);
        return updateElement.getDownloadSize();
    }

    private static Collection<Certificate> getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (String string : Collections.list(keyStore.aliases())) {
            arrayList.add(keyStore.getCertificate(string));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Certificate> getNbmCertificates(File file) throws IOException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        JarFile jarFile = new JarFile(file);
        try {
            for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                InstallSupportImpl.verifyEntry(jarFile, jarEntry);
                if (jarEntry.getCertificates() == null) continue;
                hashSet.addAll(Arrays.asList(jarEntry.getCertificates()));
            }
        }
        finally {
            jarFile.close();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = jarFile.getInputStream(jarEntry);
            byte[] byArray = new byte[8192];
            boolean bl = false;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private boolean needsRestart(boolean bl, UpdateElementImpl updateElementImpl, File file) {
        return InstallManager.needsRestart(bl, updateElementImpl, file);
    }

    private File getTargetCluster(UpdateElement updateElement, UpdateElementImpl updateElementImpl, boolean bl) {
        File file = this.getElement2Clusters().get(updateElementImpl);
        if (file == null && (file = InstallManager.findTargetDirectory(updateElement, updateElementImpl, bl)) != null) {
            this.getElement2Clusters().put(updateElementImpl, file);
        }
        return file;
    }

    private Map<UpdateElementImpl, File> getElement2Clusters() {
        if (this.element2Clusters == null) {
            this.element2Clusters = new HashMap<UpdateElementImpl, File>();
        }
        return this.element2Clusters;
    }

    private ExecutorService getExecutionService() {
        if (this.es == null || this.es.isShutdown()) {
            this.es = Executors.newSingleThreadExecutor();
        }
        return this.es;
    }

    private class OpenConnectionListener
    implements NetworkAccess.NetworkListener {
        private InputStream stream = null;
        int contentLength = -1;
        private URL source = null;
        private Exception ex = null;

        public OpenConnectionListener(URL uRL) {
            this.source = uRL;
        }

        public InputStream getInputStream() {
            return this.stream;
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public void streamOpened(InputStream inputStream, int n) {
            err.log(Level.FINEST, "Opened connection for " + this.source);
            this.stream = inputStream;
            this.contentLength = n;
        }

        public void accessCanceled() {
            err.log(Level.INFO, "Opening connection for " + this.source + "was cancelled");
        }

        public void accessTimeOut() {
            err.log(Level.INFO, "Opening connection for " + this.source + "was finised due to timeout");
        }

        public void notifyException(Exception exception) {
            this.ex = exception;
        }

        public Exception getException() {
            return this.ex;
        }
    }

    private static final class RefreshModulesListener
    implements PropertyChangeListener {
        private ProgressHandle handle;
        private int i;

        public RefreshModulesListener(ProgressHandle progressHandle) {
            this.handle = progressHandle;
            this.i = 0;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("RUNNING".equals(propertyChangeEvent.getPropertyName())) {
                if (this.handle != null) {
                    this.handle.progress(this.i++);
                }
            } else if ("FINISHED".equals(propertyChangeEvent.getPropertyName())) {
                final FileObject fileObject = FileUtil.getConfigFile((String)"Modules");
                err.log(Level.FINE, "It's a hack: Call refresh on " + fileObject + " file object.");
                if (fileObject != null) {
                    try {
                        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                            public void run() throws IOException {
                                fileObject.getParent().refresh();
                                fileObject.refresh();
                            }
                        });
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            } else assert (false) : "Unknown property " + propertyChangeEvent.getPropertyName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STEP {
        NOTSTARTED,
        DOWNLOAD,
        VALIDATION,
        INSTALLATION,
        RESTART,
        FINISHED,
        CANCEL;

    }
}

