/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.DateTools;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.gsf.GsfTaskProvider;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.gsfret.source.GlobalSourcePath;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.parsing.FileObjects;
import org.netbeans.modules.gsfret.source.usages.CachingIndexer;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.SourceAnalyser;
import org.netbeans.modules.gsfret.source.util.LowMemoryEvent;
import org.netbeans.modules.gsfret.source.util.LowMemoryListener;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifier;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.ParserTaskImpl;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryUpdater
implements PropertyChangeListener,
FileChangeListener {
    private static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    static boolean haveIndexed = false;
    private static final Logger LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
    private static final Logger BUG_LOGGER = Logger.getLogger("ruby.indexerbug");
    private static final Set<String> ignoredDirectories = RepositoryUpdater.parseSet("org.netbeans.javacore.ignoreDirectories", "SCCS CVS .svn .hg");
    private static final boolean noscan = Boolean.getBoolean("netbeans.javacore.noscan");
    private static final boolean PERF_TEST = Boolean.getBoolean("perf.refactoring.test");
    private static final long STARTED = System.currentTimeMillis();
    private static final int DELAY = Utilities.isWindows() ? 2000 : 1000;
    private static RepositoryUpdater instance;
    private final GlobalSourcePath cpImpl;
    private final ClassPath cp;
    private final ClassPath ucp;
    private final ClassPath binCp;
    private Set<URL> scannedRoots;
    private Set<URL> scannedBinaries;
    private Map<URL, List<URL>> deps;
    private Delay delay;
    private Work currentWork;
    private boolean dirty;
    private int noSubmited;
    private final AtomicBoolean closed;
    private static List<IndexerEntry> indexers;

    private static String getElapsedTime() {
        StringBuilder stringBuilder = new StringBuilder();
        long l = System.currentTimeMillis();
        long l2 = l - STARTED;
        long l3 = l2 / 1000L;
        long l4 = l3 / 60L;
        if (l3 > 400L) {
            stringBuilder.append(l4 + " minutes, " + (l3 -= l4 * 60L) + " seconds");
        } else {
            stringBuilder.append(l3 + " seconds");
        }
        stringBuilder.append(": ");
        return stringBuilder.toString();
    }

    private RepositoryUpdater() {
        try {
            this.closed = new AtomicBoolean(false);
            this.scannedRoots = Collections.synchronizedSet(new HashSet());
            this.scannedBinaries = Collections.synchronizedSet(new HashSet());
            this.deps = Collections.synchronizedMap(new HashMap());
            this.delay = new Delay();
            this.cpImpl = GlobalSourcePath.getDefault();
            this.cpImpl.setExcludesListener(this);
            this.cp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getSourcePath());
            this.cp.addPropertyChangeListener((PropertyChangeListener)this);
            this.ucp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getUnknownSourcePath());
            this.binCp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getBinaryPath());
            this.registerFileSystemListener();
            this.submitBatch();
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new IllegalStateException();
        }
    }

    public ClassPath getScannedSources() {
        return this.cp;
    }

    public ClassPath getScannedBinaries() {
        return this.binCp;
    }

    public Map<URL, List<URL>> getDependencies() {
        return new HashMap<URL, List<URL>>(this.deps);
    }

    public void close() {
        this.closed.set(true);
        this.cp.removePropertyChangeListener((PropertyChangeListener)this);
        this.unregisterFileSystemListener();
        this.delay.cancel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("roots".equals(propertyChangeEvent.getPropertyName())) {
            this.submitBatch();
        } else if ("includes".equals(propertyChangeEvent.getPropertyName())) {
            ClassPath classPath = (ClassPath)propertyChangeEvent.getNewValue();
            assert (classPath != null);
            for (ClassPath.Entry entry : classPath.entries()) {
                URL uRL = entry.getURL();
                this.scheduleCompilation(uRL, uRL, true);
            }
        }
    }

    private synchronized void submitBatch() {
        if (this.currentWork == null) {
            this.currentWork = Work.batch();
            this.submit(this.currentWork);
        } else {
            this.dirty = true;
        }
    }

    public synchronized boolean isScanInProgress() {
        return this.noSubmited > 0;
    }

    public synchronized void waitScanFinished() throws InterruptedException {
        while (this.noSubmited > 0) {
            this.wait();
        }
    }

    private synchronized boolean isDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        this.currentWork = null;
        return false;
    }

    private synchronized void resetDirty() {
        this.dirty = false;
        this.currentWork = null;
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        try {
            URL uRL;
            if ((RepositoryUpdater.isRelevantSource(fileObject) || fileObject.isFolder()) && VisibilityQuery.getDefault().isVisible(fileObject)) {
                URL uRL2 = this.getOwningSourceRoot(fileObject);
                if (uRL2 != null) {
                    File file;
                    String string = fileRenameEvent.getName();
                    String string2 = fileRenameEvent.getExt();
                    if (string2.length() > 0) {
                        string = string + '.' + string2;
                    }
                    if ((file = FileUtil.toFile((FileObject)fileObject.getParent())) != null) {
                        URL uRL3 = new File(file, string).toURI().toURL();
                        this.submit(Work.delete(uRL3, uRL2, fileObject.isFolder()));
                        this.delay.post(Work.compile(fileObject, uRL2));
                    }
                }
            } else if (RepositoryUpdater.isBinary(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject) && (uRL = this.getOwningBinaryRoot(fileObject)) != null) {
                File file;
                String string = fileRenameEvent.getName();
                String string3 = fileRenameEvent.getExt();
                if (string3.length() > 0) {
                    string = string + '.' + string3;
                }
                if ((file = FileUtil.toFile((FileObject)fileObject.getParent())) != null) {
                    URL uRL4 = new File(file, string).toURI().toURL();
                    this.submit(Work.binary(uRL4, uRL, fileObject.isFolder()));
                    this.submit(Work.binary(fileObject, uRL));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        try {
            URL uRL = this.getOwningSourceRoot(fileObject);
            if (uRL != null && VisibilityQuery.getDefault().isVisible(fileObject)) {
                this.scheduleCompilation(fileObject, uRL);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        boolean bl = fileObject.isFolder();
        try {
            URL uRL;
            boolean bl2 = RepositoryUpdater.isRelevantSource(fileObject);
            if (!bl2 && "content/unknown".equals(fileObject.getMIMEType())) {
                bl2 = true;
            }
            if ((bl2 || bl) && VisibilityQuery.getDefault().isVisible(fileObject)) {
                URL uRL2 = this.getOwningSourceRoot(fileObject);
                if (uRL2 != null) {
                    this.submit(Work.delete(fileObject, uRL2, bl));
                }
            } else if ((RepositoryUpdater.isBinary(fileObject) || bl) && VisibilityQuery.getDefault().isVisible(fileObject) && (uRL = this.getOwningBinaryRoot(fileObject)) != null) {
                this.submit(Work.binary(fileObject, uRL));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        try {
            URL uRL;
            if (RepositoryUpdater.isRelevantSource(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject)) {
                URL uRL2 = this.getOwningSourceRoot(fileObject);
                if (uRL2 != null) {
                    this.postCompilation(fileObject, uRL2);
                }
            } else if (RepositoryUpdater.isBinary(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject) && (uRL = this.getOwningBinaryRoot(fileObject)) != null) {
                this.submit(Work.binary(fileObject, uRL));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        try {
            URL uRL;
            if (RepositoryUpdater.isRelevantSource(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject)) {
                URL uRL2 = this.getOwningSourceRoot(fileObject);
                if (uRL2 != null) {
                    this.postCompilation(fileObject, uRL2);
                }
            } else if (RepositoryUpdater.isBinary(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject) && (uRL = this.getOwningBinaryRoot(fileObject)) != null) {
                this.submit(Work.binary(fileObject, uRL));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public final void scheduleCompilation(FileObject fileObject, FileObject fileObject2) throws IOException {
        URL uRL = fileObject.getURL();
        URL uRL2 = fileObject2.getURL();
        assert ("file".equals(uRL.getProtocol()) && "file".equals(uRL2.getProtocol()));
        this.scheduleCompilation(uRL, uRL2, fileObject.isFolder());
    }

    private final void scheduleCompilation(FileObject fileObject, URL uRL) throws IOException {
        this.scheduleCompilation(fileObject.getURL(), uRL, fileObject.isFolder());
    }

    private final void scheduleCompilation(URL uRL, URL uRL2, boolean bl) {
        this.submit(Work.compile(uRL, uRL2, bl));
    }

    private final void postCompilation(FileObject fileObject, URL uRL) throws FileStateInvalidException {
        this.delay.post(Work.compile(fileObject, uRL));
    }

    public final CountDownLatch scheduleCompilationAndWait(FileObject fileObject, FileObject fileObject2) throws IOException {
        CountDownLatch[] countDownLatchArray = new CountDownLatch[1];
        this.submit(Work.compile(fileObject, fileObject2.getURL(), countDownLatchArray));
        return countDownLatchArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(Work work) {
        if (!noscan) {
            Object object = this;
            synchronized (object) {
                ++this.noSubmited;
            }
            object = new CompileWorker(work);
            SourceAccessor.getINSTANCE().runSpecialTask((CancellableTask<CompilationInfo>)object, Source.Priority.MAX);
        }
    }

    private void registerFileSystemListener() {
        FileUtil.addFileChangeListener((FileChangeListener)this);
    }

    private void unregisterFileSystemListener() {
        FileUtil.removeFileChangeListener((FileChangeListener)this);
    }

    private URL getOwningSourceRoot(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(this.scannedRoots);
        for (URL uRL : arrayList) {
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
            if (fileObject2 == null || !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return uRL;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getOwningBinaryRoot(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        try {
            Set<URL> set = this.scannedBinaries;
            synchronized (set) {
                URL uRL = fileObject.getURL();
                for (URL uRL2 : this.scannedBinaries) {
                    String string;
                    String string2;
                    URL uRL3 = FileUtil.getArchiveFile((URL)uRL2);
                    boolean bl = true;
                    if (uRL3 == null) {
                        uRL3 = uRL2;
                        bl = false;
                    }
                    if ((string2 = uRL3.getPath()).equals(string = uRL.getPath())) {
                        return uRL2;
                    }
                    if (bl || !string.startsWith(string2)) continue;
                    return uRL2;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public static boolean isRelevantSource(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return false;
        }
        return LanguageRegistry.getInstance().isSupported(fileObject.getMIMEType());
    }

    private static boolean isBinary(FileObject fileObject) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchCompile(List<ParserFile> list, FileObject fileObject, ClasspathInfo classpathInfo, CachingIndexer cachingIndexer, URL uRL, Set<URI> set, Set set2, Map<Language, Map<String, String>> map, Map<Language, List<File>> map2) throws IOException {
        assert (list != null);
        assert (fileObject != null);
        assert (classpathInfo != null);
        ParserFile parserFile = null;
        CompilerListener compilerListener = new CompilerListener();
        ArrayList<IndexerEntry> arrayList = new ArrayList<IndexerEntry>(indexers.size());
        String string = uRL.toExternalForm();
        for (IndexerEntry indexerEntry : RepositoryUpdater.getIndexers()) {
            if (!indexerEntry.indexer.acceptQueryPath(string)) continue;
            arrayList.add(indexerEntry);
        }
        LowMemoryNotifier.getDefault().addLowMemoryListener(compilerListener);
        try {
            try {
                LinkedList linkedList = new LinkedList();
                boolean bl = false;
                boolean bl2 = false;
                while (!list.isEmpty() || !linkedList.isEmpty() || parserFile != null) {
                    Object object;
                    Object object2;
                    ClassPath classPath;
                    Object object3;
                    try {
                        if (compilerListener.lowMemory.getAndSet(false)) {
                            if (bl) break;
                            bl = true;
                            System.gc();
                            continue;
                        }
                        if (parserFile == null) {
                            if (!list.isEmpty()) {
                                parserFile = list.remove(0);
                                bl2 = false;
                            } else {
                                parserFile = (ParserFile)linkedList.remove(0);
                                bl2 = true;
                            }
                        }
                        if (parserFile.getNameExt().startsWith(".#")) {
                            bl = false;
                            parserFile = null;
                            continue;
                        }
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Object object4;
                            Object object5;
                            Object object6;
                            object3 = (IndexerEntry)arrayList.get(i);
                            classPath = ((IndexerEntry)object3).getIndexer();
                            if (!classPath.isIndexable(parserFile)) continue;
                            object2 = ((IndexerEntry)object3).getLanguage();
                            if (map != null && (object = map.get(object2)) != null && (object6 = (String)object.get(object5 = classPath.getPersistentUrl((File)(object4 = parserFile.getFile())))) != null) {
                                List<File> list2 = map2.get(object2);
                                if (list2 == null) {
                                    list2 = new ArrayList<File>(list.size());
                                    map2.put((Language)object2, list2);
                                }
                                list2.add((File)object4);
                                try {
                                    long l = DateTools.stringToTime((String)object6);
                                    if (((File)object4).lastModified() <= l) {
                                        continue;
                                    }
                                }
                                catch (ParseException parseException) {
                                    Exceptions.printStackTrace((Throwable)parseException);
                                }
                            }
                            object = new ParserTaskImpl((Language)object2);
                            ((ParserTaskImpl)object).setParseListener(compilerListener);
                            object4 = ((ParserTaskImpl)object).parse(parserFile);
                            if (object4 == null) continue;
                            if (cachingIndexer != null) {
                                cachingIndexer.index((Language)object2, parserFile.getFile(), (Iterable<ParserResult>)object4);
                                continue;
                            }
                            object5 = ClassIndexManager.get((Language)object2).createUsagesQuery(uRL, true);
                            assert (object5 != null);
                            object6 = ((ClassIndexImpl)object5).getSourceAnalyser();
                            if (object6 == null) continue;
                            ((SourceAnalyser)object6).analyse((Language)object2, (Iterable<ParserResult>)object4);
                        }
                        if (compilerListener.lowMemory.getAndSet(false)) {
                            compilerListener.cleanDiagnostics();
                            if (bl) {
                                if (bl2) break;
                                linkedList.add(parserFile);
                                parserFile = null;
                                bl = false;
                            } else {
                                bl = true;
                            }
                            System.gc();
                            continue;
                        }
                        if (!compilerListener.errors.isEmpty()) {
                            compilerListener.cleanDiagnostics();
                        }
                        parserFile = null;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        if (BUG_LOGGER.isLoggable(Level.FINE)) {
                            BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker *** caught exception 4 ", throwable);
                        }
                        if (PREINDEXING) {
                            Exceptions.attachMessage((Throwable)throwable, (String)("Parsing " + parserFile.getFile().getPath()));
                            Exceptions.printStackTrace((Throwable)throwable);
                            Toolkit.getDefaultToolkit().beep();
                        }
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        object3 = parserFile != null ? parserFile.getNameExt() : "unknown";
                        parserFile = null;
                        compilerListener.cleanDiagnostics();
                        classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                        object2 = classpathInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
                        object = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                        Throwable throwable2 = Exceptions.attachMessage((Throwable)throwable, (String)String.format("Root: %s File: %s Bootpath: %s Classpath: %s Sourcepath: %s", FileUtil.getFileDisplayName((FileObject)fileObject), ((String)object3).toString(), classPath == null ? null : classPath.toString(), object2 == null ? null : object2.toString(), object == null ? null : object.toString()));
                        Exceptions.printStackTrace((Throwable)throwable2);
                    }
                }
                if (bl) {
                    LOGGER.warning("Not enough memory to compile folder: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                }
                Object var28_30 = null;
            }
            catch (Throwable throwable) {
                Object var28_31 = null;
                throw throwable;
            }
            Object var30_33 = null;
            LowMemoryNotifier.getDefault().removeLowMemoryListener(compilerListener);
        }
        catch (Throwable throwable) {
            Object var30_34 = null;
            LowMemoryNotifier.getDefault().removeLowMemoryListener(compilerListener);
            throw throwable;
        }
    }

    private static Set<String> parseSet(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty(string, string2), " \t\n\r\f,-:+!");
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private static ClassPath.Entry getClassPathEntry(ClassPath classPath, URL uRL) {
        assert (classPath != null);
        assert (uRL != null);
        for (ClassPath.Entry entry : classPath.entries()) {
            if (!uRL.equals(entry.getURL())) continue;
            return entry;
        }
        return null;
    }

    public static synchronized RepositoryUpdater getDefault() {
        if (instance == null) {
            instance = new RepositoryUpdater();
        }
        return instance;
    }

    private static List<IndexerEntry> getIndexers() {
        if (indexers == null) {
            indexers = new ArrayList<IndexerEntry>();
            for (Language language : LanguageRegistry.getInstance()) {
                Indexer indexer = language.getIndexer();
                if (indexer == null) continue;
                IndexerEntry indexerEntry = new IndexerEntry(language, indexer);
                indexers.add(indexerEntry);
            }
        }
        return indexers;
    }

    static /* synthetic */ ClassPath access$1200(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.cp;
    }

    static /* synthetic */ ClassPath access$1300(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.ucp;
    }

    static /* synthetic */ ClassPath access$1400(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.binCp;
    }

    static /* synthetic */ Map access$1700(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.deps;
    }

    static /* synthetic */ void access$1800(RepositoryUpdater repositoryUpdater) {
        repositoryUpdater.resetDirty();
    }

    static /* synthetic */ boolean access$2000(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.isDirty();
    }

    static /* synthetic */ int access$2410(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.noSubmited--;
    }

    static /* synthetic */ int access$2400(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.noSubmited;
    }

    static /* synthetic */ GlobalSourcePath access$2500(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.cpImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompileWorker
    implements CancellableTask<CompilationInfo> {
        private Work work;
        private List<URL> state;
        private Set<URL> oldRoots;
        private Set<URL> oldBinaries;
        private Set<URL> newBinaries;
        private ProgressHandle handle;
        private final Set<URI> dirtyCrossFiles;
        private final Set<URL> ignoreExcludes;
        private final AtomicBoolean canceled;
        private Map<FileObject, WeakReference<ClassPath>> sourceClassPathsCache = new WeakHashMap<FileObject, WeakReference<ClassPath>>();

        public CompileWorker(Work work) {
            assert (work != null);
            this.work = work;
            this.canceled = new AtomicBoolean(false);
            this.dirtyCrossFiles = new HashSet<URI>();
            this.ignoreExcludes = new HashSet<URL>();
        }

        public void cancel() {
            this.canceled.set(true);
        }

        public void run(CompilationInfo compilationInfo) throws IOException {
            ClassIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Void run() throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 54[WHILELOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClassPath getBootClassPaths(FileObject fileObject, String string) {
            CompileWorker compileWorker = this;
            synchronized (compileWorker) {
                Reference reference;
                ClassPath classPath = null;
                if (!fileObject.isFolder()) assert (false) : fileObject;
                if (fileObject.isFolder() && ((reference = (Reference)this.sourceClassPathsCache.get(fileObject)) == null || (classPath = (ClassPath)reference.get()) == null)) {
                    classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject});
                    this.sourceClassPathsCache.put(fileObject, new WeakReference<ClassPath>(classPath));
                }
                return classPath;
            }
        }

        private void findDependencies(URL uRL, Stack<URL> stack, Map<URL, List<URL>> map, Set<URL> set, boolean bl) {
            if (bl && RepositoryUpdater.this.scannedRoots.contains(uRL)) {
                this.oldRoots.remove(uRL);
                return;
            }
            if (map.containsKey(uRL)) {
                return;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) {
                return;
            }
            map.put(uRL, new LinkedList());
            if (!RepositoryUpdater.this.scannedBinaries.contains(uRL)) {
                set.add(uRL);
            }
            this.oldBinaries.remove(uRL);
        }

        private boolean scanRoots() {
            Class<?> clazz;
            URL uRL;
            Iterator<URL> iterator = this.newBinaries.iterator();
            while (iterator.hasNext()) {
                if (this.canceled.getAndSet(false)) {
                    return false;
                }
                if (RepositoryUpdater.this.closed.get()) {
                    return true;
                }
                uRL = iterator.next();
                try {
                    iterator.remove();
                    String string = uRL.toExternalForm();
                    for (IndexerEntry indexerEntry : RepositoryUpdater.getIndexers()) {
                        Language language = indexerEntry.getLanguage();
                        if (!indexerEntry.indexer.acceptQueryPath(string)) continue;
                        clazz = ClassIndexManager.get(language).createUsagesQuery(uRL, false);
                    }
                    RepositoryUpdater.this.scannedBinaries.add(uRL);
                }
                catch (Throwable throwable) {
                    if (BUG_LOGGER.isLoggable(Level.FINE)) {
                        BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker *** caught exception ", throwable);
                    }
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Exceptions.attachMessage((Throwable)throwable, (String)("While scanning: " + uRL));
                    Exceptions.printStackTrace((Throwable)throwable);
                }
            }
            iterator = this.state.listIterator(this.state.size());
            while (iterator.hasPrevious()) {
                if (this.canceled.getAndSet(false)) {
                    return false;
                }
                if (RepositoryUpdater.this.closed.get()) {
                    return true;
                }
                try {
                    uRL = (URL)iterator.previous();
                    iterator.remove();
                    if (this.oldRoots.remove(uRL) || RepositoryUpdater.this.scannedRoots.contains(uRL)) continue;
                    long l = System.currentTimeMillis();
                    this.updateFolder(uRL, uRL, false, this.handle);
                    long l2 = System.currentTimeMillis();
                    if (PERF_TEST) {
                        try {
                            clazz = Class.forName("org.netbeans.performance.test.utilities.LoggingScanClasspath", true, Thread.currentThread().getContextClassLoader());
                            Object object = clazz.getMethod("reportScanOfFile", String.class, Long.class);
                            ((Method)object).invoke(clazz.newInstance(), uRL.toExternalForm(), new Long(l2 - l));
                        }
                        catch (Exception exception) {
                            Exceptions.printStackTrace((Throwable)exception);
                        }
                    }
                    if (!PREINDEXING) continue;
                    for (Object object : LanguageRegistry.getInstance()) {
                        if (((Language)object).getIndexer() == null) continue;
                        Index.preindex((Language)object, uRL);
                    }
                    haveIndexed = true;
                }
                catch (Throwable throwable) {
                    if (BUG_LOGGER.isLoggable(Level.FINE)) {
                        BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker *** caught exception 3 ", throwable);
                    }
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Exceptions.printStackTrace((Throwable)throwable);
                }
            }
            return true;
        }

        private boolean isBoot(ClassPath classPath, FileObject fileObject) {
            for (FileObject fileObject2 : classPath.getRoots()) {
                if (fileObject2 != fileObject) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void updateFolder(URL uRL, URL uRL2, boolean bl, ProgressHandle progressHandle) throws IOException {
            boolean bl2;
            block35: {
                block34: {
                    Object object;
                    boolean bl3;
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL2);
                    if (fileObject == null) {
                        return;
                    }
                    if (!fileObject.isFolder()) {
                        LOGGER.warning("Source root has to be a folder: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                        return;
                    }
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
                    ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                    bl2 = uRL.equals(uRL2);
                    if (classPath == null || classPath2 == null || classPath3 == null) {
                        ClassPath classPath4 = this.getBootClassPaths(fileObject, "classpath/source");
                        if (classPath == null) {
                            classPath = classPath4;
                        }
                        if (classPath2 == null) {
                            classPath2 = classPath4;
                        }
                        if (classPath3 == null) {
                            classPath3 = classPath4;
                        }
                    }
                    boolean bl4 = bl3 = bl2 && this.isBoot(classPath2, fileObject);
                    if (!bl3 && ((String)(object = uRL2.toExternalForm())).indexOf("/vendor/") != -1) {
                        bl3 = true;
                    }
                    try {
                        Object object2;
                        Object object3;
                        Object object42;
                        Object object5;
                        ClassIndexImpl classIndexImpl;
                        Language language;
                        Object object62;
                        Object object7;
                        object = FileUtil.toFile((FileObject)fileObject);
                        if (object == null && (object = FileUtil.toFile((FileObject)(object7 = FileUtil.getArchiveFile((FileObject)fileObject)))) == null) {
                            Object var35_14 = null;
                            if (bl) return;
                            if (!bl2) return;
                            RepositoryUpdater.this.scannedRoots.add(uRL2);
                            return;
                        }
                        object7 = bl2 ? object : FileUtil.normalizeFile((File)new File(URI.create(uRL.toExternalForm())));
                        Object var13_18 = null;
                        LinkedList<ParserFile> linkedList = new LinkedList<ParserFile>();
                        Map map = Collections.emptyMap();
                        LazyFileList lazyFileList = new LazyFileList((File)object7);
                        boolean bl5 = bl3;
                        if (((File)object7).getName().equals("vendor") || ((File)object7).getName().equals("lib")) {
                            bl5 = true;
                        }
                        boolean bl6 = false;
                        if (bl5 && ((File)object7).exists() && ((File)object7).canRead()) {
                            bl6 = true;
                        }
                        boolean bl7 = bl6;
                        HashMap<Language, Map<String, String>> hashMap = new HashMap<Language, Map<String, String>>();
                        boolean bl8 = false;
                        String string = uRL2.toExternalForm();
                        for (Object object62 : RepositoryUpdater.getIndexers()) {
                            language = ((IndexerEntry)object62).getLanguage();
                            if (!((IndexerEntry)object62).indexer.acceptQueryPath(string)) continue;
                            classIndexImpl = ClassIndexManager.get(language).createUsagesQuery(uRL2, true);
                            assert (classIndexImpl != null);
                            object5 = classIndexImpl.getSourceAnalyser();
                            assert (object5 != null);
                            if (bl6 && !((SourceAnalyser)object5).isUpToDate(null, ((File)object7).lastModified())) {
                                bl7 = false;
                                continue;
                            }
                            if (!bl2) continue;
                            if (!((SourceAnalyser)object5).isValid()) {
                                bl8 = true;
                                bl7 = false;
                                continue;
                            }
                            object42 = ClassIndexManager.get(language).getUsagesQuery(uRL2);
                            if (object42 == null || (object3 = ((ClassIndexImpl)object42).getTimeStamps()) == null || object3.size() <= 0) continue;
                            hashMap.put(language, (Map<String, String>)object3);
                        }
                        if (bl7) {
                            break block34;
                        }
                        if (progressHandle != null) {
                            object2 = NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Scannig", (Object)((File)object).getAbsolutePath());
                            progressHandle.setDisplayName((String)object2);
                            if (BUG_LOGGER.isLoggable(Level.FINE)) {
                                BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker.updateFolder - updating handle " + progressHandle + " to " + (String)object2 + " + folderFile");
                            }
                        }
                        if (hashMap.size() == 0) {
                            hashMap = null;
                        }
                        object2 = null;
                        if (!this.ignoreExcludes.contains(uRL2)) {
                            object2 = RepositoryUpdater.getClassPathEntry(classPath, uRL2);
                            object62 = ClasspathInfoAccessor.getInstance().create(classPath2, classPath3, classPath, var13_18, true, false);
                        } else {
                            object62 = ClasspathInfoAccessor.getInstance().create(classPath2, classPath3, classPath, var13_18, true, true);
                        }
                        language = null;
                        classIndexImpl = null;
                        for (Object object42 : lazyFileList) {
                            List list;
                            object3 = FileObjects.getRelativePath((File)object, (File)object42);
                            if (object2 != null && !object2.includes(((String)object3).replace(File.separatorChar, '/'))) continue;
                            if (bl8 || bl || this.dirtyCrossFiles.remove(((File)object42).toURI())) {
                                linkedList.add(FileObjects.fileFileObject((File)object42, (File)object, bl3, null));
                                continue;
                            }
                            int n = ((String)object3).lastIndexOf(46);
                            if (n > -1) {
                                object3 = ((String)object3).substring(0, n);
                            }
                            if ((list = (List)map.remove(object3)) == null) {
                                linkedList.add(FileObjects.fileFileObject(object42, (File)object, bl3, null));
                                continue;
                            }
                            if (((File)list.get(0)).lastModified() >= ((File)object42).lastModified()) continue;
                            linkedList.add(FileObjects.fileFileObject(object42, (File)object, bl3, null));
                            for (File file : list) {
                                file.delete();
                            }
                        }
                        for (Object object42 : map.values()) {
                            object3 = object42.iterator();
                            while (object3.hasNext()) {
                                File file = (File)object3.next();
                                file.delete();
                                if (file.getName().endsWith("sig")) continue;
                            }
                        }
                        if (linkedList.isEmpty()) break block35;
                        if (progressHandle != null) {
                            object5 = ((File)object).getAbsolutePath();
                            object42 = NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing", (Object)object5);
                            if (BUG_LOGGER.isLoggable(Level.FINE)) {
                                BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker.updateFolder2 - updating handle " + progressHandle + " to " + object42);
                            }
                            progressHandle.setDisplayName(object42);
                        }
                        object5 = CachingIndexer.get(uRL2, linkedList.size());
                        object42 = new HashMap<Language, List<File>>();
                        RepositoryUpdater.batchCompile(linkedList, fileObject, (ClasspathInfo)object62, (CachingIndexer)object5, uRL2, this.dirtyCrossFiles, (Set)((Object)classIndexImpl), hashMap, object42);
                        if (hashMap != null) {
                            this.deleteRemovedFiles((CachingIndexer)object5, (Map<Language, Map<String, String>>)hashMap, (Map<Language, List<File>>)object42);
                        }
                        if (object5 != null) {
                            ((CachingIndexer)object5).flush();
                        }
                        break block35;
                    }
                    catch (Throwable throwable) {
                        Object var35_17 = null;
                        if (bl) throw throwable;
                        if (!bl2) throw throwable;
                        RepositoryUpdater.this.scannedRoots.add(uRL2);
                        throw throwable;
                    }
                }
                Object var35_15 = null;
                if (bl) return;
                if (!bl2) return;
                RepositoryUpdater.this.scannedRoots.add(uRL2);
                return;
            }
            Object var35_16 = null;
            if (bl) return;
            if (!bl2) return;
            RepositoryUpdater.this.scannedRoots.add(uRL2);
        }

        private void deleteRemovedFiles(CachingIndexer cachingIndexer, Map<Language, Map<String, String>> map, Map<Language, List<File>> map2) {
            for (Language language : map.keySet()) {
                Map<String, String> map3;
                int n;
                List<File> list = map2.get(language);
                int n2 = list != null ? list.size() : 0;
                if (n2 == (n = (map3 = map.get(language)) != null ? map3.keySet().size() : 0)) continue;
                int n3 = 0;
                for (String string : map3.keySet()) {
                    if (!string.startsWith("jar:")) continue;
                    ++n3;
                }
                if (n2 + n3 == n) continue;
                if (n2 > n) {
                    LOGGER.warning("Unexpectedly encountered more timestamped files (" + n2 + ") than indexed (" + n + ")");
                    if (n2 < 50) {
                        LOGGER.warning(" Details: seen=" + list + "; stamps=" + map3);
                    }
                }
                HashSet hashSet = new HashSet(2 * n2);
                if (list != null) {
                    assert (map3 != null);
                    for (File file : list) {
                        Object object = language.getIndexer();
                        assert (object != null);
                        String string = object.getPersistentUrl(file);
                        hashSet.add(string);
                    }
                }
                HashSet<String> hashSet2 = new HashSet<String>(map3.keySet());
                hashSet2.removeAll(hashSet);
                for (Object object : hashSet2) {
                    try {
                        if (((String)object).startsWith("jar:")) continue;
                        cachingIndexer.remove(language, (String)object);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }

        private List<Language> getApplicableIndexers(String string) {
            List<Language> list = null;
            for (Language language : LanguageRegistry.getInstance().getApplicableLanguages(string)) {
                if (language.getIndexer() == null) continue;
                if (list == null) {
                    list = new ArrayList<Language>(5);
                }
                list.add(language);
            }
            return list != null ? list : Collections.emptyList();
        }

        private void updateFile(URL uRL, URL uRL2) throws IOException {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) {
                return;
            }
            List<Language> list = this.getApplicableIndexers(fileObject.getMIMEType());
            if (list.size() > 0) {
                File file = FileUtil.normalizeFile((File)new File(URI.create(uRL2.toExternalForm())));
                File file2 = FileUtil.toFile((FileObject)fileObject);
                ParserFile parserFile = FileObjects.fileFileObject(file2, file, false, null);
                ParserFile[] parserFileArray = new ParserFile[]{parserFile};
                ClasspathInfo classpathInfo = ClasspathInfoAccessor.getInstance().create(fileObject, null, true, false);
                ClassPath.Entry entry = RepositoryUpdater.getClassPathEntry(classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), uRL2);
                boolean bl = entry == null || entry.includes(fileObject);
                String string = uRL2.toExternalForm();
                assert ("file".equals(uRL2.getProtocol())) : "Unexpected protocol of URL: " + uRL2;
                for (Language language : list) {
                    ClassIndexImpl classIndexImpl;
                    if (language.getIndexer() != null && !language.getIndexer().acceptQueryPath(string) || (classIndexImpl = ClassIndexManager.get(language).createUsagesQuery(uRL2, true)) == null) continue;
                    classIndexImpl.setDirty(null);
                    SourceAnalyser sourceAnalyser = classIndexImpl.getSourceAnalyser();
                    assert (sourceAnalyser != null);
                    if (!bl) continue;
                    CompilerListener compilerListener = new CompilerListener();
                    ParserTaskImpl parserTaskImpl = SourceAccessor.getINSTANCE().createParserTask(language, classpathInfo);
                    parserTaskImpl.setParseListener(compilerListener);
                    Iterable<ParserResult> iterable = parserTaskImpl.parse(parserFileArray);
                    sourceAnalyser.analyse(language, iterable);
                    compilerListener.cleanDiagnostics();
                }
                GsfTaskProvider.refresh(fileObject);
            }
        }

        private void delete(URL uRL, URL uRL2, boolean bl) throws IOException {
            assert ("file".equals(uRL2.getProtocol())) : "Unexpected protocol of URL: " + uRL2;
            File file = FileUtil.normalizeFile((File)new File(URI.create(uRL2.toExternalForm())));
            assert ("file".equals(uRL.getProtocol())) : "Unexpected protocol of URL: " + uRL;
            File file2 = FileUtil.normalizeFile((File)new File(URI.create(uRL.toExternalForm())));
            String string = FileObjects.getRelativePath(file, file2);
            assert (string != null && string.length() > 0) : String.format("File %s not under root %s ", file2.getAbsolutePath(), file.getAbsolutePath());
            boolean bl2 = false;
            ParserFile parserFile = FileObjects.fileFileObject(file2, file, bl2, null);
            for (Language language : LanguageRegistry.getInstance()) {
                if (language.getIndexer() == null || !language.getIndexer().acceptQueryPath(uRL2.toExternalForm())) continue;
                ClassIndexImpl classIndexImpl = ClassIndexManager.get(language).createUsagesQuery(uRL2, true);
                assert (classIndexImpl != null);
                SourceAnalyser sourceAnalyser = classIndexImpl.getSourceAnalyser();
                assert (sourceAnalyser != null);
                sourceAnalyser.delete(parserFile, language);
            }
        }

        private void updateBinary(URL uRL, URL uRL2) throws IOException {
        }

        static /* synthetic */ Work access$000(CompileWorker compileWorker) {
            return compileWorker.work;
        }

        static /* synthetic */ void access$300(CompileWorker compileWorker, URL uRL, Stack stack, Map map, Set set, boolean bl) {
            compileWorker.findDependencies(uRL, stack, map, set, bl);
        }

        static /* synthetic */ List access$402(CompileWorker compileWorker, List list) {
            compileWorker.state = list;
            return compileWorker.state;
        }

        static /* synthetic */ List access$400(CompileWorker compileWorker) {
            return compileWorker.state;
        }

        static /* synthetic */ ProgressHandle access$600(CompileWorker compileWorker) {
            return compileWorker.handle;
        }

        static /* synthetic */ void access$700(CompileWorker compileWorker, URL uRL, URL uRL2, boolean bl, ProgressHandle progressHandle) throws IOException {
            compileWorker.updateFolder(uRL, uRL2, bl, progressHandle);
        }

        static /* synthetic */ ProgressHandle access$602(CompileWorker compileWorker, ProgressHandle progressHandle) {
            compileWorker.handle = progressHandle;
            return compileWorker.handle;
        }

        static /* synthetic */ Set access$802(CompileWorker compileWorker, Set set) {
            compileWorker.oldRoots = set;
            return compileWorker.oldRoots;
        }

        static /* synthetic */ Set access$1002(CompileWorker compileWorker, Set set) {
            compileWorker.oldBinaries = set;
            return compileWorker.oldBinaries;
        }

        static /* synthetic */ Set access$1502(CompileWorker compileWorker, Set set) {
            compileWorker.newBinaries = set;
            return compileWorker.newBinaries;
        }

        static /* synthetic */ Set access$1000(CompileWorker compileWorker) {
            return compileWorker.oldBinaries;
        }

        static /* synthetic */ Set access$1500(CompileWorker compileWorker) {
            return compileWorker.newBinaries;
        }

        static /* synthetic */ boolean access$1900(CompileWorker compileWorker) {
            return compileWorker.scanRoots();
        }

        static /* synthetic */ Work access$002(CompileWorker compileWorker, Work work) {
            compileWorker.work = work;
            return compileWorker.work;
        }

        static /* synthetic */ Set access$800(CompileWorker compileWorker) {
            return compileWorker.oldRoots;
        }

        static /* synthetic */ void access$2100(CompileWorker compileWorker, URL uRL, URL uRL2) throws IOException {
            compileWorker.updateFile(uRL, uRL2);
        }

        static /* synthetic */ void access$2200(CompileWorker compileWorker, URL uRL, URL uRL2, boolean bl) throws IOException {
            compileWorker.delete(uRL, uRL2, bl);
        }

        static /* synthetic */ void access$2300(CompileWorker compileWorker, URL uRL, URL uRL2) throws IOException {
            compileWorker.updateBinary(uRL, uRL2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilerListener
    implements LowMemoryListener,
    ParseListener {
        final List<Error> errors = new LinkedList<Error>();
        final List<Error> warnings = new LinkedList<Error>();
        final List<ParserResult> justEntered = new LinkedList<ParserResult>();
        final AtomicBoolean lowMemory = new AtomicBoolean();

        private CompilerListener() {
        }

        void cleanDiagnostics() {
            if (!this.errors.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Error error : this.errors) {
                        LOGGER.fine(error.toString());
                    }
                }
                this.errors.clear();
            }
            if (!this.warnings.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Error error : this.warnings) {
                        LOGGER.fine(error.toString());
                    }
                }
                this.warnings.clear();
            }
            this.justEntered.clear();
        }

        List<ParserResult> getEnteredTypes() {
            ArrayList<ParserResult> arrayList = new ArrayList<ParserResult>(this.justEntered);
            this.justEntered.clear();
            return arrayList;
        }

        public void error(Error error) {
            if (error.getSeverity() == Severity.ERROR) {
                this.errors.add(error);
            } else {
                this.warnings.add(error);
            }
        }

        public void exception(Exception exception) {
        }

        public void started(ParseEvent parseEvent) {
        }

        public void finished(ParseEvent parseEvent) {
            ParserResult parserResult;
            if (parseEvent.getKind() == ParseEvent.Kind.PARSE && (parserResult = parseEvent.getResult()) != null) {
                this.justEntered.add(parserResult);
            }
        }

        @Override
        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }

    private final class Delay {
        private final Timer timer = new Timer(RepositoryUpdater.class.getName());
        private final List<Work> tasks = new LinkedList<Work>();

        public synchronized void post(Work work) {
            assert (work != null);
            this.tasks.add(work);
            this.timer.schedule((TimerTask)new DelayTask(work), DELAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Work[] workArray = this;
            synchronized (this) {
                Work[] workArray2 = this.tasks.toArray(new Work[this.tasks.size()]);
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (Work work : workArray2) {
                    if (work.workType == WorkType.COMPILE) {
                        work = new SingleRootWork(WorkType.DELETE, ((SingleRootWork)work).file, ((SingleRootWork)work).root, ((SingleRootWork)work).isFolder, work.latch);
                    }
                    CompileWorker compileWorker = new CompileWorker(work);
                    try {
                        compileWorker.run(null);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                return;
            }
        }

        private class DelayTask
        extends TimerTask {
            final Work work;

            public DelayTask(Work work) {
                this.work = work;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RepositoryUpdater.this.submit(this.work);
                Delay delay = Delay.this;
                synchronized (delay) {
                    Delay.this.tasks.remove(this.work);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                boolean bl = super.cancel();
                if (bl) {
                    Delay delay = Delay.this;
                    synchronized (delay) {
                        Delay.this.tasks.remove(this.work);
                    }
                }
                return bl;
            }
        }
    }

    private static class IndexerEntry {
        private Language language;
        private Indexer indexer;

        IndexerEntry(Language language, Indexer indexer) {
            this.language = language;
            this.indexer = indexer;
        }

        Indexer getIndexer() {
            return this.indexer;
        }

        Language getLanguage() {
            return this.language;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LazyFileList
    implements Iterable<File> {
        private File root;

        public LazyFileList(File file) {
            assert (file != null);
            this.root = file;
        }

        @Override
        public Iterator<File> iterator() {
            if (!this.root.exists()) {
                return Collections.emptySet().iterator();
            }
            return new It(this.root);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class It
        implements Iterator<File> {
            private final LinkedList<File> toDo = new LinkedList();

            public It(File file) {
                File[] fileArray = file.listFiles();
                if (fileArray != null && fileArray.length > 0) {
                    this.toDo.addAll(Arrays.asList(fileArray));
                }
            }

            @Override
            public boolean hasNext() {
                while (!this.toDo.isEmpty()) {
                    File file = this.toDo.peek();
                    String string = file.getName();
                    if (file.isDirectory() && !ignoredDirectories.contains(string)) {
                        file = this.toDo.removeFirst();
                        assert (file.isDirectory());
                        File[] fileArray = file.listFiles();
                        if (fileArray == null) continue;
                        for (int i = 0; i < fileArray.length; ++i) {
                            file = fileArray[i];
                            if (file == null) continue;
                            if (file.isFile()) {
                                this.toDo.addFirst(file);
                                continue;
                            }
                            this.toDo.addLast(file);
                        }
                        continue;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public File next() {
                return this.toDo.removeFirst();
            }

            @Override
            public void remove() {
                if (BUG_LOGGER.isLoggable(Level.FINE)) {
                    BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker throwing exception 1 ");
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiRootsWork
    extends Work {
        private List<URL> roots;

        public MultiRootsWork(WorkType workType, List<URL> list, CountDownLatch countDownLatch) {
            super(workType, countDownLatch);
            this.roots = list;
        }

        public List<URL> getRoots() {
            return this.roots;
        }
    }

    private static class SingleRootWork
    extends Work {
        private URL file;
        private URL root;
        private boolean isFolder;

        public SingleRootWork(WorkType workType, URL uRL, URL uRL2, boolean bl, CountDownLatch countDownLatch) {
            super(workType, countDownLatch);
            this.file = uRL;
            this.root = uRL2;
            this.isFolder = bl;
        }

        public URL getFile() {
            return this.file;
        }

        public URL getRoot() {
            return this.root;
        }

        public boolean isFolder() {
            return this.isFolder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Work {
        private final WorkType workType;
        private final CountDownLatch latch;

        protected Work(WorkType workType, CountDownLatch countDownLatch) {
            assert (workType != null);
            this.workType = workType;
            this.latch = countDownLatch;
        }

        public WorkType getType() {
            return this.workType;
        }

        public void finished() {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public static Work batch() {
            return new Work(WorkType.COMPILE_BATCH, null);
        }

        public static Work compile(FileObject fileObject, URL uRL) throws FileStateInvalidException {
            return Work.compile(fileObject.getURL(), uRL, fileObject.isFolder());
        }

        public static Work compile(URL uRL, URL uRL2, boolean bl) {
            assert (uRL != null && uRL2 != null);
            return new SingleRootWork(WorkType.COMPILE, uRL, uRL2, bl, null);
        }

        public static Work compile(FileObject fileObject, URL uRL, CountDownLatch[] countDownLatchArray) throws FileStateInvalidException {
            assert (fileObject != null && uRL != null);
            assert (countDownLatchArray != null && countDownLatchArray.length == 1 && countDownLatchArray[0] == null);
            countDownLatchArray[0] = new CountDownLatch(1);
            return new SingleRootWork(WorkType.COMPILE, fileObject.getURL(), uRL, fileObject.isFolder(), countDownLatchArray[0]);
        }

        public static Work delete(FileObject fileObject, URL uRL, boolean bl) throws FileStateInvalidException {
            return Work.delete(fileObject.getURL(), uRL, fileObject.isFolder());
        }

        public static Work delete(URL uRL, URL uRL2, boolean bl) {
            assert (uRL != null && uRL2 != null);
            return new SingleRootWork(WorkType.DELETE, uRL, uRL2, bl, null);
        }

        public static Work binary(FileObject fileObject, URL uRL) throws FileStateInvalidException {
            return Work.binary(fileObject.getURL(), uRL, fileObject.isFolder());
        }

        public static Work binary(URL uRL, URL uRL2, boolean bl) {
            assert (uRL != null && uRL2 != null);
            return new SingleRootWork(WorkType.UPDATE_BINARY, uRL, uRL2, bl, null);
        }

        public static Work filterChange(List<URL> list) {
            assert (list != null);
            return new MultiRootsWork(WorkType.FILTER_CHANGED, list, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WorkType {
        COMPILE_BATCH,
        COMPILE_CONT,
        COMPILE,
        DELETE,
        UPDATE_BINARY,
        FILTER_CHANGED;

    }
}

