/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UiUtils {
    private UiUtils() {
    }

    public static Icon getElementIcon(ElementKind elementKind, Collection<Modifier> collection) {
        return Icons.getElementIcon(elementKind, collection);
    }

    public static boolean open(Source source, ElementHandle elementHandle) {
        DeclarationFinder.DeclarationLocation declarationLocation = UiUtils.getOpenInfo(source, elementHandle);
        if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
            return UiUtils.doOpen(declarationLocation.getFileObject(), declarationLocation.getOffset());
        }
        return false;
    }

    private static DeclarationFinder.DeclarationLocation getOpenInfo(Source source, ElementHandle elementHandle) {
        assert (source != null);
        assert (elementHandle != null);
        try {
            FileObject fileObject = source.getFileObjects().iterator().next();
            return UiUtils.getElementLocation(fileObject, elementHandle);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return DeclarationFinder.DeclarationLocation.NONE;
        }
    }

    public static boolean open(final FileObject fileObject, final int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UiUtils.doOpen(fileObject, n);
                }
            });
            return true;
        }
        return UiUtils.doOpen(fileObject, n);
    }

    private static boolean doOpen(FileObject fileObject, int n) {
        try {
            Object object;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null) {
                Line line;
                int n2 = NbDocument.findLineNumber((StyledDocument)object, (int)n);
                int n3 = NbDocument.findLineOffset((StyledDocument)object, (int)n2);
                int n4 = n - n3;
                if (n2 != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, n4);
                    return true;
                }
            }
            if ((object = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return false;
    }

    private static DeclarationFinder.DeclarationLocation getElementLocation(final FileObject fileObject, final ElementHandle elementHandle) throws IOException {
        assert (elementHandle != null);
        final DeclarationFinder.DeclarationLocation[] declarationLocationArray = new DeclarationFinder.DeclarationLocation[]{DeclarationFinder.DeclarationLocation.NONE};
        Source source = Source.forFileObject(fileObject);
        source.runUserActionTask(new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController compilationController) {
                block9: {
                    try {
                        compilationController.toPhase(Phase.RESOLVED);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    FileObject fileObject2 = compilationController.getFileObject();
                    if (elementHandle != null) {
                        fileObject2 = elementHandle.getFileObject();
                    }
                    if (fileObject2 == null) {
                        fileObject2 = fileObject;
                    }
                    if (fileObject2 == compilationController.getFileObject()) {
                        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(elementHandle.getMimeType());
                        Parser parser = language.getParser();
                        try {
                            OffsetRange offsetRange = parser.getPositionManager().getOffsetRange((CompilationInfo)compilationController, elementHandle);
                            if (offsetRange != OffsetRange.NONE && offsetRange != null) {
                                declarationLocationArray[0] = new DeclarationFinder.DeclarationLocation(fileObject2, offsetRange.getStart());
                                break block9;
                            }
                            declarationLocationArray[0] = new DeclarationFinder.DeclarationLocation(fileObject2, -1);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            declarationLocationArray[0] = new DeclarationFinder.DeclarationLocation(fileObject2, 0);
                        }
                    } else {
                        declarationLocationArray[0] = new DeclarationFinder.DeclarationLocation(fileObject2, -1);
                    }
                }
            }
        }, true);
        return declarationLocationArray[0];
    }
}

