/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceTaskFactory;
import org.netbeans.napi.gsfret.source.support.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CaretAwareSourceTaskFactory
extends SourceTaskFactory {
    private static final int DEFAULT_RESCHEDULE_TIMEOUT = 300;
    private static final RequestProcessor WORKER = new RequestProcessor("CaretAwareSourceTaskFactory worker");
    private int timeout;
    private Map<JTextComponent, ComponentListener> component2Listener = new HashMap<JTextComponent, ComponentListener>();
    private static Map<FileObject, Integer> file2LastPosition = new WeakHashMap<FileObject, Integer>();

    public CaretAwareSourceTaskFactory(Phase phase, Source.Priority priority) {
        super(phase, priority);
        OpenedEditors.getDefault().addChangeListener(new ChangeListenerImpl());
        this.timeout = 300;
    }

    public List<FileObject> getFileObjects() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(OpenedEditors.getDefault().getVisibleEditorsFiles());
        return arrayList;
    }

    public static synchronized int getLastPosition(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Cannot pass null file!");
        }
        Integer n = file2LastPosition.get(fileObject);
        if (n == null) {
            return 0;
        }
        return n;
    }

    static synchronized void setLastPosition(FileObject fileObject, int n) {
        file2LastPosition.put(fileObject, n);
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ArrayList<JTextComponent> arrayList = new ArrayList<JTextComponent>(OpenedEditors.getDefault().getVisibleEditors());
            ArrayList arrayList2 = new ArrayList(CaretAwareSourceTaskFactory.this.component2Listener.keySet());
            arrayList.removeAll(CaretAwareSourceTaskFactory.this.component2Listener.keySet());
            arrayList2.removeAll(OpenedEditors.getDefault().getVisibleEditors());
            for (JTextComponent jTextComponent : arrayList2) {
                jTextComponent.removeCaretListener((CaretListener)CaretAwareSourceTaskFactory.this.component2Listener.remove(jTextComponent));
            }
            for (JTextComponent jTextComponent : arrayList) {
                ComponentListener componentListener = new ComponentListener(jTextComponent);
                jTextComponent.addCaretListener(componentListener);
                CaretAwareSourceTaskFactory.this.component2Listener.put(jTextComponent, componentListener);
                CaretAwareSourceTaskFactory.setLastPosition(OpenedEditors.getFileObject(jTextComponent), jTextComponent.getCaretPosition());
            }
            CaretAwareSourceTaskFactory.this.fileObjectsChanged();
        }
    }

    private class ComponentListener
    implements CaretListener {
        private JTextComponent component;
        private final RequestProcessor.Task rescheduleTask;

        public ComponentListener(JTextComponent jTextComponent) {
            this.component = jTextComponent;
            this.rescheduleTask = WORKER.create(new Runnable(){

                public void run() {
                    FileObject fileObject = OpenedEditors.getFileObject(ComponentListener.this.component);
                    if (fileObject != null) {
                        CaretAwareSourceTaskFactory.setLastPosition(fileObject, ComponentListener.this.component.getCaretPosition());
                        CaretAwareSourceTaskFactory.this.reschedule(fileObject);
                    }
                }
            });
        }

        public void caretUpdate(CaretEvent caretEvent) {
            FileObject fileObject = OpenedEditors.getFileObject(this.component);
            if (fileObject != null) {
                CaretAwareSourceTaskFactory.setLastPosition(fileObject, this.component.getCaretPosition());
                this.rescheduleTask.schedule(CaretAwareSourceTaskFactory.this.timeout);
            }
        }
    }
}

