/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorToolBar;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.impl.CustomizableSideBar;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorUI
extends EditorUI {
    private FocusListener focusL = new FocusAdapter(){

        public void focusGained(FocusEvent focusEvent) {
            FileObject fileObject;
            DataObject dataObject;
            BaseDocument baseDocument = NbEditorUI.this.getDocument();
            if (baseDocument != null && (dataObject = NbEditorUtilities.getDataObject((Document)baseDocument)) != null && (fileObject = dataObject.getPrimaryFile()) != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        fileObject.refresh();
                    }
                });
            }
        }
    };
    private boolean attached = false;
    private ChangeListener listener;

    protected SystemActionUpdater createSystemActionUpdater(String string, boolean bl, boolean bl2) {
        return new SystemActionUpdater(string, bl, bl2);
    }

    private static Lookup getContextLookup(Component component) {
        Lookup lookup = null;
        for (Component component2 = component; !(component2 == null || component2 instanceof Lookup.Provider && (lookup = ((Lookup.Provider)component2).getLookup()) != null); component2 = component2.getParent()) {
        }
        return lookup;
    }

    protected void attachSystemActionPerformer(String string) {
        new SystemActionPerformer(string);
    }

    protected void installUI(JTextComponent jTextComponent) {
        super.installUI(jTextComponent);
        if (!this.attached) {
            this.attachSystemActionPerformer("incremental-search-forward");
            this.attachSystemActionPerformer("replace");
            this.attachSystemActionPerformer("goto");
            this.attachSystemActionPerformer("show-popup-menu");
            this.attached = true;
        }
        jTextComponent.addFocusListener(this.focusL);
    }

    protected void uninstallUI(JTextComponent jTextComponent) {
        super.uninstallUI(jTextComponent);
        jTextComponent.removeFocusListener(this.focusL);
    }

    protected int textLimitWidth() {
        int n;
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null && (n = CodeStylePreferences.get((Document)baseDocument).getPreferences().getInt("text-limit-width", 80)) > 0) {
            return n;
        }
        return super.textLimitWidth();
    }

    protected JComponent createExtComponent() {
        JTextComponent jTextComponent = this.getComponent();
        JScrollPane jScrollPane = new JScrollPane(jTextComponent);
        jScrollPane.getViewport().setMinimumSize(new Dimension(4, 4));
        Border border = BorderFactory.createEmptyBorder();
        jScrollPane.setBorder(border);
        jScrollPane.setViewportBorder(border);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.putClientProperty(JTextComponent.class, jTextComponent);
        jPanel.add(jScrollPane);
        CustomizableSideBar.resetSideBars(jTextComponent);
        Map<CustomizableSideBar.SideBarPosition, JComponent> map = CustomizableSideBar.getSideBars(jTextComponent);
        NbEditorUI.processSideBars(map, jPanel);
        if (this.listener == null) {
            this.listener = new SideBarsListener(jTextComponent);
            CustomizableSideBar.addChangeListener(NbEditorUtilities.getMimeType(jTextComponent), this.listener);
        }
        this.initGlyphCorner(jScrollPane);
        return jPanel;
    }

    public boolean isLineNumberEnabled() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        return preferences.getBoolean("line-number-visible", true);
    }

    public void setLineNumberEnabled(boolean bl) {
        Preferences preferences;
        boolean bl2 = (preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class)).getBoolean("line-number-visible", true);
        preferences.putBoolean("line-number-visible", !bl2);
    }

    private static void processSideBars(Map map, JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent.getComponent(0);
        jComponent.removeAll();
        jComponent.add(jScrollPane);
        jScrollPane.setRowHeader(null);
        jScrollPane.setColumnHeaderView(null);
        for (Map.Entry entry : map.entrySet()) {
            CustomizableSideBar.SideBarPosition sideBarPosition = (CustomizableSideBar.SideBarPosition)entry.getKey();
            JComponent jComponent2 = (JComponent)entry.getValue();
            if (sideBarPosition.isScrollable()) {
                if (sideBarPosition.getPosition() == 1) {
                    jScrollPane.setRowHeaderView(jComponent2);
                    continue;
                }
                if (sideBarPosition.getPosition() == 2) {
                    jScrollPane.setColumnHeaderView(jComponent2);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported side bar position, scrollable = true, position=" + sideBarPosition.getBorderLayoutPosition());
            }
            jComponent.add((Component)jComponent2, sideBarPosition.getBorderLayoutPosition());
        }
    }

    protected JToolBar createToolBarComponent() {
        return new NbEditorToolBar(this.getComponent());
    }

    static class EnabledPropertySyncListener
    implements PropertyChangeListener {
        Action action;

        EnabledPropertySyncListener(Action action) {
            this.action = action;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.action.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static final class SideBarsListener
    implements ChangeListener {
        private final JTextComponent component;

        public SideBarsListener(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JComponent jComponent;
                    EditorUI editorUI = Utilities.getEditorUI((JTextComponent)SideBarsListener.this.component);
                    if (editorUI != null && (jComponent = editorUI.getExtComponent()) != null) {
                        Map<CustomizableSideBar.SideBarPosition, JComponent> map = CustomizableSideBar.getSideBars(SideBarsListener.this.component);
                        NbEditorUI.processSideBars(map, jComponent);
                        jComponent.revalidate();
                        jComponent.repaint();
                    }
                }
            });
        }
    }

    private class SystemActionPerformer
    implements PropertyChangeListener {
        private String editorActionName;
        private Action editorAction;
        private Action systemAction;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SystemActionPerformer(String string) {
            this.editorActionName = string;
            Object object = NbEditorUI.this.getComponentLock();
            synchronized (object) {
                JTextComponent jTextComponent = NbEditorUI.this.getComponent();
                if (jTextComponent != null) {
                    this.propertyChange(new PropertyChangeEvent((Object)NbEditorUI.this, "component", null, jTextComponent));
                }
                NbEditorUI.this.addPropertyChangeListener(this);
            }
        }

        private void attachSystemActionPerformer(JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return;
            }
            Action action = this.getEditorAction(jTextComponent);
            if (action == null) {
                return;
            }
            Action action2 = this.getSystemAction(jTextComponent);
            if (action2 == null) {
                return;
            }
            if (action2 instanceof CallbackSystemAction) {
                Object object = ((CallbackSystemAction)action2).getActionMapKey();
                jTextComponent.getActionMap().put(object, action);
            }
        }

        private void detachSystemActionPerformer(JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return;
            }
            Action action = this.getEditorAction(jTextComponent);
            if (action == null) {
                return;
            }
            Action action2 = this.getSystemAction(jTextComponent);
            if (action2 == null) {
                return;
            }
            if (action2 instanceof CallbackSystemAction) {
                Action action3;
                Object object = ((CallbackSystemAction)action2).getActionMapKey();
                ActionMap actionMap = jTextComponent.getActionMap();
                if (actionMap != null && action.equals(action3 = actionMap.get(object))) {
                    actionMap.remove(object);
                }
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("component".equals(string)) {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
                if (jTextComponent != null) {
                    jTextComponent.addPropertyChangeListener(this);
                    this.attachSystemActionPerformer(jTextComponent);
                } else {
                    jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                    jTextComponent.removePropertyChangeListener(this);
                    this.detachSystemActionPerformer(jTextComponent);
                }
            }
        }

        private synchronized Action getEditorAction(JTextComponent jTextComponent) {
            BaseKit baseKit;
            if (this.editorAction == null && (baseKit = Utilities.getKit((JTextComponent)jTextComponent)) != null) {
                this.editorAction = baseKit.getActionByName(this.editorActionName);
            }
            return this.editorAction;
        }

        private Action getSystemAction(JTextComponent jTextComponent) {
            String string;
            Action action;
            if (this.systemAction == null && (action = this.getEditorAction(jTextComponent)) != null && (string = (String)action.getValue("systemActionClassName")) != null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (Throwable throwable) {
                    clazz = null;
                }
                if (clazz != null) {
                    Lookup lookup;
                    this.systemAction = SystemAction.get(clazz);
                    if (this.systemAction instanceof ContextAwareAction && (lookup = NbEditorUI.getContextLookup(jTextComponent)) != null) {
                        this.systemAction = ((ContextAwareAction)this.systemAction).createContextAwareInstance(lookup);
                    }
                }
            }
            return this.systemAction;
        }
    }

    public final class SystemActionUpdater
    implements PropertyChangeListener,
    ActionPerformer {
        private String editorActionName;
        private boolean updatePerformer;
        private boolean syncEnabling;
        private Action editorAction;
        private Action systemAction;
        private PropertyChangeListener enabledPropertySyncL;
        private boolean listeningOnTCRegistry;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SystemActionUpdater(String string, boolean bl, boolean bl2) {
            this.editorActionName = string;
            this.updatePerformer = bl;
            this.syncEnabling = bl2;
            Object object = NbEditorUI.this.getComponentLock();
            synchronized (object) {
                JTextComponent jTextComponent = NbEditorUI.this.getComponent();
                if (jTextComponent != null) {
                    this.propertyChange(new PropertyChangeEvent((Object)NbEditorUI.this, "component", null, jTextComponent));
                }
                NbEditorUI.this.addPropertyChangeListener(this);
            }
        }

        public void editorActivated() {
            Action action = this.getEditorAction();
            Action action2 = this.getSystemAction();
            if (action != null && action2 != null) {
                if (this.updatePerformer && action.isEnabled() && action2 instanceof CallbackSystemAction) {
                    ((CallbackSystemAction)action2).setActionPerformer((ActionPerformer)this);
                }
                if (this.syncEnabling) {
                    if (this.enabledPropertySyncL == null) {
                        this.enabledPropertySyncL = new EnabledPropertySyncListener(action2);
                    }
                    action.addPropertyChangeListener(this.enabledPropertySyncL);
                }
            }
        }

        public void editorDeactivated() {
            Action action = this.getEditorAction();
            Action action2 = this.getSystemAction();
            if (action != null && action2 != null && this.syncEnabling && this.enabledPropertySyncL != null) {
                action.removePropertyChangeListener(this.enabledPropertySyncL);
            }
        }

        private void reset() {
            if (this.enabledPropertySyncL != null) {
                this.editorAction.removePropertyChangeListener(this.enabledPropertySyncL);
            }
            this.editorAction = null;
            this.systemAction = null;
            this.enabledPropertySyncL = null;
        }

        public void performAction(SystemAction systemAction) {
            JTextComponent jTextComponent = NbEditorUI.this.getComponent();
            Action action = this.getEditorAction();
            if (jTextComponent != null && action != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 0, ""));
            }
        }

        private void startTCRegistryListening() {
            if (!this.listeningOnTCRegistry) {
                this.listeningOnTCRegistry = true;
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private void stopTCRegistryListening() {
            if (this.listeningOnTCRegistry) {
                this.listeningOnTCRegistry = false;
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("activated".equals(string)) {
                TopComponent topComponent = (TopComponent)propertyChangeEvent.getNewValue();
                if (topComponent instanceof CloneableEditorSupport.Pane) {
                    this.editorActivated();
                } else {
                    this.editorDeactivated();
                }
            } else if ("component".equals(string)) {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
                if (jTextComponent != null) {
                    jTextComponent.addPropertyChangeListener(this);
                    if (jTextComponent.isDisplayable()) {
                        this.startTCRegistryListening();
                    }
                } else {
                    jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                    jTextComponent.removePropertyChangeListener(this);
                    this.stopTCRegistryListening();
                }
                this.reset();
            } else if ("editorKit".equals(string)) {
                this.reset();
            } else if ("ancestor".equals(string)) {
                if (((Component)propertyChangeEvent.getSource()).isDisplayable()) {
                    this.startTCRegistryListening();
                } else {
                    this.stopTCRegistryListening();
                }
            }
        }

        private synchronized Action getEditorAction() {
            BaseKit baseKit;
            if (this.editorAction == null && (baseKit = Utilities.getKit((JTextComponent)NbEditorUI.this.getComponent())) != null) {
                this.editorAction = baseKit.getActionByName(this.editorActionName);
            }
            return this.editorAction;
        }

        private Action getSystemAction() {
            String string;
            Action action;
            if (this.systemAction == null && (action = this.getEditorAction()) != null && (string = (String)action.getValue("systemActionClassName")) != null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (Throwable throwable) {
                    clazz = null;
                }
                if (clazz != null) {
                    this.systemAction = SystemAction.get(clazz);
                }
            }
            return this.systemAction;
        }

        protected void finalize() throws Throwable {
            this.reset();
        }
    }
}

