/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.impl.StatusLineComponent;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.StatusLineElementProvider;
import org.openide.windows.WindowManager;

public final class StatusLineFactories {
    private static final Logger LOG = Logger.getLogger(StatusLineFactories.class.getName());
    public static JLabel LINE_COLUMN_CELL = new StatusLineComponent(StatusLineComponent.Type.LINE_COLUMN);
    public static JLabel TYPING_MODE_CELL = new StatusLineComponent(StatusLineComponent.Type.TYPING_MODE);
    public static JLabel MAIN_CELL = new JLabel();

    private static void clearStatusLine() {
        LINE_COLUMN_CELL.setText("");
        TYPING_MODE_CELL.setText("");
    }

    static void refreshStatusLine() {
        LOG.fine("StatusLineFactories.refreshStatusLine()\n");
        List list = EditorRegistry.componentList();
        for (JTextComponent jTextComponent : list) {
            String string;
            boolean bl = SwingUtilities.isDescendingFrom(jTextComponent, WindowManager.getDefault().getMainWindow());
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
            if (LOG.isLoggable(Level.FINE)) {
                Object object;
                string = jTextComponent.toString();
                Document document = jTextComponent.getDocument();
                if (document != null && (object = document.getProperty("stream")) != null) {
                    string = object.toString();
                }
                LOG.fine("  underMainWindow=" + bl + ", text-component: " + string + "\n");
            }
            if (editorUI == null) continue;
            string = editorUI.getStatusBar();
            string.setVisible(!bl);
            boolean bl2 = bl && jTextComponent.isShowing();
            if (!bl2) continue;
            string.updateGlobal();
            LOG.fine("  end of refreshStatusLine() - found main window component\n\n");
            return;
        }
        StatusLineFactories.clearStatusLine();
        LOG.fine("  end of refreshStatusLine() - no components - status line cleared\n\n");
    }

    static Component panelWithSeparator(JLabel jLabel) {
        JSeparator jSeparator = new JSeparator(1){

            public Dimension getPreferredSize() {
                return new Dimension(3, 3);
            }
        };
        jSeparator.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jSeparator, "West");
        jPanel.add(jLabel);
        return jPanel;
    }

    static {
        MAIN_CELL.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("text".equals(propertyChangeEvent.getPropertyName())) {
                    Integer n = (Integer)MAIN_CELL.getClientProperty("importance");
                    StatusDisplayer.Message message = StatusDisplayer.getDefault().setStatusText(MAIN_CELL.getText(), n.intValue());
                    message.clear(5000);
                }
            }
        });
        StatusBar.setGlobalCell((String)"main", (JLabel)MAIN_CELL);
        StatusBar.setGlobalCell((String)"position", (JLabel)LINE_COLUMN_CELL);
        StatusBar.setGlobalCell((String)"typing-mode", (JLabel)TYPING_MODE_CELL);
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                StatusLineFactories.refreshStatusLine();
            }
        });
    }

    public static final class LineColumn
    implements StatusLineElementProvider {
        public Component getStatusLineElement() {
            return StatusLineFactories.panelWithSeparator(LINE_COLUMN_CELL);
        }
    }

    public static final class TypingMode
    implements StatusLineElementProvider {
        public Component getStatusLineElement() {
            return StatusLineFactories.panelWithSeparator(TYPING_MODE_CELL);
        }
    }
}

