/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Filter {
    private static Map<Query, Map<Class, Filter>> queryToFilter = new WeakHashMap<Query, Map<Class, Filter>>();

    public abstract String getDisplayName();

    public abstract boolean accept(Issue var1);

    public static Filter getAllFilter(Query query) {
        return Filter.getFilter(query, AllFilter.class);
    }

    public static Filter getNotSeenFilter() {
        return Filter.getFilter(null, NotSeenFilter.class);
    }

    public static Filter getNewFilter(Query query) {
        return Filter.getFilter(query, NewFilter.class);
    }

    public static Filter getObsoleteDateFilter(Query query) {
        return Filter.getFilter(query, ObsoleteDateFilter.class);
    }

    public static Filter getAllButObsoleteDateFilter(Query query) {
        return Filter.getFilter(query, AllButObsoleteDateFilter.class);
    }

    private static <T extends Filter> Filter getFilter(Query query, Class<T> clazz) {
        Filter filter;
        Map<Class, Filter> map = queryToFilter.get(query);
        if (map == null) {
            map = new HashMap<Class, Filter>(5);
            queryToFilter.put(query, map);
        }
        if ((filter = map.get(clazz)) == null) {
            try {
                if (query == null) {
                    Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    filter = (Filter)constructor.newInstance(new Object[0]);
                } else {
                    Constructor<T> constructor = clazz.getDeclaredConstructor(Query.class);
                    filter = (Filter)constructor.newInstance(query);
                }
            }
            catch (Exception exception) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, exception);
            }
            map.put(clazz, filter);
        }
        return filter;
    }

    private static class AllButObsoleteDateFilter
    extends Filter {
        private final Query query;

        AllButObsoleteDateFilter(Query query) {
            this.query = query;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_AllButObsoleteIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return this.query.contains(issue);
        }
    }

    private static class AllFilter
    extends Filter {
        private final Query query;

        AllFilter(Query query) {
            this.query = query;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_AllIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return this.query.contains(issue) || !IssueCacheUtils.wasSeen(issue);
        }
    }

    private static class NewFilter
    extends Filter {
        private final Query query;

        NewFilter(Query query) {
            this.query = query;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_NewIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return this.query.getIssueStatus(issue) == 4;
        }
    }

    private static class NotSeenFilter
    extends Filter {
        NotSeenFilter() {
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_UnseenIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return !IssueCacheUtils.wasSeen(issue);
        }
    }

    private static class ObsoleteDateFilter
    extends Filter {
        private final Query query;

        ObsoleteDateFilter(Query query) {
            this.query = query;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_ObsoleteIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return !this.query.contains(issue);
        }
    }
}

