/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.jira;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.bugtracking.jira.JiraUpdater;
import org.netbeans.modules.bugtracking.kenai.QueryDescriptor;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeJiraSupport {
    private static final String JIRA_SUBSTRING = "kenai.com/jira/";
    private final String projectUrl;
    private final String createIssueUrl;
    private final String openIssueUrl;
    private static Map<String, FakeJiraSupport> supportedProjects = new HashMap<String, FakeJiraSupport>();
    private static List<QueryHandle> queryHandles;

    private FakeJiraSupport(String string, String string2, String string3) {
        this.projectUrl = string;
        this.createIssueUrl = string2;
        this.openIssueUrl = string3;
    }

    public static synchronized FakeJiraSupport get(ProjectHandle projectHandle) {
        KenaiProject kenaiProject = KenaiUtil.getKenaiProject(projectHandle);
        if (kenaiProject == null) {
            return null;
        }
        return FakeJiraSupport.get(kenaiProject);
    }

    public static synchronized FakeJiraSupport get(KenaiProject kenaiProject) {
        Object object;
        if (kenaiProject == null) {
            return null;
        }
        FakeJiraSupport fakeJiraSupport = supportedProjects.get(kenaiProject.getName());
        if (fakeJiraSupport != null) {
            return fakeJiraSupport;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            KenaiFeature[] kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.ISSUES);
            string = null;
            object = kenaiFeatureArray;
            int n = ((KenaiFeature[])object).length;
            int n2 = 0;
            if (n2 < n) {
                KenaiFeature kenaiFeature = object[n2];
                if (!"jira".equals(kenaiFeature.getService())) {
                    return null;
                }
                string = kenaiFeature.getLocation();
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (string == null) {
            return null;
        }
        int n = string.indexOf(JIRA_SUBSTRING);
        if (n > -1) {
            object = string.substring(0, n + JIRA_SUBSTRING.length());
            string2 = (String)object + "secure/CreateIssue!default.jspa?pname=" + kenaiProject.getName();
            string3 = (String)object + "browse/";
        }
        fakeJiraSupport = new FakeJiraSupport(string, string2, string3);
        supportedProjects.put(kenaiProject.getName(), fakeJiraSupport);
        return fakeJiraSupport;
    }

    public ActionListener getCreateIssueListener() {
        return this.getJiraListener(this.createIssueUrl);
    }

    public ActionListener getOpenProjectListener() {
        return this.getJiraListener(this.projectUrl);
    }

    public String getIssueUrl(String string) {
        return this.openIssueUrl + string;
    }

    public QueryHandle getAllIssuesQuery() {
        List<QueryHandle> list = this.getQueries();
        String string = NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_AllIssues");
        for (QueryHandle queryHandle : list) {
            if (!queryHandle.getDisplayName().equals(string)) continue;
            return queryHandle;
        }
        return null;
    }

    public List<QueryHandle> getQueries() {
        if (queryHandles == null) {
            queryHandles = this.createQueryHandles();
        }
        return queryHandles;
    }

    private List<QueryHandle> createQueryHandles() {
        ArrayList<QueryHandle> arrayList = new ArrayList<QueryHandle>(2);
        arrayList.add(new FakeJiraQueryHandle(NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_MyIssues"), this.projectUrl));
        arrayList.add(new FakeJiraQueryHandle(NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_AllIssues"), this.projectUrl));
        return arrayList;
    }

    private ActionListener getJiraListener(final String string) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JiraUpdater.notifyJiraDownload(string)) {
                    JiraUpdater.getInstance().downloadAndInstall();
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeJiraQueryHandle
    extends QueryHandle
    implements QueryDescriptor,
    ActionListener {
        private final String displayName;
        private static List<QueryResultHandle> results;
        private final String projectUrl;
        private final String notAvailableResult;

        public FakeJiraQueryHandle(String string, String string2) {
            this.displayName = string;
            this.projectUrl = string2;
            this.notAvailableResult = NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_NotAvailable");
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JiraUpdater.notifyJiraDownload(this.projectUrl)) {
                JiraUpdater.getInstance().downloadAndInstall();
            }
        }

        public List<QueryResultHandle> getQueryResults() {
            if (results == null) {
                ArrayList<QueryResultHandle> arrayList = new ArrayList<QueryResultHandle>(1);
                arrayList.add(new FakeJiraQueryResultHandle(this.notAvailableResult, QueryResultHandle.ResultType.NAMED_RESULT, this.projectUrl));
                results = arrayList;
            }
            return results;
        }

        public QueryResultHandle getUnseenResult() {
            return new FakeJiraQueryResultHandle(this.notAvailableResult, QueryResultHandle.ResultType.ALL_CHANGES_RESULT, this.projectUrl);
        }

        @Override
        public boolean isPredefined() {
            return true;
        }

        @Override
        public Query getQuery() {
            return null;
        }
    }

    public static class FakeJiraQueryResultHandle
    extends QueryResultHandle
    implements ActionListener {
        private final String label;
        private final QueryResultHandle.ResultType type;
        private final String projectUrl;

        public FakeJiraQueryResultHandle(String string, QueryResultHandle.ResultType resultType, String string2) {
            this.label = string;
            this.type = resultType;
            this.projectUrl = string2;
        }

        public String getText() {
            return this.label;
        }

        public String getToolTipText() {
            return NbBundle.getMessage(FakeJiraQueryHandle.class, (String)"LBL_NotAvailableTooltip");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JiraUpdater.notifyJiraDownload(this.projectUrl)) {
                JiraUpdater.getInstance().downloadAndInstall();
            }
        }

        public QueryResultHandle.ResultType getResultType() {
            return this.type;
        }
    }
}

