/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.jira.FakeJiraSupport;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositoryUtils;
import org.netbeans.modules.bugtracking.kenai.QueryDescriptor;
import org.netbeans.modules.bugtracking.kenai.QueryHandleImpl;
import org.netbeans.modules.bugtracking.kenai.QueryResultHandleImpl;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryAccessorImpl
extends QueryAccessor
implements PropertyChangeListener {
    private final Map<String, ProjectHandleListener> projectListeners = new HashMap<String, ProjectHandleListener>();
    private final Map<String, KenaiRepositoryListener> kenaiRepoListeners = new HashMap<String, KenaiRepositoryListener>();
    private final Map<String, Map<String, QueryHandle>> queryHandles = new HashMap<String, Map<String, QueryHandle>>();
    private String lastLoggedUser = null;

    public QueryAccessorImpl() {
        Kenai.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        Dashboard.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.lastLoggedUser = this.getKenaiUser();
    }

    public QueryHandle getAllIssuesQuery(ProjectHandle projectHandle) {
        Repository repository = KenaiRepositoryUtils.getInstance().getRepository(projectHandle);
        if (repository == null) {
            FakeJiraSupport fakeJiraSupport = FakeJiraSupport.get(projectHandle);
            if (fakeJiraSupport != null) {
                return fakeJiraSupport.getAllIssuesQuery();
            }
            return null;
        }
        KenaiSupport kenaiSupport = (KenaiSupport)repository.getLookup().lookup(KenaiSupport.class);
        if (kenaiSupport == null) {
            return null;
        }
        this.registerRepository(repository, projectHandle);
        Query query = kenaiSupport.getAllIssuesQuery(repository);
        if (query == null) {
            return null;
        }
        List<QueryHandle> list = this.getQueryHandles(projectHandle, query);
        assert (list.size() == 1);
        this.registerProject(projectHandle, list);
        return list.get(0);
    }

    public List<QueryHandle> getQueries(ProjectHandle projectHandle) {
        Repository repository = KenaiRepositoryUtils.getInstance().getRepository(projectHandle);
        if (repository == null) {
            return this.getQueriesForNoRepo(projectHandle);
        }
        this.registerRepository(repository, projectHandle);
        List<QueryHandle> list = this.getQueryHandles(repository, projectHandle);
        this.registerProject(projectHandle, list);
        return Collections.unmodifiableList(list);
    }

    private void sortQueries(List<QueryHandle> list) {
        Collections.sort(list, new Comparator<QueryHandle>(){

            @Override
            public int compare(QueryHandle queryHandle, QueryHandle queryHandle2) {
                if (queryHandle == null && queryHandle == null) {
                    return 0;
                }
                if (queryHandle2 == null) {
                    return 1;
                }
                if (queryHandle == null) {
                    return -1;
                }
                boolean bl = false;
                boolean bl2 = false;
                if (queryHandle instanceof QueryDescriptor && ((QueryDescriptor)queryHandle).isPredefined()) {
                    bl = true;
                }
                if (queryHandle2 instanceof QueryDescriptor && ((QueryDescriptor)queryHandle2).isPredefined()) {
                    bl2 = true;
                }
                if (bl && !bl2) {
                    return -1;
                }
                if (bl && !bl2) {
                    return 1;
                }
                return queryHandle.getDisplayName().compareTo(queryHandle2.getDisplayName());
            }
        });
    }

    private List<QueryHandle> getQueriesForNoRepo(ProjectHandle projectHandle) {
        FakeJiraSupport fakeJiraSupport = FakeJiraSupport.get(projectHandle);
        if (fakeJiraSupport != null) {
            return fakeJiraSupport.getQueries();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryHandle> getQueryHandles(ProjectHandle projectHandle, Query ... queryArray) {
        ArrayList<QueryHandle> arrayList = new ArrayList<QueryHandle>();
        Map<String, Map<String, QueryHandle>> map = this.queryHandles;
        synchronized (map) {
            Object object;
            Object object2;
            Map<String, QueryHandle> map2 = this.queryHandles.get(projectHandle.getId());
            if (map2 == null) {
                map2 = new HashMap<String, QueryHandle>();
                this.queryHandles.put(projectHandle.getId(), map2);
            } else {
                Query[] queryArray2 = new ArrayList();
                Query[] queryArray3 = queryArray;
                int n = queryArray3.length;
                for (int i = 0; i < n; ++i) {
                    object2 = queryArray3[i];
                    if (object2 == null) continue;
                    object = ((Query)object2).getDisplayName();
                    queryArray2.add(object);
                }
                map2.keySet().retainAll((Collection<?>)queryArray2);
            }
            for (Query query : queryArray) {
                object2 = query.getDisplayName();
                object = map2.get(object2);
                if (object == null) {
                    Issue[] issueArray = query.getIssues();
                    object = issueArray != null && issueArray.length > 0 ? this.createQueryHandle(query, false) : this.createQueryHandle(query, true);
                    map2.put((String)object2, (QueryHandle)object);
                }
                arrayList.add((QueryHandle)object);
            }
        }
        this.sortQueries(arrayList);
        return arrayList;
    }

    private QueryHandleImpl createQueryHandle(Query query, boolean bl) {
        Repository repository = query.getRepository();
        KenaiSupport kenaiSupport = (KenaiSupport)repository.getLookup().lookup(KenaiSupport.class);
        boolean bl2 = false;
        if (kenaiSupport != null) {
            boolean bl3 = kenaiSupport.needsLogin(query);
            boolean bl4 = bl2 = kenaiSupport.getAllIssuesQuery(repository) == query || kenaiSupport.getMyIssuesQuery(repository) == query;
            if (bl3) {
                return new LoginAwareQueryHandle(query, bl, bl2);
            }
        }
        return new QueryHandleImpl(query, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProject(ProjectHandle projectHandle, List<QueryHandle> list) {
        ProjectHandleListener projectHandleListener;
        Map<String, ProjectHandleListener> map = this.projectListeners;
        synchronized (map) {
            projectHandleListener = this.projectListeners.get(projectHandle.getId());
        }
        if (projectHandleListener != null) {
            projectHandle.removePropertyChangeListener((PropertyChangeListener)projectHandleListener);
        }
        projectHandleListener = new ProjectHandleListener(projectHandle, list);
        projectHandle.addPropertyChangeListener((PropertyChangeListener)projectHandleListener);
        map = this.projectListeners;
        synchronized (map) {
            this.projectListeners.put(projectHandle.getId(), projectHandleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRepository(Repository repository, ProjectHandle projectHandle) {
        KenaiRepositoryListener kenaiRepositoryListener = null;
        Map<String, KenaiRepositoryListener> map = this.kenaiRepoListeners;
        synchronized (map) {
            kenaiRepositoryListener = this.kenaiRepoListeners.get(repository.getID());
            if (kenaiRepositoryListener == null) {
                kenaiRepositoryListener = new KenaiRepositoryListener(repository, projectHandle);
                repository.addPropertyChangeListener(kenaiRepositoryListener);
                this.kenaiRepoListeners.put(repository.getID(), kenaiRepositoryListener);
            }
        }
    }

    private List<QueryHandle> getQueryHandles(Repository repository, ProjectHandle projectHandle) {
        Query[] queryArray = repository.getQueries();
        if (queryArray == null) {
            return Collections.emptyList();
        }
        return this.getQueryHandles(projectHandle, queryArray);
    }

    public List<QueryResultHandle> getQueryResults(QueryHandle queryHandle) {
        if (queryHandle instanceof QueryHandleImpl) {
            QueryHandleImpl queryHandleImpl = (QueryHandleImpl)queryHandle;
            queryHandleImpl.refreshIfNeeded();
            return Collections.unmodifiableList(queryHandleImpl.getQueryResults());
        }
        if (queryHandle instanceof FakeJiraSupport.FakeJiraQueryHandle) {
            FakeJiraSupport.FakeJiraQueryHandle fakeJiraQueryHandle = (FakeJiraSupport.FakeJiraQueryHandle)queryHandle;
            return fakeJiraQueryHandle.getQueryResults();
        }
        return Collections.emptyList();
    }

    public Action getFindIssueAction(ProjectHandle projectHandle) {
        final Repository repository = KenaiRepositoryUtils.getInstance().getRepository(projectHandle);
        if (repository == null) {
            FakeJiraSupport fakeJiraSupport = FakeJiraSupport.get(projectHandle);
            if (fakeJiraSupport != null) {
                return new ActionWrapper(fakeJiraSupport.getOpenProjectListener());
            }
            return null;
        }
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!KenaiUtil.isLoggedIn() && KenaiSupport.BugtrackingType.JIRA == QueryAccessorImpl.this.getBugtrackingType(repository) && !KenaiUtil.showLogin()) {
                    return;
                }
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    public void run() {
                        QueryAction.openQuery(null, repository, true);
                    }
                });
            }
        };
    }

    public Action getCreateIssueAction(ProjectHandle projectHandle) {
        final Repository repository = KenaiRepositoryUtils.getInstance().getRepository(projectHandle);
        if (repository == null) {
            FakeJiraSupport fakeJiraSupport = FakeJiraSupport.get(projectHandle);
            if (fakeJiraSupport != null) {
                return new ActionWrapper(fakeJiraSupport.getCreateIssueListener());
            }
            return null;
        }
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!KenaiUtil.isLoggedIn() && KenaiSupport.BugtrackingType.JIRA == QueryAccessorImpl.this.getBugtrackingType(repository) && !KenaiUtil.showLogin()) {
                    return;
                }
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    public void run() {
                        IssueAction.openIssue(repository);
                    }
                });
            }
        };
    }

    public Action getOpenQueryResultAction(QueryResultHandle queryResultHandle) {
        if (queryResultHandle instanceof QueryResultHandleImpl || queryResultHandle instanceof FakeJiraSupport.FakeJiraQueryResultHandle) {
            return new ActionWrapper((ActionListener)queryResultHandle);
        }
        return null;
    }

    public Action getDefaultAction(QueryHandle queryHandle) {
        if (queryHandle instanceof QueryHandleImpl || queryHandle instanceof FakeJiraSupport.FakeJiraQueryHandle) {
            return new ActionWrapper((ActionListener)queryHandle);
        }
        return null;
    }

    void fireQueriesChanged(ProjectHandle projectHandle, List<QueryHandle> list) {
        this.fireQueryListChanged(projectHandle, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("refreshRequest")) {
            Map<String, Object> map = this.projectListeners;
            synchronized (map) {
                this.projectListeners.clear();
            }
            map = this.kenaiRepoListeners;
            synchronized (map) {
                this.kenaiRepoListeners.clear();
            }
            map = this.queryHandles;
            synchronized (map) {
                this.queryHandles.clear();
                return;
            }
        }
        if (!propertyChangeEvent.getPropertyName().equals("login")) return;
        if (propertyChangeEvent.getNewValue() == null) {
            ProjectHandleListener[] projectHandleListenerArray = this.projectListeners;
            synchronized (this.projectListeners) {
                ProjectHandleListener[] projectHandleListenerArray2 = this.projectListeners.values().toArray(new ProjectHandleListener[this.projectListeners.values().size()]);
                // ** MonitorExit[var3_6] (shouldn't be in output)
                for (ProjectHandleListener projectHandleListener : projectHandleListenerArray2) {
                    projectHandleListener.closeQueries();
                }
            }
        } else {
            String string = this.getKenaiUser();
            if (!string.equals(this.lastLoggedUser)) {
                for (Map<String, QueryHandle> map : this.queryHandles.values()) {
                    for (QueryHandle queryHandle : map.values()) {
                        if (!(queryHandle instanceof LoginAwareQueryHandle)) continue;
                        ((LoginAwareQueryHandle)queryHandle).needsRefresh();
                    }
                }
            }
            string = this.lastLoggedUser;
        }
        {
            this.refreshKenaiQueries();
            return;
        }
    }

    private void refreshKenaiQueries() {
        Set<QueryTopComponent> set = QueryTopComponent.getOpenQueries();
        for (QueryTopComponent queryTopComponent : set) {
            queryTopComponent.updateSavedQueries();
        }
    }

    private KenaiSupport.BugtrackingType getBugtrackingType(Repository repository) {
        KenaiSupport kenaiSupport = (KenaiSupport)repository.getLookup().lookup(KenaiSupport.class);
        if (kenaiSupport != null) {
            return kenaiSupport.getType();
        }
        assert (false) : "no KenaiSupport available for repository [" + repository.getDisplayName() + "]";
        return null;
    }

    private String getKenaiUser() {
        PasswordAuthentication passwordAuthentication = KenaiUtil.getPasswordAuthentication(false);
        return passwordAuthentication != null ? passwordAuthentication.getUserName() : null;
    }

    private static class ActionWrapper
    extends AbstractAction {
        private final ActionListener al;

        public ActionWrapper(ActionListener actionListener) {
            this.al = actionListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.al.actionPerformed(actionEvent);
        }
    }

    private class KenaiRepositoryListener
    implements PropertyChangeListener {
        private final ProjectHandle ph;
        private Repository repo;

        public KenaiRepositoryListener(Repository repository, ProjectHandle projectHandle) {
            this.ph = projectHandle;
            this.repo = repository;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("bugtracking.repository.queries.changed")) {
                QueryAccessorImpl.this.fireQueriesChanged(this.ph, QueryAccessorImpl.this.getQueryHandles(this.repo, this.ph));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoginAwareQueryHandle
    extends QueryHandleImpl {
        private String notLoggedIn;

        public LoginAwareQueryHandle(Query query, boolean bl, boolean bl2) {
            super(query, bl, bl2);
            this.notLoggedIn = NbBundle.getMessage(QueryAccessorImpl.class, (String)"LBL_NotLoggedIn");
        }

        @Override
        public String getDisplayName() {
            return super.getDisplayName() + (KenaiUtil.isLoggedIn() ? "" : " " + this.notLoggedIn);
        }

        @Override
        List<QueryResultHandle> getQueryResults() {
            return KenaiUtil.isLoggedIn() ? super.getQueryResults() : Collections.EMPTY_LIST;
        }

        @Override
        void refreshIfNeeded() {
            if (!KenaiUtil.isLoggedIn()) {
                return;
            }
            super.refreshIfNeeded();
        }

        void needsRefresh() {
            this.needsRefresh = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectHandleListener
    implements PropertyChangeListener {
        private List<QueryHandle> queries;
        private ProjectHandle ph;

        public ProjectHandleListener(ProjectHandle projectHandle, List<QueryHandle> list) {
            this.queries = list;
            this.ph = projectHandle;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("close")) {
                this.closeQueries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeQueries() {
            for (QueryHandle queryHandle : this.queries) {
                if (!(queryHandle instanceof QueryHandleImpl)) continue;
                QueryAction.closeQuery(((QueryHandleImpl)queryHandle).getQuery());
            }
            Map map = QueryAccessorImpl.this.projectListeners;
            synchronized (map) {
                this.ph.removePropertyChangeListener((PropertyChangeListener)this);
                QueryAccessorImpl.this.projectListeners.remove(this.ph.getId());
            }
        }
    }
}

