/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bugtracking.kenai.QueryDescriptor;
import org.netbeans.modules.bugtracking.kenai.QueryResultHandleImpl;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHandleImpl
extends QueryHandle
implements QueryDescriptor,
ActionListener,
PropertyChangeListener {
    private final Query query;
    private final PropertyChangeSupport changeSupport;
    protected final boolean predefined;
    private Issue[] issues = new Issue[0];
    private String stringValue;
    protected boolean needsRefresh;

    QueryHandleImpl(Query query, boolean bl, boolean bl2) {
        this.query = query;
        this.needsRefresh = bl;
        this.predefined = bl2;
        this.changeSupport = new PropertyChangeSupport(query);
        query.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)query));
        this.registerIssues();
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public boolean isPredefined() {
        return this.predefined;
    }

    public String getDisplayName() {
        return this.query.getDisplayName();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        QueryAction.openQuery(this.query, null, true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("bugtracking.query.issues_changed")) {
            this.registerIssues();
            this.changeSupport.firePropertyChange(new PropertyChangeEvent(this, "queryResult", null, this.getQueryResults()));
        } else if (propertyChangeEvent.getPropertyName().equals("issue.seen_changed")) {
            this.changeSupport.firePropertyChange(new PropertyChangeEvent(this, "queryResult", null, this.getQueryResults()));
        }
    }

    List<QueryResultHandle> getQueryResults() {
        ArrayList<QueryResultHandle> arrayList = new ArrayList<QueryResultHandle>();
        QueryResultHandleImpl queryResultHandleImpl = QueryResultHandleImpl.forStatus(this.query, 14);
        if (queryResultHandleImpl != null) {
            arrayList.add(queryResultHandleImpl);
        }
        if ((queryResultHandleImpl = QueryResultHandleImpl.forStatus(this.query, 12)) != null) {
            arrayList.add(queryResultHandleImpl);
        }
        if ((queryResultHandleImpl = QueryResultHandleImpl.getAllChangedResult(this.query)) != null) {
            arrayList.add(queryResultHandleImpl);
        }
        return arrayList;
    }

    synchronized void refreshIfNeeded() {
        if (this.needsRefresh) {
            this.needsRefresh = false;
            this.query.refresh();
        }
    }

    private void registerIssues() {
        for (Issue issue : this.issues = this.query.getIssues(14)) {
            issue.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)issue));
            IssueCacheUtils.addCacheListener(issue, this);
        }
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append(this.query.getRepository().getDisplayName());
            stringBuffer.append(",");
            stringBuffer.append(this.query.getDisplayName());
            stringBuffer.append("]");
            this.stringValue = stringBuffer.toString();
        }
        return this.stringValue;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryHandleImpl queryHandleImpl = (QueryHandleImpl)object;
        return !(this.toString() == null ? queryHandleImpl.toString() != null : !this.toString().equals(queryHandleImpl.toString()));
    }
}

