/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchPopup;

public class QuickSearchComboBar
extends JPanel {
    private QuickSearchPopup displayer;
    private Color origForeground;
    private JPanel caller;
    private PropertyChangeSupport changeSupport;
    public static final String EVT_ISSUE_CHANGED = "QuickSearchComboBar.issue.changed";
    private JComboBox command;

    public QuickSearchComboBar(JPanel jPanel) {
        this.caller = jPanel;
        this.initComponents();
        this.command.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof Issue) {
                    Issue issue = (Issue)object;
                    object = PopupItem.IssueItem.getIssueDescription(issue);
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.command.setEditor(new ComboEditor(this.command.getEditor()));
        this.displayer = new QuickSearchPopup(this);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public Issue getIssue() {
        return (Issue)this.command.getEditor().getItem();
    }

    public void setRepository(Repository repository) {
        this.displayer.setRepository(repository);
        List<Issue> list = BugtrackingManager.getInstance().getRecentIssues(repository);
        this.command.setModel(new DefaultComboBoxModel<Issue>(list.toArray(new Issue[list.size()])));
        this.command.setSelectedItem(null);
    }

    void setIssue(Issue issue) {
        if (issue != null) {
            this.command.getEditor().setItem(issue);
            this.displayer.setVisible(false);
        }
    }

    private void initComponents() {
        this.command = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.setName("Form");
        this.setOpaque(false);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                QuickSearchComboBar.this.formFocusLost(focusEvent);
            }
        });
        this.command.setEditable(true);
        this.command.setName("command");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.command, 0, 353, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.command, -2, -1, -2));
    }

    private void formFocusLost(FocusEvent focusEvent) {
        this.displayer.setVisible(false);
    }

    private void returnFocus() {
        this.displayer.setVisible(false);
        if (this.caller != null) {
            this.caller.requestFocus();
        }
    }

    public void enableFields(boolean bl) {
        this.command.setEnabled(bl);
    }

    public void invokeSelectedItem() {
        JList jList = this.displayer.getList();
        if (jList.getModel().getSize() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JList jList = QuickSearchComboBar.this.displayer.getList();
                    if (jList.getSelectedIndex() == -1) {
                        jList.setSelectedIndex(jList.getModel().getSize() - 1);
                    }
                    QuickSearchComboBar.this.displayer.invoke();
                }
            });
        }
    }

    private PropertyChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport;
    }

    public void setNoResults(boolean bl) {
        if (this.command == null || this.origForeground == null) {
            return;
        }
        if (this.command.getForeground().equals(((JTextField)this.command.getEditor().getEditorComponent()).getDisabledTextColor())) {
            return;
        }
        this.command.setForeground(bl ? Color.RED : this.origForeground);
    }

    public void requestFocus() {
        super.requestFocus();
        this.command.requestFocus();
    }

    public Component getIssueComponent() {
        return this.command;
    }

    String getText() {
        return ((JTextField)this.command.getEditor().getEditorComponent()).getText();
    }

    static Color getPopupBorderColor() {
        Color color = UIManager.getColor("controlShadow");
        return color != null ? color : Color.GRAY;
    }

    static Color getTextBackground() {
        Color color = UIManager.getColor("TextPane.background");
        return color != null ? color : Color.WHITE;
    }

    static Color getResultBackground() {
        return QuickSearchComboBar.getTextBackground();
    }

    boolean isTextFieldFocusOwner() {
        return this.command.getEditor().getEditorComponent().isFocusOwner();
    }

    private class ComboEditor
    implements ComboBoxEditor {
        private final JTextField editor;
        private Issue issue;
        private boolean ignoreCommandChanges = false;
        private final ComboBoxEditor delegate;

        public ComboEditor(ComboBoxEditor comboBoxEditor) {
            this.delegate = comboBoxEditor;
            this.editor = (JTextField)comboBoxEditor.getEditorComponent();
            this.editor.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                private void textChanged() {
                    if (ComboEditor.this.ignoreCommandChanges) {
                        return;
                    }
                    if (QuickSearchComboBar.this.isTextFieldFocusOwner()) {
                        if (!ComboEditor.this.editor.getText().equals("")) {
                            QuickSearchComboBar.this.command.hidePopup();
                        }
                        QuickSearchComboBar.this.displayer.maybeEvaluate(ComboEditor.this.editor.getText());
                    }
                    ComboEditor.this.setItem(null, true);
                }
            });
            this.editor.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    ComboEditor.this.commandKeyPressed(keyEvent);
                }
            });
        }

        public Component getEditorComponent() {
            return this.editor;
        }

        private void setItem(Object object, boolean bl) {
            Issue issue = this.issue;
            if (object == null) {
                this.issue = null;
                if (!bl) {
                    this.editor.setText("");
                }
            } else if (object instanceof Issue) {
                this.issue = (Issue)object;
                this.ignoreCommandChanges = true;
                if (!bl) {
                    this.editor.setText(PopupItem.IssueItem.getIssueDescription(this.issue));
                }
                this.ignoreCommandChanges = false;
            }
            if (issue != null || this.issue != null) {
                QuickSearchComboBar.this.getChangeSupport().firePropertyChange(QuickSearchComboBar.EVT_ISSUE_CHANGED, issue, this.issue);
            }
        }

        public void setItem(Object object) {
            this.setItem(object, false);
        }

        public Object getItem() {
            return this.issue;
        }

        public void selectAll() {
            this.delegate.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.delegate.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.delegate.removeActionListener(actionListener);
        }

        private void commandKeyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 40) {
                if (QuickSearchComboBar.this.displayer.isVisible()) {
                    QuickSearchComboBar.this.displayer.selectNext();
                    keyEvent.consume();
                }
            } else if (keyEvent.getKeyCode() == 38) {
                if (QuickSearchComboBar.this.displayer.isVisible()) {
                    QuickSearchComboBar.this.displayer.selectPrev();
                    keyEvent.consume();
                }
            } else if (keyEvent.getKeyCode() == 10) {
                if (QuickSearchComboBar.this.displayer.isVisible()) {
                    keyEvent.consume();
                    QuickSearchComboBar.this.invokeSelectedItem();
                }
            } else if (keyEvent.getKeyCode() == 27 && QuickSearchComboBar.this.displayer.isVisible()) {
                QuickSearchComboBar.this.returnFocus();
                QuickSearchComboBar.this.displayer.clearModel();
                keyEvent.consume();
            }
        }
    }
}

