/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.ui.search.ResultsModel;
import org.netbeans.modules.bugtracking.ui.search.SearchResultRenderer;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSearchPopup
extends JPanel
implements ListDataListener,
ActionListener,
TaskListener,
Runnable {
    private QuickSearchComboBar comboBar;
    private ResultsModel rModel;
    private Rectangle popupBounds = new Rectangle();
    private static final int[] COALESCE_TIMES = new int[]{150, 400, 300, 200};
    private Timer updateTimer;
    private String searchedText;
    private RequestProcessor.Task evalTask;
    private Repository repository;
    private RequestProcessor rp;
    private List<PopupItem> currentHitlist;
    private JLabel hintLabel;
    private JSeparator hintSep;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JLabel noResultsLabel;
    private JLabel searchingLabel;
    private JSeparator searchingSep;
    private JPanel statusPanel;

    public QuickSearchPopup(QuickSearchComboBar quickSearchComboBar) {
        this.comboBar = quickSearchComboBar;
        this.initComponents();
        this.hintLabel.setVisible(false);
        this.hintSep.setVisible(false);
        this.rModel = ResultsModel.getInstance();
        this.jList1.setModel(this.rModel);
        this.jList1.setCellRenderer(new SearchResultRenderer(quickSearchComboBar, this));
        this.rp = new RequestProcessor("Bugtracking quick issue search", 1, true);
        this.setVisible(false);
        this.updateStatusPanel();
    }

    @Override
    public void addNotify() {
        this.rModel.addListDataListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.rModel.removeListDataListener(this);
        super.removeNotify();
    }

    void invoke() {
        int n = this.jList1.getSelectedIndex();
        ListModel listModel = this.jList1.getModel();
        Object e = listModel.getElementAt(n);
        if (e == null) {
            return;
        }
        if (e instanceof PopupItem.IssueItem) {
            Issue issue = ((PopupItem.IssueItem)e).getIssue();
            if (issue != null) {
                this.comboBar.setIssue(issue);
                this.clearModel();
            }
        } else {
            PopupItem popupItem = (PopupItem)e;
            popupItem.invoke();
        }
    }

    void selectNext() {
        int n = this.jList1.getSelectedIndex();
        if (n >= 0 && n < this.jList1.getModel().getSize() - 1) {
            int n2 = n + 1;
            this.jList1.setSelectedIndex(n2);
            this.jList1.scrollRectToVisible(this.jList1.getCellBounds(n2, n2));
        } else if (n < 0 && this.rModel.getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
    }

    void selectPrev() {
        int n = this.jList1.getSelectedIndex();
        if (n > 0) {
            int n2 = n - 1;
            this.jList1.setSelectedIndex(n2);
            this.jList1.scrollRectToVisible(this.jList1.getCellBounds(n2, n2));
        }
    }

    public JList getList() {
        return this.jList1;
    }

    public void clearModel() {
        this.rModel.setContent(null);
    }

    public void cancel() {
        this.cancelTask();
        this.rModel.setContent(null);
    }

    private void cancelTask() {
        if (this.evalTask != null) {
            this.evalTask.removeTaskListener((TaskListener)this);
            this.evalTask.cancel();
            this.updateTimer.stop();
        }
    }

    public void maybeEvaluate(String string) {
        this.searchedText = string;
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(200, this);
        }
        if (!this.updateTimer.isRunning()) {
            this.updateTimer.setDelay(COALESCE_TIMES[Math.min(string.length(), 3)]);
            this.updateTimer.start();
        } else {
            this.updateTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateTimer.stop();
        if (this.comboBar.isTextFieldFocusOwner()) {
            this.runTask(new Runnable(){

                public void run() {
                    QuickSearchPopup.this.searchLocalIssues();
                }
            });
        }
    }

    void setRepository(Repository repository) {
        this.repository = repository;
    }

    private void runTask(Runnable runnable) {
        this.cancelTask();
        this.evalTask = this.rp.create(runnable);
        this.evalTask.addTaskListener((TaskListener)this);
        this.evalTask.schedule(0);
    }

    private void searchLocalIssues() {
        Query[] queryArray;
        String string = this.comboBar.getText();
        if (string.equals("")) {
            this.rModel.setContent(null);
            return;
        }
        this.currentHitlist = new ArrayList<PopupItem>();
        HashSet<String> hashSet = new HashSet<String>();
        this.addIssues(BugtrackingUtil.getByIdOrSummary(BugtrackingUtil.getOpenIssues(), string), hashSet);
        for (Query query : queryArray = this.repository.getQueries()) {
            Issue[] issueArray = query.getIssues(string);
            this.addIssues(issueArray, hashSet);
        }
        this.addIssues(BugtrackingUtil.getByIdOrSummary(ResultsModel.getInstance().getCachedIssues(this.repository), string), hashSet);
        this.populateModel(string, false, true);
    }

    private void addIssues(Issue[] issueArray, Set<String> set) {
        if (issueArray == null) {
            return;
        }
        for (Issue issue : issueArray) {
            if (set.contains(issue.getID())) continue;
            this.currentHitlist.add(new PopupItem.IssueItem(issue));
            set.add(issue.getID());
        }
    }

    private void populateModel(final String string, boolean bl, final boolean bl2) {
        ArrayList<PopupItem> arrayList = new ArrayList<PopupItem>();
        for (PopupItem popupItem : this.currentHitlist) {
            arrayList.add(popupItem);
            if (arrayList.size() <= 4 || bl) continue;
            arrayList.add(new PopupItem(){

                void invoke() {
                    QuickSearchPopup.this.populateModel(string, true, bl2);
                }

                String getDisplayText() {
                    return "...";
                }
            });
            break;
        }
        if (bl2) {
            arrayList.add(new SearchItem(string));
        }
        this.rModel.setContent(arrayList);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.statusPanel = new JPanel();
        this.searchingSep = new JSeparator();
        this.searchingLabel = new JLabel();
        this.noResultsLabel = new JLabel();
        this.hintSep = new JSeparator();
        this.hintLabel = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(QuickSearchComboBar.getPopupBorderColor()));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 150));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jList1.setFocusable(false);
        this.jList1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                QuickSearchPopup.this.jList1MouseMoved(mouseEvent);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                QuickSearchPopup.this.jList1MouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusPanel.setBackground(QuickSearchComboBar.getResultBackground());
        this.statusPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.searchingSep, gridBagConstraints);
        this.searchingLabel.setText(NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.searchingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.statusPanel.add((Component)this.searchingLabel, gridBagConstraints);
        this.noResultsLabel.setForeground(Color.red);
        this.noResultsLabel.setHorizontalAlignment(0);
        this.noResultsLabel.setText(NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.noResultsLabel.text"));
        this.noResultsLabel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.noResultsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.hintSep, gridBagConstraints);
        this.hintLabel.setBackground(QuickSearchComboBar.getResultBackground());
        this.hintLabel.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.statusPanel.add((Component)this.hintLabel, gridBagConstraints);
        this.add((Component)this.statusPanel, "Last");
    }

    private void jList1MouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.jList1.locationToIndex(point);
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.jList1.getCellBounds(n, n);
        if (rectangle != null && rectangle.contains(point)) {
            this.jList1.setSelectedIndex(n);
        }
    }

    private void jList1MouseClicked(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.invoke();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updatePopup();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updatePopup();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updatePopup();
    }

    public void updatePopup() {
        int n = this.rModel.getSize();
        JLayeredPane jLayeredPane = JLayeredPane.getLayeredPaneAbove(this.comboBar);
        if (!this.isDisplayable() && jLayeredPane != null) {
            jLayeredPane.add((Component)this, new Integer(JLayeredPane.POPUP_LAYER + 1));
        }
        boolean bl = this.updateStatusPanel();
        if (jLayeredPane != null) {
            this.computePopupBounds(this.popupBounds, jLayeredPane, n);
            this.setBounds(this.popupBounds);
        }
        if ((n > 0 || bl) && this.comboBar.isTextFieldFocusOwner()) {
            if (this.jList1.getSelectedIndex() >= n) {
                this.jList1.setSelectedIndex(n - 1);
            }
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.revalidate();
    }

    public int getResultWidth() {
        return this.comboBar.getWidth();
    }

    public void taskFinished(Task task) {
        this.evalTask = null;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.updatePopup();
    }

    private void computePopupBounds(Rectangle rectangle, JLayeredPane jLayeredPane, int n) {
        Point point = new Point(this.comboBar.getIssueComponent().getX(), this.comboBar.getIssueComponent().getY() + this.comboBar.getIssueComponent().getHeight() - 1);
        point = SwingUtilities.convertPoint(this.comboBar, point, jLayeredPane);
        rectangle.setLocation(point);
        this.jList1.setFixedCellHeight(15);
        this.jList1.setFixedCellHeight(-1);
        this.jList1.setVisibleRowCount(n);
        Dimension dimension = this.jList1.getPreferredSize();
        dimension.width = this.comboBar.getIssueComponent().getWidth();
        dimension.height += this.statusPanel.getPreferredSize().height + 3;
        if (dimension.height > 150) {
            dimension.height = 150;
        }
        rectangle.setSize(dimension);
    }

    private static int computeWidth(JComponent jComponent, int n, int n2) {
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        int n3 = fontMetrics.charWidth('X');
        int n4 = n3 * n;
        Window window = SwingUtilities.windowForComponent(jComponent);
        if (window != null) {
            n4 = Math.min(n4, window.getWidth() * n2 / 100);
        }
        return n4;
    }

    private boolean updateStatusPanel() {
        boolean bl = false;
        boolean bl2 = this.evalTask != null;
        this.searchingSep.setVisible(bl2 && this.rModel.getSize() > 0);
        this.searchingLabel.setVisible(bl2);
        bl = bl || bl2;
        boolean bl3 = this.searchedText != null && this.searchedText.trim().length() > 0;
        boolean bl4 = this.rModel.getSize() <= 0 && bl3 && !bl2;
        this.noResultsLabel.setVisible(bl4);
        this.comboBar.setNoResults(bl4);
        bl = bl || bl4;
        Issue issue = this.comboBar.getIssue();
        String string = issue != null ? PopupItem.IssueItem.getIssueDescription(issue).trim() : "";
        bl = bl && (issue == null || !string.equals(this.comboBar.getText().trim()));
        return bl;
    }

    private class SearchItem
    extends PopupItem {
        private String criteria;

        public SearchItem(String string) {
            this.criteria = string;
        }

        void invoke() {
            QuickSearchPopup.this.runTask(new Runnable(){

                public void run() {
                    QuickSearchPopup.this.clearModel();
                    QuickSearchPopup.this.currentHitlist = new ArrayList();
                    HashSet hashSet = new HashSet();
                    QuickSearchPopup.this.addIssues(BugtrackingUtil.getByIdOrSummary(BugtrackingUtil.getOpenIssues(), SearchItem.this.criteria), hashSet);
                    Issue[] issueArray = QuickSearchPopup.this.repository.simpleSearch(SearchItem.this.criteria);
                    QuickSearchPopup.this.addIssues(issueArray, hashSet);
                    QuickSearchPopup.this.populateModel(SearchItem.this.criteria, false, QuickSearchPopup.this.currentHitlist.size() > 0);
                    ResultsModel.getInstance().cacheIssues(QuickSearchPopup.this.repository, issueArray);
                }
            });
        }

        String getDisplayText() {
            return NbBundle.getMessage(PopupItem.class, (String)"LBL_SearchCommand");
        }
    }
}

