/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.net.URI;

public class WebUrlHyperlinkSupport {
    public static int[] findBoundaries(String string) {
        return new SearchMachine(string).findBoundaries();
    }

    static final class SearchMachine {
        private static final String URI_INIT_CHARS = " <[(\"'";
        private static final String GEN_DELIMS = ":/?#[]@";
        private static final String SUB_DELIMS = "!$&'()*+,;=";
        private static final String RESERVED = ":/?#[]@!$&'()*+,;=";
        private static final String PUNCT_CHARS = ".,:;()[]{}";
        private static final String[] SUPPORTED_SCHEMES = new String[]{"http", "https"};
        private static final int LOWER_A = 97;
        private static final int LOWER_F = 97;
        private static final int LOWER_Z = 122;
        private State state = State.INIT;
        private final CharSequence text;
        int[] result;
        int start;
        int end;

        SearchMachine(CharSequence charSequence) {
            this.text = charSequence;
            this.reset();
        }

        private void reset() {
            this.state = State.INIT;
            this.start = -1;
            this.end = -1;
            this.result = null;
        }

        int[] findBoundaries() {
            int n = this.text.length();
            if (n == 0) {
                return new int[0];
            }
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n15 = 0;
            for (int i = 0; i < n; ++i) {
                boolean bl4 = false;
                if (bl3) {
                    --i;
                    bl3 = false;
                }
                char c = this.text.charAt(i);
                State state = null;
                if (n9 != 0) {
                    if (!SearchMachine.isHexDigit(c)) continue;
                    --n9;
                    state = this.state;
                    continue;
                }
                switch (this.state) {
                    case WAITING_FOR_URI_END_CHAR: {
                        if (SearchMachine.isUriEndChar(c)) {
                            if (SearchMachine.isInitChar(c)) {
                                state = State.INIT;
                                bl3 = true;
                                break;
                            }
                            state = State.WAITING_FOR_INIT_CHAR;
                            break;
                        }
                        state = State.WAITING_FOR_URI_END_CHAR;
                        break;
                    }
                    case WAITING_FOR_INIT_CHAR: {
                        if (SearchMachine.isInitChar(c)) {
                            state = State.INIT;
                            bl3 = true;
                            break;
                        }
                        state = State.WAITING_FOR_INIT_CHAR;
                        break;
                    }
                    case INIT: {
                        if (SearchMachine.isLetter(c)) {
                            state = State.SCHEME;
                            n2 = i;
                            this.rememberIsStart(i);
                            break;
                        }
                        if (SearchMachine.isInitChar(c)) {
                            state = State.INIT;
                            break;
                        }
                        state = State.WAITING_FOR_INIT_CHAR;
                        break;
                    }
                    case SCHEME: {
                        if (c == ':') {
                            state = State.HIER_START;
                            bl4 = true;
                            break;
                        }
                        if (!SearchMachine.isSchemeChar(c)) break;
                        state = State.SCHEME;
                        break;
                    }
                    case HIER_START: {
                        if (c == '/') {
                            n6 = i;
                            state = State.HIER_SLASH;
                            bl4 = true;
                            break;
                        }
                        if (!SearchMachine.isPathSegmentChar(c)) break;
                        if (c == '%') {
                            n9 = 2;
                        } else if (c == '(') {
                            ++n15;
                        }
                        n6 = i;
                        state = State.PATH;
                        bl4 = true;
                        break;
                    }
                    case HIER_SLASH: {
                        if (c == '/') {
                            n6 = -1;
                            n3 = i + 1;
                            state = State.USERINFO_OR_HOST_START;
                            bl4 = true;
                            break;
                        }
                        if (!SearchMachine.isPathSegmentChar(c)) break;
                        if (c == '%') {
                            n9 = 2;
                        } else if (c == '(') {
                            ++n15;
                        }
                        state = State.PATH;
                        bl4 = true;
                        break;
                    }
                    case USERINFO_OR_HOST_START: {
                        if (c == ':') {
                            n5 = i + 1;
                            state = State.USERINFO_OR_PORT_NUMBER;
                            bl4 = true;
                            break;
                        }
                        if (SearchMachine.isDigit(c)) {
                            n10 = 1;
                            n11 = 1;
                            n12 = c - 48;
                            n4 = i;
                            state = State.USERINFO_OR_IPV4_OR_REGNAME;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                n9 = 2;
                            } else if (c == '(') {
                                ++n15;
                            }
                            n4 = i;
                            state = State.USERINFO_OR_REGNAME;
                            bl4 = true;
                            break;
                        }
                        if (c == '@') {
                            n4 = i + 1;
                            state = State.HOST_START;
                            bl4 = true;
                            break;
                        }
                        if (c == '[') {
                            n4 = i;
                            state = State.IP_LITERAL_START;
                            break;
                        }
                        if (c == '/') {
                            n6 = i;
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        n8 = i + 1;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case USERINFO_OR_IPV4_OR_REGNAME: {
                        if (c == ':') {
                            n5 = i + 1;
                            state = State.USERINFO_OR_PORT_NUMBER;
                            bl4 = true;
                            break;
                        }
                        if (SearchMachine.isDigit(c)) {
                            state = ++n11 > 3 ? State.USERINFO_OR_REGNAME : (n11 < 3 ? State.USERINFO_OR_IPV4_OR_REGNAME : ((n12 = 10 * n12 + (c - 48)) <= 255 ? State.USERINFO_OR_IPV4_OR_REGNAME : State.USERINFO_OR_REGNAME));
                            bl4 = true;
                            break;
                        }
                        if (c == '.') {
                            if (++n10 > 4) {
                                state = State.USERINFO_OR_REGNAME;
                            } else if (n11 == 0) {
                                state = State.USERINFO_OR_REGNAME;
                            } else {
                                n11 = 0;
                                n12 = 0;
                                state = State.USERINFO_OR_IPV4_OR_REGNAME;
                            }
                            bl4 = true;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                n9 = 2;
                            } else if (c == '(') {
                                assert (n15 == 0);
                                ++n15;
                            }
                            state = State.USERINFO_OR_REGNAME;
                            bl4 = true;
                            break;
                        }
                        if (c == '@') {
                            n4 = i + 1;
                            state = State.HOST_START;
                            bl4 = true;
                            break;
                        }
                        if (c == '/') {
                            n6 = i;
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        n8 = i + 1;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case USERINFO_OR_REGNAME: {
                        if (c == ':') {
                            n15 = 0;
                            n5 = i + 1;
                            state = State.USERINFO_OR_PORT_NUMBER;
                            bl4 = true;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                n9 = 2;
                            } else if (c == '(') {
                                ++n15;
                            } else if (c == ')') {
                                --n15;
                            }
                            state = State.USERINFO_OR_REGNAME;
                            bl4 = true;
                            break;
                        }
                        if (c == '@') {
                            n15 = 0;
                            n4 = i + 1;
                            state = State.HOST_START;
                            bl4 = true;
                            break;
                        }
                        if (c == '/') {
                            n15 = 0;
                            n6 = i;
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            n15 = 0;
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        n15 = 0;
                        n8 = i + 1;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case USERINFO_OR_PORT_NUMBER: {
                        if (SearchMachine.isDigit(c)) {
                            state = State.USERINFO_OR_PORT_NUMBER;
                            bl4 = true;
                            break;
                        }
                        if (SearchMachine.isUserInfoChar(c)) {
                            n4 = -1;
                            n5 = -1;
                            state = State.USERINFO;
                            break;
                        }
                        if (c == '@') {
                            n4 = i + 1;
                            n5 = -1;
                            state = State.HOST_START;
                            bl4 = true;
                            break;
                        }
                        if (c == '/') {
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case USERINFO: {
                        if (SearchMachine.isUserInfoChar(c)) {
                            state = State.USERINFO;
                            break;
                        }
                        if (c != '@') break;
                        n4 = i + 1;
                        state = State.HOST_START;
                        bl4 = true;
                        break;
                    }
                    case HOST_START: {
                        if (SearchMachine.isDigit(c)) {
                            n10 = 1;
                            n11 = 1;
                            n12 = c - 48;
                            n4 = i;
                            state = State.IPV4_OR_REGNAME;
                            bl4 = true;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                n9 = 2;
                            } else if (c == '(') {
                                assert (n15 == 0);
                                ++n15;
                            }
                            n4 = i;
                            state = State.REGNAME;
                            bl4 = true;
                            break;
                        }
                        if (c == '[') {
                            n4 = i;
                            state = State.IP_LITERAL_START;
                            break;
                        }
                        if (c == '/') {
                            n6 = i;
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        n8 = i + 1;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case IPV4_OR_REGNAME: {
                        if (SearchMachine.isDigit(c)) {
                            state = ++n11 > 3 ? State.REGNAME : (n11 < 3 ? State.IPV4_OR_REGNAME : ((n12 = 10 * n12 + (c - 48)) <= 255 ? State.IPV4_OR_REGNAME : State.REGNAME));
                            bl4 = true;
                            break;
                        }
                        if (c == '.') {
                            if (++n10 > 4) {
                                state = State.REGNAME;
                            } else if (n11 == 0) {
                                state = State.REGNAME;
                            } else {
                                n11 = 0;
                                n12 = 0;
                                state = State.IPV4_OR_REGNAME;
                            }
                            bl4 = true;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                n9 = 2;
                            } else if (c == '(') {
                                assert (n15 == 0);
                                ++n15;
                            }
                            state = State.REGNAME;
                            bl4 = true;
                            break;
                        }
                        if (c == '/') {
                            n6 = i;
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        n8 = i + 1;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case REGNAME: {
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                n9 = 2;
                            } else if (c == '(') {
                                ++n15;
                            } else if (c == ')') {
                                --n15;
                            }
                            state = State.REGNAME;
                            bl4 = true;
                            break;
                        }
                        if (c == '/') {
                            n15 = 0;
                            n6 = i;
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            n15 = 0;
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        n15 = 0;
                        n8 = i + 1;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case IP_LITERAL_START: {
                        if (c == 'v' || c == 'V') {
                            state = State.IP_FUTURE_START;
                            break;
                        }
                        if (c == ':') {
                            state = State.IPV6_QDOT_1;
                            n13 = 0;
                            n14 = 0;
                            break;
                        }
                        if (!SearchMachine.isHexDigit(c)) break;
                        n13 = 1;
                        n14 = 1;
                        state = State.IPV6;
                        break;
                    }
                    case IPV6: {
                        int n16;
                        if (c == ':') {
                            int n17 = n16 = bl ? 7 : 8;
                            if (n13 >= n16) break;
                            state = State.IPV6_DDOT;
                            break;
                        }
                        if (SearchMachine.isHexDigit(c)) {
                            if (++n14 > 4) break;
                            state = State.IPV6;
                            break;
                        }
                        if (c != ']') break;
                        int n18 = bl ? (n13 < 8 ? 1 : 0) : (n16 = n13 == 8 ? 1 : 0);
                        if (n16 == 0) break;
                        state = State.PORT_NUMBER_OR_AUTHORITY_END;
                        bl4 = true;
                        break;
                    }
                    case IPV6_DDOT: {
                        if (c == ':') {
                            if (bl) break;
                            bl = true;
                            state = State.IPV6_QDOT_2;
                            break;
                        }
                        if (!SearchMachine.isHexDigit(c)) break;
                        ++n13;
                        n14 = 1;
                        state = State.IPV6;
                        break;
                    }
                    case IPV6_QDOT_1: {
                        if (c != ':') break;
                        bl = true;
                        state = State.IPV6_QDOT_2;
                        break;
                    }
                    case IPV6_QDOT_2: {
                        int n16;
                        if (SearchMachine.isHexDigit(c)) {
                            ++n13;
                            n14 = 1;
                            state = State.IPV6;
                            break;
                        }
                        if (c != ']') break;
                        int n19 = bl ? (n13 < 8 ? 1 : 0) : (n16 = n13 == 8 ? 1 : 0);
                        if (n16 == 0) break;
                        state = State.PORT_NUMBER_OR_AUTHORITY_END;
                        break;
                    }
                    case IP_FUTURE_START: {
                        if (!SearchMachine.isHexDigit(c)) break;
                        state = State.IP_FUTURE_VER_NUM;
                        break;
                    }
                    case IP_FUTURE_VER_NUM: {
                        if (c == '.') {
                            state = State.IP_FUTURE_ADDR_START;
                            break;
                        }
                        if (!SearchMachine.isHexDigit(c)) break;
                        state = State.IP_FUTURE_VER_NUM;
                        break;
                    }
                    case IP_FUTURE_ADDR_START: {
                        if (!SearchMachine.isIpFutureAddrChar(c)) break;
                        state = State.IP_FUTURE_ADDR;
                        break;
                    }
                    case IP_FUTURE_ADDR: {
                        if (SearchMachine.isIpFutureAddrChar(c)) {
                            state = State.IP_FUTURE_ADDR;
                            break;
                        }
                        if (c != ']') break;
                        state = State.PORT_NUMBER_OR_AUTHORITY_END;
                        bl4 = true;
                        break;
                    }
                    case PORT_NUMBER_OR_AUTHORITY_END: {
                        if (c == ':') {
                            state = State.PORT_NUMBER;
                            bl4 = true;
                            break;
                        }
                        if (c == '/') {
                            n6 = i;
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        n8 = i + 1;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case PORT_NUMBER: {
                        if (SearchMachine.isDigit(c)) {
                            state = State.PORT_NUMBER;
                            bl4 = true;
                            break;
                        }
                        if (c == '/') {
                            n6 = i;
                            state = State.PATH;
                            bl4 = true;
                            break;
                        }
                        if (c == '?') {
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c != '#') break;
                        n8 = i + 1;
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    case PATH: {
                        if (c == '?') {
                            n15 = 0;
                            n7 = i + 1;
                            state = State.QUERY;
                            bl4 = true;
                            break;
                        }
                        if (c == '#') {
                            n15 = 0;
                            n8 = i + 1;
                            state = State.FRAGMENT;
                            bl4 = true;
                            break;
                        }
                        if (c != '/' && !SearchMachine.isPathSegmentChar(c)) break;
                        if (c == '%') {
                            n9 = 2;
                        } else if (c == '(') {
                            ++n15;
                        } else if (c == ')') {
                            --n15;
                        }
                        state = State.PATH;
                        bl4 = true;
                        break;
                    }
                    case QUERY: {
                        if (c == '#') {
                            n15 = 0;
                            n8 = i + 1;
                            state = State.FRAGMENT;
                            bl4 = true;
                            break;
                        }
                        if (!SearchMachine.isQueryChar(c)) break;
                        if (c == '%') {
                            n9 = 2;
                        } else if (c == '(') {
                            ++n15;
                        } else if (c == ')') {
                            --n15;
                        }
                        state = State.QUERY;
                        bl4 = true;
                        break;
                    }
                    case FRAGMENT: {
                        if (!SearchMachine.isFragmentChar(c)) break;
                        if (c == '%') {
                            n9 = 2;
                        } else if (c == '(') {
                            ++n15;
                        } else if (c == ')') {
                            --n15;
                        }
                        state = State.FRAGMENT;
                        bl4 = true;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                bl4 &= n9 == 0;
                if (state == null) {
                    assert (!bl3);
                    if (SearchMachine.isUriEndChar(c)) {
                        if (bl2) {
                            assert (this.start != -1);
                            this.checkAndStoreResult(this.start, i, n15);
                        }
                        state = SearchMachine.isInitChar(c) ? State.INIT : State.WAITING_FOR_INIT_CHAR;
                    } else {
                        state = State.WAITING_FOR_URI_END_CHAR;
                    }
                    this.start = -1;
                }
                if (this.state != State.INIT && state == State.INIT) {
                    n2 = -1;
                    n3 = -1;
                    n4 = -1;
                    n5 = -1;
                    n6 = -1;
                    n7 = -1;
                    n8 = -1;
                    n9 = 0;
                    n15 = 0;
                }
                bl2 = bl4;
                this.state = state;
            }
            if (bl2) {
                assert (this.start != -1);
                if (n3 != -1) {
                    this.checkAndStoreResult(this.start, n, n15);
                }
            }
            return this.result;
        }

        private void rememberIsStart(int n) {
            this.start = n;
        }

        private void checkAndStoreResult(int n, int n2, int n3) {
            char c = this.text.charAt(n2 - 1);
            if (c == '.' || c == ',' || c == ':' || c == ';') {
                c = this.text.charAt(--n2 - 1);
            }
            if (n3 < 0 && c == ')') {
                c = this.text.charAt(--n2 - 1);
            }
            if (this.checkUrl(n, n2)) {
                this.storeResult(n, n2);
            }
        }

        private boolean checkUrl(int n, int n2) {
            String string = ((Object)this.text.subSequence(n, n2)).toString();
            try {
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    return false;
                }
                if (uRI.isOpaque()) {
                    return false;
                }
                String string2 = uRI.getScheme();
                if (!string2.equals("http") && !string2.equals("https")) {
                    return false;
                }
                uRI.toURL();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        private void storeResult(int n, int n2) {
            assert (n != -1);
            if (this.result == null) {
                this.result = new int[]{n, n2};
            } else {
                int[] nArray = new int[this.result.length + 2];
                System.arraycopy(this.result, 0, nArray, 0, this.result.length);
                nArray[this.result.length] = n;
                nArray[this.result.length + 1] = n2;
                this.result = nArray;
            }
        }

        private static boolean isSupportedScheme(String string) {
            for (String string2 : SUPPORTED_SCHEMES) {
                if (!string.equals(string2)) continue;
                return true;
            }
            return false;
        }

        private static State getInitialState(int n) {
            return SearchMachine.isInitChar(n) ? State.INIT : State.WAITING_FOR_INIT_CHAR;
        }

        private static boolean isInitChar(int n) {
            return n < 32 || URI_INIT_CHARS.indexOf(n) != -1 || n > 255 && Character.isSpaceChar(n);
        }

        private static boolean isUriEndChar(int n) {
            return n < 32 || n == 32 || n == 62 || n == 34 || n > 255 && Character.isSpaceChar(n);
        }

        private static boolean isSchemeChar(int n) {
            if (n >= 255) {
                return false;
            }
            return SearchMachine.isLetter(n) || SearchMachine.isDigit(n) || n == 43 || n == 45 || n == 46;
        }

        private static boolean isIpFutureAddrChar(int n) {
            return SearchMachine.isUnreserved(n) || SearchMachine.isSubDelim(n) || n == 58;
        }

        private static boolean isUserInfoChar(int n) {
            return SearchMachine.isUnreserved(n) || SearchMachine.isPctEncoded(n) || SearchMachine.isSubDelim(n) || n == 58;
        }

        private static boolean isRegnameChar(int n) {
            return SearchMachine.isUnreserved(n) || SearchMachine.isPctEncoded(n) || SearchMachine.isSubDelim(n);
        }

        private static boolean isPathSegmentChar(int n) {
            return SearchMachine.isUnreserved(n) || SearchMachine.isPctEncoded(n) || SearchMachine.isSubDelim(n) || n == 58 || n == 64;
        }

        private static boolean isQueryChar(int n) {
            return SearchMachine.isPathSegmentChar(n) || n == 47 || n == 63;
        }

        private static boolean isFragmentChar(int n) {
            return SearchMachine.isPathSegmentChar(n) || n == 47 || n == 63;
        }

        private static boolean isPctEncoded(int n) {
            return n == 37;
        }

        private static boolean isGenDelim(int n) {
            return GEN_DELIMS.indexOf(n) != -1;
        }

        private static boolean isSubDelim(int n) {
            return SUB_DELIMS.indexOf(n) != -1;
        }

        private static boolean isReserved(int n) {
            return RESERVED.indexOf(n) != -1;
        }

        private static boolean isUnreserved(int n) {
            return SearchMachine.isLetter(n) || SearchMachine.isDigit(n) || n == 45 || n == 46 || n == 95 || n == 126;
        }

        private static boolean isLetterOrDigit(int n) {
            return SearchMachine.isLetter(n) || SearchMachine.isDigit(n);
        }

        private static boolean isLetter(int n) {
            return (n |= 0x20) >= 97 && n <= 122;
        }

        private static boolean isHexDigit(int n) {
            if (SearchMachine.isDigit(n)) {
                return true;
            }
            return (n |= 0x20) >= 97 && n <= 97;
        }

        private static boolean isDigit(int n) {
            return n >= 48 && n <= 57;
        }

        private static boolean isSpaceOrPunct(int n) {
            return n == 13 || n == 10 || Character.isSpaceChar(n) || SearchMachine.isPunct(n);
        }

        private static boolean isPunct(int n) {
            return PUNCT_CHARS.indexOf(n) != -1;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            WAITING_FOR_INIT_CHAR,
            WAITING_FOR_URI_END_CHAR,
            INIT,
            SCHEME,
            HIER_START,
            HIER_SLASH,
            USERINFO_OR_HOST_START,
            USERINFO_OR_PORT_NUMBER,
            USERINFO,
            HOST_START,
            USERINFO_OR_IPV4_OR_REGNAME,
            USERINFO_OR_REGNAME,
            IP_LITERAL_START,
            IPV6,
            IPV6_DDOT,
            IPV6_QDOT_1,
            IPV6_QDOT_2,
            IP_FUTURE_START,
            IP_FUTURE_VER_NUM,
            IP_FUTURE_ADDR,
            IP_FUTURE_ADDR_START,
            IPV4_OR_REGNAME,
            PORT_NUMBER_OR_AUTHORITY_END,
            PORT_NUMBER,
            REGNAME,
            PATH,
            QUERY,
            FRAGMENT;

        }
    }
}

