/*
 * Decompiled with CFR 0.152.
 */
package cz.cze.radicalchat;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.sharedobject.ISharedObject;
import com.wowza.wms.sharedobject.ISharedObjects;
import com.wowza.wms.sharedobject.SharedObject;
import com.wowza.wms.stream.IMediaStream;
import cz.cze.radicalchat.ClientInfo;
import cz.cze.radicalchat.Command;
import cz.cze.radicalchat.Connector;
import cz.cze.radicalchat.Const;
import cz.cze.radicalchat.Logger;
import cz.cze.radicalchat.Mutex;
import cz.cze.radicalchat.RoomInfo;
import cz.cze.radicalchat.Service;
import cz.cze.radicalchat.StreamInfo;
import cz.cze.radicalchat.StringQueue;
import cz.cze.radicalchat.TextMessage;
import cz.cze.radicalchatservice.ChatRoom;
import cz.cze.radicalchatservice.Client;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConnectorWowza
extends Thread
implements Connector {
    public Map<String, ClientInfo> clientinfos = new HashMap<String, ClientInfo>();
    public Map<Integer, String> clientids;
    Service service;
    public Map<String, RoomInfo> chatrooms;
    ISharedObjects sharedObjects;
    private boolean isRunning;
    public static boolean T = true;
    public static boolean F = false;
    private Mutex clientinfoMutex;
    private Mutex chatroomsMutex;

    public ConnectorWowza() {
        try {
            this.service = new Service("");
            if (!this.testAPICode()) {
                Logger.info("Service API code is wrong.");
                this.stopRunning();
                return;
            }
            this.service.implemenatationStatus.loadFromString(this.service.getImplementedFunctions());
            this.start();
        }
        catch (Exception err) {
            Logger.error("Error during creating connection to the web service. Something is wrong with your web service.");
            this.stopRunning();
        }
    }

    public ConnectorWowza(String serviceURL) {
        this.clientids = new HashMap<Integer, String>();
        this.chatrooms = new HashMap<String, RoomInfo>();
        this.clientinfoMutex = new Mutex("clientinfo");
        this.chatroomsMutex = new Mutex("chatrooms");
        try {
            this.service = new Service(serviceURL);
            if (!this.testAPICode()) {
                Logger.error("Service API code is wrong.");
                this.stopRunning();
                return;
            }
            this.service.implemenatationStatus.loadFromString(this.service.getImplementedFunctions());
            this.start();
        }
        catch (Exception err) {
            Logger.error("Error during creating service.");
            this.stopRunning();
        }
    }

    public boolean testAPICode() {
        String s = this.service.getAPICode();
        return s.equals("RadicalChat 1.0.0");
    }

    public boolean isStringNull(String value) {
        return value == null || value.isEmpty();
    }

    public String getStringParamForCalledFunction(AMFDataList params) {
        return params.get(params.size() - 1).getValue().toString();
    }

    public ClientInfo getClientInfo(String UID) {
        return this.clientinfos.get(UID);
    }

    public ClientInfo getClientInfo(int ID) {
        return this.clientinfos.get(this.clientids.get(ID));
    }

    public boolean addClient(ClientInfo clientinfo) {
        this.clientinfoMutex.lock();
        try {
            this.clientinfos.put(clientinfo.client.getUID(), clientinfo);
            this.clientids.put(clientinfo.wwclient.getClientId(), clientinfo.client.getUID());
            clientinfo.wwclient.setSharedObjectReadAccess(String.valueOf(clientinfo.client.getRoomUID()) + Const.PATHSEPARATOR + ";" + clientinfo.client.getUID() + Const.PATHSEPARATOR);
            clientinfo.wwclient.setSharedObjectWriteAccess(String.valueOf(clientinfo.client.getRoomUID()) + Const.PATHSEPARATOR + ";" + clientinfo.client.getUID() + Const.PATHSEPARATOR);
            clientinfo.wwclient.setStreamReadAccess(String.valueOf(clientinfo.client.getRoomUID()) + Const.PATHSEPARATOR);
            clientinfo.wwclient.setStreamWriteAccess("*");
        }
        finally {
            this.clientinfoMutex.release();
        }
        return true;
    }

    public void removeClient(String UID) {
        ClientInfo ci = this.getClientInfo(UID);
        ci.privateso.lock();
        try {
            ci.privateso.release();
        }
        finally {
            ci.privateso.unlock();
        }
        this.clientids.remove(ci.wwclient.getClientId());
        this.clientinfos.remove(UID);
        this.removeUserFromRoom(this.getRoomInfo(ci.client.getRoomUID()), ci);
    }

    public void rejectClient(ClientInfo ci) {
        ci.softRejected = true;
    }

    public void rejectClientNow(IClient wwclient) {
        if (wwclient != null) {
            wwclient.rejectConnection();
            wwclient.setShutdownClient(true);
        }
    }

    private void updateSkinObject(ISharedObject so, Command skinObject, boolean isChatRoom) {
        if (so == null || skinObject == null || skinObject.commandName.length() < 1) {
            Logger.warn("Cannot send skinObject into shared object.");
            return;
        }
        so.lock();
        try {
            try {
                StringQueue sq = new StringQueue();
                sq.assign(so.getProperty(Const.SKIN));
                sq.addString(skinObject.serializeToString());
                so.setProperty(Const.SKIN, (AMFData)sq.getAMFDataArray());
            }
            catch (Exception err) {
                Logger.error("Error during filling shared object.", err);
                so.unlock();
            }
        }
        finally {
            so.unlock();
        }
    }

    private void sendCommandIntoSharedObject(ISharedObject so, Command command, boolean isChatRoom) {
        if (so == null || command == null || command.commandName.length() < 1) {
            Logger.warn("Cannot send command into shared object.");
            return;
        }
        so.lock();
        try {
            StringQueue sq = new StringQueue();
            sq.assign(so.getProperty(Const.COMMANDS));
            sq.addString(command.serializeToString());
            so.setProperty(Const.COMMANDS, (AMFData)sq.getAMFDataArray());
        }
        finally {
            so.unlock();
        }
    }

    public void processCommands(String commands) {
        if (commands == null || commands.trim().length() < 1) {
            return;
        }
        String[] cmdarray = commands.split(Const.NEWLINE);
        int a = 0;
        while (a < cmdarray.length) {
            Command command = new Command();
            command.deserializeFromString(cmdarray[a]);
            ClientInfo ci = null;
            RoomInfo ri = null;
            if (!command.isRoomCommand) {
                ci = this.getClientInfo(command.clientRoomUID);
            } else {
                ri = this.getRoomInfo(command.clientRoomUID);
            }
            try {
                if (command.commandName.equals(Command.COMMAND_UPDATESKINOBJECT)) {
                    if (!command.isRoomCommand && ci != null) {
                        this.updateSkinObject(ci.privateso, command, false);
                    } else if (command.isRoomCommand && ri != null) {
                        ri.addSkinObjectUpdate(command);
                        this.updateSkinObject(ri.so, command, true);
                    }
                } else if (command.commandName.equals(Command.COMMAND_DELETEALLSKINOBJECTUPDATES)) {
                    if (!command.isRoomCommand && ci != null) {
                        this.updateSkinObject(ci.privateso, command, false);
                    } else if (command.isRoomCommand && ri != null) {
                        ri.deleteAllSkinObjectUpdates(command);
                        this.updateSkinObject(ri.so, command, true);
                    }
                } else if (command.commandName.equals(Command.COMMAND_OPENWEBPAGE)) {
                    if (!command.isRoomCommand && ci != null) {
                        this.sendCommandIntoSharedObject(ci.privateso, command, false);
                    } else if (command.isRoomCommand && ri != null) {
                        this.sendCommandIntoSharedObject(ri.so, command, true);
                    }
                } else if (command.commandName.equals(Command.COMMAND_STOPSTREAMING)) {
                    if (ci != null) {
                        this.sendCommandIntoSharedObject(ci.privateso, command, false);
                    }
                } else if (command.commandName.equals(Command.COMMAND_REJECTCONNECTION)) {
                    if (ci != null) {
                        this.rejectClient(ci);
                    }
                } else if (command.commandName.equals(Command.COMMAND_CLOSEROOM)) {
                    if (ri != null) {
                        this.closeRoom(ri);
                    }
                } else if (command.commandName.equals(Command.COMMAND_SETNEXTCHECK)) {
                    if (!command.isRoomCommand && ci != null) {
                        ci.client.setNextCheck(Integer.parseInt(Const.getCommandParam("nextCheck", command.commandParams, "-1")));
                    } else if (command.isRoomCommand && ri != null) {
                        ri.room.setNextCheck(Integer.parseInt(Const.getCommandParam("nextCheck", command.commandParams, "-1")));
                    }
                } else if (command.commandName.equals(Command.COMMAND_SETDEFAULTNEXTCHECK)) {
                    if (!command.isRoomCommand && ci != null) {
                        ci.defaultNextCheck = Integer.parseInt(Const.getCommandParam("defaultNextCheck", command.commandParams, "-1"));
                    } else if (command.isRoomCommand && ri != null) {
                        ri.defaultNextCheck = Integer.parseInt(Const.getCommandParam("defaultNextCheck", command.commandParams, "-1"));
                    }
                } else if (command.commandName.equals(Command.COMMAND_SETDESCRIPTION)) {
                    if (!command.isRoomCommand && ci != null) {
                        ci.client.setDescription(Const.getCommandParam("description", command.commandParams, ""));
                    } else if (command.isRoomCommand && ri != null) {
                        ri.room.setDescription(Const.getCommandParam("description", command.commandParams, ""));
                    }
                }
            }
            catch (Exception err) {
                Logger.error("Stream server error during proccessing command in processCommands.\nCommand is " + command.commandName + ".\n" + "Command params are " + command.commandParams, err);
            }
            ++a;
        }
    }

    public boolean addRoom(RoomInfo value) {
        this.chatrooms.put(value.room.getUID(), value);
        Logger.info("Room " + value.room.getUID() + " was created.");
        return true;
    }

    public RoomInfo getRoomInfo(String UID) {
        return this.chatrooms.get(UID);
    }

    public RoomInfo getOrCreateRoomInfo(String UID) {
        RoomInfo ri = this.getRoomInfo(UID);
        if (ri != null) {
            return ri;
        }
        try {
            this.chatroomsMutex.lock();
            try {
                ri = new RoomInfo();
                ri.room = Service.CreateRoom();
                ri.room.setUID(UID);
                ChatRoom result = this.service.onChatRoomCreated(ri.room);
                this.service.copyChatRoom(result, ri.room, T, T, T, T, F, F);
                ri.so = new SharedObject(String.valueOf(ri.room.getUID()) + Const.ROOMSOPOSTFIX);
                this.sharedObjects.put(String.valueOf(ri.room.getUID()) + Const.ROOMSOPOSTFIX, ri.so);
                ri.so.lock();
                try {
                    ri.so.acquire();
                    ri.so.setProperty(Const.USERSLIST, "");
                    StringQueue sq = new StringQueue();
                    sq.create(Const.MESSAGESBUFFERMAXSIZE);
                    ri.so.setProperty(Const.CHAT, (AMFData)sq.getAMFDataArray());
                    sq = new StringQueue();
                    sq.create(Const.COMMANDSBUFFERMAXSIZE);
                    ri.so.setProperty(Const.COMMANDS, (AMFData)sq.getAMFDataArray());
                    sq = new StringQueue();
                    sq.create(Const.SKINOBJECTSBUFFERMAXSIZE);
                    ri.so.setProperty(Const.SKIN, (AMFData)sq.getAMFDataArray());
                }
                finally {
                    ri.so.unlock();
                }
                this.addRoom(ri);
                if (result != null) {
                    this.processTextMessages(ri, result.getChatText());
                    this.processCommands(result.getCommands());
                }
            }
            finally {
                this.chatroomsMutex.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ri;
    }

    public void increaseUsersCountInRoomInfo(RoomInfo ri, int value) {
        try {
            this.chatroomsMutex.lock();
            try {
                ri.room.setUsersCount(ri.room.getUsersCount() + value);
            }
            finally {
                this.chatroomsMutex.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addUserToRoom(RoomInfo ri, ClientInfo user) {
        if (ri == null || user == null) {
            return;
        }
        try {
            this.chatroomsMutex.lock();
            try {
                ri.room.setUsersCount(ri.room.getUsersCount() + 1);
                ri.so.lock();
                String users = (String)ri.so.getProperty(Const.USERSLIST).getValue();
                ri.so.setProperty(Const.USERSLIST, String.valueOf(users) + user.serializeToString());
                ri.so.unlock();
            }
            finally {
                this.chatroomsMutex.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateUserInRoom(RoomInfo ri, ClientInfo ci) {
        if (ri == null || ci == null) {
            return;
        }
        ri.so.lock();
        String users = (String)ri.so.getProperty(Const.USERSLIST).getValue();
        String[] usersarr = users.split(Const.NEWLINE);
        String newUsers = "";
        String key = String.valueOf(Const.SEPARATOR) + "UID=" + ci.client.getUID() + Const.SEPARATOR;
        String[] stringArray = usersarr;
        int n = usersarr.length;
        int n2 = 0;
        while (n2 < n) {
            String user = stringArray[n2];
            newUsers = user.indexOf(key) == -1 ? String.valueOf(newUsers) + user + Const.NEWLINE : String.valueOf(newUsers) + ci.serializeToString();
            ++n2;
        }
        ri.so.setProperty(Const.USERSLIST, newUsers);
        ri.so.unlock();
    }

    public void removeUserFromRoom(RoomInfo ri, ClientInfo ci) {
        block13: {
            if (ri == null || ci == null) {
                return;
            }
            try {
                this.chatroomsMutex.lock();
                try {
                    try {
                        ri.room.setUsersCount(ri.room.getUsersCount() - 1);
                        ri.so.lock();
                        String users = (String)ri.so.getProperty(Const.USERSLIST).getValue();
                        String[] usersarr = users.split(Const.NEWLINE);
                        String newUsers = "";
                        String key = "UID=" + ci.client.getUID();
                        String[] stringArray = usersarr;
                        int n = usersarr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String user = stringArray[n2];
                            if (user.indexOf(key) == -1) {
                                newUsers = String.valueOf(newUsers) + user + Const.NEWLINE;
                            }
                            ++n2;
                        }
                        ri.so.setProperty(Const.USERSLIST, newUsers);
                        ri.so.unlock();
                        Logger.info("Clients count:" + Integer.toString(ri.room.getUsersCount()) + " in room \"" + ri.room.getRoomName() + "\".");
                        if (ri.room.getUsersCount() != 0) break block13;
                        ri.so.lock();
                        try {
                            ri.so.release();
                        }
                        finally {
                            ri.so.unlock();
                        }
                        this.service.onChatRoomClosed(ri.room);
                        this.chatrooms.remove(ri.room.getUID());
                    }
                    catch (Exception err) {
                        Logger.error("Stream server error in removeUserFromRoom.", err);
                        this.chatroomsMutex.release();
                    }
                }
                finally {
                    this.chatroomsMutex.release();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeRoom(RoomInfo ri) {
        Logger.info("Forcefully closing room \"" + ri.room.getUID() + "\"");
        ri.room.setRoomClosed(true);
        for (Map.Entry<String, ClientInfo> pairs : this.clientinfos.entrySet()) {
            ClientInfo ci = pairs.getValue();
            if (ci == null || !ci.client.getRoomUID().equals(ri.room.getUID())) continue;
            this.rejectClient(ci);
        }
    }

    private void sendTextMessageIntoSharedObject(ISharedObject so, TextMessage message) {
        if (so == null || message == null || message.message.length() < 1) {
            return;
        }
        so.lock();
        try {
            StringQueue sq = new StringQueue();
            sq.assign(so.getProperty(Const.CHAT));
            sq.addString(message.serializeToString());
            so.setProperty(Const.CHAT, (AMFData)sq.getAMFDataArray());
        }
        finally {
            so.unlock();
        }
    }

    public void processTextMessages(ClientInfo sender, String value) {
        if (sender == null || value == null || value.trim().length() < 1) {
            return;
        }
        String[] arr = value.split(Const.NEWLINE);
        TextMessage[] message = new TextMessage[arr.length];
        int a = 0;
        while (a < arr.length) {
            message[a] = new TextMessage();
            message[a].deserializeFromString(arr[a]);
            ++a;
        }
        RoomInfo ri = this.getRoomInfo(sender.client.getRoomUID());
        int a2 = 0;
        while (a2 < message.length) {
            if (message[a2].toClientUID.equals(Const.ALL) && ri != null) {
                this.sendTextMessageIntoSharedObject(ri.so, message[a2]);
            } else {
                ClientInfo clientTo = this.getClientInfo(message[a2].toClientUID);
                if (clientTo != null) {
                    this.sendTextMessageIntoSharedObject(clientTo.privateso, message[a2]);
                }
            }
            ++a2;
        }
    }

    public void processTextMessages(RoomInfo ri, String value) {
        if (ri == null || value == null || value.trim().length() < 1) {
            return;
        }
        String[] arr = value.split(Const.NEWLINE);
        TextMessage[] message = new TextMessage[arr.length];
        int a = 0;
        while (a < arr.length) {
            message[a] = new TextMessage();
            message[a].deserializeFromString(arr[a]);
            ++a;
        }
        a = 0;
        while (a < message.length) {
            if (message[a].toClientUID.equals(Const.ALL)) {
                this.sendTextMessageIntoSharedObject(ri.so, message[a]);
            }
            ++a;
        }
    }

    public void updateArrayOfClients(Client[] newClients) {
        if (newClients != null) {
            this.clientinfoMutex.lock();
            try {
                Client[] clientArray = newClients;
                int n = newClients.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientInfo ci;
                    Client client = clientArray[n2];
                    if (client != null && (ci = this.getClientInfo(client.getUID())) != null) {
                        this.onAfterCheckClients(ci, client);
                    }
                    ++n2;
                }
            }
            finally {
                this.clientinfoMutex.release();
            }
        }
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                Logger.save();
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    this.stopRunning();
                    return;
                }
                ArrayList<Client> clientsList = new ArrayList<Client>();
                ArrayList<Client> clientsToRemove = new ArrayList<Client>();
                this.clientinfoMutex.lock();
                try {
                    for (Map.Entry<String, ClientInfo> pairs : this.clientinfos.entrySet()) {
                        ClientInfo clientInfo = pairs.getValue();
                        clientInfo.client.setNextCheck(clientInfo.client.getNextCheck() - 1);
                        if (!clientInfo.wwclient.isConnected()) {
                            Logger.info("Client \"" + clientInfo.client.getUID() + "\" is no longer connected " + Integer.toString(clientInfo.wwclient.getClientId()) + " counting down " + Integer.toString(clientInfo.gcCounter));
                            --clientInfo.gcCounter;
                            if (clientInfo.gcCounter > 0) continue;
                            clientsToRemove.add(clientInfo.client);
                            continue;
                        }
                        if (clientInfo.softRejected) {
                            --clientInfo.softGCCounter;
                            if (clientInfo.softGCCounter > 0) continue;
                            this.rejectClientNow(clientInfo.wwclient);
                            continue;
                        }
                        if (clientInfo.client.getNextCheck() == 0) {
                            clientInfo.gcCounter = ClientInfo.GC_COUNTER_DEFAULT_VALUE;
                            clientInfo.softGCCounter = ClientInfo.SOFT_GC_COUNTER_DEFAULT_VALUE;
                            clientsList.add(clientInfo.client);
                            continue;
                        }
                        if (clientInfo.client.getNextCheck() >= 0) continue;
                        clientInfo.client.setNextCheck(clientInfo.defaultNextCheck - 1);
                    }
                    if (clientsToRemove.size() > 0) {
                        for (Client client : clientsToRemove) {
                            this.removeClient(client.getUID());
                        }
                    }
                }
                finally {
                    this.clientinfoMutex.release();
                }
                if (clientsList.size() > 0) {
                    Client[] clients = new Client[clientsList.size()];
                    clients = clientsList.toArray(clients);
                    Client[] clientArray = this.service.onCheckClients(clients);
                    this.updateArrayOfClients(clientArray);
                }
                ArrayList<ChatRoom> roomsList = new ArrayList<ChatRoom>();
                this.chatroomsMutex.lock();
                try {
                    for (Map.Entry<String, Object> entry : this.chatrooms.entrySet()) {
                        RoomInfo ri = (RoomInfo)entry.getValue();
                        ri.room.setNextCheck(ri.room.getNextCheck() - 1);
                        if (ri.room.getNextCheck() == 0 && !ri.room.isRoomClosed()) {
                            roomsList.add(ri.room);
                        }
                        if (ri.room.getNextCheck() >= 0 || ri.room.isRoomClosed()) continue;
                        ri.room.setNextCheck(ri.defaultNextCheck - 1);
                    }
                }
                finally {
                    this.chatroomsMutex.release();
                }
                if (roomsList.size() <= 0) continue;
                ChatRoom[] chatRoomArray2 = new ChatRoom[roomsList.size()];
                chatRoomArray2 = roomsList.toArray(chatRoomArray2);
                ChatRoom[] roomsResult = new ChatRoom[]{};
                roomsResult = this.service.onCheckChatRooms(chatRoomArray2);
                if (roomsResult == null) continue;
                this.chatroomsMutex.lock();
                try {
                    ChatRoom[] chatRoomArray3 = roomsResult;
                    int n = roomsResult.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RoomInfo ri;
                        ChatRoom room = chatRoomArray3[n2];
                        if (room != null && (ri = this.getRoomInfo(room.getUID())) != null) {
                            this.onAfterCheckRooms(ri, room);
                        }
                        ++n2;
                    }
                }
                finally {
                    this.chatroomsMutex.release();
                }
            }
            catch (Exception err) {
                Logger.error("Stream server error in onCheck(clients)/(rooms).", err);
            }
        }
    }

    public void onAfterCheckClients(ClientInfo ci, Client newClient) {
        this.service.copyClient(newClient, ci.client, T, T, T, T, F, F, F);
        this.processTextMessages(ci, newClient.getChatText());
        this.processCommands(newClient.getCommands());
        if (!newClient.isConnected()) {
            this.rejectClient(ci);
        }
    }

    public void onAfterCheckRooms(RoomInfo ri, ChatRoom newRoom) {
        this.service.copyChatRoom(newRoom, ri.room, T, T, T, F, F, F);
        this.processTextMessages(ri, newRoom.getChatText());
        this.processCommands(newRoom.getCommands());
        if (newRoom.isRoomClosed()) {
            this.closeRoom(ri);
        }
    }

    public void stopRunning() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public String getAPICode(IClient client, RequestFunction function, AMFDataList params) {
        return "RadicalChat 1.0.0";
    }

    public String getMyInfo(IClient client, RequestFunction function, AMFDataList params) {
        try {
            ClientInfo ci = this.getClientInfo(client.getClientId());
            if (ci != null) {
                return ci.serializeToString();
            }
            return "";
        }
        catch (Exception err) {
            Logger.error("Stream server error in getMyInfo.", err);
            return "";
        }
    }

    public String getDynamicSkin(IClient client, RequestFunction function, AMFDataList params) {
        try {
            RoomInfo ri;
            ClientInfo ci = this.getClientInfo(client.getClientId());
            if (ci != null && (ri = this.getRoomInfo(ci.client.getRoomUID())) != null) {
                return ri.getAllSkinObjectsUpdatesAsText();
            }
            return "";
        }
        catch (Exception err) {
            Logger.error("Stream server error in getDynamicSkin.", err);
            return "";
        }
    }

    public void onClientSendTextMessage(IClient client, RequestFunction function, AMFDataList params) {
        try {
            ClientInfo ci = this.getClientInfo(client.getClientId());
            if (ci == null) {
                Logger.warn("Client does not exist, in \"onClientSendTextMessage\"");
                return;
            }
            if (ci.softRejected) {
                return;
            }
            String messageData = this.getStringParamForCalledFunction(params);
            TextMessage message = new TextMessage();
            message.deserializeFromString(messageData);
            message.fromClientNickName = ci.client.getNickname();
            Client result = null;
            if (ci.client.isDispatchEventIfClientSendChatMessage()) {
                result = this.service.onClientSendMessage(ci.client, message.toClientUID, message.color, message.message);
                if (result != null) {
                    this.service.copyClient(result, ci.client, T, T, T, T, F, F, F);
                    this.processTextMessages(ci, result.getChatText());
                    this.processCommands(result.getCommands());
                    if (!result.isConnected()) {
                        this.rejectClient(ci);
                    }
                }
            } else {
                this.processTextMessages(ci, message.serializeToString());
            }
        }
        catch (Exception err) {
            Logger.error("Stream server error in onClientSendTextMessage.", err);
        }
    }

    public void onUniversalCall(IClient client, RequestFunction function, AMFDataList params) {
        try {
            ClientInfo ci = this.getClientInfo(client.getClientId());
            if (ci == null) {
                Logger.warn("Client does not exist, in \"onUniversalCall\"");
                return;
            }
            if (ci.softRejected) {
                return;
            }
            String universalCallData = this.getStringParamForCalledFunction(params);
            String[] arr = universalCallData.split(Const.NEWLINE, 4);
            if (arr.length < 3) {
                Logger.warn("Wrong incoming data in onUniversalCall.");
                return;
            }
            String senderName = arr[0];
            String eventName = arr[1];
            String value = arr[2];
            String otherData = "";
            if (arr.length == 4) {
                otherData = arr[3];
            }
            if (eventName.equals(Const.EVENT_BASICBUTTONCLICKED_WITHSELECTEDCLIENTS) || eventName.equals(Const.EVENT_BASICBUTTONCLICKED)) {
                Client[] clients;
                if (otherData.length() > 0) {
                    ArrayList<Client> clientsList = new ArrayList<Client>();
                    clientsList.add(ci.client);
                    String[] serializedClients = otherData.split(Const.NEWLINE);
                    int a = 0;
                    while (a < serializedClients.length) {
                        ClientInfo selectedClient = new ClientInfo();
                        selectedClient.deserializeFromString(serializedClients[a]);
                        if (!selectedClient.client.getUID().equals(Const.ALL) && (selectedClient = this.getClientInfo(selectedClient.client.getUID())) != null && !selectedClient.softRejected) {
                            clientsList.add(selectedClient.client);
                        }
                        ++a;
                    }
                    clients = new Client[]{};
                    clients = clientsList.toArray(clients);
                } else {
                    clients = new Client[]{ci.client};
                }
                Client[] clientsResult = this.service.onUniversalCall(clients, senderName, eventName, value);
                this.updateArrayOfClients(clientsResult);
                return;
            }
            Logger.warn("Unknown event in onUniversalCall.");
        }
        catch (Exception err) {
            Logger.error("Stream server error in onUniversalCall.", err);
        }
    }

    public void onAppStart(IApplicationInstance appInstance) {
        try {
            Logger.info(String.valueOf(Const.RADICALCHATVERSION) + ", subversion: " + Const.RADICALCHATSUBVERSION);
            this.sharedObjects = appInstance.getSharedObjects(false);
            this.service.onApplicationStarted();
            Logger.save();
        }
        catch (Exception err) {
            Logger.error("Stream server error in onApplicationStarted.", err);
        }
    }

    public void onAppStop(IApplicationInstance appInstance) {
        try {
            this.service.onApplicationStopped();
            this.stopRunning();
            Logger.save();
        }
        catch (Exception err) {
            Logger.error("Stream server error in onApplicationStopped.", err);
        }
    }

    public void onConnect(IClient wwclient, RequestFunction function, AMFDataList params) {
        block13: {
            try {
                String clientData = this.getStringParamForCalledFunction(params);
                ClientInfo ci = new ClientInfo();
                ci.client = Service.CreateClient();
                ci.deserializeFromString(clientData);
                ci.client.setConnected(false);
                ci.client.setIP(wwclient.getIp());
                ci.client.setFlashVersion(wwclient.getFlashVer());
                if (ci.client.getUID() == null || ci.client.getUID().trim().length() < 1) {
                    Logger.error("Client does not have UID in onClientWantsToConnect. Client will be rejected immediatelly.");
                    this.rejectClientNow(wwclient);
                    return;
                }
                if (this.getClientInfo(ci.client.getUID()) != null) {
                    Logger.error("Client with the same UID \"" + ci.client.getUID() + "\" " + "already exist. Warning in onClientWantsToConnect.");
                    this.rejectClientNow(wwclient);
                    return;
                }
                if (ci.client.getRoomUID() == null || ci.client.getRoomUID().trim().length() < 1) {
                    Logger.error("You have to set roomUID in onClientWantsToConnect. Client will be rejected immediatelly.");
                    this.rejectClientNow(wwclient);
                    return;
                }
                try {
                    RoomInfo ri = this.getOrCreateRoomInfo(ci.client.getRoomUID());
                    Client result = this.service.onClientWantsToConnect(ci.client);
                    if (result == null) {
                        Logger.error("Null was returned from web service.");
                        result = ci.client;
                    }
                    this.service.copyClient(result, ci.client, T, T, T, T, T, F, T, T, F, F, F, F);
                    ci.wwclient = wwclient;
                    this.addUserToRoom(ri, ci);
                    ci.privateso = new SharedObject(String.valueOf(ci.client.getUID()) + Const.CLIENTSOPOSTFIX);
                    this.sharedObjects.put(String.valueOf(ci.client.getUID()) + Const.CLIENTSOPOSTFIX, ci.privateso);
                    ci.privateso.lock();
                    try {
                        ci.privateso.acquire();
                        StringQueue sq = new StringQueue();
                        sq.create(Const.MESSAGESBUFFERMAXSIZE);
                        ci.privateso.setProperty(Const.CHAT, (AMFData)sq.getAMFDataArray());
                        sq = new StringQueue();
                        sq.create(Const.COMMANDSBUFFERMAXSIZE);
                        ci.privateso.setProperty(Const.COMMANDS, (AMFData)sq.getAMFDataArray());
                        sq = new StringQueue();
                        sq.create(Const.SKINOBJECTSBUFFERMAXSIZE);
                        ci.privateso.setProperty(Const.SKIN, (AMFData)sq.getAMFDataArray());
                    }
                    finally {
                        ci.privateso.unlock();
                    }
                    this.addClient(ci);
                    if (!result.isConnected()) {
                        this.rejectClientNow(wwclient);
                        break block13;
                    }
                    this.processTextMessages(ci, result.getChatText());
                    this.processCommands(result.getCommands());
                }
                catch (Exception err) {
                    Logger.error("Error during onClientWantsToConnect.", err);
                    this.rejectClientNow(wwclient);
                }
            }
            catch (Exception err) {
                Logger.error("Stream server error in onClientWantsToConnect.", err);
            }
        }
    }

    public void onConnectAccept(IClient wwclient) {
        try {
            ClientInfo ci = this.getClientInfo(wwclient.getClientId());
            try {
                if (ci != null) {
                    Client result = this.service.onClientConnectionWasAccepted(ci.client);
                    this.service.copyClient(result, ci.client, T, T, T, T, false, false, false);
                    if (result != null) {
                        this.processTextMessages(ci, result.getChatText());
                        this.processCommands(result.getCommands());
                        if (!result.isConnected()) {
                            this.rejectClient(ci);
                        }
                    }
                }
            }
            catch (Exception err) {
                Logger.error("Error during onClientConnectionWasAccepted. ", err);
                this.rejectClientNow(wwclient);
            }
        }
        catch (Exception err) {
            Logger.error("Stream server error in onClientConnectionWasAccepted.", err);
        }
    }

    public void onConnectReject(IClient wwclient) {
        try {
            ClientInfo ci = this.getClientInfo(wwclient.getClientId());
            if (ci != null) {
                this.service.onClientConnectionWasRejected(ci.client);
            }
        }
        catch (Exception err) {
            Logger.error("Stream server error in onClientConnectionWasRejected.", err);
        }
    }

    public void onDisconnect(IClient wwclient) {
        try {
            ClientInfo ci = this.getClientInfo(wwclient.getClientId());
            if (ci != null) {
                RoomInfo ri = this.getRoomInfo(ci.client.getRoomUID());
                ChatRoom result = null;
                if (ri != null) {
                    result = this.service.onClientDisconnected(ci.client, ri.room);
                } else {
                    this.service.onClientDisconnected(ci.client, null);
                }
                if (ri != null && result != null) {
                    this.service.copyChatRoom(result, ri.room, T, T, T, F, F, F);
                    this.processTextMessages(ri, result.getChatText());
                    this.processCommands(result.getCommands());
                    if (result.isRoomClosed()) {
                        this.closeRoom(ri);
                        return;
                    }
                }
            }
        }
        catch (Exception err) {
            Logger.error("Stream server error in onClientDisconnected.", err);
        }
    }

    public String onClientWantsToStartStreaming(IClient client, RequestFunction function, AMFDataList params) {
        Client result;
        ClientInfo ci;
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            ci = this.getClientInfo(client.getClientId());
                            if (ci != null) break block7;
                            Logger.warn("Client does not exist, in \"onClientWantsToStartStreaming\"");
                            return "false";
                        }
                        catch (Exception err) {
                            Logger.error("Stream server error in onClientWantsToStartStreaming.", err);
                            return "false";
                        }
                    }
                    if (!ci.softRejected) break block8;
                    return "false";
                }
                String streamData = this.getStringParamForCalledFunction(params);
                StreamInfo si = new StreamInfo();
                si.deserializeFromString(streamData);
                ci.lastStream = si;
                result = this.service.onClientWantsToStartStreaming(ci.client, si.stream);
                if (result != null) break block9;
                Logger.warn("Service returned \"null\" answer in onClientWantsToStartStreaming.");
                return "false";
            }
            this.service.copyClient(result, ci.client, T, T, T, T, F, F, F, F, F, F, F, F);
            this.processTextMessages(ci, result.getChatText());
            this.processCommands(result.getCommands());
            if (result.isConnected()) break block10;
            this.rejectClient(ci);
            return "false";
        }
        if (result.isStreamAccepted()) {
            ci.client.setIsStreaming(true);
            return "true";
        }
        return "false";
    }

    public void onClientStartStreaming(IMediaStream stream, String streamName, boolean isRecord, boolean isAppend) {
        try {
            if (stream == null) {
                Logger.warn("Stream is null in onClientStartStreaming.");
                return;
            }
            ClientInfo ci = this.getClientInfo(stream.getClientId());
            if (ci != null && ci.client.isIsStreaming()) {
                RoomInfo ri = this.getRoomInfo(ci.client.getRoomUID());
                if (ri != null) {
                    this.updateUserInRoom(ri, ci);
                    Logger.info("Stream accepted. Client \"" + ci.client.getUID() + "\" " + "has started streaming. " + "Shared object altered.");
                }
            } else {
                Logger.info("Stream rejected. User " + ci.client.getUID() + " in onClientStartStreaming.");
            }
        }
        catch (Exception err) {
            Logger.error("Stream server error in onClientStartStreaming.", err);
        }
    }

    public void onClientStoppedStreaming(IMediaStream stream, String streamName, boolean isRecord, boolean isAppend) {
        try {
            if (stream == null) {
                return;
            }
            ClientInfo ci = this.getClientInfo(stream.getClientId());
            if (ci == null) {
                Logger.warn("Client does not exist, in \"onUniversalCall\"");
                return;
            }
            ci.client.setIsStreaming(false);
            if (ci.lastStream != null) {
                this.service.onClientStoppedStreaming(ci.client, ci.lastStream.stream);
            }
            ci.lastStream = null;
        }
        catch (Exception err) {
            Logger.error("Stream server error in onClientStoppedStreaming.", err);
        }
    }

    public String onClientWantsToPlayStream(IClient client, RequestFunction function, AMFDataList params) {
        Client result;
        ClientInfo clientWhoIsStreaming;
        block12: {
            ClientInfo clientWhoWantsToPlayStream;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            try {
                                clientWhoWantsToPlayStream = this.getClientInfo(client.getClientId());
                                if (clientWhoWantsToPlayStream != null) break block8;
                                Logger.warn("Client who wants to play stream does not exist, in \"onClientWantsToPlayStream\"");
                                return "false";
                            }
                            catch (Exception err) {
                                Logger.error("Stream server error in onClientWantsToPlayStream.", err);
                                return "false";
                            }
                        }
                        if (!clientWhoWantsToPlayStream.softRejected) break block9;
                        return "false";
                    }
                    String clientData = this.getStringParamForCalledFunction(params);
                    clientWhoIsStreaming = new ClientInfo();
                    clientWhoIsStreaming.deserializeFromString(clientData);
                    clientWhoIsStreaming = this.getClientInfo(clientWhoIsStreaming.client.getUID());
                    if (clientWhoIsStreaming != null && !clientWhoIsStreaming.softRejected) break block10;
                    Logger.warn("Client who is streaming does not exist in \"onClientWantsToPlayStream\"");
                    return "false";
                }
                result = this.service.onClientWantsToPlayStream(clientWhoWantsToPlayStream.client, clientWhoIsStreaming.lastStream.stream);
                if (result != null) break block11;
                Logger.warn("Service returned \"null\" result inonClientWantsToPlayStream. Client who wants to play stream: \"" + clientWhoWantsToPlayStream.client.getUID() + "\"" + "Client which stream wants to be played: \"" + clientWhoIsStreaming.client.getUID() + "\".");
                return "false";
            }
            this.service.copyClient(result, clientWhoWantsToPlayStream.client, T, T, T, T, F, F, F, F, F, F, F, F);
            this.processTextMessages(clientWhoWantsToPlayStream, result.getChatText());
            this.processCommands(result.getCommands());
            if (result.isConnected()) break block12;
            this.rejectClient(clientWhoWantsToPlayStream);
            return "false";
        }
        if (result.isStreamAccepted()) {
            return "true" + Const.NEWLINE + clientWhoIsStreaming.serializeToString() + clientWhoIsStreaming.lastStream.serializeToString();
        }
        return "false";
    }

    public void onClientPlayStream(IMediaStream stream, String streamName, double playStart, double playLen, int playReset) {
        try {
            Logger.info("client started playing stream " + streamName);
        }
        catch (Exception err) {
            Logger.error("Stream server error in onClientPlayStream.", err);
        }
    }

    public void onClientStoppedPlayingStream(IMediaStream stream) {
        try {
            if (stream == null) {
                return;
            }
            ClientInfo clientWhoWantsToStopPlayingStream = this.getClientInfo(stream.getClientId());
            String[] arr = stream.getName().split(Const.PATHSEPARATOR);
            if (arr.length != 2) {
                Logger.warn("Stream name is wrong, in onClientStoppedPlayingStream.");
                return;
            }
            ClientInfo clientWhoIsStreaming = this.getClientInfo(arr[1]);
            if (clientWhoWantsToStopPlayingStream == null || clientWhoIsStreaming == null) {
                Logger.error("Client was not found, in onClientStoppedPlayingStream.");
                return;
            }
            this.service.onClientStoppedPlayingStream(clientWhoWantsToStopPlayingStream.client, clientWhoIsStreaming.lastStream.stream);
        }
        catch (Exception err) {
            Logger.error("Stream server error in onClientStoppedPlayingStream.", err);
        }
    }

    public void onCall(String handlerName, IClient client, RequestFunction function, AMFDataList params) {
    }
}

