/*
 * Decompiled with CFR 0.152.
 */
package cz.cze.radicalchat;

import com.wowza.wms.logging.WMSLogger;
import cz.cze.radicalchat.Mutex;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    public static WMSLogger wmsLogger;
    public static StringBuilder logs;
    public static StringBuilder informations;
    public static StringBuilder warnings;
    public static StringBuilder errors;
    public static StringBuilder serializedTextMessages;
    public static String delimitter;
    public static String linedelimitter;
    public static String filename;
    public static Mutex mutex;

    static {
        delimitter = "~~";
        linedelimitter = "~!~";
        filename = "";
        mutex = new Mutex("Logger");
    }

    private Logger() {
        logs = new StringBuilder();
        informations = new StringBuilder();
        warnings = new StringBuilder();
        errors = new StringBuilder();
        serializedTextMessages = new StringBuilder();
    }

    public static void createLogger() {
        logs = new StringBuilder();
        informations = new StringBuilder();
        warnings = new StringBuilder();
        errors = new StringBuilder();
        serializedTextMessages = new StringBuilder();
    }

    public static void save() {
        if (filename.length() < 1) {
            return;
        }
        mutex.lock();
        try {
            try {
                String logsText = logs.toString();
                logs.delete(0, logs.length() - 1);
                if (logsText.length() > 1) {
                    FileWriter fw = new FileWriter(filename, true);
                    BufferedWriter writer = new BufferedWriter(fw);
                    writer.write(logsText);
                    writer.close();
                }
                String serializedTextMessagesText = serializedTextMessages.toString();
                serializedTextMessages.delete(0, serializedTextMessages.length() - 1);
                if (serializedTextMessagesText.length() > 1) {
                    FileWriter fw = new FileWriter(String.valueOf(filename) + ".messages", true);
                    BufferedWriter writer = new BufferedWriter(fw);
                    writer.write(serializedTextMessagesText);
                    writer.close();
                }
            }
            catch (Exception exception) {
                mutex.release();
            }
        }
        finally {
            mutex.release();
        }
    }

    public static void log(String value, String prefix, int level) {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss;");
        String s = formatter.format(date);
        value = String.valueOf(Integer.toString(level)) + ";" + s + prefix + value.replace("\n", "<br/>");
        mutex.lock();
        try {
            logs.append(String.valueOf(value) + "\n");
        }
        finally {
            mutex.release();
        }
        System.out.println(value);
    }

    public static void log(String value) {
        Logger.log(value, "note; ", 0);
    }

    public static void log() {
        Logger.log("");
    }

    public static void func(String value) {
        Logger.log("-------------------------", "func;", 0);
        Logger.log(value, "func;", 0);
        Logger.log("-------------------------", "func;", 0);
    }

    public static void info(String value) {
        Logger.info(value, 0);
    }

    public static void info(String value, int level) {
        Logger.log(value, "info; ", level);
    }

    public static void warn(String value) {
        Logger.warn(value, 0);
    }

    public static void warn(String value, int level) {
        Logger.log(value, "warn; ", level);
    }

    public static void error(String value) {
        Logger.error(value, 0);
    }

    public static void error(String value, Exception err) {
        Logger.error(value, err, 0);
    }

    public static void error(String value, Exception err, int level) {
        String message = String.valueOf(value) + "\n";
        message = String.valueOf(message) + err.getMessage() + "\n";
        message = String.valueOf(message) + "Stack trace:\n";
        StackTraceElement[] errs = err.getStackTrace();
        int a = 0;
        while (a < errs.length) {
            message = String.valueOf(message) + errs[a].toString() + "\n";
            ++a;
        }
        Logger.error(message, level);
    }

    public static void error(String value, int level) {
        Logger.log(value, "error;", level);
    }

    public static void logSerializedTextMessage(String value) {
        mutex.lock();
        try {
            serializedTextMessages.append(String.valueOf(value) + "\n");
        }
        finally {
            mutex.release();
        }
    }
}

