/*
 * Decompiled with CFR 0.152.
 */
package cz.cze.radicalchat;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import cz.cze.radicalchat.ConnectorWowza;
import cz.cze.radicalchat.Const;
import cz.cze.radicalchat.Logger;
import cz.cze.radicalchat.StringQueue;

public class RadicalChat
extends ModuleBase {
    public ConnectorWowza connector;

    public void getAPICode(IClient client, RequestFunction function, AMFDataList params) {
        RadicalChat.sendResult((IClient)client, (AMFDataList)params, (String)this.connector.getAPICode(client, function, params));
    }

    public void getMyInfo(IClient client, RequestFunction function, AMFDataList params) {
        RadicalChat.sendResult((IClient)client, (AMFDataList)params, (String)this.connector.getMyInfo(client, function, params));
    }

    public void getDynamicSkin(IClient client, RequestFunction function, AMFDataList params) {
        String[] arr = this.connector.getDynamicSkin(client, function, params).split(Const.NEWLINE);
        StringQueue result = new StringQueue();
        result.create(arr.length);
        result.addStringArray(arr);
        RadicalChat.sendResult((IClient)client, (AMFDataList)params, (AMFData)result.getAMFDataArray());
    }

    public void onClientSendTextMessage(IClient client, RequestFunction function, AMFDataList params) {
        this.connector.onClientSendTextMessage(client, function, params);
    }

    public void onClientWantsToStartStreaming(IClient client, RequestFunction function, AMFDataList params) {
        RadicalChat.sendResult((IClient)client, (AMFDataList)params, (String)this.connector.onClientWantsToStartStreaming(client, function, params));
    }

    public void onClientWantsToPlayStream(IClient client, RequestFunction function, AMFDataList params) {
        RadicalChat.sendResult((IClient)client, (AMFDataList)params, (String)this.connector.onClientWantsToPlayStream(client, function, params));
    }

    public void onUniversalCall(IClient client, RequestFunction function, AMFDataList params) {
        this.connector.onUniversalCall(client, function, params);
    }

    public void onAppStart(IApplicationInstance appInstance) {
        Logger.createLogger();
        Logger.wmsLogger = RadicalChat.getLogger();
        WMSProperties wmsp = appInstance.getProperties();
        Logger.filename = wmsp.getPropertyStr("logfile", "");
        this.connector = new ConnectorWowza(wmsp.getPropertyStr("webserviceurl"));
        this.connector.onAppStart(appInstance);
    }

    public void onAppStop(IApplicationInstance appInstance) {
        this.connector.onAppStop(appInstance);
    }

    public void onConnect(IClient client, RequestFunction function, AMFDataList params) {
        if (!this.connector.isRunning()) {
            client.rejectConnection();
            RadicalChat.getAppInstance((IClient)client).shutdown(false, true);
        } else {
            this.connector.onConnect(client, function, params);
        }
    }

    public void onConnectAccept(IClient client) {
        this.connector.onConnectAccept(client);
    }

    public void onConnectReject(IClient client) {
        this.connector.onConnectReject(client);
    }

    public void onDisconnect(IClient client) {
        this.connector.onDisconnect(client);
    }

    public void onStreamCreate(IMediaStream stream) {
        StreamListener streamListener = new StreamListener();
        stream.addClientListener((IMediaStreamActionNotify)streamListener);
    }

    public void onStreamDestroy(IMediaStream stream) {
    }

    public void onCall(String handlerName, IClient client, RequestFunction function, AMFDataList params) {
        this.connector.onCall(handlerName, client, function, params);
    }

    class StreamListener
    implements IMediaStreamActionNotify {
        StreamListener() {
        }

        public void onPlay(IMediaStream stream, String streamName, double playStart, double playLen, int playReset) {
            RadicalChat.getLogger().info("onPlay");
            RadicalChat.this.connector.onClientPlayStream(stream, streamName, playStart, playLen, playReset);
        }

        public void onPublish(IMediaStream stream, String streamName, boolean isRecord, boolean isAppend) {
            RadicalChat.getLogger().info("onPublish");
            RadicalChat.this.connector.onClientStartStreaming(stream, streamName, isRecord, isAppend);
        }

        public void onSeek(IMediaStream stream, double location) {
            RadicalChat.getLogger().info("onSeek");
        }

        public void onStop(IMediaStream stream) {
            RadicalChat.getLogger().info("onStop");
            RadicalChat.this.connector.onClientStoppedPlayingStream(stream);
        }

        public void onPause(IMediaStream stream, boolean isPause, double location) {
            RadicalChat.getLogger().info("onPause");
        }

        public void onUnPublish(IMediaStream stream, String streamName, boolean isRecord, boolean isAppend) {
            RadicalChat.getLogger().info("onUnPublish");
            RadicalChat.this.connector.onClientStoppedStreaming(stream, streamName, isRecord, isAppend);
        }
    }
}

