/*
 * Decompiled with CFR 0.152.
 */
package cz.cze.radicalchat;

import com.wowza.wms.sharedobject.ISharedObject;
import cz.cze.radicalchat.Command;
import cz.cze.radicalchat.Const;
import cz.cze.radicalchat.Logger;
import cz.cze.radicalchat.Mutex;
import cz.cze.radicalchat.StringComplexResult;
import cz.cze.radicalchatservice.ChatRoom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RoomInfo {
    public ChatRoom room;
    public int gcCounter = GC_COUNTER_DEFAULT_VALUE;
    public boolean softClosed = false;
    public int defaultNextCheck = -1;
    public static int GC_COUNTER_DEFAULT_VALUE = 3;
    public ISharedObject so;
    public Map<String, Command> skinChanges = new HashMap<String, Command>();
    public Mutex skinChangesMutex = new Mutex("RoomInfoMutex");
    public String skinChangesLastUpdateUID = Const.generateNextContinuousUID();
    public String skinChangesText = "";
    public String skinChangesTextLastUpdateUID = Const.generateNextContinuousUID();

    public void addSkinObjectUpdate(Command skinChange) {
        if (skinChange != null && skinChange.commandParams.length() > 1) {
            StringComplexResult name = Const.getTextInsideTags("&lt;Name&gt;", "&lt;/Name&gt;", skinChange.commandParams, 0);
            if (name.isValid) {
                try {
                    this.skinChangesMutex.lock();
                    try {
                        Command actualSkinObject = this.skinChanges.get(name.text);
                        if (actualSkinObject == null || actualSkinObject.UID.compareTo(skinChange.UID) <= 0) {
                            this.skinChanges.put(name.text, skinChange);
                            this.skinChangesLastUpdateUID = Const.generateNextContinuousUID();
                        }
                    }
                    finally {
                        this.skinChangesMutex.release();
                    }
                }
                catch (Exception err) {
                    Logger.error("Error in addSkinChages, in room \"" + this.room.getUID() + "\".", err);
                }
            } else {
                Logger.warn("Dynamic skin cannot be updated, name tag was not found in " + skinChange.commandParams);
            }
        }
    }

    public void deleteAllSkinObjectUpdates(Command skinChange) {
        String name = Const.getCommandParam("name", skinChange.commandParams, Const.NONE);
        try {
            this.skinChangesMutex.lock();
            try {
                Command actualSkinObject = this.skinChanges.get(name);
                if (actualSkinObject != null && actualSkinObject.UID.compareTo(skinChange.UID) <= 0 && this.skinChanges.remove(name) != null) {
                    this.skinChangesLastUpdateUID = Const.generateNextContinuousUID();
                }
            }
            finally {
                this.skinChangesMutex.release();
            }
        }
        catch (Exception err) {
            Logger.error("Error in deleteAllSkinObjectUpdates, in room \"" + this.room.getUID() + "\".", err);
        }
    }

    public String getAllSkinObjectsUpdatesAsText() {
        if (this.skinChangesTextLastUpdateUID != this.skinChangesLastUpdateUID) {
            try {
                this.skinChangesMutex.lock();
                try {
                    Iterator<Map.Entry<String, Command>> it = this.skinChanges.entrySet().iterator();
                    StringBuilder sb = new StringBuilder();
                    while (it.hasNext()) {
                        Map.Entry<String, Command> pairs = it.next();
                        Command skinChange = pairs.getValue();
                        sb.append(skinChange.serializeToString());
                    }
                    this.skinChangesText = sb.toString();
                    this.skinChangesTextLastUpdateUID = this.skinChangesLastUpdateUID;
                }
                finally {
                    this.skinChangesMutex.release();
                }
            }
            catch (Exception err) {
                Logger.error("Error in getAllSkinChangesAsText, in room \"" + this.room.getUID() + "\".", err);
            }
        }
        return this.skinChangesText;
    }
}

