/*
 * Decompiled with CFR 0.152.
 */
package cz.cze.radicalchat;

import cz.cze.radicalchat.Const;
import cz.cze.radicalchat.ImplementationStatus;
import cz.cze.radicalchat.Logger;
import cz.cze.radicalchatservice.ChatRoom;
import cz.cze.radicalchatservice.Client;
import cz.cze.radicalchatservice.RadicalChatServiceSoap;
import cz.cze.radicalchatservice.RadicalChatServiceSoapProxy;
import cz.cze.radicalchatservice.Stream;
import javax.xml.rpc.Stub;

public class Service {
    RadicalChatServiceSoapProxy proxy;
    RadicalChatServiceSoap service;
    ImplementationStatus implemenatationStatus = new ImplementationStatus();

    public Service(String value) {
        this.proxy = new RadicalChatServiceSoapProxy(value);
        this.service = this.proxy.getRadicalChatServiceSoap();
        Logger.createLogger();
    }

    public void setCookie(String value) {
        Stub cfr_ignored_0 = (Stub)this.service;
        ((Stub)this.service)._setProperty("javax.xml.rpc.session.maintain", (Object)Boolean.TRUE);
        ((Stub)this.service)._setProperty("Cookie", (Object)value);
    }

    public static Client CreateClient() {
        Client result = new Client();
        result.setUID("guest");
        result.setRoomUID("");
        result.setNickname("");
        result.setConnected(false);
        result.setNextCheck(-1);
        result.setIsStreaming(false);
        result.setStreamAccepted(false);
        result.setChatText("");
        result.setUserFlag("");
        result.setDescription("");
        result.setDispatchEventIfClientSendChatMessage(false);
        result.setIP("127.0.0.1");
        result.setFlashVersion("10.0.0");
        result.setCommands("");
        result.setAdditionalVariables("");
        return result;
    }

    public static ChatRoom CreateRoom() {
        ChatRoom cr = new ChatRoom();
        cr.setUID("default");
        cr.setUsersCount(0);
        cr.setRoomClosed(false);
        cr.setChatText("");
        cr.setDescription("");
        cr.setRoomName("default");
        cr.setNextCheck(-1);
        cr.setCommands("");
        cr.setAdditionalVariables("");
        return cr;
    }

    public static Stream CreateStream() {
        Stream stream = new Stream();
        stream.setUID(String.valueOf(Const.LIVESTREAMING) + "_" + Const.generateUID());
        stream.setInformations("");
        return stream;
    }

    public void copyClient(Client source, Client dest, boolean additionalVariables, boolean description, boolean nextCheck, boolean dispatchEventIfClientSendChatMessage, boolean userFlag, boolean roomUID, boolean nickName) {
        if (source == null || dest == null) {
            return;
        }
        if (additionalVariables) {
            dest.setAdditionalVariables(source.getAdditionalVariables());
        }
        if (description) {
            dest.setDescription(source.getDescription());
        }
        if (nextCheck) {
            dest.setNextCheck(source.getNextCheck());
        }
        if (dispatchEventIfClientSendChatMessage) {
            dest.setDispatchEventIfClientSendChatMessage(source.isDispatchEventIfClientSendChatMessage());
        }
        if (userFlag) {
            dest.setUserFlag(source.getUserFlag());
        }
        if (roomUID) {
            dest.setRoomUID(source.getRoomUID());
        }
        if (nickName) {
            dest.setNickname(source.getNickname());
        }
    }

    public void copyClient(Client source, Client dest, boolean additionalVariables, boolean description, boolean nextCheck, boolean dispatchEventIfClientSendChatMessage, boolean userFlag, boolean roomUID, boolean nickName, boolean connected, boolean streamAccepted, boolean chatText, boolean cookie, boolean commands) {
        if (source == null || dest == null) {
            return;
        }
        this.copyClient(source, dest, additionalVariables, description, nextCheck, dispatchEventIfClientSendChatMessage, userFlag, roomUID, nickName);
        if (connected) {
            dest.setConnected(source.isConnected());
        }
        if (streamAccepted) {
            dest.setStreamAccepted(source.isStreamAccepted());
        }
        if (chatText) {
            dest.setChatText(String.valueOf(dest.getChatText()) + source.getChatText());
        }
        if (cookie) {
            dest.setCookie(source.getCookie());
        }
        if (commands) {
            dest.setCommands(source.getCommands());
        }
    }

    public void copyChatRoom(ChatRoom source, ChatRoom dest, boolean additionalVariables, boolean nextCheck, boolean description, boolean roomName, boolean roomClosed, boolean chatText) {
        if (source == null || dest == null) {
            return;
        }
        if (additionalVariables) {
            dest.setAdditionalVariables(source.getAdditionalVariables());
        }
        if (nextCheck) {
            dest.setNextCheck(source.getNextCheck());
        }
        if (description) {
            dest.setDescription(source.getDescription());
        }
        if (roomName) {
            dest.setRoomName(source.getRoomName());
        }
        if (roomClosed) {
            dest.setRoomClosed(source.isRoomClosed());
        }
        if (chatText) {
            dest.setChatText(String.valueOf(dest.getChatText()) + source.getChatText());
        }
    }

    private void infoAboutClient(Client client) {
        Logger.log("  Client:");
        if (client == null) {
            Logger.log("null");
            Logger.log();
            return;
        }
        Logger.log("    UID            = " + client.getUID());
        Logger.log("    roomUID        = " + client.getRoomUID());
        Logger.log("    nickname       = " + client.getNickname());
        Logger.log("    connected      = " + Boolean.toString(client.isConnected()));
        Logger.log("    nextCheck      = " + Integer.toString(client.getNextCheck()));
        Logger.log("    isStreaming    = " + Boolean.toString(client.isIsStreaming()));
        Logger.log("    StreamAccepted = " + Boolean.toString(client.isStreamAccepted()));
        Logger.log("    chatText       = " + client.getChatText());
        Logger.log("    userFlag       = " + client.getUserFlag());
        Logger.log("    description    = " + client.getDescription());
        Logger.log("    dispatchEvent~ = " + client.isDispatchEventIfClientSendChatMessage());
        Logger.log("    IP             = " + client.getIP());
        Logger.log("    flashVersion   = " + client.getFlashVersion());
        Logger.log("    commands       = " + client.getCommands());
        Logger.log("    additionalVar~ = " + client.getAdditionalVariables());
        Logger.log("    cookie         = " + client.getCookie());
        Logger.log();
    }

    public void infoAboutClients(Client[] clients) {
        int a = 0;
        while (a < clients.length) {
            this.infoAboutClient(clients[a]);
            ++a;
        }
    }

    private void infoAboutStream(Stream stream) {
        Logger.log("  Stream:");
        if (stream == null) {
            Logger.log("    null");
            Logger.log();
            return;
        }
        Logger.log("    UID       = " + stream.getUID());
        Logger.log("    informat~ = " + stream.getInformations());
        Logger.log();
    }

    public void infoAboutChatRoom(ChatRoom room) {
        Logger.log("  Room:");
        if (room == null) {
            Logger.log("null");
            Logger.log();
            return;
        }
        Logger.log("    UID            = " + room.getUID());
        Logger.log("    roomName       = " + room.getRoomName());
        Logger.log("    nextCheck      = " + Integer.toString(room.getNextCheck()));
        Logger.log("    closed         = " + Boolean.toString(room.isRoomClosed()));
        Logger.log("    chatText       = " + room.getChatText());
        Logger.log("    description    = " + room.getDescription());
        Logger.log("    usersCount     = " + Integer.toString(room.getUsersCount()));
        Logger.log("    commands       = " + room.getCommands());
        Logger.log();
    }

    public void infoAboutChatRooms(ChatRoom[] rooms) {
        int a = 0;
        while (a < rooms.length) {
            this.infoAboutChatRoom(rooms[a]);
            ++a;
        }
    }

    public String getAPICode() {
        Logger.func("getAPICode");
        String result = "";
        try {
            result = this.service.getAPICode();
        }
        catch (Exception err) {
            Logger.error("Error in getAPICode.", err);
            return null;
        }
        Logger.log("Response:");
        Logger.log(result);
        return result;
    }

    public String getImplementedFunctions() {
        Logger.func("getImplementedFunctions");
        String result = "";
        try {
            result = this.service.getImplementedFunctions();
        }
        catch (Exception err) {
            Logger.error("Error in getImplementedFunctions.", err);
            return null;
        }
        Logger.log("Response:");
        Logger.log(result);
        return result;
    }

    public void onApplicationStarted() {
        String functionName = "onApplicationStarted";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onApplicationStarted) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return;
        }
        try {
            this.service.onApplicationStarted();
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return;
        }
        Logger.log("Response:");
        Logger.log("    void");
    }

    public void onApplicationStopped() {
        String functionName = "onApplicationStopped";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onApplicationStopped) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return;
        }
        try {
            this.service.onApplicationStopped();
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return;
        }
        Logger.log("Response:");
        Logger.log("    void");
    }

    public Client onClientWantsToConnect(Client client) {
        String functionName = "onClientWantsToConnect";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientWantsToConnect) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            client.setConnected(true);
            return client;
        }
        Client result = new Client();
        Logger.log("Request:");
        this.infoAboutClient(client);
        try {
            this.setCookie(client.getCookie());
            result = this.service.onClientWantsToConnect(client);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutClient(result);
        return result;
    }

    public Client onClientConnectionWasAccepted(Client client) {
        String functionName = "onClientConnectionWasAccepted";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientConnectionWasAccepted) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return client;
        }
        Client result = new Client();
        Logger.log("Request:");
        this.infoAboutClient(client);
        try {
            this.setCookie(client.getCookie());
            result = this.service.onClientConnectionWasAccepted(client);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutClient(result);
        return result;
    }

    public void onClientConnectionWasRejected(Client client) {
        String functionName = "onClientConnectionWasRejected";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientConnectionWasRejected) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return;
        }
        Logger.log("Request:");
        this.infoAboutClient(client);
        try {
            this.setCookie(client.getCookie());
            this.service.onClientConnectionWasRejected(client);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return;
        }
        Logger.log("Response:");
        Logger.log("    void");
    }

    public ChatRoom onClientDisconnected(Client client, ChatRoom room) {
        String functionName = "onClientDisconnected";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientDisconnected) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return room;
        }
        ChatRoom result = null;
        Logger.log("Request:");
        this.infoAboutClient(client);
        this.infoAboutChatRoom(room);
        try {
            this.setCookie(client.getCookie());
            result = this.service.onClientDisconnected(client, room);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutChatRoom(result);
        return result;
    }

    public Client onClientWantsToStartStreaming(Client client, Stream stream) {
        String functionName = "onClientWantsToStartStreaming";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientWantsToStartStreaming) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            client.setStreamAccepted(true);
            return client;
        }
        Client result = new Client();
        Logger.log("Request:");
        this.infoAboutClient(client);
        this.infoAboutStream(stream);
        try {
            this.setCookie(client.getCookie());
            result = this.service.onClientWantsToStartStreaming(client, stream);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutClient(result);
        return result;
    }

    public Client onClientWantsToPlayStream(Client client, Stream stream) {
        String functionName = "onClientWantsToPlayStream";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientWantsToPlayStream) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            client.setStreamAccepted(true);
            return client;
        }
        Client result = new Client();
        Logger.log("Request:");
        this.infoAboutClient(client);
        this.infoAboutStream(stream);
        try {
            this.setCookie(client.getCookie());
            result = this.service.onClientWantsToPlayStream(client, stream);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutClient(result);
        return result;
    }

    public void onClientStoppedStreaming(Client client, Stream stream) {
        String functionName = "onClientStoppedStreaming";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientStoppedStreaming) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return;
        }
        Logger.log("Request:");
        this.infoAboutClient(client);
        this.infoAboutStream(stream);
        try {
            this.setCookie(client.getCookie());
            this.service.onClientStoppedStreaming(client, stream);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return;
        }
        Logger.log("Response:");
        Logger.log("    void");
    }

    public void onClientStoppedPlayingStream(Client client, Stream stream) {
        String functionName = "onClientStoppedPlayingStream";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientStoppedPlayingStream) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return;
        }
        Logger.log("Request:");
        this.infoAboutClient(client);
        this.infoAboutStream(stream);
        try {
            this.setCookie(client.getCookie());
            this.service.onClientStoppedPlayingStream(client, stream);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return;
        }
        Logger.log("Response:");
        Logger.log("    void");
    }

    public Client[] onCheckClients(Client[] clients) {
        String functionName = "onCheckClients";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onCheckClients) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return clients;
        }
        Client[] result = new Client[]{};
        Logger.log("Request:");
        this.infoAboutClients(clients);
        try {
            result = this.service.onCheckClients(clients);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutClients(result);
        return result;
    }

    public Client[] onUniversalCall(Client[] clients, String senderName, String eventName, String value) {
        String functionName = "onUniversalCall";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onUniversalCall) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return clients;
        }
        Client[] result = new Client[]{};
        Logger.log("Request:");
        this.infoAboutClients(clients);
        Logger.log("  senderName:");
        Logger.log("    " + senderName);
        Logger.log();
        Logger.log("  eventName:");
        Logger.log("    " + eventName);
        Logger.log();
        Logger.log("  value:");
        Logger.log("    " + value);
        Logger.log();
        try {
            result = this.service.onUniversalCall(clients, senderName, eventName, value);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutClients(result);
        return result;
    }

    public Client onClientSendMessage(Client client, String toUID, String color, String message) {
        String functionName = "onClientSendMessage";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onClientSendMessage) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            client.setChatText("TextMessage~~fromClientUID=" + client.getUID() + "~~fromClientNickName=" + client.getNickname() + "~~toClientUID=" + toUID + "~~color=" + color + "~~message=" + message + "~!~");
            return client;
        }
        Client result = new Client();
        Logger.log("Request:");
        this.infoAboutClient(client);
        Logger.log("  toUID:");
        Logger.log("    " + toUID);
        Logger.log();
        Logger.log("  color");
        Logger.log("    " + color);
        Logger.log();
        Logger.log("  message:");
        Logger.log("    " + message);
        Logger.log();
        try {
            this.setCookie(client.getCookie());
            result = this.service.onClientSendMessage(client, toUID, color, message);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutClient(result);
        return result;
    }

    public ChatRoom onChatRoomCreated(ChatRoom room) {
        String functionName = "onChatRoomCreated";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onChatRoomCreated) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return room;
        }
        ChatRoom result = new ChatRoom();
        Logger.log("Request:");
        this.infoAboutChatRoom(room);
        try {
            result = this.service.onChatRoomCreated(room);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutChatRoom(result);
        return result;
    }

    public ChatRoom[] onCheckChatRooms(ChatRoom[] rooms) {
        String functionName = "onCheckChatRooms";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onCheckChatRooms) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return rooms;
        }
        ChatRoom[] result = new ChatRoom[]{};
        Logger.log("Request:");
        this.infoAboutChatRooms(rooms);
        try {
            result = this.service.onCheckChatRooms(rooms);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return null;
        }
        Logger.log("Response:");
        this.infoAboutChatRooms(result);
        return result;
    }

    public void onChatRoomClosed(ChatRoom room) {
        String functionName = "onChatRoomClosed";
        Logger.func(functionName);
        if (!this.implemenatationStatus.onChatRoomClosed) {
            Logger.info("Using default implementation, because getImplementedFunctions said that \"" + functionName + "\" is not implemented.");
            return;
        }
        Logger.log("Request:");
        this.infoAboutChatRoom(room);
        try {
            this.service.onChatRoomClosed(room);
        }
        catch (Exception err) {
            Logger.error("Error in " + functionName + ".", err);
            return;
        }
        Logger.log("Response:");
        Logger.log("    void");
    }
}

