/*
 * Decompiled with CFR 0.152.
 */
package cz.cze.radicalchat;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import cz.cze.radicalchat.Const;
import cz.cze.radicalchat.Logger;

public class StringQueue {
    private int index = 0;
    private int capacity = 0;
    private AMFDataArray arr;
    private static int HEADER_SIZE = 1;

    public void create(int aCapacity) {
        this.index = 0;
        this.capacity = Math.max(aCapacity, 1);
        this.arr = new AMFDataArray();
        this.arr.add(this.index);
        int a = 0;
        while (a < this.capacity) {
            this.arr.add("");
            ++a;
        }
    }

    public void assign(AMFData value) {
        this.arr = (AMFDataArray)value;
        this.index = this.arr.getInt(0);
        this.capacity = this.arr.size() - HEADER_SIZE;
    }

    public void addString(String value) {
        if (value.length() >= Const.SHAREDOBJECTSTRINGMAXLENGTH) {
            Logger.error("You are attempting to send too long string " + value);
            return;
        }
        this.arr.set(this.index + HEADER_SIZE, value);
        ++this.index;
        if (this.index >= this.capacity) {
            this.index = 0;
        }
    }

    public void addStringArray(String[] values) {
        int a = 0;
        while (a < values.length) {
            this.addString(values[a]);
            ++a;
        }
    }

    public AMFDataArray getAMFDataArray() {
        this.arr.set(0, this.index);
        return this.arr;
    }
}

