/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.mina.common.ByteBuffer;

public class ByteBufferProxy
extends ByteBuffer {
    protected ByteBuffer buf;
    protected Object extra = null;

    protected ByteBufferProxy(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException("buf");
        }
        this.buf = byteBuffer;
    }

    public void acquire() {
        this.buf.acquire();
    }

    public void release() {
        this.buf.release();
    }

    public boolean isDirect() {
        return this.buf.isDirect();
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object object) {
        this.extra = object;
    }

    public java.nio.ByteBuffer buf() {
        return this.buf.buf();
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public int position() {
        return this.buf.position();
    }

    public ByteBuffer position(int n) {
        this.buf.position(n);
        return this;
    }

    public int limit() {
        return this.buf.limit();
    }

    public ByteBuffer limit(int n) {
        this.buf.limit(n);
        return this;
    }

    public ByteBuffer mark() {
        this.buf.mark();
        return this;
    }

    public ByteBuffer reset() {
        this.buf.reset();
        return this;
    }

    public ByteBuffer clear() {
        this.buf.clear();
        return this;
    }

    public ByteBuffer sweep() {
        this.buf.sweep();
        return this;
    }

    public ByteBuffer sweep(byte by) {
        this.buf.sweep(by);
        return this;
    }

    public ByteBuffer flip() {
        this.buf.flip();
        return this;
    }

    public ByteBuffer rewind() {
        this.buf.rewind();
        return this;
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    public byte get() {
        return this.buf.get();
    }

    public short getUnsigned() {
        return this.buf.getUnsigned();
    }

    public ByteBuffer put(byte by) {
        this.buf.put(by);
        return this;
    }

    public byte get(int n) {
        return this.buf.get(n);
    }

    public short getUnsigned(int n) {
        return this.buf.getUnsigned(n);
    }

    public ByteBuffer put(int n, byte by) {
        this.buf.put(n, by);
        return this;
    }

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        this.buf.get(byArray, n, n2);
        return this;
    }

    public ByteBuffer get(byte[] byArray) {
        this.buf.get(byArray);
        return this;
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        this.buf.put(byteBuffer);
        return this;
    }

    public ByteBuffer put(java.nio.ByteBuffer byteBuffer) {
        this.buf.put(byteBuffer);
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        this.buf.put(byArray, n, n2);
        return this;
    }

    public ByteBuffer put(byte[] byArray) {
        this.buf.put(byArray);
        return this;
    }

    public ByteBuffer compact() {
        this.buf.compact();
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object object) {
        return this.buf.equals(object);
    }

    public int compareTo(Object object) {
        return this.buf.compareTo(object);
    }

    public ByteOrder order() {
        return this.buf.order();
    }

    public ByteBuffer order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
        return this;
    }

    public char getChar() {
        return this.buf.getChar();
    }

    public ByteBuffer putChar(char c) {
        this.buf.putChar(c);
        return this;
    }

    public char getChar(int n) {
        return this.buf.getChar(n);
    }

    public ByteBuffer putChar(int n, char c) {
        this.buf.putChar(n, c);
        return this;
    }

    public CharBuffer asCharBuffer() {
        return this.buf.asCharBuffer();
    }

    public short getShort() {
        return this.buf.getShort();
    }

    public int getUnsignedShort() {
        return this.buf.getUnsignedShort();
    }

    public ByteBuffer putShort(short s) {
        this.buf.putShort(s);
        return this;
    }

    public short getShort(int n) {
        return this.buf.getShort(n);
    }

    public int getUnsignedShort(int n) {
        return this.buf.getUnsignedShort(n);
    }

    public ByteBuffer putShort(int n, short s) {
        this.buf.putShort(n, s);
        return this;
    }

    public ShortBuffer asShortBuffer() {
        return this.buf.asShortBuffer();
    }

    public int getInt() {
        return this.buf.getInt();
    }

    public long getUnsignedInt() {
        return this.buf.getUnsignedInt();
    }

    public ByteBuffer putInt(int n) {
        this.buf.putInt(n);
        return this;
    }

    public int getInt(int n) {
        return this.buf.getInt(n);
    }

    public long getUnsignedInt(int n) {
        return this.buf.getUnsignedInt(n);
    }

    public ByteBuffer putInt(int n, int n2) {
        this.buf.putInt(n, n2);
        return this;
    }

    public IntBuffer asIntBuffer() {
        return this.buf.asIntBuffer();
    }

    public long getLong() {
        return this.buf.getLong();
    }

    public ByteBuffer putLong(long l) {
        this.buf.putLong(l);
        return this;
    }

    public long getLong(int n) {
        return this.buf.getLong(n);
    }

    public ByteBuffer putLong(int n, long l) {
        this.buf.putLong(n, l);
        return this;
    }

    public LongBuffer asLongBuffer() {
        return this.buf.asLongBuffer();
    }

    public float getFloat() {
        return this.buf.getFloat();
    }

    public ByteBuffer putFloat(float f) {
        this.buf.putFloat(f);
        return this;
    }

    public float getFloat(int n) {
        return this.buf.getFloat(n);
    }

    public ByteBuffer putFloat(int n, float f) {
        this.buf.putFloat(n, f);
        return this;
    }

    public FloatBuffer asFloatBuffer() {
        return this.buf.asFloatBuffer();
    }

    public double getDouble() {
        return this.buf.getDouble();
    }

    public ByteBuffer putDouble(double d) {
        this.buf.putDouble(d);
        return this;
    }

    public double getDouble(int n) {
        return this.buf.getDouble(n);
    }

    public ByteBuffer putDouble(int n, double d) {
        this.buf.putDouble(n, d);
        return this;
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.buf.asDoubleBuffer();
    }

    public String getHexDump() {
        return this.buf.getHexDump();
    }

    public String getString(int n, CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getString(n, charsetDecoder);
    }

    public String getString(CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getString(charsetDecoder);
    }

    public String getPrefixedString(CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getPrefixedString(charsetDecoder);
    }

    public String getPrefixedString(int n, CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getPrefixedString(n, charsetDecoder);
    }

    public ByteBuffer putString(CharSequence charSequence, int n, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putString(charSequence, n, charsetEncoder);
        return this;
    }

    public ByteBuffer putString(CharSequence charSequence, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putString(charSequence, charsetEncoder);
        return this;
    }

    public ByteBuffer putPrefixedString(CharSequence charSequence, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putPrefixedString(charSequence, charsetEncoder);
        return this;
    }

    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putPrefixedString(charSequence, n, charsetEncoder);
        return this;
    }

    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, int n2, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putPrefixedString(charSequence, n, n2, charsetEncoder);
        return this;
    }

    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, int n2, byte by, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putPrefixedString(charSequence, n, n2, by, charsetEncoder);
        return this;
    }

    public ByteBuffer skip(int n) {
        this.buf.skip(n);
        return this;
    }

    public ByteBuffer fill(byte by, int n) {
        this.buf.fill(by, n);
        return this;
    }

    public ByteBuffer fillAndReset(byte by, int n) {
        this.buf.fillAndReset(by, n);
        return this;
    }

    public ByteBuffer fill(int n) {
        this.buf.fill(n);
        return this;
    }

    public ByteBuffer fillAndReset(int n) {
        this.buf.fillAndReset(n);
        return this;
    }

    public boolean isAutoExpand() {
        return this.buf.isAutoExpand();
    }

    public ByteBuffer setAutoExpand(boolean bl) {
        this.buf.setAutoExpand(bl);
        return this;
    }

    public ByteBuffer expand(int n, int n2) {
        this.buf.expand(n, n2);
        return this;
    }

    public ByteBuffer expand(int n) {
        this.buf.expand(n);
        return this;
    }

    public boolean isPooled() {
        return this.buf.isPooled();
    }

    public void setPooled(boolean bl) {
        this.buf.setPooled(bl);
    }

    public Object getObject() throws ClassNotFoundException {
        return this.buf.getObject();
    }

    public Object getObject(ClassLoader classLoader) throws ClassNotFoundException {
        return this.buf.getObject(classLoader);
    }

    public ByteBuffer putObject(Object object) {
        this.buf.putObject(object);
        return this;
    }

    public InputStream asInputStream() {
        return this.buf.asInputStream();
    }

    public OutputStream asOutputStream() {
        return this.buf.asOutputStream();
    }

    public ByteBuffer duplicate() {
        return this.buf.duplicate();
    }

    public ByteBuffer slice() {
        return this.buf.slice();
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.buf.asReadOnlyBuffer();
    }

    public byte[] array() {
        return this.buf.array();
    }

    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public ByteBuffer capacity(int n) {
        this.buf.capacity(n);
        return this;
    }

    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    public int markValue() {
        return this.buf.markValue();
    }
}

