/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferProxy;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.support.SSLHandler;
import org.apache.mina.util.SessionLog;

public class SSLFilter
extends IoFilterAdapter {
    public static final String SSL_SESSION = SSLFilter.class.getName() + ".SSLSession";
    public static final String DISABLE_ENCRYPTION_ONCE = SSLFilter.class.getName() + ".DisableEncryptionOnce";
    public static final String USE_NOTIFICATION = SSLFilter.class.getName() + ".UseNotification";
    public static final SSLFilterMessage SESSION_SECURED = new SSLFilterMessage("SESSION_SECURED");
    public static final SSLFilterMessage SESSION_UNSECURED = new SSLFilterMessage("SESSION_UNSECURED");
    private static final String NEXT_FILTER = SSLFilter.class.getName() + ".NextFilter";
    private static final String SSL_HANDLER = SSLFilter.class.getName() + ".SSLHandler";
    private SSLContext sslContext;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public SSLFilter(SSLContext sSLContext) {
        if (sSLContext == null) {
            throw new NullPointerException("sslContext");
        }
        this.sslContext = sSLContext;
    }

    public SSLSession getSSLSession(IoSession ioSession) {
        return (SSLSession)ioSession.getAttribute(SSL_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSSL(IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            if (sSLHandler.isOutboundDone()) {
                IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)ioSession.getAttribute(NEXT_FILTER);
                sSLHandler.destroy();
                sSLHandler.init();
                sSLHandler.handshake(nextFilter);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSSLStarted(IoSession ioSession) {
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            return !sSLHandler.isOutboundDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture stopSSL(IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)ioSession.getAttribute(NEXT_FILTER);
        SSLHandler sSLHandler2 = sSLHandler;
        synchronized (sSLHandler2) {
            return this.initiateClosure(nextFilter, ioSession);
        }
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean bl) {
        this.client = bl;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = stringArray;
    }

    public void onPreAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        if (ioFilterChain.contains(SSLFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one SSLFilter.");
        }
    }

    public void onPostAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession ioSession = ioFilterChain.getSession();
        ioSession.setAttribute(NEXT_FILTER, nextFilter);
        SSLHandler sSLHandler = new SSLHandler(this, this.sslContext, ioSession);
        ioSession.setAttribute(SSL_HANDLER, sSLHandler);
        sSLHandler.handshake(nextFilter);
    }

    public void onPreRemove(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession ioSession = ioFilterChain.getSession();
        this.stopSSL(ioSession);
        ioSession.removeAttribute(NEXT_FILTER);
        ioSession.removeAttribute(SSL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        try {
            SSLHandler sSLHandler2 = sSLHandler;
            synchronized (sSLHandler2) {
                if (this.isSSLStarted(ioSession) && SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, " Closed: " + this.getSSLSessionHandler(ioSession));
                }
                sSLHandler.destroy();
            }
        }
        finally {
            nextFilter.sessionClosed(ioSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws SSLException {
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            if (!this.isSSLStarted(ioSession) && sSLHandler.isInboundDone()) {
                nextFilter.messageReceived(ioSession, object);
                return;
            }
            ByteBuffer byteBuffer = (ByteBuffer)object;
            if (SessionLog.isDebugEnabled(ioSession)) {
                SessionLog.debug(ioSession, " Data Read: " + sSLHandler + " (" + byteBuffer + ')');
            }
            try {
                sSLHandler.messageReceived(nextFilter, byteBuffer.buf());
                this.handleSSLData(nextFilter, sSLHandler);
                if (sSLHandler.isInboundDone()) {
                    if (sSLHandler.isOutboundDone()) {
                        if (SessionLog.isDebugEnabled(ioSession)) {
                            SessionLog.debug(ioSession, " SSL Session closed.");
                        }
                        sSLHandler.destroy();
                    } else {
                        this.initiateClosure(nextFilter, ioSession);
                    }
                    if (byteBuffer.hasRemaining()) {
                        nextFilter.messageReceived(ioSession, byteBuffer);
                    }
                }
            }
            catch (SSLException sSLException) {
                SSLHandshakeException sSLHandshakeException;
                if (!sSLHandler.isInitialHandshakeComplete()) {
                    SSLHandshakeException sSLHandshakeException2 = new SSLHandshakeException("Initial SSL handshake failed.");
                    sSLHandshakeException2.initCause(sSLException);
                    sSLHandshakeException = sSLHandshakeException2;
                }
                throw sSLHandshakeException;
            }
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
        if (object instanceof EncryptedBuffer) {
            EncryptedBuffer encryptedBuffer = (EncryptedBuffer)object;
            encryptedBuffer.release();
            nextFilter.messageSent(ioSession, encryptedBuffer.originalBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) throws SSLException {
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            if (!this.isSSLStarted(ioSession)) {
                nextFilter.filterWrite(ioSession, writeRequest);
                return;
            }
            if (ioSession.containsAttribute(DISABLE_ENCRYPTION_ONCE)) {
                ioSession.removeAttribute(DISABLE_ENCRYPTION_ONCE);
                nextFilter.filterWrite(ioSession, writeRequest);
                return;
            }
            ByteBuffer byteBuffer = (ByteBuffer)writeRequest.getMessage();
            if (SessionLog.isDebugEnabled(ioSession)) {
                SessionLog.debug(ioSession, " Filtered Write: " + sSLHandler);
            }
            if (sSLHandler.isWritingEncryptedData()) {
                if (SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, "   already encrypted: " + byteBuffer);
                }
                nextFilter.filterWrite(ioSession, writeRequest);
                return;
            }
            if (sSLHandler.isInitialHandshakeComplete()) {
                if (SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, " encrypt: " + byteBuffer);
                }
                int n = byteBuffer.position();
                sSLHandler.encrypt(byteBuffer.buf());
                byteBuffer.position(n);
                EncryptedBuffer encryptedBuffer = new EncryptedBuffer(SSLHandler.copy(sSLHandler.getOutNetBuffer()), byteBuffer);
                if (SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, " encrypted buf: " + encryptedBuffer);
                }
                nextFilter.filterWrite(ioSession, new IoFilter.WriteRequest(encryptedBuffer, writeRequest.getFuture()));
                return;
            }
            if (!ioSession.isConnected()) {
                if (SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, " Write request on closed session.");
                }
            } else {
                if (SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, " Handshaking is not complete yet. Buffering write request.");
                }
                sSLHandler.scheduleWrite(nextFilter, writeRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterClose(IoFilter.NextFilter nextFilter, IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        WriteFuture writeFuture = null;
        SSLHandler sSLHandler2 = sSLHandler;
        synchronized (sSLHandler2) {
            block8: {
                try {
                    if (this.isSSLStarted(ioSession)) {
                        writeFuture = this.initiateClosure(nextFilter, ioSession);
                    }
                    if (writeFuture != null) break block8;
                    nextFilter.filterClose(ioSession);
                }
                catch (Throwable throwable) {
                    if (writeFuture == null) {
                        nextFilter.filterClose(ioSession);
                    } else {
                        writeFuture.addListener(new IoFutureListener(nextFilter, ioSession){
                            final /* synthetic */ IoFilter.NextFilter val$nextFilter;
                            final /* synthetic */ IoSession val$session;
                            {
                                this.val$nextFilter = nextFilter;
                                this.val$session = ioSession;
                            }

                            public void operationComplete(IoFuture ioFuture) {
                                this.val$nextFilter.filterClose(this.val$session);
                            }
                        });
                    }
                    throw throwable;
                }
            }
            writeFuture.addListener(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private WriteFuture initiateClosure(IoFilter.NextFilter nextFilter, IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        if (!sSLHandler.closeOutbound()) {
            return DefaultWriteFuture.newNotWrittenFuture(ioSession);
        }
        WriteFuture writeFuture = sSLHandler.writeNetBuffer(nextFilter);
        if (sSLHandler.isInboundDone()) {
            sSLHandler.destroy();
        }
        if (ioSession.containsAttribute(USE_NOTIFICATION)) {
            nextFilter.messageReceived(ioSession, SESSION_UNSECURED);
        }
        return writeFuture;
    }

    private void handleSSLData(IoFilter.NextFilter nextFilter, SSLHandler sSLHandler) throws SSLException {
        if (sSLHandler.isInitialHandshakeComplete()) {
            sSLHandler.flushScheduledWrites();
        }
        sSLHandler.writeNetBuffer(nextFilter);
        this.handleAppDataRead(nextFilter, sSLHandler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, SSLHandler sSLHandler) {
        IoSession ioSession = sSLHandler.getSession();
        if (!sSLHandler.getAppBuffer().hasRemaining()) {
            return;
        }
        if (SessionLog.isDebugEnabled(ioSession)) {
            SessionLog.debug(ioSession, " appBuffer: " + sSLHandler.getAppBuffer());
        }
        ByteBuffer byteBuffer = SSLHandler.copy(sSLHandler.getAppBuffer());
        if (SessionLog.isDebugEnabled(ioSession)) {
            SessionLog.debug(ioSession, " app data read: " + byteBuffer + " (" + byteBuffer.getHexDump() + ')');
        }
        nextFilter.messageReceived(ioSession, byteBuffer);
    }

    private SSLHandler getSSLSessionHandler(IoSession ioSession) {
        SSLHandler sSLHandler = (SSLHandler)ioSession.getAttribute(SSL_HANDLER);
        if (sSLHandler == null) {
            throw new IllegalStateException();
        }
        if (sSLHandler.getParent() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return sSLHandler;
    }

    private static class EncryptedBuffer
    extends ByteBufferProxy {
        private final ByteBuffer originalBuffer;

        private EncryptedBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            super(byteBuffer);
            this.originalBuffer = byteBuffer2;
        }
    }

    public static class SSLFilterMessage {
        private final String name;

        private SSLFilterMessage(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

