/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.support;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.support.SSLByteBufferPool;
import org.apache.mina.util.Queue;
import org.apache.mina.util.SessionLog;

public class SSLHandler {
    private final SSLFilter parent;
    private final SSLContext ctx;
    private final IoSession session;
    private final Queue scheduledWrites = new Queue();
    private SSLEngine sslEngine;
    private java.nio.ByteBuffer inNetBuffer;
    private java.nio.ByteBuffer outNetBuffer;
    private java.nio.ByteBuffer appBuffer;
    private final java.nio.ByteBuffer hsBB = java.nio.ByteBuffer.allocate(0);
    private SSLEngineResult.HandshakeStatus initialHandshakeStatus;
    private boolean initialHandshakeComplete;
    private boolean writingEncryptedData;

    public SSLHandler(SSLFilter sSLFilter, SSLContext sSLContext, IoSession ioSession) throws SSLException {
        this.parent = sSLFilter;
        this.session = ioSession;
        this.ctx = sSLContext;
        this.init();
    }

    public void init() throws SSLException {
        if (this.sslEngine != null) {
            return;
        }
        this.sslEngine = this.ctx.createSSLEngine();
        this.sslEngine.setUseClientMode(this.parent.isUseClientMode());
        if (this.parent.isWantClientAuth()) {
            this.sslEngine.setWantClientAuth(true);
        }
        if (this.parent.isNeedClientAuth()) {
            this.sslEngine.setNeedClientAuth(true);
        }
        if (this.parent.getEnabledCipherSuites() != null) {
            this.sslEngine.setEnabledCipherSuites(this.parent.getEnabledCipherSuites());
        }
        if (this.parent.getEnabledProtocols() != null) {
            this.sslEngine.setEnabledProtocols(this.parent.getEnabledProtocols());
        }
        this.sslEngine.beginHandshake();
        this.initialHandshakeStatus = this.sslEngine.getHandshakeStatus();
        this.initialHandshakeComplete = false;
        SSLByteBufferPool.initiate(this.sslEngine);
        this.appBuffer = SSLByteBufferPool.getApplicationBuffer();
        this.inNetBuffer = SSLByteBufferPool.getPacketBuffer();
        this.outNetBuffer = SSLByteBufferPool.getPacketBuffer();
        this.outNetBuffer.position(0);
        this.outNetBuffer.limit(0);
        this.writingEncryptedData = false;
    }

    public void destroy() {
        if (this.sslEngine == null) {
            return;
        }
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException sSLException) {
            SessionLog.debug(this.session, "Unexpected exception from SSLEngine.closeInbound().", sSLException);
        }
        try {
            do {
                this.outNetBuffer.clear();
            } while (this.sslEngine.wrap(this.hsBB, this.outNetBuffer).bytesProduced() > 0);
        }
        catch (SSLException sSLException) {
            SessionLog.debug(this.session, "Unexpected exception from SSLEngine.wrap().", sSLException);
        }
        this.sslEngine.closeOutbound();
        this.sslEngine = null;
        SSLByteBufferPool.release(this.appBuffer);
        SSLByteBufferPool.release(this.inNetBuffer);
        SSLByteBufferPool.release(this.outNetBuffer);
        this.scheduledWrites.clear();
    }

    public SSLFilter getParent() {
        return this.parent;
    }

    public IoSession getSession() {
        return this.session;
    }

    public boolean isWritingEncryptedData() {
        return this.writingEncryptedData;
    }

    public boolean isInitialHandshakeComplete() {
        return this.initialHandshakeComplete;
    }

    public boolean isInboundDone() {
        return this.sslEngine == null || this.sslEngine.isInboundDone();
    }

    public boolean isOutboundDone() {
        return this.sslEngine == null || this.sslEngine.isOutboundDone();
    }

    public boolean needToCompleteInitialHandshake() {
        return this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && !this.isInboundDone();
    }

    public void scheduleWrite(IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
        this.scheduledWrites.push(new ScheduledWrite(nextFilter, writeRequest));
    }

    public void flushScheduledWrites() throws SSLException {
        ScheduledWrite scheduledWrite;
        while ((scheduledWrite = (ScheduledWrite)this.scheduledWrites.pop()) != null) {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " Flushing buffered write request: " + scheduledWrite.writeRequest);
            }
            this.parent.filterWrite(scheduledWrite.nextFilter, this.session, scheduledWrite.writeRequest);
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, java.nio.ByteBuffer byteBuffer) throws SSLException {
        if (byteBuffer.limit() > this.inNetBuffer.remaining()) {
            this.inNetBuffer = SSLByteBufferPool.expandBuffer(this.inNetBuffer, this.inNetBuffer.capacity() + byteBuffer.limit() * 2);
            this.appBuffer = SSLByteBufferPool.expandBuffer(this.appBuffer, this.inNetBuffer.capacity() * 2);
            this.appBuffer.position(0);
            this.appBuffer.limit(0);
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " expanded inNetBuffer:" + this.inNetBuffer);
                SessionLog.debug(this.session, " expanded appBuffer:" + this.appBuffer);
            }
        }
        this.inNetBuffer.put(byteBuffer);
        if (!this.initialHandshakeComplete) {
            this.handshake(nextFilter);
        } else {
            this.decrypt();
        }
        if (this.isInboundDone()) {
            byteBuffer.position(byteBuffer.position() - this.inNetBuffer.position());
            this.inNetBuffer.clear();
        }
    }

    public java.nio.ByteBuffer getAppBuffer() {
        return this.appBuffer;
    }

    public java.nio.ByteBuffer getOutNetBuffer() {
        return this.outNetBuffer;
    }

    public void encrypt(java.nio.ByteBuffer byteBuffer) throws SSLException {
        if (!this.initialHandshakeComplete) {
            throw new IllegalStateException();
        }
        this.outNetBuffer.clear();
        while (byteBuffer.hasRemaining()) {
            if (byteBuffer.remaining() > (this.outNetBuffer.capacity() - this.outNetBuffer.position()) / 2) {
                this.outNetBuffer = SSLByteBufferPool.expandBuffer(this.outNetBuffer, byteBuffer.capacity() * 2);
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, " expanded outNetBuffer:" + this.outNetBuffer);
                }
            }
            SSLEngineResult sSLEngineResult = this.sslEngine.wrap(byteBuffer, this.outNetBuffer);
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " Wrap res:" + sSLEngineResult);
            }
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                if (sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.doTasks();
                continue;
            }
            throw new SSLException("SSLEngine error during encrypt: " + (Object)((Object)sSLEngineResult.getStatus()) + " src: " + byteBuffer + "outNetBuffer: " + this.outNetBuffer);
        }
        this.outNetBuffer.flip();
    }

    public boolean closeOutbound() throws SSLException {
        if (this.sslEngine == null || this.sslEngine.isOutboundDone()) {
            return false;
        }
        this.sslEngine.closeOutbound();
        this.outNetBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new SSLException("Improper close state: " + sSLEngineResult);
        }
        this.outNetBuffer.flip();
        return true;
    }

    private void decrypt() throws SSLException {
        if (!this.initialHandshakeComplete) {
            throw new IllegalStateException();
        }
        if (this.appBuffer.hasRemaining()) {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " Error: appBuffer not empty!");
            }
            throw new IllegalStateException();
        }
        this.unwrap();
    }

    private SSLEngineResult.Status checkStatus(SSLEngineResult.Status status) throws SSLException {
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("SSLEngine error during decrypt: " + (Object)((Object)status) + " inNetBuffer: " + this.inNetBuffer + "appBuffer: " + this.appBuffer);
        }
        return status;
    }

    public void handshake(IoFilter.NextFilter nextFilter) throws SSLException {
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, " doHandshake()");
        }
        while (!this.initialHandshakeComplete) {
            Object object;
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.session.setAttribute(SSLFilter.SSL_SESSION, this.sslEngine.getSession());
                if (SessionLog.isDebugEnabled(this.session)) {
                    object = this.sslEngine.getSession();
                    SessionLog.debug(this.session, "  initialHandshakeStatus=FINISHED");
                    SessionLog.debug(this.session, "  sslSession CipherSuite used " + object.getCipherSuite());
                }
                this.initialHandshakeComplete = true;
                if (!this.session.containsAttribute(SSLFilter.USE_NOTIFICATION)) break;
                nextFilter.messageReceived(this.session, SSLFilter.SESSION_SECURED);
                break;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, "  initialHandshakeStatus=NEED_TASK");
                }
                this.initialHandshakeStatus = this.doTasks();
                continue;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, "  initialHandshakeStatus=NEED_UNWRAP");
                }
                object = this.unwrapHandshake();
                if ((this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || object != SSLEngineResult.Status.BUFFER_UNDERFLOW) && !this.isInboundDone()) continue;
                break;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, "  initialHandshakeStatus=NEED_WRAP");
                }
                if (this.outNetBuffer.hasRemaining()) {
                    if (!SessionLog.isDebugEnabled(this.session)) break;
                    SessionLog.debug(this.session, "  Still data in out buffer!");
                    break;
                }
                this.outNetBuffer.clear();
                object = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, " Wrap res:" + object);
                }
                this.outNetBuffer.flip();
                this.initialHandshakeStatus = ((SSLEngineResult)object).getHandshakeStatus();
                this.writeNetBuffer(nextFilter);
                continue;
            }
            throw new IllegalStateException("Invalid Handshaking State" + (Object)((Object)this.initialHandshakeStatus));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture writeNetBuffer(IoFilter.NextFilter nextFilter) throws SSLException {
        if (!this.getOutNetBuffer().hasRemaining()) {
            return DefaultWriteFuture.newNotWrittenFuture(this.session);
        }
        DefaultWriteFuture defaultWriteFuture = null;
        this.writingEncryptedData = true;
        try {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " write outNetBuffer: " + this.getOutNetBuffer());
            }
            ByteBuffer byteBuffer = SSLHandler.copy(this.getOutNetBuffer());
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " session write: " + byteBuffer);
            }
            defaultWriteFuture = new DefaultWriteFuture(this.session);
            this.parent.filterWrite(nextFilter, this.session, new IoFilter.WriteRequest(byteBuffer, defaultWriteFuture));
            while (this.needToCompleteInitialHandshake()) {
                try {
                    this.handshake(nextFilter);
                }
                catch (SSLException sSLException) {
                    SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("Initial SSL handshake failed.");
                    sSLHandshakeException.initCause(sSLException);
                    throw sSLHandshakeException;
                }
                if (!this.getOutNetBuffer().hasRemaining()) continue;
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, " write outNetBuffer2: " + this.getOutNetBuffer());
                }
                ByteBuffer byteBuffer2 = SSLHandler.copy(this.getOutNetBuffer());
                defaultWriteFuture = new DefaultWriteFuture(this.session);
                this.parent.filterWrite(nextFilter, this.session, new IoFilter.WriteRequest(byteBuffer2, defaultWriteFuture));
            }
        }
        finally {
            this.writingEncryptedData = false;
        }
        if (defaultWriteFuture != null) {
            return defaultWriteFuture;
        }
        return DefaultWriteFuture.newNotWrittenFuture(this.session);
    }

    private SSLEngineResult.Status unwrap() throws SSLException {
        SSLEngineResult sSLEngineResult;
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, " unwrap()");
        }
        this.appBuffer.clear();
        this.inNetBuffer.flip();
        do {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, "   inNetBuffer: " + this.inNetBuffer);
                SessionLog.debug(this.session, "   appBuffer: " + this.appBuffer);
            }
            sSLEngineResult = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
            if (!SessionLog.isDebugEnabled(this.session)) continue;
            SessionLog.debug(this.session, " Unwrap res:" + sSLEngineResult);
        } while (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK);
        this.inNetBuffer.compact();
        this.appBuffer.flip();
        return this.checkStatus(sSLEngineResult.getStatus());
    }

    private SSLEngineResult.Status unwrapHandshake() throws SSLException {
        SSLEngineResult sSLEngineResult;
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, " unwrapHandshake()");
        }
        this.appBuffer.clear();
        this.inNetBuffer.flip();
        do {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, "   inNetBuffer: " + this.inNetBuffer);
                SessionLog.debug(this.session, "   appBuffer: " + this.appBuffer);
            }
            sSLEngineResult = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
            if (!SessionLog.isDebugEnabled(this.session)) continue;
            SessionLog.debug(this.session, " Unwrap res:" + sSLEngineResult);
        } while (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        this.initialHandshakeStatus = sSLEngineResult.getHandshakeStatus();
        if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && this.appBuffer.position() == 0 && sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && this.inNetBuffer.hasRemaining()) {
            do {
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, "  extra handshake unwrap");
                    SessionLog.debug(this.session, "   inNetBuffer: " + this.inNetBuffer);
                    SessionLog.debug(this.session, "   appBuffer: " + this.appBuffer);
                }
                sSLEngineResult = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
                if (!SessionLog.isDebugEnabled(this.session)) continue;
                SessionLog.debug(this.session, " Unwrap res:" + sSLEngineResult);
            } while (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK);
        }
        this.inNetBuffer.compact();
        this.appBuffer.flip();
        return this.checkStatus(sSLEngineResult.getStatus());
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, "   doTasks()");
        }
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, "    doTask: " + runnable);
            }
            runnable.run();
        }
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, "   doTasks(): " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public static ByteBuffer copy(java.nio.ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining(), false);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        return byteBuffer2;
    }

    private static class ScheduledWrite {
        private final IoFilter.NextFilter nextFilter;
        private final IoFilter.WriteRequest writeRequest;

        public ScheduledWrite(IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
            this.nextFilter = nextFilter;
            this.writeRequest = writeRequest;
        }
    }
}

