/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Position;
import org.openide.filesystems.FileObject;

public final class ChangeInfo {
    private List<Change> changes = null;

    public ChangeInfo(FileObject fileObject, Position position, Position position2) {
        this.add(fileObject, position, position2);
    }

    public ChangeInfo(Position position, Position position2) {
        this.add(null, position, position2);
    }

    public ChangeInfo() {
    }

    public final int size() {
        return this.changes != null ? this.changes.size() : 0;
    }

    public final void add(FileObject fileObject, Position position, Position position2) {
        if (this.changes == null) {
            this.changes = new ArrayList<Change>(5);
        }
        this.changes.add(new ChangeImpl(fileObject, position, position2));
    }

    public final Change get(int n) {
        if (this.changes == null) {
            throw new ArrayIndexOutOfBoundsException("No changes");
        }
        return this.changes.get(n);
    }

    public String toString() {
        int n = this.size();
        if (n == 0) {
            return "Empty ChangeInfo";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ChangeInfo [");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.get(i));
            if (i == n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static interface Change {
        public Position getStart();

        public Position getEnd();

        public FileObject getFileObject();
    }

    private static final class ChangeImpl
    implements Change {
        Position start;
        Position end;
        FileObject fileObject;

        ChangeImpl(FileObject fileObject, Position position, Position position2) {
            this.fileObject = fileObject;
            this.start = position;
            this.end = position2;
        }

        public Position getStart() {
            return this.start;
        }

        public Position getEnd() {
            return this.end;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public String toString() {
            return "Change from " + this.start.getOffset() + " to " + this.end.getOffset() + " in " + this.fileObject;
        }
    }
}

