/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.php.project.PhpLanguageOptionsAccessor;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PhpLanguageOptions {
    public static final boolean SHORT_TAGS_ENABLED = true;
    public static final boolean ASP_TAGS_ENABLED = false;
    public static final String PROP_SHORT_TAGS = PhpLanguageOptions.class.getName() + ".shortTags";
    public static final String PROP_ASP_TAGS = PhpLanguageOptions.class.getName() + ".aspTags";
    public static final String PROP_PHP_VERSION = PhpLanguageOptions.class.getName() + ".phpVersion";
    static final PhpLanguageOptions INSTANCE = new PhpLanguageOptions();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private PhpLanguageOptions() {
    }

    public static PhpLanguageOptions getDefault() {
        return INSTANCE;
    }

    public Properties getProperties(FileObject fileObject) {
        PhpProject phpProject;
        boolean bl = true;
        boolean bl2 = false;
        PhpVersion phpVersion = PhpVersion.PHP_5;
        if (fileObject != null && (phpProject = PhpProjectUtils.getPhpProject(fileObject)) != null) {
            bl = ProjectPropertiesSupport.areShortTagsEnabled(phpProject);
            bl2 = ProjectPropertiesSupport.areAspTagsEnabled(phpProject);
            phpVersion = ProjectPropertiesSupport.getPhpVersion(phpProject);
        }
        return new Properties(bl, bl2, phpVersion);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    static {
        PhpLanguageOptionsAccessor.setDefault(new PhpLanguageOptionsAccessor(){

            public void firePropertyChange(String string, Object object, Object object2) {
                INSTANCE.firePropertyChange(string, object, object2);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PhpVersion
    extends Enum<PhpVersion> {
        public static final /* enum */ PhpVersion PHP_5 = new PhpVersion(NbBundle.getMessage(PhpLanguageOptions.class, (String)"PHP_5"));
        public static final /* enum */ PhpVersion PHP_53 = new PhpVersion(NbBundle.getMessage(PhpLanguageOptions.class, (String)"PHP_53"));
        private final String displayName;
        private static final /* synthetic */ PhpVersion[] $VALUES;

        public static PhpVersion[] values() {
            return (PhpVersion[])$VALUES.clone();
        }

        public static PhpVersion valueOf(String string) {
            return Enum.valueOf(PhpVersion.class, string);
        }

        private PhpVersion(String string2) {
            assert (string2 != null);
            this.displayName = string2;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        static {
            $VALUES = new PhpVersion[]{PHP_5, PHP_53};
        }
    }

    public static final class Properties {
        private final boolean shortTagsEnabled;
        private final boolean aspTagsEnabled;
        private final PhpVersion phpVersion;

        Properties(boolean bl, boolean bl2, PhpVersion phpVersion) {
            this.shortTagsEnabled = bl;
            this.aspTagsEnabled = bl2;
            this.phpVersion = phpVersion;
        }

        public boolean areShortTagsEnabled() {
            return this.shortTagsEnabled;
        }

        public boolean areAspTagsEnabled() {
            return this.aspTagsEnabled;
        }

        public PhpVersion getPhpVersion() {
            return this.phpVersion;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append(" [shorTagsEnabled: ");
            stringBuilder.append(this.shortTagsEnabled);
            stringBuilder.append(", aspTagsEnabled: ");
            stringBuilder.append(this.aspTagsEnabled);
            stringBuilder.append(", PHP version: ");
            stringBuilder.append((Object)this.phpVersion);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

